/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.IFormulaMutiReturnValue;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.stefan.snrpc.util.StringUtil;

public class DisposalDateInfo
extends AbstractFormulaCalculatorParameter
implements IFormulaMutiReturnValue {
    public static final Logger logger = Logger.getLogger(DisposalDateInfo.class);
    String orgTreeNumber = null;
    String companyNumber = null;
    String orgUnitNumber = null;
    int year = 0;
    int period = 0;
    String dateFormat = null;
    BatchHelper batchHelper;
    Context serverContext;
    Map orgTreeMap;
    boolean isValueNull = false;

    public DisposalDateInfo(Parameter param, BatchHelper batchHelper, Map orgTreeMap) {
        try {
            this.setParameter(param);
            this.batchHelper = batchHelper;
            this.serverContext = batchHelper.getServerContext();
            this.orgTreeMap = orgTreeMap;
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            logger.error((Object)"DisposalDateInfo error.", (Throwable)e);
            this.setException(e);
        }
    }

    public String getStateKey() {
        StringBuffer str = new StringBuffer();
        str.append(this.year).append(this.period).append(this.orgTreeNumber);
        return str.toString();
    }

    public String getFormulaKey() {
        return this.orgUnitNumber + this.companyNumber;
    }

    public void processMutiReturnValue(IFormulaCombinationPreparedState prepareState) {
    }

    public Object getMutiReturnValue() {
        return null;
    }

    protected void verifyArgs() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)this.companyNumber)) {
            this.companyNumber = this.batchHelper.getOrgUnit_Number();
            if (StringUtils.isEmpty((String)this.companyNumber)) {
                this.companyNumber = this.batchHelper.getCompany_Number();
            }
        }
        if (this.year <= 0 || this.period <= 0) {
            int periodType;
            int rptPeriod;
            int rptYear = this.batchHelper.getReport_Year();
            Date date = FiscalPeriodHelper.getPeriodLastDate(null, (int)rptYear, (int)(rptPeriod = this.batchHelper.getReport_Period()), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)(periodType = this.batchHelper.getReport_PeriodType())), (boolean)false);
            int[] yd = FiscalPeriodHelper.getYearAndPeriod(null, (Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY, (boolean)false);
            int[] yearPeriod = FiscalPeriodHelper.getRptFormualYearAndPeriod((boolean)false, null, (int)yd[0], (int)yd[1], (int)3, (int)this.year, (int)this.period, (boolean)false);
            if (yearPeriod == null) {
                this.year = yd[0];
                this.period = yd[1];
            } else {
                this.year = yearPeriod[0];
                this.period = yearPeriod[1];
            }
        }
        int datasource = this.batchHelper.getReport_SourceType();
        if (StringUtils.isEmpty((String)this.orgTreeNumber)) {
            this.orgTreeNumber = this.batchHelper.getOrgTreeNumber();
            if (this.orgTreeNumber == null && (datasource == 7 || datasource == 1)) {
                this.orgTreeNumber = this.batchHelper.getOrgTreeNumber(this.year, this.period, this.year, this.period, 3, this.companyNumber, this.orgTreeMap, null, false);
            }
            if (this.orgTreeNumber == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"42_AcctItemCalcuter", (Locale)this.serverContext.getLocale())});
            }
        }
        if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
            this.orgUnitNumber = CslRptUtil.isCslRpt((int)datasource) ? (String)this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("OrgUnit.Number") : (String)this.batchHelper.getCalCulateContext().getReportAdapter().getReportProperty("CSLReport_OrgUnit_Group");
            if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                try {
                    SQLBuilder sql = new SQLBuilder();
                    sql.append(" select fnumber from (");
                    sql.append("select max(cslOrg.fdate) fdate, orgunit.fnumber from T_Csl_CslOrgUnit cslOrg ");
                    sql.append(" inner join t_org_tree tree on tree.fid=cslOrg.FOrgTreeId ");
                    sql.append(" inner join t_org_baseunit company on company.fid=cslOrg.fcompanyid ");
                    sql.append(" inner join t_org_baseunit orgunit on orgunit.fid=cslOrg.fdisposalOrgUnitId ");
                    sql.append("where tree.fnumber=?", this.orgTreeNumber);
                    sql.append(" and company.fnumber=?", this.companyNumber);
                    sql.append(" and cslOrg.fyear=? ", this.year);
                    sql.append(" and cslOrg.fperiod<=? ", this.period);
                    sql.append(" group by orgunit.fnumber) maxDate ");
                    sql.append(" order by fdate desc ");
                    IRowSet rowSet = DbUtil.executeQuery(this.serverContext, sql.toString(), sql.getParams());
                    if (rowSet.next()) {
                        this.orgUnitNumber = rowSet.getString("fnumber");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"DisposalDateInfo error.", (Throwable)ex);
                    this.setException(ex);
                }
            }
            if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                this.isValueNull = true;
            }
        }
        if (StringUtil.isEmpty((String)this.dateFormat)) {
            this.setException(new Exception("dateFormat is null."));
        } else {
            this.dateFormat = this.dateFormat.replaceAll("Y", "y");
            this.dateFormat = this.dateFormat.replaceAll("m", "M");
            this.dateFormat = this.dateFormat.replaceAll("D", "d");
        }
    }

    protected void initArgs() throws BOSException, EASBizException {
        int argsIndex;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.orgTreeNumber = ((Variant)args[argsIndex = 0]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.companyNumber = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.orgUnitNumber = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.year = this.batchHelper.initNumberParam((Variant)args[++argsIndex]);
        this.period = this.batchHelper.initNumberParam((Variant)args[++argsIndex]);
        this.dateFormat = ((Variant)args[++argsIndex]).getValue() == null ? "YYYY-MM-DD" : ((Variant)args[argsIndex]).getValue().toString();
    }
}

