/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum SchedulePlanDateEnum {
    CURRENT_MONTH_FIRST(0, 1),
    CURRENT_MONTH_SECOND(0, 2),
    CURRENT_MONTH_THIRD(0, 3),
    CURRENT_MONTH_FOURTH(0, 4),
    CURRENT_MONTH_FIFTH(0, 5),
    CURRENT_MONTH_SIXTH(0, 6),
    CURRENT_MONTH_SEVENTH(0, 7),
    CURRENT_MONTH_EIGHTH(0, 8),
    CURRENT_MONTH_NINTH(0, 9),
    CURRENT_MONTH_TENTH(0, 10),
    CURRENT_MONTH_ELEVEN(0, 11),
    CURRENT_MONTH_TWELFTH(0, 12),
    CURRENT_MONTH_THIRTEENTH(0, 13),
    CURRENT_MONTH_FOURTEEHTH(0, 14),
    CURRENT_MONTH_FIFTEENTH(0, 15),
    CURRENT_MONTH_SIXTEENTH(0, 16),
    CURRENT_MONTH_SEVENTEENTH(0, 17),
    CURRENT_MONTH_EIGHTEENTH(0, 18),
    CURRENT_MONTH_NINITEENTH(0, 19),
    CURRENT_MONTH_TWENTIETH(0, 20),
    CURRENT_MONTH_TWENTY_FIRST(0, 21),
    CURRENT_MONTH_TWENTY_SECOND(0, 22),
    CURRENT_MONTH_TWENTY_THIRD(0, 23),
    CURRENT_MONTH_TWENTY_FOURTH(0, 24),
    CURRENT_MONTH_TWENTY_FIFTH(0, 25),
    CURRENT_MONTH_TWENTY_SIXTH(0, 26),
    CURRENT_MONTH_TWENTY_SEVENTH(0, 27),
    CURRENT_MONTH_TWENTY_EIGHTH(0, 28),
    CURRENT_MONTH_TWENTY_NINTH(0, 29),
    CURRENT_MONTH_THIRTIETH(0, 30),
    CURRENT_MONTH_THIRTY_FIRST(0, 31),
    NEXT_MONTH_FIRST(1, 1),
    NEXT_MONTH_SECOND(1, 2),
    NEXT_MONTH_THIRD(1, 3),
    NEXT_MONTH_FOURTH(1, 4),
    NEXT_MONTH_FIFTH(1, 5),
    NEXT_MONTH_SIXTH(1, 6),
    NEXT_MONTH_SEVENTH(1, 7),
    NEXT_MONTH_EIGHTH(1, 8),
    NEXT_MONTH_NINTH(1, 9),
    NEXT_MONTH_TENTH(1, 10),
    NEXT_MONTH_ELEVEN(1, 11),
    NEXT_MONTH_TWELFTH(1, 12),
    NEXT_MONTH_THIRTEENTH(1, 13),
    NEXT_MONTH_FOURTEEHTH(1, 14),
    NEXT_MONTH_FIFTEENTH(1, 15),
    NEXT_MONTH_SIXTEENTH(1, 16),
    NEXT_MONTH_SEVENTEENTH(1, 17),
    NEXT_MONTH_EIGHTEENTH(1, 18),
    NEXT_MONTH_NINITEENTH(1, 19),
    NEXT_MONTH_TWENTIETH(1, 20),
    NEXT_MONTH_TWENTY_FIRST(1, 21),
    NEXT_MONTH_TWENTY_SECOND(1, 22),
    NEXT_MONTH_TWENTY_THIRD(1, 23),
    NEXT_MONTH_TWENTY_FOURTH(1, 24),
    NEXT_MONTH_TWENTY_FIFTH(1, 25),
    NEXT_MONTH_TWENTY_SIXTH(1, 26),
    NEXT_MONTH_TWENTY_SEVENTH(1, 27),
    NEXT_MONTH_TWENTY_EIGHTH(1, 28),
    NEXT_MONTH_TWENTY_NINTH(1, 29),
    NEXT_MONTH_THIRTIETH(1, 30),
    NEXT_MONTH_THIRTY_FIRST(1, 31);

    private static Map<String, SchedulePlanDateEnum> entries;
    private int month = 0;
    private int day = 0;
    private String value = null;

    private SchedulePlanDateEnum(int month, int day) {
        this.month = month;
        this.day = day;
        this.value = String.valueOf(this.month) + (this.day < 10 ? "0" + String.valueOf(this.day) : String.valueOf(this.day));
    }

    public static SchedulePlanDateEnum getEnum(String planDateEnum) {
        if (planDateEnum == null || planDateEnum.length() != 9) {
            return null;
        }
        return entries.get(planDateEnum.substring(0, 3));
    }

    public String getValue() {
        return this.value;
    }

    public int interval(String enumValue, Date date) {
        Calendar calendar = this.getRepresentCalendar(enumValue);
        Calendar other = this.getCalendarWithHourMinute(date);
        return this.intervalDays(calendar.getTimeInMillis(), other.getTimeInMillis()).intValue();
    }

    public int intervalByPeriod(String periodNumber, String enumValue, Date date) {
        if (periodNumber == null || periodNumber.length() != 6) {
            return 0;
        }
        int year = Integer.parseInt(periodNumber.substring(0, 4));
        int month = Integer.parseInt(periodNumber.substring(4, 6));
        Calendar calendar = this.getRepresentCalendarByPeriod(enumValue, year, month);
        Calendar other = this.getCalendarWithHourMinute(date);
        return this.intervalDays(calendar.getTimeInMillis(), other.getTimeInMillis()).intValue();
    }

    public Calendar getCalendarByEnum(SchedulePlanDateEnum planDateEnum) {
        return this.getCalendarByEnum(planDateEnum.month, planDateEnum.day);
    }

    public Calendar getRepresentCalendar() {
        return this.getCalendarByEnum(this.month, this.day);
    }

    public Calendar getRepresentCalendar(String enumValue) {
        if (enumValue == null || enumValue.length() != 9) {
            return null;
        }
        Calendar calendar = this.getCalendarByEnum(this.month, this.day);
        calendar.set(11, Integer.parseInt(enumValue.substring(4, 6)));
        calendar.set(12, Integer.parseInt(enumValue.substring(7, 9)));
        return calendar;
    }

    public Calendar getRepresentCalendarByPeriod(String enumValue, int periodYear, int periodMonth) {
        if (enumValue == null || enumValue.length() != 9) {
            return null;
        }
        Calendar calendar = this.getCalendar(null);
        calendar.set(1, periodYear);
        calendar.set(2, periodMonth - 1);
        this.ajustDate(this.month, this.day, calendar);
        calendar.set(11, Integer.parseInt(enumValue.substring(4, 6)));
        calendar.set(12, Integer.parseInt(enumValue.substring(7, 9)));
        return calendar;
    }

    public String toString() {
        return super.toString();
    }

    private BigDecimal intervalDays(long millis, long otherMillis) {
        double diffMillis = (double)(millis - otherMillis) / 8.64E7;
        int type = -1;
        type = diffMillis >= 0.0 ? 2 : 3;
        return new BigDecimal(diffMillis).setScale(0, type);
    }

    private Calendar getCalendarByEnum(int month, int day) {
        Calendar calendar = this.getCalendar(null);
        this.ajustDate(month, day, calendar);
        return calendar;
    }

    private void ajustDate(int month, int day, Calendar calendar) {
        int maxDayOfMonth;
        if (month == 1) {
            calendar.add(2, month);
        }
        calendar.set(5, (maxDayOfMonth = calendar.getActualMaximum(5)) < day ? maxDayOfMonth : day);
    }

    private Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private Calendar getCalendarWithHourMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    static {
        entries = new HashMap<String, SchedulePlanDateEnum>();
        for (SchedulePlanDateEnum date : SchedulePlanDateEnum.values()) {
            entries.put(date.value, date);
        }
    }
}

