/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.pcc.CloseAccountNoticeFactory;
import com.kingdee.eas.fi.pcc.CloseAccountNoticeInfo;
import com.kingdee.eas.fi.pcc.app.AbstractCloseAccountNoticeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class CloseAccountNoticeControllerBean
extends AbstractCloseAccountNoticeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.pcc.app.CloseAccountNoticeControllerBean");

    @Override
    protected IObjectPK _handleConfirm(Context ctx, BOSUuid id, String personId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        UserInfo info = (UserInfo)UserFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(personId), sic);
        String personID = info.getPerson().getId().toString();
        Timestamp confirmTime = new Timestamp(System.currentTimeMillis());
        CloseAccountNoticeInfo accountNoticeInfo = CloseAccountNoticeFactory.getLocalInstance(ctx).getCloseAccountNoticeInfo((IObjectPK)new ObjectUuidPK(id));
        Timestamp submitTime = accountNoticeInfo.getSubmitTime();
        int FRemainingTime = (int)((confirmTime.getTime() - submitTime.getTime()) / 1000L / 3600L);
        Connection conn = null;
        PreparedStatement entryStmt = null;
        String sql = "update T_PCC_CloseAccountNotice set FConfirmPersonID = ? , FConfirmTime = ? , FStatus = ? , FRemainingTime = ? where FID = ? ";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            entryStmt = conn.prepareStatement(sql);
            int index = 1;
            entryStmt.setString(index++, personID);
            entryStmt.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
            entryStmt.setInt(index++, 3);
            entryStmt.setInt(index++, 0);
            entryStmt.setString(index++, id.toString());
            entryStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(entryStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)entryStmt, (Connection)conn);
        return null;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }
}

