/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Date;

public class ConsignLoanIntBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        ConsignLoanIntBillInfo info = this.getConsignLoanIntBillInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        if (info.getIntCalType() == IntCalTypeEnum.REC_INT || info.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            this.addIntAmtJournal(ctx, info, journalColl);
        }
        return journalColl;
    }

    private void addIntAmtJournal(Context ctx, ConsignLoanIntBillInfo info, JournalCollection journalColl) throws EASBizException, BOSException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setAccountBank(info.getAcctBank());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(this.getBookDate(ctx, info));
        journalInfo.setDebitAmount(FMHelper.add((BigDecimal)info.getShijiIntAmt(), (BigDecimal)info.getShijiPenaAmt()));
        journalInfo.setCreditAmount(FMConstants.ZERO);
        journalInfo.setBizDate(info.getBizDate());
        journalInfo.setAccountView(info.getAcctBank().getAccount());
        String oppUnit = info.getLoanCompany() == null ? info.getCustomer().getName() : info.getLoanCompany().getName();
        journalInfo.setOppUnit(oppUnit);
        journalInfo.setBillType(BillTypeEnum.ConsignLoanIntBill);
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setDescription(EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"182_ConsignIntDecription"));
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setCompany(info.getCompany());
        journalColl.add(journalInfo);
    }

    private Date getBookDate(Context ctx, ConsignLoanIntBillInfo info) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = info.getCompany();
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = info.getBizDate();
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    private ConsignLoanIntBillInfo getConsignLoanIntBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ConsignLoanIntBillInfo info = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("account.*");
        sic.add("loanCompany.*");
        sic.add("acctBank.*");
        return sic;
    }
}

