/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignLoanExtBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.cl.app.AbstractConsignLoanExtBillControllerBean;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.framework.AbstractCoreBillBaseInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ConsignLoanExtBillControllerBean
extends AbstractConsignLoanExtBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.ConsignLoanExtBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        }
        catch (Exception ex) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        return pkReturn;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        boolean isAddNew;
        boolean bl = isAddNew = ((ConsignLoanExtBillInfo)info).getId() == null;
        if (FMHelper.isInstanceof((String)((AbstractCoreBillBaseInfo)info).getSourceBillId(), ConsignmentLoanBillInfo.class)) {
            isAddNew = true;
        }
        if (FMHelper.isInstanceof((String)((AbstractCoreBillBaseInfo)info).getSourceBillId(), LoanExhibitionInfo.class)) {
            isAddNew = true;
        }
        if (((AbstractCoreBillBaseInfo)info).getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)((AbstractCoreBillBaseInfo)info).getSourceBillId(), (String)"1");
        }
        IObjectPK pk = super._submit(ctx, info);
        this.afterSubmit(ctx, info, pk, isAddNew);
        return pk;
    }

    protected void updateChLoanContract(Context ctx, ConsignLoanExtBillInfo info, boolean isDelete) throws EASBizException, BOSException {
        ConsignLoanExtBillInfo cinfo = this.getConsignLoanExtBillInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getLoanSelectors());
        if (isDelete) {
            String sql = " update T_CL_ConsignContact set FEndDate = ? where fid =? and FEndDate = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getBeforeExtDate(), cinfo.getLoan().getConsignContact().getId().toString(), info.getAfterExtDate()});
            return;
        }
        String sql = " update T_CL_ConsignContact set FEndDate = ? where fid =? and FEndDate < ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getAfterExtDate(), cinfo.getLoan().getConsignContact().getId().toString(), info.getAfterExtDate()});
    }

    private void afterSubmit(Context ctx, IObjectValue info, IObjectPK pk, boolean isAddNew) throws BOSException, EASBizException {
        this.updateLoanInfo(ctx, (ConsignLoanExtBillInfo)info, 1, isAddNew);
        this.saveBOTPRelationShip(ctx, (ConsignLoanExtBillInfo)info, pk);
        this.updateChLoanContract(ctx, (ConsignLoanExtBillInfo)info, false);
    }

    private void saveBOTPRelationShip(Context ctx, ConsignLoanExtBillInfo info, IObjectPK pk) throws BOSException {
        if (FMHelper.isInstanceof((String)info.getSourceBillId(), ConsignmentLoanBillInfo.class)) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            botpRelationShip.put(info.getLoan().getId().toString(), pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
        } else if (FMHelper.isInstanceof((String)info.getSourceBillId(), LoanExhibitionInfo.class)) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            botpRelationShip.put(info.getLoan().getId().toString(), pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            ConsignLoanExtBillInfo info = (ConsignLoanExtBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void updateLoanInfo(Context ctx, ConsignLoanExtBillInfo info, int type, boolean updateExtTime) throws BOSException, EASBizException {
        String extTimesUpdate = "";
        if (updateExtTime) {
            extTimesUpdate = " ,FExtTimes = FExtTimes+? ";
        }
        String sql = "update T_CL_ConsignmentLoanBill set FMaturityDate = ?,FHorizon=? " + extTimesUpdate + "  where fid = ?";
        String loanid = info.getLoan().getId().toString();
        if (type == 1) {
            java.util.Date endDate = info.getAfterExtDate();
            Object[] params = null;
            params = updateExtTime ? new Object[]{new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime()), this.getHorizon(ctx, info, endDate), new Integer(1), loanid} : new Object[]{new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime()), this.getHorizon(ctx, info, endDate), loanid};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        } else {
            java.util.Date endDate = info.getBeforeExtDate();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime()), this.getHorizon(ctx, info, endDate), new Integer(-1), loanid});
        }
    }

    private BigDecimal getHorizon(Context ctx, ConsignLoanExtBillInfo info, java.util.Date endDate) throws EASBizException, BOSException {
        java.util.Date startDate = DateTimeUtils.truncateDate((java.util.Date)info.getLoan().getEffectiveDate());
        return FinHorizon.getHorizon((java.util.Date)startDate, (java.util.Date)endDate);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConsignLoanExtBillInfo info = this.getConsignLoanExtBillInfo(ctx, pk, this.getLoanSelectors());
        this.updateLoanInfo(ctx, info, 2, true);
        this.updateChLoanContract(ctx, info, true);
        if (info.getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)info.getSourceBillId(), (String)"0");
        }
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    private SelectorItemCollection getLoanSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loan.id"));
        sic.add(new SelectorItemInfo("loan.effectiveDate"));
        sic.add(new SelectorItemInfo("loan.consignContact.id"));
        return sic;
    }

    @Override
    protected String _audit(Context ctx, List idList) throws BOSException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        if (idList != null && idList.size() > 0) {
            String[] str = new String[idList.size()];
            String lst = FMHelper.Array2String((String[])idList.toArray(str));
            StringBuffer sql = new StringBuffer();
            sql.append("update T_CL_ConsignLoanExtBill set FAuditorID = '");
            sql.append(userID).append("'");
            sql.append(",FBillStatus = ");
            sql.append(2);
            sql.append(" where FID in ");
            sql.append(lst);
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected String _antiaudit(Context ctx, List id) throws BOSException {
        if (id != null && id.size() > 0) {
            String[] str = new String[id.size()];
            String lst = FMHelper.Array2String((String[])id.toArray(str));
            StringBuffer sql = new StringBuffer();
            sql.append("update T_CL_ConsignLoanExtBill set FAuditorID = '");
            sql.append("'");
            sql.append(",FBillStatus = ");
            sql.append(1);
            sql.append(" where FID in ");
            sql.append(lst);
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

