/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillCollection;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillFactory;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillInfo;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillBookNotifyBuilder;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillCollection;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsignLoanIntEntriesBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillCollection;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanException;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillCollection;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.ConsingnmentNoticeInfo;
import com.kingdee.eas.fm.cl.HandlingChargeTypeEnum;
import com.kingdee.eas.fm.cl.ImCLAdjustIntRateCollection;
import com.kingdee.eas.fm.cl.ImCLRepaymentBillCollection;
import com.kingdee.eas.fm.cl.ImClRepaymentBillInfo;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.cl.app.AbstractConsignLoanIntBillControllerBean;
import com.kingdee.eas.fm.cl.app.ConsignLoanIntBillControllerBeanHelper;
import com.kingdee.eas.fm.cl.app.ConsignLoanIntBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.util.TransPrecisionUtil;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.im.IMException;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConsignLoanIntBillControllerBean
extends AbstractConsignLoanIntBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.ConsignLoanIntBillControllerBean");
    private boolean deleteRelated = false;

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        TransPrecisionUtil.trancatePrecision((Context)ctx, (CoreBaseInfo)((CoreBaseInfo)model), (String[])new String[]{"handleChargeAmt", "amount", "shijiIntAmt", "yingjiIntAmt", "yingjiPenaAmt", "shijiPenaAmt", "strikeAmt"}, (CurrencyInfo)((CurrencyInfo)model.get("currency")), null);
        IObjectPK pkReturn = super._addnew(ctx, model);
        ConsignLoanIntBillControllerBeanHelper.afterIntBillSaved(ctx, (ConsignLoanIntBillInfo)model, pkReturn);
        ctx.put((Object)"OPRTSTATE", (Object)"ADDNEW");
        return pkReturn;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ConsingnRepaymentBillInfo repayBill;
        ConsignLoanIntBillInfo oldInfo;
        ConsignLoanIntBillInfo loanIntBillInfo = (ConsignLoanIntBillInfo)model;
        ConsignLoanIntBillInfo info = (ConsignLoanIntBillInfo)model;
        info.setEffectedStatus(StateEnum.SUBMISSION);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((ConsignLoanIntBillInfo)model));
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getConsignLoanIntBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        if (loanIntBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT && (repayBill = loanIntBillInfo.getRepayBill()) != null) {
            BOSObjectType repayBillBOSType = repayBill.getBOSType();
            if (repayBill.getId() == null) {
                BOSUuid id = BOSUuid.create((BOSObjectType)repayBillBOSType);
                repayBill.setId(id);
                repayBill.setHasInterestBill(true);
                loanIntBillInfo.getRepaymentBill().setId(id);
            }
        }
        IObjectPK pk = super._submit(ctx, model);
        ConsignLoanIntBillControllerBeanHelper.afterIntBillSubmited(ctx, loanIntBillInfo, pk);
        if (loanIntBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            return pk;
        }
        ConsignLoanIntBillInfo sumbittedInfo = this.getConsignLoanIntBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, null);
        return pk;
    }

    @Override
    protected ConsignLoanIntBillInfo _repayInt(Context ctx, Date startDate, Date endDate, ConsingnRepaymentBillInfo clRepayInfo) throws BOSException, EASBizException {
        String loanid = clRepayInfo.getLoan().getId().toString();
        HashSet<String> loanIDSet = new HashSet<String>();
        loanIDSet.add(loanid);
        CLRateAdjustmentBillCollection adjustCol = this.getClAdjustColl(ctx, loanIDSet);
        ConsingnRepaymentBillCollection repayCol = this.getClRepayCol(ctx, loanIDSet);
        ConsignmentLoanBillCollection loanCol = this.getClLoanCol(ctx, loanIDSet);
        CLRateAdjustmentBillCollection byLoanId_AdjCol = this.filtedAdjColByLoanId(adjustCol, loanid);
        ConsingnRepaymentBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
        ConsignmentLoanBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
        IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanId_AdjCol, byLoanId_RepayCol, clRepayInfo);
        LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
        ConsignLoanIntBillInfo rs = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, clRepayInfo);
        if (clRepayInfo.getOperationType() != null) {
            rs.setOperationType(clRepayInfo.getOperationType());
        }
        if (clRepayInfo.getConsignCom() != null && clRepayInfo.getConsignCom().getId() != null) {
            String id = clRepayInfo.getConsignCom().getId().toString();
            CompanyOrgUnitInfo cCom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            rs.setConsignCom(cCom);
        }
        return rs;
    }

    @Override
    protected Set _batchPreInt(Context ctx, Set loanIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        ConsignLoanIntBillInfo loanInterestBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        HashSet<String> usedAdjuectID = new HashSet<String>();
        CLRateAdjustmentBillCollection adjustCol = this.getClAdjustColl(ctx, loanIDSet);
        ConsingnRepaymentBillCollection repayCol = this.getClRepayCol(ctx, loanIDSet);
        ConsignmentLoanBillCollection loanCol = this.getClLoanCol(ctx, loanIDSet);
        for (String loanid : loanIDSet) {
            CLRateAdjustmentBillCollection byLoanId_AdjCol = this.filtedAdjColByLoanId(adjustCol, loanid);
            ConsingnRepaymentBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
            ConsignmentLoanBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanId_AdjCol, byLoanId_RepayCol, null);
            LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PRE_INT).calInt(ctx, model);
            loanInterestBillInfo = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, null);
            IObjectPK pk = null;
            if (FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)loanInterestBillInfo.getBOSType())) {
                loanInterestBillInfo.setEffectedStatus(StateEnum.SAVE);
                pk = super.save(ctx, (CoreBaseInfo)loanInterestBillInfo);
            } else {
                pk = super.submit(ctx, (CoreBaseInfo)loanInterestBillInfo);
            }
            LoanInterestEntryCollection iCol = loanIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestBillInfo);
                usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
            }
            createdIntReceivedID.add(pk);
        }
        ConsignLoanIntBillControllerBeanHelper.updateAdjustRateStatus(ctx, usedAdjuectID);
        return createdIntReceivedID;
    }

    @Override
    protected Set _batchRecInt(Context ctx, Set loanIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        ConsignLoanIntBillInfo loanInterestBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        HashSet<String> usedAdjuectID = new HashSet<String>();
        CLRateAdjustmentBillCollection adjustCol = this.getClAdjustColl(ctx, loanIDSet);
        ConsingnRepaymentBillCollection repayCol = this.getClRepayCol(ctx, loanIDSet);
        ConsignmentLoanBillCollection loanCol = this.getClLoanCol(ctx, loanIDSet);
        IntRateTypeCollection intRateTypeColl = null;
        Object intRateTypeInfo = null;
        for (String loanid : loanIDSet) {
            CLRateAdjustmentBillCollection byLoanId_AdjCol = this.filtedAdjColByLoanId(adjustCol, loanid);
            ConsingnRepaymentBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
            ConsignmentLoanBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
            intRateTypeColl = this.filterIntRateTypeByID(adjustCol, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanId_AdjCol, byLoanId_RepayCol, null);
            LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REC_INT).calInt(ctx, model);
            loanInterestBillInfo = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, null);
            IObjectPK pk = null;
            if (FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)loanInterestBillInfo.getBOSType())) {
                loanInterestBillInfo.setEffectedStatus(StateEnum.SAVE);
                pk = super.save(ctx, (CoreBaseInfo)loanInterestBillInfo);
            } else {
                pk = super.submit(ctx, (CoreBaseInfo)loanInterestBillInfo);
            }
            LoanInterestEntryCollection iCol = loanIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestBillInfo);
                usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
            }
            createdIntReceivedID.add(pk);
        }
        ConsignLoanIntBillControllerBeanHelper.updateAdjustRateStatus(ctx, usedAdjuectID);
        return createdIntReceivedID;
    }

    private IntRateTypeCollection filterIntRateTypeByID(CLRateAdjustmentBillCollection adjustColl, String loanId) {
        IntRateTypeCollection returnColl = new IntRateTypeCollection();
        CLRateAdjustmentBillInfo tmp = null;
        for (int i = 0; i < adjustColl.size(); ++i) {
            tmp = adjustColl.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanId) || tmp.getIntRateType() == null) continue;
            returnColl.add(tmp.getIntRateType());
        }
        return returnColl;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            ConsignLoanIntBillInfo info = (ConsignLoanIntBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccount(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccount(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        } else if (new ConsingnmentNoticeInfo().getBOSType().equals((Object)bosType)) {
            ConsignLoanIntBillInfo info = (ConsignLoanIntBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setIsGenerated(false);
            } else {
                info.setIsGenerated(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private ConsignLoanIntBillInfo transfrom(Context ctx, LoanInterestInfo loanIntInfo, ConsignmentLoanBillInfo byLoanID_LoanInfo, ConsingnRepaymentBillInfo clRepayInfo) throws EASBizException, BOSException {
        ConsignLoanIntBillInfo consignLoanIntInfo = new ConsignLoanIntBillInfo();
        LoanInterestEntryCollection entries = loanIntInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            LoanInterestEntryInfo imEntryInfo = entries.get(i);
            ConsignLoanIntEntriesBillInfo clIntBillEntryInfo = new ConsignLoanIntEntriesBillInfo();
            this.copyValuesToEntries(clIntBillEntryInfo, imEntryInfo);
            consignLoanIntInfo.getEntries().add(clIntBillEntryInfo);
        }
        this.copyValuesToHead(ctx, consignLoanIntInfo, loanIntInfo, byLoanID_LoanInfo, clRepayInfo);
        return consignLoanIntInfo;
    }

    private void copyValuesToHead(Context ctx, ConsignLoanIntBillInfo consignLoanIntInfo, LoanInterestInfo loanIntInfo, ConsignmentLoanBillInfo consignmentLoan, ConsingnRepaymentBillInfo clRepayInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (consignLoanIntInfo.getBizDate() != null) {
            consignLoanIntInfo.setBizDate(DateTimeUtils.truncateDate((Date)consignLoanIntInfo.getBizDate()));
        } else {
            consignLoanIntInfo.setBizDate(DateUtil.getDayBegin());
        }
        consignLoanIntInfo.setRepayBill(clRepayInfo);
        consignLoanIntInfo.setRepaymentBill(clRepayInfo);
        consignLoanIntInfo.setLoan(consignmentLoan);
        consignLoanIntInfo.setIntCalType(loanIntInfo.getIntCalType());
        consignLoanIntInfo.setCompany(clRepayInfo == null ? CURRENT_COMPANY : clRepayInfo.getCompany());
        consignLoanIntInfo.setCreator(user);
        consignLoanIntInfo.setCurrency(consignmentLoan.getCurrency());
        consignLoanIntInfo.setBizDate(loanIntInfo.getBizDate());
        consignLoanIntInfo.setStartDate(loanIntInfo.getBeginDate());
        consignLoanIntInfo.setEndDate(loanIntInfo.getEndDate());
        consignLoanIntInfo.setIntervalDays(loanIntInfo.getDays());
        consignLoanIntInfo.setAmount(loanIntInfo.getPrincipal());
        consignLoanIntInfo.setRateExpression(loanIntInfo.getIntRateTypeExp());
        consignLoanIntInfo.setRate(loanIntInfo.getIntRate());
        consignLoanIntInfo.setRateDisplay(this.getRateDisplay(loanIntInfo.getIntRateTypeExp(), loanIntInfo.getIntRate()));
        consignLoanIntInfo.setDescription(loanIntInfo.getDescription());
        consignLoanIntInfo.setOverdueDays(loanIntInfo.getOverdueDays());
        consignLoanIntInfo.setPenaAccrualType(loanIntInfo.getPunishType());
        consignLoanIntInfo.setPenaRate(loanIntInfo.getPunishIntRate());
        consignLoanIntInfo.setPenaRateDisplay(this.getPenaRateDisplay(loanIntInfo.getPunishType(), loanIntInfo.getPunishIntRate()));
        consignLoanIntInfo.setYingjiIntAmt(loanIntInfo.getInterest());
        consignLoanIntInfo.setShijiIntAmt(loanIntInfo.getInterest());
        consignLoanIntInfo.setYingjiPenaAmt(loanIntInfo.getPunishInterest());
        consignLoanIntInfo.setShijiPenaAmt(loanIntInfo.getPunishInterest());
        if (consignLoanIntInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            consignLoanIntInfo.setStrikeAmt(Constants.ZERO);
        } else {
            consignLoanIntInfo.setStrikeAmt(this.getStrikeAmount(ctx, consignLoanIntInfo));
        }
        consignLoanIntInfo.setIsStriked(false);
        consignLoanIntInfo.setStrilkeBy(null);
        consignLoanIntInfo.setFivouchered(false);
        consignLoanIntInfo.setLoanCompany(consignmentLoan.getLoanCompany());
        consignLoanIntInfo.setCustomer(consignmentLoan.getCustomer());
        consignLoanIntInfo.setSettleAcctView(consignmentLoan.getSettleAcctView());
        consignLoanIntInfo.setAcctBank(consignmentLoan.getAccountBank());
        consignLoanIntInfo.setHandleChargeAmt(this.getHandleChargeAmt(consignLoanIntInfo, consignmentLoan));
        consignLoanIntInfo.setSalesTax(this.getSalesTax(consignLoanIntInfo, consignmentLoan));
        if (consignLoanIntInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            consignLoanIntInfo.setLastPreIntDate(this.getLastIntDate(ctx, "PreDate", consignmentLoan, consignLoanIntInfo));
        } else {
            consignLoanIntInfo.setLastSettleDate(consignmentLoan.getLastSettleDate());
        }
        consignLoanIntInfo.setRelationWithCmp(consignmentLoan.getRelationWithCmp());
        consignLoanIntInfo.setLoanInterestInfo(loanIntInfo);
    }

    private Date getLastIntDate(Context ctx, String type, ConsignmentLoanBillInfo consignmentLoan, ConsignLoanIntBillInfo consignLoanIntInfo) throws BOSException {
        Date utilDate = null;
        Integer calType = new Integer(-1);
        calType = type.equals("PreDate") ? new Integer(0) : new Integer(consignLoanIntInfo.getIntCalType().getValue());
        String sql = "select max(FEndDate) from T_CL_ConsignLoanIntBill where FIntCalType=? and FLoanID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{calType, consignmentLoan.getId().toString()});
        try {
            java.sql.Date sqlDate;
            if (rs.next() && (sqlDate = rs.getDate(1)) != null) {
                utilDate = new Date(sqlDate.getTime());
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException(e.getCause());
        }
        if (utilDate == null) {
            utilDate = type.equals("PreDate") ? consignmentLoan.getLastPreIntDate() : consignmentLoan.getLastSettleDate();
        }
        return utilDate;
    }

    private BigDecimal getSalesTax(ConsignLoanIntBillInfo consignLoanIntInfo, ConsignmentLoanBillInfo consignmentLoan) {
        BigDecimal tmp = FMHelper.add((BigDecimal)consignLoanIntInfo.getShijiIntAmt(), (BigDecimal)consignLoanIntInfo.getShijiPenaAmt());
        return FMHelper.multiply((BigDecimal)tmp, (BigDecimal)consignmentLoan.getSalesTaxDeductRate()).divide(Constants.ONE_HUNDRED, consignmentLoan.getCurrency().getPrecision(), 0);
    }

    private BigDecimal getHandleChargeAmt(ConsignLoanIntBillInfo consignLoanIntInfo, ConsignmentLoanBillInfo consignmentLoan) {
        BigDecimal handleChargeAmt = Constants.ZERO;
        if (consignmentLoan.getHandlingChargeType() == HandlingChargeTypeEnum.BY_INSTEREST_PER) {
            BigDecimal tmp = FMHelper.add((BigDecimal)consignLoanIntInfo.getYingjiIntAmt(), (BigDecimal)consignLoanIntInfo.getYingjiPenaAmt());
            handleChargeAmt = FMHelper.multiply((BigDecimal)consignmentLoan.getHandlingChargeRate(), (BigDecimal)tmp).divide(Constants.ONE_HUNDRED, consignmentLoan.getCurrency().getPrecision(), 0);
        } else {
            handleChargeAmt = Constants.ZERO;
        }
        return handleChargeAmt;
    }

    private void copyValuesToEntries(ConsignLoanIntEntriesBillInfo clIntBillEntryInfo, LoanInterestEntryInfo imEntryInfo) {
        clIntBillEntryInfo.setId(BOSUuid.create((BOSObjectType)clIntBillEntryInfo.getBOSType()));
        clIntBillEntryInfo.setSeq(imEntryInfo.getSeq());
        clIntBillEntryInfo.setStartDate(imEntryInfo.getBeginDate());
        clIntBillEntryInfo.setEndDate(imEntryInfo.getEndDate());
        clIntBillEntryInfo.setIntervalDays(imEntryInfo.getDays());
        clIntBillEntryInfo.setAmount(imEntryInfo.getPrincipal());
        clIntBillEntryInfo.setRateExpression(imEntryInfo.getIntRateTypeExp());
        clIntBillEntryInfo.setRate(imEntryInfo.getIntRate());
        clIntBillEntryInfo.setRateDispaly(this.getRateDisplay(imEntryInfo.getIntRateTypeExp(), imEntryInfo.getIntRate()));
        clIntBillEntryInfo.setIntAmt(imEntryInfo.getInterest());
        clIntBillEntryInfo.setYearDays(imEntryInfo.getConvertDays());
        clIntBillEntryInfo.setOverdueDay(imEntryInfo.getOverdueDays());
        clIntBillEntryInfo.setPenaAccrualType(imEntryInfo.getPunishType());
        clIntBillEntryInfo.setPenaRate(imEntryInfo.getPunishIntRate());
        clIntBillEntryInfo.setPenaAccrualType(imEntryInfo.getPunishType());
        clIntBillEntryInfo.setPenaRateDisplay(this.getPenaRateDisplay(imEntryInfo.getPunishType(), imEntryInfo.getPunishIntRate()));
        clIntBillEntryInfo.setPenaAccrualAmt(imEntryInfo.getPunishInterest());
    }

    private String getPenaRateDisplay(PenAccrualTypeEnum punishType, BigDecimal intPenaRate) {
        String penaRateDisplay = "";
        penaRateDisplay = punishType == PenAccrualTypeEnum.ADD_PERCENT ? String.valueOf(intPenaRate) + "%" : String.valueOf(intPenaRate) + "\u2030";
        return penaRateDisplay;
    }

    private String getRateDisplay(IntRateTypeExpressionEnum intRateTypeExp, BigDecimal intRate) {
        String rateDisplay = "";
        rateDisplay = intRateTypeExp == IntRateTypeExpressionEnum.YEAR ? String.valueOf(intRate) + "%" : String.valueOf(intRate) + "\u2030";
        return rateDisplay;
    }

    private IntCalModel getIntCalModel(Date startDate, Date endDate, ILoanInfo byLoanID_LoanInfo, CLRateAdjustmentBillCollection byLoanId_AdjCol, ConsingnRepaymentBillCollection byLoanId_RepayCol, ConsingnRepaymentBillInfo clRepayInfo) {
        ImCLAdjustIntRateCollection iAdjColl = new ImCLAdjustIntRateCollection(byLoanId_AdjCol);
        ImCLRepaymentBillCollection iRepayColl = new ImCLRepaymentBillCollection(byLoanId_RepayCol);
        ImClRepaymentBillInfo imClRepaymentBillInfo = new ImClRepaymentBillInfo(clRepayInfo);
        IntCalModel model = new IntCalModel();
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo(byLoanID_LoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)imClRepaymentBillInfo);
        model.setNewRequirement(false);
        return model;
    }

    private ConsignmentLoanBillInfo filtedLoanColByLoanId(ConsignmentLoanBillCollection loanCol, String loanid) {
        ConsignmentLoanBillInfo tmp = null;
        for (int i = 0; i < loanCol.size() && !(tmp = loanCol.get(i)).getId().toString().equals(loanid); ++i) {
        }
        return tmp;
    }

    private ConsingnRepaymentBillCollection filtedRepayColByLoanId(ConsingnRepaymentBillCollection repayCol, String loanid) {
        ConsingnRepaymentBillCollection repayColReturn = new ConsingnRepaymentBillCollection();
        ConsingnRepaymentBillInfo tmp = null;
        for (int i = 0; i < repayCol.size(); ++i) {
            tmp = repayCol.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanid)) continue;
            repayColReturn.add(tmp);
        }
        return repayColReturn;
    }

    private CLRateAdjustmentBillCollection filtedAdjColByLoanId(CLRateAdjustmentBillCollection adjustCol, String loanid) {
        CLRateAdjustmentBillCollection adjColReturn = new CLRateAdjustmentBillCollection();
        CLRateAdjustmentBillInfo tmp = null;
        for (int i = 0; i < adjustCol.size(); ++i) {
            tmp = adjustCol.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanid)) continue;
            adjColReturn.add(tmp);
        }
        return adjColReturn;
    }

    private ConsignmentLoanBillCollection getClLoanCol(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("currency.id"));
        evi.getSelector().add(new SelectorItemInfo("currency.precision"));
        evi.getSelector().add(new SelectorItemInfo("settleAcctView.id"));
        evi.getSelector().add(new SelectorItemInfo("settleAcctView.number"));
        evi.getSelector().add(new SelectorItemInfo("settleAcctView.name"));
        evi.getSelector().add(new SelectorItemInfo("loanCompany.id"));
        evi.getSelector().add(new SelectorItemInfo("loanCompany.number"));
        evi.getSelector().add(new SelectorItemInfo("loanCompany.name"));
        evi.getSelector().add(new SelectorItemInfo("customer.id"));
        evi.getSelector().add(new SelectorItemInfo("customer.number"));
        evi.getSelector().add(new SelectorItemInfo("customer.name"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.id"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.number"));
        evi.getSelector().add(new SelectorItemInfo("accountBank.name"));
        evi.getSelector().add(new SelectorItemInfo("currency.id"));
        evi.getSelector().add(new SelectorItemInfo("currency.number"));
        evi.getSelector().add(new SelectorItemInfo("currency.name"));
        return ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillCollection(evi);
    }

    private ConsingnRepaymentBillCollection getClRepayCol(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("repayDate"));
        return ConsingnRepaymentBillFactory.getLocalInstance(ctx).getConsingnRepaymentBillCollection(evi);
    }

    private CLRateAdjustmentBillCollection getClAdjustColl(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("IntRateTypeInfo.*"));
        return CLRateAdjustmentBillFactory.getLocalInstance(ctx).getCLRateAdjustmentBillCollection(evi);
    }

    protected BigDecimal getStrikeAmount(Context ctx, ConsignLoanIntBillInfo clIntLoan) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        BigDecimal returnValue = Constants.ZERO;
        sbSQL.append("select sum(FShijiIntAmt) from T_CL_ConsignLoanIntBill ");
        sbSQL.append("where FEndDate<?  and FIntCalType=0 and  FIsStriked=? and FLoanID = ? ");
        Object[] params = new Object[]{new java.sql.Date(clIntLoan.getEndDate().getTime()), new Integer(0), clIntLoan.getLoan().getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
        try {
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    @Override
    protected void _batchSubmit(Context ctx, Set loanIntIDSet) throws BOSException, EASBizException {
        String intBillId2 = "";
        ConsignLoanIntBillInfo info = null;
        for (String intBillId2 : loanIntIDSet) {
            info = this.getConsignLoanIntBillInfo(ctx, (IObjectPK)new ObjectUuidPK(intBillId2));
            super.submit(ctx, (CoreBaseInfo)info);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConsignLoanIntBillInfo loanInterestBillInfo = this.getConsignLoanIntBillInfo(ctx, pk, this.getSelectItemCollection());
        this.deleteCheck(ctx, loanInterestBillInfo);
        ConsignLoanIntBillControllerBeanHelper.afterIntBillDeleted(ctx, loanInterestBillInfo, pk);
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)loanInterestBillInfo, (String)loanInterestBillInfo.getCompany().getId().toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    private SelectorItemCollection getSelectItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("repayBill.*"));
        return sic;
    }

    @Override
    protected void _deleteRaleted(Context ctx, IObjectPK repaymentBillPK) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("repayBill.id", (Object)repaymentBillPK.toString()));
        evi.setFilter(fil);
        ConsignLoanIntBillCollection col = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            this.deleteRelated = true;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(col.get(i).getId()));
        }
    }

    private void deleteCheck(Context ctx, ConsignLoanIntBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        this.checkIsVouchered(loanInterestBillInfo);
        this.checkIsLastInt(loanInterestBillInfo, ctx);
        this.checkIsStriked(loanInterestBillInfo);
        this.checkIsCashier(loanInterestBillInfo);
        if (!this.deleteRelated) {
            this.checkIntCalType(loanInterestBillInfo);
        }
    }

    private void checkIntCalType(ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        if (loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR2);
        }
    }

    private void checkIsCashier(ConsignLoanIntBillInfo loanInterestBillInfo) throws ConsignmentLoanException {
        if (loanInterestBillInfo.getCashier() != null) {
            throw new ConsignmentLoanException(ConsignmentLoanException.BILL_HAS_CASHIER);
        }
    }

    private void checkIsVouchered(ConsignLoanIntBillInfo loanInterestBillInfo) throws ConsignmentLoanException {
        if (loanInterestBillInfo.isFivouchered()) {
            throw new ConsignmentLoanException(ConsignmentLoanException.BILLHASVOUCHERED);
        }
    }

    private void checkIsStriked(ConsignLoanIntBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        if (loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT && loanInterestBillInfo.isIsStriked()) {
            throw new ConsignmentLoanException(ConsignmentLoanException.PRE_INT_BILL_HAS_STRIKED);
        }
    }

    private void checkIsLastInt(ConsignLoanIntBillInfo loanInterestBillInfo, Context ctx) throws EASBizException, BOSException {
        if (loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            this.deletePreInt(loanInterestBillInfo, ctx);
        } else {
            this.deleteOther(loanInterestBillInfo, ctx);
        }
    }

    private void deleteOther(ConsignLoanIntBillInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from T_CL_ConsignLoanIntBill where (fintcaltype = ? or fintcaltype=?) and floanid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), new Integer(1), loanInterestBillInfo.getLoan().getId().toString()});
        Date billEndDate = DateTimeUtils.truncateDate((Date)loanInterestBillInfo.getEndDate());
        try {
            if (rs.next()) {
                Date maxEndDate = new Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                    throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_NON_PRE_INT_BILL);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_NON_PRE_INT_BILL);
        }
    }

    private void deletePreInt(ConsignLoanIntBillInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from T_CL_ConsignLoanIntBill where fintcaltype = ? and floanid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(loanInterestBillInfo.getIntCalType().getValue()), loanInterestBillInfo.getLoan().getId().toString()});
        Date billEndDate = DateTimeUtils.truncateDate((Date)loanInterestBillInfo.getEndDate());
        try {
            if (rs.next()) {
                Date maxEndDate = new Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                    throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_PRE_INT_BILL);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_PRE_INT_BILL);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ConsignLoanIntBillInfo loanInterestBillInfo = this.getConsignLoanIntBillInfo(ctx, pk, this.getSelectItemCollection());
        super._update(ctx, pk, model);
        ctx.put((Object)"OPRTSTATE", (Object)"EDIT");
    }

    private void updateRepaymentBill(Context ctx, ConsignLoanIntBillInfo intInfo) throws BOSException, EASBizException {
        if (intInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            String sql = "update T_CL_ConsingnRepaymentBill set FAccrual=?,penaAccrual=?,handlingChargeAmt=?,FSaleTax=? where fid = ?";
            Object[] params = new Object[]{intInfo.getShijiIntAmt(), intInfo.getShijiPenaAmt(), intInfo.getHandleChargeAmt(), intInfo.getSalesTax(), intInfo.getRepayBill().getId().toString()};
            FMHelper.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    @Override
    protected void _updateColumn(Context ctx, String billId, String columnName, String value) throws BOSException {
        if (billId != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_CL_ConsignLoanIntBill set ");
            sql.append(columnName).append(" = '");
            sql.append(value).append("' ");
            sql.append(" where FID = '").append(billId).append("' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _dispose(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsignLoanIntBillInfo info = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillInfo(pk);
            String billId = info.getId().toString();
            if (NTBookHelper.checkIsBook((Context)ctx, (Date)new Date())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"0_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale()));
            }
            info.setIsDispose(true);
            ConsignLoanIntBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
            NTBookHelper.bookSubsidiary((Context)ctx, (String)billId, (String)ConsignLoanIntBillSubsidiaryBookProvider.class.getName());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unDispose(Context ctx, IObjectPK pk) throws BOSException {
        try {
            ConsignLoanIntBillInfo info = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillInfo(pk);
            String billId = info.getId().toString();
            SubsidiaryLedgerCollection bookColl = NTBookHelper.getLastSubsidiaryLedgerInfo((Context)ctx, (String)billId);
            if (bookColl.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"1_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale()));
            }
            info.setIsDispose(false);
            ConsignLoanIntBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
            NTBookHelper.antiBookSubsidiary((Context)ctx, (String)billId);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        ConsignLoanIntBillBookNotifyBuilder builder = new ConsignLoanIntBillBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_CL_ConsignLoanIntBill SET FCashierID = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            journalColl.addCollection(builder.getJournalColl(ctx, billId));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    @Override
    protected void _cancelBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_CL_ConsignLoanIntBill SET FCashierID = NULL WHERE FID = ? ";
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        ConsignLoanIntBillCollection coll = this.getConsignLoanIntBillCollection(ctx, evi);
        ConsignLoanIntBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getAcctBank() != null) continue;
            throw new LoanException(LoanException.BOOKERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"183_ConsignLoanIntBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _audit(Context ctx, Set ids) throws BOSException, EASBizException {
        String id2 = null;
        for (String id2 : ids) {
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), true);
    }

    @Override
    protected void _unAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        try {
            String id2 = null;
            String sql = null;
            ConsignLoanIntBillInfo billInfo = null;
            for (String id2 : ids) {
                billInfo = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillInfo((IObjectPK)new ObjectUuidPK(id2));
                if (billInfo.isIsGenLoanInt()) {
                    throw new FMException(FMException.HASLOANINTNOTUNAUDIT);
                }
                sql = "select 1 from t_bot_relation where fsrcobjectid = '" + id2 + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    throw new FMException(FMException.HASDESTBILLNOTUNAUDIT);
                }
                super.unAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), false);
    }

    protected void updateState(Context ctx, String id, boolean isAudit) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CL_ConsignLoanIntBill set FEffectedStatus = ?, fauditorID = ?, fauditTime = ? where fid = ? and FEffectedStatus = ?");
        if (isAudit) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{2, userInfo.getId().toString(), new java.sql.Date(this.getCurrentDate().getTime()), id, 1});
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{0, null, null, id, 2});
        }
    }

    protected boolean _isExistPropertyName(Context ctx, CoreBaseInfo coreBaseInfo, String propertyName) {
        return false;
    }

    @Override
    protected void _updateRecment(Context ctx, IObjectPK ConsignLoanIntId) throws BOSException, EASBizException {
        String sql = "update T_CL_ConsignLoanIntBill set FISGENRECEIVING = ? where FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{Boolean.TRUE, ConsignLoanIntId.toString()});
    }

    @Override
    protected Map _batchRecIntWithRetMsg(Context ctx, Set loanIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        String errorMsgHeader = EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource", (String)"recInt_error_header", (Locale)ctx.getLocale());
        String errorMsgBody = EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource", (String)"rec_int_no_principal", (Locale)ctx.getLocale());
        ConsignLoanIntBillInfo loanInterestBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        HashSet<String> usedAdjuectID = new HashSet<String>();
        CLRateAdjustmentBillCollection adjustCol = this.getClAdjustColl(ctx, loanIDSet);
        ConsingnRepaymentBillCollection repayCol = this.getClRepayCol(ctx, loanIDSet);
        ConsignmentLoanBillCollection loanCol = this.getClLoanCol(ctx, loanIDSet);
        IntRateTypeCollection intRateTypeColl = null;
        Object intRateTypeInfo = null;
        for (String loanid : loanIDSet) {
            CLRateAdjustmentBillCollection byLoanId_AdjCol = this.filtedAdjColByLoanId(adjustCol, loanid);
            ConsingnRepaymentBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
            ConsignmentLoanBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
            intRateTypeColl = this.filterIntRateTypeByID(adjustCol, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanId_AdjCol, byLoanId_RepayCol, null);
            LoanInterestInfo loanIntInfo = null;
            try {
                loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REC_INT).calInt(ctx, model);
            }
            catch (FinBizException e) {
                if ("129".equals(e.getSubCode())) {
                    sb.append(byLoanID_LoanInfo.getNumber()).append(errorMsgHeader).append(errorMsgBody).append("\n");
                    continue;
                }
                sb.append(byLoanID_LoanInfo.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
                continue;
            }
            catch (IMException imEx) {
                if ("007".equals(imEx.getSubCode())) {
                    sb.append(MessageFormat.format(imEx.getMessage(), byLoanID_LoanInfo.getNumber())).append("\n");
                    continue;
                }
                sb.append(byLoanID_LoanInfo.getNumber()).append(errorMsgHeader).append(imEx.getMessage()).append("\n");
                continue;
            }
            if (EmptyUtil.isEmpty((Object)loanIntInfo)) continue;
            loanInterestBillInfo = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, null);
            IObjectPK pk = null;
            if (FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)loanInterestBillInfo.getBOSType())) {
                loanInterestBillInfo.setEffectedStatus(StateEnum.SAVE);
                pk = super.save(ctx, (CoreBaseInfo)loanInterestBillInfo);
            } else {
                pk = super.submit(ctx, (CoreBaseInfo)loanInterestBillInfo);
            }
            LoanInterestEntryCollection iCol = loanIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                ConsignLoanIntBillControllerBeanHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestBillInfo);
                usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
            }
            createdIntReceivedID.add(pk);
        }
        ConsignLoanIntBillControllerBeanHelper.updateAdjustRateStatus(ctx, usedAdjuectID);
        hm.put("createdIds", createdIntReceivedID);
        if (sb.length() > 0) {
            String msg = sb.toString();
            hm.put("failureMsg", msg);
        }
        return hm;
    }
}

