/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class ConsignLoanIntBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection collection = new SubsidiaryLedgerCollection();
        ConsignLoanIntBillInfo billInfo = this.getConsignLoanIntInfo(ctx, billId);
        if (billInfo == null) {
            return collection;
        }
        collection.add(this.createConsignBook(billInfo, ctx));
        collection.add(this.createLoanBook(billInfo, ctx));
        return collection;
    }

    private SubsidiaryLedgerInfo createConsignBook(ConsignLoanIntBillInfo info, Context ctx) {
        if (FMHelper.isEmpty((CoreBaseInfo)info.getLoan().getConsignInnerBank())) {
            return new SubsidiaryLedgerInfo();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.CONSIGNLOANINT);
        subInfo.setCompany(info.getCompany());
        subInfo.setApplyUnit(info.getCompany());
        subInfo.setInnerAccount(info.getLoan().getConsignInnerBank());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"2_ConsignLoanIntBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(Constants.ZERO);
        subInfo.setDebitAmount(info.getShijiIntAmt().add(info.getShijiPenaAmt()));
        subInfo.setExchangeRate(info.getLoan().getExchangeRate());
        subInfo.setLocalAmount(info.getAmount());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private SubsidiaryLedgerInfo createLoanBook(ConsignLoanIntBillInfo info, Context ctx) {
        if (FMHelper.isEmpty((CoreBaseInfo)info.getLoan().getLoanCompanyInnerBank())) {
            return new SubsidiaryLedgerInfo();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.CONSIGNLOANINT);
        subInfo.setCompany(info.getCompany());
        subInfo.setApplyUnit(info.getCompany());
        subInfo.setInnerAccount(info.getLoan().getLoanCompanyInnerBank());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"2_ConsignLoanIntBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(info.getShijiIntAmt().add(info.getShijiPenaAmt()));
        subInfo.setDebitAmount(Constants.ZERO);
        subInfo.setExchangeRate(info.getLoan().getExchangeRate());
        subInfo.setLocalAmount(info.getAmount());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private ConsignLoanIntBillInfo getConsignLoanIntInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ConsignLoanIntBillInfo info = null;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        info = ConsignLoanIntBillFactory.getLocalInstance(ctx).getConsignLoanIntBillInfo((IObjectPK)pk);
        String loanID = info.getLoan().getId().toString();
        ConsignmentLoanBillInfo loanInfo = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo((IObjectPK)new ObjectUuidPK(loanID));
        info.setLoan(loanInfo);
        return info;
    }
}

