/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fm.cl.ConsignRepayBookNotifyBuilder;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillCollection;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.OperationTypeEnum;
import com.kingdee.eas.fm.cl.app.AbstractConsignRepayFacadeControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ConsignRepayFacadeControllerBean
extends AbstractConsignRepayFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.cl.app.ConsignRepayFacadeControllerBean");

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        ConsignRepayBookNotifyBuilder builder = new ConsignRepayBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_CL_ConsingnRepaymentBill SET FCashierID = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            journalColl.addCollection(builder.getJournalColl(ctx, billId));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    @Override
    protected void _antiBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_CL_ConsingnRepaymentBill SET FCashierID = NULL WHERE FID = ? ";
        String billId = null;
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        }
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        ConsingnRepaymentBillCollection coll = ConsingnRepaymentBillFactory.getLocalInstance(ctx).getConsingnRepaymentBillCollection(evi);
        ConsingnRepaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.isIsGenRecBill()) {
                FMHelper.throwFMCommonException((String)(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"13_ConsignmentLoanBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"20_ConsignRepayFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            if (info.getAccountBank() == null) {
                FMHelper.throwFMCommonException((String)(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"13_ConsignmentLoanBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"19_ConsignRepayFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            if (info.getOperationType() == OperationTypeEnum.CONSIGN) continue;
            FMHelper.throwFMCommonException((String)(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"13_ConsignmentLoanBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"17_ConsignmentLoanBillFacadeControllerBean", (Locale)ctx.getLocale())));
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }
}

