/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class ConsignmentLoanBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection collection = new SubsidiaryLedgerCollection();
        ConsignmentLoanBillInfo billInfo = this.getConsignmentLoanInfo(ctx, billId);
        if (billInfo == null) {
            return collection;
        }
        collection.add(this.createConsignBook(billInfo, ctx));
        collection.add(this.createLoanBook(billInfo, ctx));
        return collection;
    }

    private SubsidiaryLedgerInfo createConsignBook(ConsignmentLoanBillInfo info, Context ctx) {
        if (FMHelper.isEmpty((CoreBaseInfo)info.getConsignInnerBank())) {
            return new SubsidiaryLedgerInfo();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.CONSIGNLOAN);
        subInfo.setCompany(info.getCompany());
        subInfo.setApplyUnit(info.getConsignCompany());
        subInfo.setInnerAccount(info.getConsignInnerBank());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"18_ConsignmentLoanBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(info.getDisposeAmount());
        subInfo.setDebitAmount(Constants.ZERO);
        subInfo.setLocalAmount(info.getLoanAmtLocal());
        subInfo.setExchangeRate(info.getExchangeRate());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private SubsidiaryLedgerInfo createLoanBook(ConsignmentLoanBillInfo info, Context ctx) {
        if (FMHelper.isEmpty((CoreBaseInfo)info.getLoanCompanyInnerBank())) {
            return new SubsidiaryLedgerInfo();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.CONSIGNLOAN);
        subInfo.setCompany(info.getCompany());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getLoanCompany())) {
            subInfo.setApplyUnit(info.getLoanCompany());
        } else {
            subInfo.setApplyUnit(info.getLoanCompanyInnerBank().getCompany());
        }
        subInfo.setInnerAccount(info.getLoanCompanyInnerBank());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"18_ConsignmentLoanBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(Constants.ZERO);
        subInfo.setDebitAmount(info.getLoanDisposeAmount());
        subInfo.setExchangeRate(info.getExchangeRate());
        subInfo.setLocalAmount(info.getLoanAmtLocal());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private ConsignmentLoanBillInfo getConsignmentLoanInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ConsignmentLoanBillInfo info = null;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        info = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo((IObjectPK)pk, this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("loanCompanyInnerBank.*");
        sic.add("consignInnerBank.*");
        return sic;
    }
}

