/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class ConsingnRepaymentBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection collection = new SubsidiaryLedgerCollection();
        ConsingnRepaymentBillInfo billInfo = this.getConsingnRepaymentBillInfo(ctx, billId);
        if (billInfo == null) {
            return collection;
        }
        collection.add(this.createConsignBook(billInfo, ctx));
        collection.add(this.createLoanBook(billInfo, ctx));
        return collection;
    }

    private SubsidiaryLedgerInfo createConsignBook(ConsingnRepaymentBillInfo info, Context ctx) {
        if (FMHelper.isEmpty((CoreBaseInfo)info.getLoan().getConsignInnerBank())) {
            return new SubsidiaryLedgerInfo();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.CONSIGNLOANREPY);
        subInfo.setCompany(info.getCompany());
        subInfo.setApplyUnit(info.getConsignCom());
        subInfo.setInnerAccount(info.getLoan().getConsignInnerBank());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"23_ConsingnRepaymentBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(Constants.ZERO);
        subInfo.setDebitAmount(info.getRepayAmt().add(info.getAccrual()).add(info.getPenaAccrual()));
        subInfo.setExchangeRate(info.getLoan().getExchangeRate());
        subInfo.setLocalAmount(info.getLoanAmt());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private SubsidiaryLedgerInfo createLoanBook(ConsingnRepaymentBillInfo info, Context ctx) {
        if (FMHelper.isEmpty((CoreBaseInfo)info.getLoan().getLoanCompanyInnerBank())) {
            return new SubsidiaryLedgerInfo();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.CONSIGNLOANREPY);
        subInfo.setCompany(info.getCompany());
        subInfo.setApplyUnit(info.getLoanCompany());
        subInfo.setInnerAccount(info.getLoan().getLoanCompanyInnerBank());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"23_ConsingnRepaymentBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(info.getRepayAmt().add(info.getAccrual()).add(info.getPenaAccrual()));
        subInfo.setDebitAmount(Constants.ZERO);
        subInfo.setExchangeRate(info.getLoan().getExchangeRate());
        subInfo.setLocalAmount(info.getLoanAmt());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private ConsingnRepaymentBillInfo getConsingnRepaymentBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ConsingnRepaymentBillInfo info = null;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        info = ConsingnRepaymentBillFactory.getLocalInstance(ctx).getConsingnRepaymentBillInfo((IObjectPK)pk);
        String loanID = info.getLoan().getId().toString();
        ConsignmentLoanBillInfo loanInfo = ConsignmentLoanBillFactory.getLocalInstance(ctx).getConsignmentLoanBillInfo((IObjectPK)new ObjectUuidPK(loanID));
        info.setLoan(loanInfo);
        return info;
    }
}

