/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.app.RptCLSchemaSourceMaker_ByCompany;
import com.kingdee.eas.fm.cl.app.RptCLSchemaSourceMaker_ByConsignCompany;
import com.kingdee.eas.fm.cl.app.RptCLSchemaSourceMaker_ByDepositary;
import com.kingdee.eas.fm.cl.app.RptCLSchemaSourceMaker_ByLoanPro;
import com.kingdee.eas.fm.cl.app.RptConsignmentLoanFacadeControllerBean;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Locale;
import java.util.Set;

public class RptCLSchemaSourceMaker {
    protected CompanyOrgUnitInfo currentCompany;
    protected CurrencyInfo baseCurrency;
    protected java.util.Date endDate = DateUtil.getDayBegin();
    protected LoanStatisticalUnitEnum amountUnit;
    protected String loc;
    protected String[] companyIDs;
    protected String[] finacingProIDs;
    protected String[] loanCompanyIDs;
    protected String[] customerIDs;
    protected String[] depositaryIDs;
    protected String[] consignCompanyIDs;
    protected String unit = "1";
    protected CurrencyInfo currency;
    protected RelationshipWithLoanCompanyEnum relations;
    protected StringBuffer commonFiler;

    public static RptCLSchemaSourceMaker getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        String queryType = (String)params.getObject("query_type");
        if ("by_company".equals(queryType)) {
            return new RptCLSchemaSourceMaker_ByCompany(params, ctx);
        }
        if ("by_consignCompany".equals(queryType)) {
            return new RptCLSchemaSourceMaker_ByConsignCompany(params, ctx);
        }
        if ("by_deposity".equals(queryType)) {
            return new RptCLSchemaSourceMaker_ByDepositary(params, ctx);
        }
        if ("by_loanProduct".equals(queryType)) {
            return new RptCLSchemaSourceMaker_ByLoanPro(params, ctx);
        }
        return null;
    }

    public RptCLSchemaSourceMaker(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        Set companySet = (Set)params.getObject("companyIDs");
        this.companyIDs = companySet.toArray(new String[companySet.size()]);
        this.endDate = (java.util.Date)params.getObject("endDate");
        this.currency = (CurrencyInfo)params.getObject("currency");
        this.amountUnit = (LoanStatisticalUnitEnum)params.getObject("amount_amt");
        this.finacingProIDs = (String[])params.getObject("by_loanProduct");
        this.relations = (RelationshipWithLoanCompanyEnum)((Object)params.getObject("relations"));
        this.loanCompanyIDs = (String[])params.getObject("chLoanCompany");
        this.consignCompanyIDs = (String[])params.getObject("by_consignCompany");
        this.customerIDs = (String[])params.getObject("Customer");
        this.depositaryIDs = (String[])params.getObject("by_deposity");
        this.loc = this.getLoc(ctx);
        this.prepare(this.amountUnit.getValue());
    }

    public void prepare(String amountUnit) throws BOSException, EASBizException {
        this.commonFiler = this.getCommonFilter();
        if (amountUnit.equals("thousand")) {
            this.unit = "1000";
        } else if (amountUnit.equals("ten_thousand")) {
            this.unit = "10000";
        } else if (amountUnit.equals("million")) {
            this.unit = "1000000";
        } else if (amountUnit.equals("hundred_thousand")) {
            this.unit = "10000000";
        } else if (amountUnit.equals("hundred_million")) {
            this.unit = "100000000";
        }
    }

    public SchemaSource createSchemaSource() {
        SchemaSource ss = new SchemaSource();
        this.assembleSchemaSource(ss);
        return ss;
    }

    protected StringBuffer getCommonFilter() {
        StringBuffer sbCommonFilter = new StringBuffer();
        this.setDateCondition(sbCommonFilter);
        this.setCurrencyCondition(sbCommonFilter);
        this.setCompanyCondition(sbCommonFilter);
        this.setFinaProdeuctCondition(sbCommonFilter);
        this.setDepositaryCondition(sbCommonFilter);
        this.setConsignCompanyCondition(sbCommonFilter);
        this.setFixCompanyCondition(sbCommonFilter);
        this.setStatusCondition(sbCommonFilter);
        return sbCommonFilter;
    }

    protected Object[] getParams() {
        int i;
        Date endDateParam = new Date(DateTimeUtils.truncateDate((java.util.Date)this.endDate).getTime());
        Object[] endDateArray = new Object[]{endDateParam};
        Object[] currencyArray = new Object[]{this.currency.getId().toString()};
        Object[] companyParam = null;
        if (this.companyIDs != null && this.companyIDs.length > 0) {
            companyParam = new Object[this.getPlaceholderCount(this.companyIDs.length)];
            this.setParamArray(companyParam, this.companyIDs);
        }
        int companyParamCount = companyParam == null ? 0 : companyParam.length;
        Object[] finacingProductParam = null;
        if (this.finacingProIDs != null && this.finacingProIDs.length > 0) {
            finacingProductParam = new Object[this.getPlaceholderCount(this.finacingProIDs.length)];
            this.setParamArray(finacingProductParam, this.finacingProIDs);
        }
        int finacingProductParamCount = finacingProductParam == null ? 0 : finacingProductParam.length;
        Object[] depositaryParam = null;
        if (this.depositaryIDs != null && this.depositaryIDs.length > 0) {
            depositaryParam = new Object[this.getPlaceholderCount(this.depositaryIDs.length)];
            this.setParamArray(depositaryParam, this.depositaryIDs);
        }
        int depositaryParamCount = depositaryParam == null ? 0 : depositaryParam.length;
        Object[] fixLoanCompanyParam = null;
        if (this.relations != null) {
            if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                if (this.loanCompanyIDs != null && this.loanCompanyIDs.length > 0) {
                    fixLoanCompanyParam = new Object[this.getPlaceholderCount(this.loanCompanyIDs.length)];
                    this.setParamArray(fixLoanCompanyParam, this.loanCompanyIDs);
                }
            } else if (this.customerIDs != null && this.customerIDs.length > 0) {
                fixLoanCompanyParam = new Object[this.getPlaceholderCount(this.customerIDs.length)];
                this.setParamArray(fixLoanCompanyParam, this.customerIDs);
            }
        }
        int fixLoanCompanyParamCount = fixLoanCompanyParam == null ? 0 : fixLoanCompanyParam.length;
        int allParamCount = 2 + companyParamCount + finacingProductParamCount + depositaryParamCount + fixLoanCompanyParamCount;
        Object[] allParam = new Object[allParamCount];
        int currentPos = 0;
        for (i = 0; i < endDateArray.length; ++i) {
            allParam[i] = endDateArray[i];
        }
        currentPos = endDateArray.length;
        for (i = 0; i < currencyArray.length; ++i) {
            allParam[currentPos + i] = currencyArray[i];
        }
        currentPos += currencyArray.length;
        if (companyParamCount > 0) {
            for (i = 0; i < companyParam.length; ++i) {
                allParam[currentPos + i] = companyParam[i];
            }
        }
        currentPos += companyParamCount;
        if (finacingProductParamCount > 0) {
            for (i = 0; i < finacingProductParam.length; ++i) {
                allParam[currentPos + i] = finacingProductParam[i];
            }
        }
        currentPos += finacingProductParamCount;
        if (depositaryParamCount > 0) {
            for (i = 0; i < depositaryParam.length; ++i) {
                allParam[currentPos + i] = depositaryParam[i];
            }
        }
        currentPos += depositaryParamCount;
        if (fixLoanCompanyParamCount > 0) {
            for (i = 0; i < fixLoanCompanyParam.length; ++i) {
                allParam[currentPos + i] = fixLoanCompanyParam[i];
            }
        }
        currentPos += fixLoanCompanyParamCount;
        return allParam;
    }

    private void setParamArray(Object[] iDParams, String[] idValues) {
        for (int i = 0; i < idValues.length; ++i) {
            iDParams[i] = idValues[i].toString();
        }
        int idCount = idValues.length;
        for (int j = 0; j < iDParams.length - idCount; ++j) {
            iDParams[j + idCount] = "";
        }
    }

    private void setCompanyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FCompanyID", this.companyIDs));
    }

    private void setStatusCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append("(").append("FEffectedStatus = 2 ").append(")");
    }

    private void setFixCompanyCondition(StringBuffer sbCommonFilter) {
        if (this.relations != null) {
            if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.setLoanCompanyCondition(sbCommonFilter);
            } else {
                this.setCustomerCondition(sbCommonFilter);
            }
        }
    }

    protected void setLoanCompanyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FLoanCompanyID", this.loanCompanyIDs)).append("FCustomerID is null and ");
    }

    protected void setCustomerCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FCustomerID", this.customerIDs)).append("FLoanCompanyID is null and ");
    }

    protected void setConsignCompanyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FConsignCompanyID", this.consignCompanyIDs));
    }

    protected void setDepositaryCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FDepositaryID", this.depositaryIDs));
    }

    protected void setFinaProdeuctCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FFinacingProductID", this.finacingProIDs));
    }

    protected void setDateCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append("(").append("FEffectiveDate <= ? ").append(")");
        sbCommonFilter.append(" and ");
    }

    private void setCurrencyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append("(").append("FCurrencyID = ? ").append(")");
        sbCommonFilter.append(" and ");
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    protected String getSQLFilterPrepared(String filed, String[] ids) {
        String returnValue = "";
        if (ids != null && ids.length > 0) {
            StringBuffer sb = new StringBuffer();
            int placeholderCount = this.getPlaceholderCount(ids.length);
            for (int i = 0; i < placeholderCount; ++i) {
                sb.append(filed + " = ? ");
                if (i == placeholderCount - 1) continue;
                sb.append(" or ");
            }
            returnValue = "(" + sb.toString() + ") ";
            returnValue = returnValue + " and ";
        }
        return returnValue;
    }

    protected int getPlaceholderCount(int idCount) {
        if (idCount <= 20) {
            return 20;
        }
        if (idCount > 20 && idCount <= 40) {
            return 40;
        }
        if (idCount > 40 && idCount <= 60) {
            return 60;
        }
        if (idCount > 60 && idCount <= 80) {
            return 80;
        }
        return idCount;
    }

    protected SqlParams getSqlParams() {
        SqlParams sp = new SqlParams();
        Object[] allparams = this.getParams();
        for (int i = 0; i < allparams.length; ++i) {
            sp.addObject(allparams[i]);
        }
        return sp;
    }

    protected String getSumSQLPrepared() {
        return null;
    }

    protected String getMdx() {
        return null;
    }

    protected String getConfigFileName() {
        return null;
    }

    protected void assembleSchemaSource(SchemaSource ss) {
        ss.setDataItem("Fact", this.getSumSQLPrepared(), this.getSqlParams());
        ss.setCaller(RptConsignmentLoanFacadeControllerBean.class);
        ss.setFilename(this.getConfigFileName());
    }

    protected String getSumFields() {
        StringBuffer sb = new StringBuffer();
        sb.append("        sum(FLoanAmt)/").append(this.unit).append(" as FloanAmtSum,    \n");
        sb.append("        sum(FLoanAmt-FLoanBalanceAmt)/").append(this.unit).append(" as FRepayAmtSum,  \n");
        sb.append("        sum(FLoanBalanceAmt*FExchangeRate)/").append(this.unit).append(" as FLoanBalanceSum,  \n");
        return sb.toString();
    }
}

