/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cl.modelutils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.RepayBaseBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AppUtils {
    private static Map botpRelationShip = new HashMap();

    public static void afterRepaymentBillSubmited(Context ctx, RepayBaseBillInfo info) throws EASBizException, BOSException {
        AppUtils.reverseLoanBill(ctx, info);
        AppUtils.saveBOTPRelationShip(ctx, info);
    }

    public static void reverseLoanBillLastRepayDate(Context ctx, RepayBaseBillInfo info) throws EASBizException, BOSException {
        String tableName = "";
        tableName = info instanceof ConsingnRepaymentBillInfo ? "T_CL_ConsignmentLoanBill" : "T_FT_FundTransferBill";
        String sqlUpdated = "update " + tableName + " set FLastRepayDate=? where fid=?";
        FMHelper.execute((Context)ctx, (String)sqlUpdated, (Object[])new Object[]{new java.sql.Date(info.getRepayDate().getTime()), info.getLoanBaseBill().getId().toString()});
    }

    public static void reverseLoanBill(Context ctx, RepayBaseBillInfo info) throws BOSException {
        Object[] objParam = AppUtils.getParmas(info, "A");
        String tableName = "";
        tableName = info instanceof ConsingnRepaymentBillInfo ? "T_CL_ConsignmentLoanBill" : "T_FT_FundTransferBill";
        String sqlUpdated = "update " + tableName + " set FRepayTimes=?,FLoanBalanceAmt=FLoanBalanceAmt-?,FLastRepayDate=?,FRepayTotalAmt=? where fid=?";
        FMHelper.execute((Context)ctx, (String)sqlUpdated, (Object[])objParam);
    }

    private static void saveBOTPRelationShip(Context ctx, RepayBaseBillInfo repaymentBillInfo) throws BOSException {
        botpRelationShip.clear();
        botpRelationShip.put(repaymentBillInfo.getLoanBaseBill().getId().toString(), repaymentBillInfo.getId().toString());
        if (!FMHelper.isEmpty((String)repaymentBillInfo.getSourceBillId()) && !botpRelationShip.containsKey(repaymentBillInfo.getSourceBillId())) {
            botpRelationShip.put(repaymentBillInfo.getSourceBillId(), repaymentBillInfo.getId().toString());
        }
        FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
    }

    private static Object[] getParmas(RepayBaseBillInfo info, String opr) {
        int repayTimes = info.getRepaySeq();
        Integer repayTimeParm = null;
        BigDecimal amtRepay = Constants.ZERO;
        BigDecimal amtToBeDecreased = info.getRepayAmt();
        Date lastRepayDate = null;
        if (opr.equals("A")) {
            lastRepayDate = info.getRepayDate();
            repayTimeParm = new Integer(repayTimes);
            amtRepay = info.getRepayAmt();
        } else if (opr.equals("D")) {
            lastRepayDate = info.getLastRepayDate();
            repayTimeParm = new Integer(repayTimes - 1);
            amtRepay = info.getRepayAmt().negate();
        }
        Object[] objParam = new Object[]{repayTimeParm, amtToBeDecreased, lastRepayDate == null ? null : new java.sql.Date(lastRepayDate.getTime()), amtRepay, info.getLoanBaseBill().getId().toString()};
        return objParam;
    }

    public static void afterRepaymentBillDeleted(Context ctx, RepayBaseBillInfo info) throws EASBizException, BOSException {
        Object[] objParam = AppUtils.getParmas(info, "D");
        String tableName = "";
        tableName = info instanceof ConsingnRepaymentBillInfo ? "T_CL_ConsignmentLoanBill" : "T_FT_FundTransferBill";
        String sqlUpdated = "update " + tableName + " set FRepayTimes=?,FLoanBalanceAmt=FLoanBalanceAmt+?,FLastRepayDate=?,FRepayTotalAmt=FRepayTotalAmt+? where fid=?";
        FMHelper.execute((Context)ctx, (String)sqlUpdated, (Object[])objParam);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }
}

