/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPItemFormulaFormat;
import com.kingdee.eas.fm.fpl.FpCommonException;
import com.kingdee.eas.fm.fpl.FpDataGenerator;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.FpFormulaObject;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpTemplateHelper;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpFormHelper {
    private static Logger logger = Logger.getLogger((String)FpFormHelper.class.getName());
    public static final String RESOURCE = "com.kingdee.eas.fm.fpl.client.FpFormResource";
    public static final String IS_BIZ_ACTUAL = "isBizActual";
    public static final String FP_FORM_DATATYPE = "dataType";
    public static final String FP_SHEET_TAG = "RPTSHEET";
    public static final String ACTUAL_SHEET_TAG = "ACTSHEET";
    public static final String FP_FORM_INFO = "fpFormInfo";
    public static final String FP_FORM_INFO_ID = "fpFormInfoId";
    public static final String FP_AUDIT_UI = "fpAuditUI";
    public static final String FP_FORM_AUDIT_TYPE = "fpFormAuditType";
    public static final String FP_FORM_SHOW_AUDIT = "fpFormShowAudit";
    public static final String FP_FORM_TYPE = "fpFormType";
    public static final String FP_EDIT_TYPE = "fpEditType";
    public static final String FP_AUDIT_TYPE = "fpAuditType";
    public static final String FP_ANTIAUDIT_TYPE = "fpAntiAuditType";
    public static final String FP_ACCREDIT_TYPE = "fpAccreditType";
    public static final String ACTUAL_EDIT_TYPE = "ActualEditType";
    public static final String FP_ADJUST_TYPE = "fpAdjustType";
    public static final String SUB_ORGID_LIST = "subOrgIdList";
    public static final String SUB_PERIODID_LIST = "subPeriodIdList";
    public static final String FORM_COLLECT_TYPE = "fpFormCollectType";
    public static final String ORG_NORMAL_COLLECT = "fpOrgNormalCollect";
    public static final String ORG_ADJUST_COLLECT = "fpOrgAdjustCollect";
    public static final String ORG_ACTUAL_COLLECT = "fpOrgActualCollect";
    public static final String PERIOD_NORMAL_COLLECT = "fpPeriodNormalCollect";
    public static final String HAS_COLLECTED_OU_IDLIST = "hasCollectedOuIdList";
    public static final Color WHITE_COLOR = new Color(255, 255, 255);
    public static final Color ADJUST_COLOR = new Color(0xF6F6B6);

    public static void collectOrgFormDetail(Context ctx, KDTable table, List orgList, String collectType) throws BOSException {
        if (orgList.isEmpty()) {
            return;
        }
        Map map = FpFormHelper.getOrgCollectValueMap(ctx, orgList, collectType);
        Map currInfoMap = FpItemFormulaHelper.getCurrencyInfoMap(ctx);
        RptCell rptCell = null;
        ICell cell = null;
        String formula = null;
        String commonFormula = null;
        String currNumber = null;
        FpItemFormulaParser parser = null;
        BigDecimal value = null;
        BigDecimal tempValue = null;
        int prec = 0;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                value = Constants.ZERO;
                rptCell = (RptCell)cell.getUserObject();
                formula = rptCell.getItemFormulaLine();
                parser = new FpItemFormulaParser(formula);
                parser.parse();
                commonFormula = parser.getCommonFormula();
                if (!map.containsKey(commonFormula)) continue;
                if (collectType.equals(ORG_NORMAL_COLLECT) || collectType.equals(ORG_ADJUST_COLLECT)) {
                    value = ((FpDataInfo)map.get(commonFormula)).getFpValue();
                } else if (collectType.equals(ORG_ACTUAL_COLLECT)) {
                    value = ((FpDataInfo)map.get(commonFormula)).getBizActual();
                }
                currNumber = parser.getCurrency();
                prec = ((CurrencyInfo)currInfoMap.get(currNumber)).getPrecision();
                value = value.divide(Constants.ONE, prec, 6);
                if (collectType.equals(ORG_ADJUST_COLLECT) && value.compareTo(tempValue = cell.getValue() != null && cell.getValue() instanceof BigDecimal ? (BigDecimal)cell.getValue() : Constants.ZERO) != 0) {
                    cell.getStyleAttributes().setBackground(ADJUST_COLOR);
                }
                cell.setValue((Object)value);
            }
        }
    }

    private static Map getOrgCollectValueMap(Context ctx, List orgList, String collectType) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        int size = orgList.size();
        for (int i = 0; i < size; ++i) {
            idList.add(((FullOrgUnitInfo)orgList.get(i)).getId().toString());
        }
        ArrayList<String> stateList = new ArrayList<String>();
        if (collectType.equals(ORG_NORMAL_COLLECT)) {
            stateList.add("editing");
            stateList.add("submited");
            stateList.add("approved");
            stateList.add("executing");
        } else if (collectType.equals(ORG_ADJUST_COLLECT)) {
            stateList.add("approved");
            stateList.add("executing");
        } else if (collectType.equals(ORG_ACTUAL_COLLECT)) {
            List enumList = FpFormStateEnum.getEnumList();
            int size2 = enumList.size();
            for (int i = 0; i < size2; ++i) {
                stateList.add(((FpFormStateEnum)((Object)enumList.get(i))).getValue());
            }
        }
        HashMap<String, FpDataInfo> map = new HashMap<String, FpDataInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT data.FFormula, SUM(data.FFpValue) FpValue, SUM(data.FBizActual) ActualValue \n").append(" FROM T_FPL_FpData data \n").append(" \tJOIN T_FPL_FpForm form ON data.FFpFormID = form.FID \n").append(" WHERE form.FOrgUnitID IN ").append(FpHelper.tranColl2String(idList)).append(" \n AND form.FState IN ").append(FpHelper.tranColl2String(stateList)).append(" \n GROUP BY data.FFormula \n");
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"33_FpFormHelper") + sql));
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            FpDataInfo dataInfo = null;
            String formula = null;
            while (rs.next()) {
                formula = rs.getString("FFormula");
                dataInfo = new FpDataInfo();
                dataInfo.setFpFormula(formula);
                dataInfo.setFpValue(rs.getBigDecimal("FpValue"));
                dataInfo.setBizActual(rs.getBigDecimal("ActualValue"));
                map.put(formula, dataInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return map;
    }

    public static void collectPeriodFormDetail(Context ctx, KDTable table, String orgId, BgPeriodInfo period, List periodList) throws BOSException {
        if (FMHelper.isEmpty((String)orgId) || periodList.isEmpty() || period == null) {
            return;
        }
        Map map = FpFormHelper.getPeriodCollectValueMap(ctx, orgId, period, periodList);
        Map currInfoMap = FpItemFormulaHelper.getCurrencyInfoMap(ctx);
        RptCell rptCell = null;
        ICell cell = null;
        String formula = null;
        String commonFormula = null;
        String currNumber = null;
        FpItemFormulaParser parser = null;
        BigDecimal value = null;
        int prec = 0;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                value = Constants.ZERO;
                rptCell = (RptCell)cell.getUserObject();
                formula = rptCell.getItemFormulaLine();
                parser = new FpItemFormulaParser(formula);
                parser.parse();
                commonFormula = parser.getCommonFormula();
                if (!map.containsKey(commonFormula)) continue;
                value = ((FpDataInfo)map.get(commonFormula)).getFpValue();
                currNumber = parser.getCurrency();
                prec = ((CurrencyInfo)currInfoMap.get(currNumber)).getPrecision();
                value = value.divide(Constants.ONE, prec, 6);
                cell.setValue((Object)value);
            }
        }
    }

    private static Map getPeriodCollectValueMap(Context ctx, String orgId, BgPeriodInfo period, List periodList) throws BOSException {
        HashMap<String, FpDataInfo> map = new HashMap<String, FpDataInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT e.FNumber itemNum, f.FKey asstItemComb, g.FNumber currNum, d.Total FROM \n").append("\t(SELECT a.FFpItemId, a.FFpAssistItemCombId, a.FCurrencyId, SUM(FFpValue) Total FROM T_FPL_FpData a \n").append("\t\tJOIN T_FPL_FpForm b ON a.FFpFormId = b.FID \n").append("\t  WHERE b.FOrgUnitId = ? \n AND a.FFpPeriodId IN ").append(FpHelper.tranColl2String(periodList)).append("\t\n\tGROUP BY a.FFpItemId, a.FFpAssistItemCombId, a.FCurrencyId) d \n").append(" JOIN T_FPL_FpItem e ON d.FFpItemId = e.FID \n").append(" LEFT JOIN T_FPL_FpAssistItemCombi F ON d.FFpAssistItemCombId = f.FID \n").append(" JOIN T_BD_Currency g ON d.FCurrencyID = g.FID ORDER BY itemNum \n");
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"34_FpFormHelper") + sql));
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgId);
            rs = pstmt.executeQuery();
            FPItemFormulaFormat fmt = FPItemFormulaFormat.getInstance();
            FpItemFormulaInfo formulaInfo = null;
            FpDataInfo dataInfo = null;
            String formula = null;
            while (rs.next()) {
                formulaInfo = new FpItemFormulaInfo();
                formulaInfo.setItemNum(rs.getString("itemNum"));
                formulaInfo.setAsstItemCombine(rs.getString("asstItemComb"));
                formulaInfo.setPeriodNum(period.getNumber());
                formulaInfo.setCurrencyNum(rs.getString("currNum"));
                formula = fmt.format(formulaInfo);
                dataInfo = new FpDataInfo();
                dataInfo.setFpFormula(formula);
                dataInfo.setFpValue(rs.getBigDecimal("Total"));
                map.put(formula, dataInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return map;
    }

    public static Map getFormulaAndValueMap(Context ctx, String id) throws FpFormException, EASBizException, BOSException {
        return FpFormHelper.getFormulaAndValueMap(ctx, id, null);
    }

    public static Map getFormulaAndValueMap(Context ctx, String id, FpDataTypeEnum dataType) throws BOSException, EASBizException, FpFormException, FpCommonException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        KDF kdf = FpFormHelper.getKDF(info);
        return FpFormHelper.getFormulaAndValueMap(kdf, dataType);
    }

    public static Map getFormulaAndValueMap(KDF kdf, FpDataTypeEnum dataType) throws FpFormException {
        HashMap<String, BigDecimal> formulaAndValueMap = new HashMap<String, BigDecimal>();
        if (kdf == null) {
            return formulaAndValueMap;
        }
        KDTable table2 = null;
        ICell cell = null;
        int rowCount = 0;
        int colCount = 0;
        BigDecimal value = null;
        String fpFormula = null;
        Collection coll = kdf.getAllTable();
        for (KDTable table2 : coll) {
            if (table2.getID().indexOf(ACTUAL_SHEET_TAG) != -1) continue;
            rowCount = table2.getBody().size();
            colCount = table2.getColumnCount();
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    cell = table2.getCell(i, j);
                    if (!FpFormHelper.hasItemFormula(cell) || FMHelper.isEmpty((String)(fpFormula = FpHelper.getItemFormula(cell)))) continue;
                    fpFormula = FpFormHelper.replaceItemFormula(fpFormula, dataType);
                    value = FpFormHelper.parseBigDecimal(cell);
                    formulaAndValueMap.put(fpFormula, value);
                }
            }
        }
        coll.clear();
        return formulaAndValueMap;
    }

    private static String replaceItemFormula(String formula, FpDataTypeEnum dataType) {
        if (dataType == null) {
            return formula;
        }
        FPItemFormulaFormat itemFmt = FPItemFormulaFormat.getInstance();
        FpItemFormulaInfo info = null;
        try {
            info = (FpItemFormulaInfo)itemFmt.parseObject(formula);
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        info.setDataType(dataType);
        return itemFmt.format(info);
    }

    private static BigDecimal parseBigDecimal(ICell cell) throws FpFormException {
        if (cell == null || cell.getValue() == null || cell.getValue() instanceof FpFormulaObject) {
            return Constants.ZERO;
        }
        String str = cell.getValue().toString();
        BigDecimal value = null;
        try {
            value = new BigDecimal(str);
        }
        catch (Exception e) {
            String range = TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex());
            throw new FpFormException(FpFormException.CELLVALUEISNOTVALID, new String[]{range, str});
        }
        return value;
    }

    public static void drawOutFpData(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FpFormInfo info = (FpFormInfo)model;
        KDF kdf = FpFormHelper.getKDF(info);
        FpFormHelper.saveAsstItemComb(ctx, kdf);
        if (FpDataTypeEnum.P.equals((Object)info.getDataType())) {
            FpFormHelper.drawOutBudget(ctx, pk.toString());
        } else if (FpDataTypeEnum.ADJ.equals((Object)info.getDataType())) {
            FpFormHelper.drawOutAdjust(ctx, pk.toString(), info.getAdjustRootID());
        } else if (FpDataTypeEnum.A.equals((Object)info.getDataType())) {
            FpFormHelper.drawOutActual(ctx, pk.toString());
        }
    }

    private static void saveAsstItemComb(Context ctx, KDF kdf) throws EASBizException, BOSException {
        if (kdf == null) {
            return;
        }
        Collection coll = kdf.getAllTable();
        if (coll != null) {
            KDTable table = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                table = (KDTable)kdf.getTableByIndex(i);
                FpTemplateHelper.getAssistItemCombineMap(ctx, table);
            }
        }
    }

    private static boolean drawOutBudget(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new NullPointerException("_drawOutBudget Id is null!");
        }
        Map map = FpFormHelper.getFormulaAndValueMap(ctx, id);
        FpDataGenerator fpDataGen = new FpDataGenerator(ctx, map, id, FpDataTypeEnum.P);
        fpDataGen.parse();
        fpDataGen.save();
        return true;
    }

    private static boolean drawOutAdjust(Context ctx, String id, String adjustRootID) throws BOSException, EASBizException {
        if (id == null || adjustRootID == null) {
            throw new NullPointerException("_drawOutAdjust Id is null!");
        }
        Map map = FpFormHelper.getFormulaAndValueMap(ctx, id);
        FpDataGenerator fpDataGen = new FpDataGenerator(ctx, map, adjustRootID, FpDataTypeEnum.ADJ);
        fpDataGen.parse();
        fpDataGen.saveAdjustData();
        return true;
    }

    private static boolean drawOutActual(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new NullPointerException("Id is null!");
        }
        Map map = FpFormHelper.getFormulaAndValueMap(ctx, id, FpDataTypeEnum.A);
        FpDataGenerator fpDataGen = new FpDataGenerator(ctx, map, id, FpDataTypeEnum.A);
        fpDataGen.parse();
        fpDataGen.saveActualData();
        return true;
    }

    public static FpFormInfo getFpFormInfo(Context ctx, String id) throws BOSException, EASBizException, FpFormException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IFpForm iFpForm = null;
        iFpForm = ctx == null ? FpFormFactory.getRemoteInstance() : FpFormFactory.getLocalInstance(ctx);
        FpFormInfo info = iFpForm.getFpFormInfo((IObjectPK)pk, FpFormHelper.getSelectors());
        return info;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("fpTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("fpCycle"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("source"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.creator.*"));
        return sic;
    }

    public static Map getFpDataMap(Context ctx, String formId) throws BOSException, EASBizException {
        HashMap<String, FpDataInfo> fpDataMap = new HashMap<String, FpDataInfo>();
        if (formId == null) {
            return fpDataMap;
        }
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ste = null;
        try {
            if (ctx == null) {
                String sql = " SELECT * FROM T_FPL_FpData WHERE FFpFormId = '" + formId + "'";
                ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
                rs = exec.executeSQL();
            } else {
                conn = EJBFactory.getConnection((Context)ctx);
                ste = conn.prepareStatement("SELECT * FROM T_FPL_FpData WHERE FFpFormId =?");
                ste.setString(1, formId);
                rs = ste.executeQuery();
            }
            FpDataInfo info = null;
            while (rs.next()) {
                info = new FpDataInfo();
                info.setId(rs.getString("FID"));
                info.setFpFormId(rs.getString("FFpFormId"));
                info.setFpValue(rs.getBigDecimal("FFpValue"));
                info.setAdjustValue(rs.getBigDecimal("FAdjustValue"));
                info.setBizActual(rs.getBigDecimal("FBizActual"));
                info.setFpFormula(rs.getString("FFormula"));
                info.setFpItemId(rs.getString("FFpItemId"));
                info.setFpAssistItemId(rs.getString("FFpAssistItemCombId"));
                info.setFpPeriodId(rs.getString("FFpPeriodId"));
                info.setCurrencyId(rs.getString("FCurrencyId"));
                fpDataMap.put(rs.getString("FFormula"), info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ste, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ste, (Connection)conn);
        return fpDataMap;
    }

    public static void setDataFormula(FpFormInfo info, boolean isActual) throws BOSException {
        KDF kdf = FpFormHelper.getKDF(info);
        kdf = FpFormHelper.setDataFormula(kdf, isActual);
        try {
            info.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static KDF setDataFormula(KDF kdf, boolean isActual) {
        KDTable table = null;
        Collection collection = kdf.getAllTable();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            table = (KDTable)kdf.getTableByIndex(i);
            FpFormHelper.setDataFormula(table, isActual);
        }
        return kdf;
    }

    private static void setDataFormula(KDTable table, boolean isActual) {
        ICell cell = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                FpFormHelper.setDataFormula(cell, isActual);
            }
        }
    }

    private static void setDataFormula(ICell cell, boolean isActual) {
        if (FpFormHelper.hasItemFormula(cell)) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            ItemFormula itemFormula = rptCell.getItemFormula();
            String fpDataFormula = itemFormula.getExt("FpDataFormula");
            String fpActualFormula = itemFormula.getExt("FpActualFormula");
            if (isActual) {
                if (FMHelper.isEmpty((String)fpActualFormula)) {
                    cell.setExpressions(null);
                } else {
                    cell.setExpressions(fpActualFormula);
                }
            } else if (FMHelper.isEmpty((String)fpDataFormula)) {
                cell.setExpressions(null);
            } else {
                cell.setExpressions(fpDataFormula);
            }
        } else if (cell.getValue() != null && cell.getValue() instanceof FpFormulaObject) {
            FpFormulaObject formula = (FpFormulaObject)cell.getValue();
            cell.setExpressions(formula.getFpDataFormula());
            cell.setValue(null);
        }
    }

    public static boolean hasItemFormula(ICell cell) {
        return cell != null && cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && ((RptCell)cell.getUserObject()).getItemFormula() != null;
    }

    public static String getFormula(ICell cell) {
        if (FpFormHelper.hasItemFormula(cell)) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            ItemFormula itemFormula = rptCell.getItemFormula();
            return itemFormula.getFormula();
        }
        return null;
    }

    public static Map syncKDF(FpFormInfo info, List result) throws BOSException {
        HashMap map = new HashMap();
        if (info == null || result == null || result.isEmpty()) {
            return map;
        }
        KDF kdf = FpFormHelper.getKDF(info);
        if (kdf == null) {
            return map;
        }
        KDTable table = null;
        List rowList = null;
        Collection collection = kdf.getAllTable();
        if (collection == null || collection.isEmpty()) {
            return map;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            table = (KDTable)kdf.getTableByIndex(i);
            rowList = (List)result.get(i);
            FpFormHelper.syncTable(map, table, rowList);
        }
        return map;
    }

    private static void syncTable(Map map, KDTable table, List rowList) throws ParserException {
        if (table == null || rowList == null || rowList.isEmpty()) {
            return;
        }
        ICell cell = null;
        String formula = null;
        List cellList = null;
        Object obj = null;
        BigDecimal value = null;
        FpItemFormulaParser parser = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            cellList = (List)rowList.get(i);
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (!FpFormHelper.hasItemFormula(cell) || FMHelper.isEmpty((String)(formula = FpHelper.getItemFormula(cell)))) continue;
                parser = new FpItemFormulaParser(formula);
                parser.parse();
                formula = parser.getCommonFormula();
                obj = cellList.get(j);
                value = FpFormHelper.parseBigDecimal(obj);
                cell.setValue((Object)value);
                map.put(formula, value);
            }
        }
    }

    private static BigDecimal parseBigDecimal(Object obj) {
        if (obj == null) {
            return Constants.ZERO;
        }
        String value = obj.toString();
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            return Constants.ZERO;
        }
    }

    public static Map beforeSyncFpActual(Context ctx, FpFormInfo info) throws EASBizException, BOSException {
        Map map = FpFormHelper.getFpDataMap(ctx, info.getId().toString());
        KDF kdf = FpFormHelper.getKDF(info);
        FpFormHelper.setFpData(kdf, map, FpDataTypeEnum.A);
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"35_FpFormHelper"));
        FpFormHelper.setDataFormula(kdf, true);
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"36_FpFormHelper"));
        try {
            info.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static void setFpData(Context ctx, FpFormInfo info, FpDataTypeEnum dataType) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (dataType == null) {
            dataType = FpDataTypeEnum.P;
        }
        if (FMHelper.isEmpty((String)info.getAdjustRootID())) {
            return;
        }
        Map fpDataMap = FpFormHelper.getFpDataMap(ctx, info.getAdjustRootID());
        if (fpDataMap == null || fpDataMap.isEmpty()) {
            return;
        }
        KDF kdf = FpFormHelper.getKDF(info);
        kdf = FpFormHelper.setFpData(kdf, fpDataMap, dataType);
        try {
            info.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static KDF setFpData(KDF kdf, Map fpDataMap, FpDataTypeEnum dataType) throws ParserException {
        Collection tableColl = kdf.getAllTable();
        KDTable table = null;
        if (tableColl != null && tableColl.size() > 0) {
            int count = tableColl.size();
            for (int j = 0; j < count; ++j) {
                table = (KDTable)kdf.getTableByIndex(j);
                if (table == null) continue;
                table.setFormulaMode(1);
                table.getScriptManager().setAutoRun(false);
                FpFormHelper.setFpData(table, fpDataMap, dataType, false);
            }
        }
        return kdf;
    }

    public static void setFpData(KDTable table, Map fpDataMap, FpDataTypeEnum dataType, boolean isFpFormQuery) throws ParserException {
        ICell cell = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                FpFormHelper.setFpData(cell, fpDataMap, dataType, isFpFormQuery);
            }
        }
    }

    private static void setFpData(ICell cell, Map fpDataMap, FpDataTypeEnum dataType, boolean isFpFormQuery) throws ParserException {
        if (!FpFormHelper.hasItemFormula(cell)) {
            return;
        }
        RptCell rptCell = (RptCell)cell.getUserObject();
        String itemFormula = rptCell.getItemFormulaLine();
        if (itemFormula == null) {
            return;
        }
        if (isFpFormQuery) {
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        FpItemFormulaParser parser = new FpItemFormulaParser(itemFormula);
        parser.parse();
        String commonFormula = parser.getCommonFormula();
        FpDataInfo dataInfo = (FpDataInfo)fpDataMap.get(commonFormula);
        if (dataType.equals((Object)FpDataTypeEnum.P)) {
            cell.setValue((Object)FpFormHelper.getData(dataInfo, parser.getDataType()));
        } else if (dataType.equals((Object)FpDataTypeEnum.ADJ)) {
            cell.setValue((Object)FpFormHelper.getData(dataInfo, dataType));
        } else if (dataType.equals((Object)FpDataTypeEnum.A)) {
            cell.setValue((Object)FpFormHelper.getData(dataInfo, dataType));
        }
    }

    public static KDF getKDF(FpFormInfo info) throws BOSException {
        KDF kdf = null;
        try {
            kdf = info.getKDF();
        }
        catch (KDFException e) {
            logger.error((Object)e);
            throw new BOSException(e.toString());
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException(e.toString());
        }
        return kdf;
    }

    private static BigDecimal getData(FpDataInfo info, FpDataTypeEnum dataType) {
        if (info == null) {
            return Constants.ZERO;
        }
        if (dataType == null) {
            dataType = FpDataTypeEnum.P;
        }
        if (dataType.equals((Object)FpDataTypeEnum.P)) {
            return info.getFpValue();
        }
        if (dataType.equals((Object)FpDataTypeEnum.ADJ)) {
            return info.getAdjustValue();
        }
        if (dataType.equals((Object)FpDataTypeEnum.A)) {
            return info.getBizActual();
        }
        return Constants.ZERO;
    }

    public static boolean hasCtrlRecord(Context ctx, String formId) throws BOSException {
        if (FMHelper.isEmpty((String)formId)) {
            throw new BOSException("hasCtrlRecord params is null");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FID FROM T_FPL_FpData a \n").append("\tJOIN T_FPL_FpCtrlRecord b ON a.FID = b.FFpDataId \n").append(" WHERE a.FFpFormId ='").append(formId).append("'");
        ISQLExecutor sqlExec = null;
        sqlExec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = sqlExec.executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static KDF getKDF(FpTemplateInfo info) throws BOSException {
        KDF kdf = null;
        try {
            kdf = info.getKDF();
        }
        catch (KDFException e) {
            logger.error((Object)e);
            throw new BOSException(e.toString());
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException(e.toString());
        }
        return kdf;
    }
}

