/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fm.fpl.AbstractFpFormInfo;
import com.kingdee.eas.fm.fpl.FpCommonException;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.log4j.Logger;

public class FpFormInfo
extends AbstractFpFormInfo
implements Serializable {
    private static Logger logger = Logger.getLogger((String)FpFormInfo.class.getName());
    private FpDataTypeEnum dataType;

    public FpFormInfo() {
    }

    protected FpFormInfo(String pkField) {
        super(pkField);
    }

    public FpDataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(FpDataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public void setItemFormulaExt(boolean isActual) throws FpCommonException {
        KDF kdf = null;
        try {
            kdf = this.getKDF();
        }
        catch (KDFException e) {
            logger.error((Object)e);
            throw new FpCommonException(FpCommonException.UNSERIALIZABLE_ERROR);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new FpCommonException(FpCommonException.UNSERIALIZABLE_ERROR);
        }
        if (kdf == null) {
            return;
        }
        Collection collection = kdf.getAllTable();
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                KDTable tempTable = (KDTable)kdf.getTableByIndex(i);
                this.setItemFormulaExt(tempTable, isActual);
            }
        }
        try {
            this.setData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new FpCommonException(FpCommonException.UNSERIALIZABLE_ERROR);
        }
    }

    private void setItemFormulaExt(KDTable table, boolean isActual) {
        ICell cell = null;
        ItemFormula formula = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formula = ((RptCell)cell.getUserObject()).getItemFormula()) == null || cell.getExpressions() == null) continue;
                String dataFormula = cell.getExpressions();
                String key = isActual ? "FpActualFormula" : "FpDataFormula";
                formula.putExt(key, dataFormula);
            }
        }
    }

    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.dataType);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.dataType = (FpDataTypeEnum)((Object)unmarshaller.readObject());
    }
}

