/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.VOComparator;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpCommonException;
import com.kingdee.eas.fm.fpl.TempValueObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class FpHelper {
    private static Logger logger = Logger.getLogger((String)FpHelper.class.getName());
    public static final String FPDATABOSTYPE = "DDDDDDDD";
    public static final String FPITEMCOMBINE = "FPITEMCOMBINE";
    public static final String FPELEMENT = "FPELEMENT";
    public static final String FPCURRENCY = "FPCURRENCY";
    public static final String IS_TEMPLATE_ITEMFORMULA = "isTemplateItemFormula";
    public static final String FP_DATA_FORMULA = "FpDataFormula";
    public static final String FP_ACTUAL_FORMULA = "FpActualFormula";
    public static final String REGEX = "|";
    public static final String CONVERT_REGEX = "\\|";

    public static BigDecimal getBigDecimal(Object obj) {
        BigDecimal value = null;
        if (obj == null) {
            return SysConstant.BIGZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        String s = obj.toString();
        if (s == null || s.trim().length() == 0) {
            value = SysConstant.BIGZERO;
            return value;
        }
        if (!FMClientHelper.verifyIsNumber((String)s)) {
            throw new IllegalArgumentException("object is not BigDecimal type!");
        }
        value = new BigDecimal(s);
        return value;
    }

    public static List getOrgViewTypes(OrgUnitInfo ouInfo) {
        ArrayList<OrgViewType> list = new ArrayList<OrgViewType>();
        if (ouInfo.isIsAdminOrgUnit()) {
            list.add(OrgViewType.ADMIN);
        }
        if (ouInfo.isIsCompanyOrgUnit()) {
            list.add(OrgViewType.COMPANY);
        }
        if (ouInfo.isIsCompanyOrgUnit() || ouInfo.isIsProfitOrgUnit() || ouInfo.isIsCostOrgUnit()) {
            list.add(OrgViewType.RESPONSECENTER);
        }
        if (ouInfo.isIsSaleOrgUnit()) {
            list.add(OrgViewType.SALE);
        }
        if (ouInfo.isIsPurchaseOrgUnit()) {
            list.add(OrgViewType.PURCHASE);
        }
        if (ouInfo.isIsStorageOrgUnit()) {
            list.add(OrgViewType.STORAGE);
        }
        return list;
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0 || param[0] == null;
    }

    public static Set tranArray2Set(String[] ids) {
        if (FpHelper.isEmpty(ids)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        return set;
    }

    public static String[] getIds(Object value) {
        Object[] data = value instanceof Object[] ? (Object[])value : new Object[]{value};
        if (FMHelper.isEmpty((Object[])data)) {
            return null;
        }
        String[] result = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)data[i];
            result[i] = info.getId().toString();
        }
        return result;
    }

    public static void addArray2Set(Set set, Object[] obj) {
        if (set == null) {
            set = new HashSet<Object>();
        }
        for (int i = 0; i < obj.length; ++i) {
            set.add(obj[i]);
        }
    }

    public static String getTimeString() {
        StringBuffer sb = new StringBuffer();
        Calendar instance = Calendar.getInstance();
        sb.append(instance.get(1));
        sb.append(instance.get(2));
        sb.append(instance.get(5));
        sb.append(instance.get(11));
        sb.append(instance.get(12));
        sb.append(instance.get(13));
        return sb.toString();
    }

    public static Vector tranColl2Vec(IObjectCollection objColl) {
        Vector<IObjectValue> vec = new Vector<IObjectValue>();
        if (objColl != null && objColl.size() > 0) {
            for (int i = 0; i < objColl.size(); ++i) {
                IObjectValue objVal = objColl.getObject(i);
                vec.add(objVal);
            }
        }
        return vec;
    }

    public static Map tranColl2Map(IObjectCollection objColl, String[] keys) {
        HashMap<String, IObjectValue> tranMap = new HashMap<String, IObjectValue>();
        int colSize = objColl.size();
        for (int i = 0; i < colSize; ++i) {
            IObjectValue objVal = objColl.getObject(i);
            tranMap.put(FpHelper.getKeyString(objVal, keys), objVal);
        }
        return tranMap;
    }

    public static String[] tranObjArray2StrArray(Object[] objs) {
        String[] strArray = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            strArray[i] = (String)objs[i];
        }
        return strArray;
    }

    public static String getKeyString(IObjectValue iter, String[] keys) {
        StringBuffer sb = new StringBuffer(keys.length * 10);
        for (int i = 0; i < keys.length; ++i) {
            Object val = iter.get(keys[i]);
            if (i != 0) {
                sb.append("_");
            }
            if (val == null) {
                sb.append("null");
                continue;
            }
            if (val instanceof IObjectValue) {
                IObjectValue new_val = (IObjectValue)val;
                Object pk = new_val.get("id");
                if (pk == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(pk);
                continue;
            }
            if (val instanceof BigDecimal) {
                NumberFormat fmt = NumberFormat.getInstance();
                sb.append(fmt.format(val));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public static SelectorItemCollection getUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU"));
        return sic;
    }

    public static int compareFpPeriod(BgPeriodInfo beginFpPeriod, BgPeriodInfo endFpPeriod) {
        if (beginFpPeriod == null) {
            // empty if block
        }
        return endFpPeriod.getNumber().compareTo(beginFpPeriod.getNumber());
    }

    public static boolean compareFpPeriodBegin2End(BgPeriodInfo beginFpPeriod, BgPeriodInfo endFpPeriod) {
        return FpHelper.compareFpPeriod(beginFpPeriod, endFpPeriod) >= 0;
    }

    public static CurrencyInfo getCompanyBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        return FpHelper.getCompanyBaseCurrency(null, company);
    }

    public static CurrencyInfo getCompanyBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        ICompanyOrgUnit corgUnit = null;
        corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        selectors.add("baseCurrency.id");
        selectors.add("baseCurrency.name");
        selectors.add("baseCurrency.number");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static BgPeriodCollection getBgPeriodCollection(int fpPeriodType, Date beginDate, Date endDate) throws Exception {
        return FpHelper.getBgPeriodCollection(null, fpPeriodType, beginDate, endDate);
    }

    public static BgPeriodCollection getBgPeriodCollection(Context ctx, int fpPeriodType, Date beginDate, Date endDate) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItem = filter.getFilterItems();
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        switch (fpPeriodType) {
            case 1: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                break;
            }
            case 2: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS));
                filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and#6) or (#7 and #8 and #9 and #10) ");
                break;
            }
            case 3: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(FpHelper.getQuarterByMonth(beginCal.get(2))), CompareType.GREATER_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(FpHelper.getQuarterByMonth(endCal.get(2))), CompareType.LESS_EQUALS));
                }
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(FpHelper.getQuarterByMonth(endCal.get(2))), CompareType.LESS_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(FpHelper.getQuarterByMonth(beginCal.get(2))), CompareType.GREATER_EQUALS));
                }
                if (beginCal.get(1) == endCal.get(1)) {
                    filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and#6) or (#7 and #8 and #9 and #10) ");
                    break;
                }
                filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 ) or (#6 and #7 and #8) ");
                break;
            }
            case 4: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("month", (Object)new Integer(beginCal.get(2) + 1), CompareType.GREATER_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("month", (Object)new Integer(endCal.get(2) + 1), CompareType.LESS_EQUALS));
                }
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("month", (Object)new Integer(endCal.get(2) + 1), CompareType.LESS_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("month", (Object)new Integer(beginCal.get(2) + 1), CompareType.GREATER_EQUALS));
                }
                if (beginCal.get(1) == endCal.get(1)) {
                    filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and#6) or (#7 and #8 and #9 and #10) ");
                    break;
                }
                filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 ) or (#6 and #7 and #8) ");
                break;
            }
            default: {
                filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum((int)fpPeriodType), CompareType.EQUALS));
            }
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sort = viewInfo.getSorter();
        SorterItemInfo sortItemInfo = new SorterItemInfo("number");
        sortItemInfo.setSortType(SortType.ASCEND);
        sort.add(sortItemInfo);
        IBgPeriod iFpPeriod = null;
        iFpPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodCollection fpPeriodColl = iFpPeriod.getBgPeriodCollection(viewInfo);
        return fpPeriodColl;
    }

    public static int getQuarterByMonth(int month) {
        int quarter = 1;
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                quarter = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                quarter = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                quarter = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                quarter = 4;
            }
        }
        return quarter;
    }

    public static String getParentNumber(String number) {
        if (FMHelper.isEmpty((String)number)) {
            return null;
        }
        int idex = number.lastIndexOf(".");
        if (idex >= 0) {
            return number.substring(0, idex);
        }
        return null;
    }

    public static String getOrgParentNumber(String number) {
        if (FMHelper.isEmpty((String)number)) {
            return null;
        }
        int idex = number.lastIndexOf("!");
        if (idex >= 0) {
            return number.substring(0, idex);
        }
        return null;
    }

    public static String trimString(String s) {
        if (s == null) {
            return s;
        }
        return s.trim();
    }

    public static String trimString(Object s) {
        if (s == null) {
            return null;
        }
        return FpHelper.trimString(s.toString());
    }

    public static BgPeriodCollection getPeriodColl(BgPeriodInfo begin, BgPeriodInfo end) throws BOSException, EASBizException {
        BgPeriodCollection periodColl = new BgPeriodCollection();
        if (begin == null && end == null) {
            return periodColl;
        }
        if (begin == null || end == null) {
            throw new NullPointerException("BeginPeriod or endPeriod is Null!");
        }
        IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
        periodColl = iBgPeriod.getPeriodCollection(begin.getId(), end.getId());
        return periodColl;
    }

    public static List genAssistItemCombine(List groupAndItemList) {
        ArrayList combineList = new ArrayList();
        int size = groupAndItemList.size();
        ArrayList<Object> tempList = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            tempList.add(null);
        }
        FpHelper.fillItem(combineList, tempList, groupAndItemList, 0);
        return combineList;
    }

    private static void fillItem(List combineList, List tempList, List itemGroup, int index) {
        if (itemGroup == null) {
            throw new IllegalArgumentException("itemGroup can not null");
        }
        if (index < 0 || index > itemGroup.size() - 1) {
            throw new IndexOutOfBoundsException("idx must <0 and >" + (itemGroup.size() - 1));
        }
        if (tempList.size() != itemGroup.size()) {
            throw new IllegalArgumentException("template's length must equal itemGroup's Size");
        }
        if (itemGroup.size() - 1 == index) {
            List l = (List)itemGroup.get(index);
            for (int j = 0; j < l.size(); ++j) {
                tempList.set(index, l.get(j));
                FpHelper.genCombineColl(combineList, tempList);
            }
            return;
        }
        List list = (List)itemGroup.get(index);
        for (int i = 0; i < list.size(); ++i) {
            tempList.set(index, list.get(i));
            FpHelper.fillItem(combineList, tempList, itemGroup, index + 1);
        }
    }

    private static List genCombineColl(List combineList, List tempList) {
        TempValueObject info = new TempValueObject();
        FpAssistItemInfo asstItemInfo = null;
        String number = "";
        String name = "";
        String groupItemNum = "";
        String groupItemName = "";
        for (int i = 0; i < tempList.size(); ++i) {
            asstItemInfo = (FpAssistItemInfo)tempList.get(i);
            number = number + asstItemInfo.getNumber() + REGEX;
            name = name + asstItemInfo.getName() + REGEX;
            groupItemNum = groupItemNum + asstItemInfo.getGroup().getNumber() + REGEX + asstItemInfo.getNumber() + REGEX;
            groupItemName = groupItemName + asstItemInfo.getGroup().getName() + REGEX + asstItemInfo.getName() + REGEX;
        }
        info.setAsstItemNum(number.substring(0, number.length() - 1));
        info.setAsstItemName(name.substring(0, name.length() - 1));
        info.setAsstGroupItemNum(groupItemNum.substring(0, groupItemNum.length() - 1));
        info.setAsstGroupItemName(groupItemName.substring(0, groupItemName.length() - 1));
        combineList.add(info);
        return combineList;
    }

    public static Collection sortCollection(Collection coll, String[] sortArray, boolean isASC) {
        VOComparator comp = new VOComparator(sortArray, isASC);
        Object[] infoArray = coll.toArray();
        Arrays.sort(infoArray, comp);
        coll.clear();
        for (int i = 0; i < infoArray.length; ++i) {
            coll.add((IObjectValue)infoArray[i]);
        }
        return coll;
    }

    private static Map getFormulaAndCellMap(KDTable table) {
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        String itemFormula = null;
        RptCell rptCell = null;
        LinkedHashMap<String, List<ICell>> formulaMap = new LinkedHashMap<String, List<ICell>>();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                List<ICell> cellList;
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                rptCell = (RptCell)cell.getUserObject();
                itemFormula = rptCell.getItemFormulaLine();
                if (formulaMap.containsKey(itemFormula)) {
                    cellList = (List)formulaMap.get(itemFormula);
                    if (cellList.contains(cell)) continue;
                    cellList.add(cell);
                    continue;
                }
                cellList = new ArrayList();
                cellList.add(cell);
                formulaMap.put(itemFormula, cellList);
            }
        }
        return formulaMap;
    }

    public static String tranArray2String(String[] idArray) {
        if (idArray == null || idArray.length < 1) {
            return null;
        }
        StringBuffer ids = new StringBuffer();
        int len = idArray.length;
        for (int i = 0; i < len && i <= 999; ++i) {
            if (i == 0) {
                ids.append(" ('" + idArray[i] + "'");
                continue;
            }
            ids.append(", '" + idArray[i] + "'");
        }
        ids.append(") ");
        return ids.toString();
    }

    public static String tranColl2String(Collection idColl) {
        if (idColl == null || idColl.size() < 1) {
            return null;
        }
        String ids = null;
        Iterator iter = idColl.iterator();
        for (int i = 0; iter.hasNext() && i <= 999; ++i) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public static String[] getFpPeriodIds(Context ctx, String beginPeriodId, String endPeriodId) throws BOSException, EASBizException {
        BOSUuid sId = BOSUuid.read((String)beginPeriodId);
        BOSUuid eId = BOSUuid.read((String)endPeriodId);
        IBgPeriod iFpP = BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodCollection fpPeiodColl = iFpP.getPeriodCollection(sId, eId);
        String[] ids = new String[fpPeiodColl.size()];
        for (int i = 0; i < fpPeiodColl.size(); ++i) {
            ids[i] = fpPeiodColl.get(i).getId().toString();
        }
        return ids;
    }

    public static String[] getFpPeriodIdsByNum(Context ctx, String beginPeriodNum, String endPeriodNum) throws BOSException, EASBizException {
        if (beginPeriodNum == null || beginPeriodNum.trim().length() <= 0 || endPeriodNum == null || endPeriodNum.trim().length() <= 0) {
            return null;
        }
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodInfo info = null;
        String oql = "SELECT id WHERE number = '" + beginPeriodNum + "'";
        info = iBgPeriod.getBgPeriodInfo(oql);
        BOSUuid sId = info.getId();
        oql = "SELECT id WHERE number = '" + endPeriodNum + "'";
        info = iBgPeriod.getBgPeriodInfo(oql);
        BOSUuid eId = info.getId();
        BgPeriodCollection fpPeiodColl = iBgPeriod.getPeriodCollection(sId, eId);
        String[] ids = new String[fpPeiodColl.size()];
        for (int i = 0; i < fpPeiodColl.size(); ++i) {
            ids[i] = fpPeiodColl.get(i).getId().toString();
        }
        return ids;
    }

    public static BigDecimal getFpBalance(BigDecimal fpValue, BigDecimal bizActual) {
        if (fpValue != null && bizActual != null) {
            return fpValue.subtract(bizActual);
        }
        if (fpValue == null && bizActual != null) {
            return bizActual.negate();
        }
        if (fpValue != null && bizActual == null) {
            return fpValue;
        }
        return null;
    }

    public static FullOrgUnitInfo getFullOrgUnitInfoById(Context ctx, String currentOrgUnitId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("isLeaf");
        selectors.add("longNumber");
        FullOrgUnitInfo currentOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrgUnitId), selectors);
        return currentOrgUnit;
    }

    public static KDTable getKDTableByByteData(byte[] data) throws BOSException {
        if (data == null) {
            return null;
        }
        KDTable kdtable = null;
        try {
            KDF kdf = ZipKDF.unpack((byte[])data);
            Collection coll = kdf.getAllTable();
            if (coll.size() > 0) {
                kdtable = (KDTable)coll.iterator().next();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return kdtable;
    }

    public static KDF getKDF(byte[] data) throws FpCommonException {
        KDF kdf = null;
        if (data == null) {
            return null;
        }
        try {
            kdf = ZipKDF.unpack((byte[])data);
        }
        catch (KDFException ex) {
            logger.error((Object)ex);
            throw new FpCommonException(FpCommonException.UNSERIALIZABLE_ERROR);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (kdf == null) {
            throw new FpCommonException(FpCommonException.UNSERIALIZABLE_ERROR);
        }
        return kdf;
    }

    public static void closeInputByte(ByteArrayInputStream data) {
        if (data != null) {
            try {
                data.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                data = null;
            }
        }
    }

    public static void closeOutputByte(ByteArrayOutputStream data) {
        if (data != null) {
            try {
                data.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                data = null;
            }
        }
    }

    public static String[] getItemParams(ICell cell) throws ParserException {
        if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) {
            return null;
        }
        String itemFormula = FpHelper.getItemFormula(cell);
        if (itemFormula == null) {
            return null;
        }
        List list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
        if (list == null || list.size() == 0) {
            return null;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        return params;
    }

    public static String[] getItemParams(String itemFormula) throws ParserException {
        List list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
        if (list == null || list.size() == 0) {
            return null;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        return params;
    }

    public static String getItemFormula(ICell cell) {
        if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) {
            return null;
        }
        RptCell rCell = (RptCell)cell.getUserObject();
        String itemFormula = rCell.getItemFormulaLine();
        return itemFormula;
    }

    public static String popStringData(IObjectValue info, Hashtable hsData, String fieldName) {
        if (info == null || hsData == null || FMHelper.isEmpty((String)fieldName)) {
            return null;
        }
        Object val = FpHelper.getData(hsData, fieldName);
        if (val == null) {
            return null;
        }
        String trimValue = val.toString().trim();
        if (trimValue.length() > 0) {
            info.setString(fieldName, trimValue);
        }
        return trimValue;
    }

    public static Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public static boolean isSamePeriodType(BgPeriodInfo bPeriod, BgPeriodInfo ePeriod) {
        if (bPeriod == null || ePeriod == null) {
            return false;
        }
        return bPeriod.getPeriodType().equals((Object)ePeriod.getPeriodType());
    }

    public static boolean isBeginLargerEnd(BgPeriodInfo bPeriod, BgPeriodInfo ePeriod) {
        String endNum;
        String beginNum;
        boolean isBeginLargerEnd = false;
        if (bPeriod.getPeriodType().getValue() == 1) {
            if (bPeriod.getYear() > ePeriod.getYear()) {
                isBeginLargerEnd = true;
            }
        } else if (bPeriod.getPeriodType().getValue() == 2) {
            int endNum2;
            int beginNum2 = bPeriod.getYear() * 100 + bPeriod.getHalfYear();
            if (beginNum2 > (endNum2 = ePeriod.getYear() * 100 + ePeriod.getHalfYear())) {
                isBeginLargerEnd = true;
            }
        } else if (bPeriod.getPeriodType().getValue() == 3) {
            int endNum3;
            int beginNum3 = bPeriod.getYear() * 100 + bPeriod.getQuarter();
            if (beginNum3 > (endNum3 = ePeriod.getYear() * 100 + ePeriod.getQuarter())) {
                isBeginLargerEnd = true;
            }
        } else if (bPeriod.getPeriodType().getValue() == 4) {
            int endNum4;
            int beginNum4 = bPeriod.getYear() * 100 + bPeriod.getMonth();
            if (beginNum4 > (endNum4 = ePeriod.getYear() * 100 + ePeriod.getMonth())) {
                isBeginLargerEnd = true;
            }
        } else if (bPeriod.getPeriodType().getValue() == 6) {
            int endNum5;
            int beginNum5 = bPeriod.getYear() * 100 + bPeriod.getWeek();
            if (beginNum5 > (endNum5 = ePeriod.getYear() * 100 + ePeriod.getWeek())) {
                isBeginLargerEnd = true;
            }
        } else if (bPeriod.getPeriodType().getValue() == 7 && (beginNum = bPeriod.getLongNumber()).compareTo(endNum = ePeriod.getLongNumber()) > 0) {
            isBeginLargerEnd = true;
        }
        return isBeginLargerEnd;
    }

    public static String getBlank(int len) {
        String blank = "";
        for (int i = 0; i < len; ++i) {
            blank = blank + " ";
        }
        return blank;
    }

    public static boolean isOrgCtrlFpItem(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"FP001") : ParamManager.getParamValue((Context)ctx, null, (String)"FP001");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (paramValue == null || paramValue.trim().equals("")) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }
}

