/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.eas.util.client.EASResource;
import java.util.Calendar;
import java.util.Date;

public final class FpPeriodHelper {
    public static final String STRRESOURCE = "com.kingdee.eas.fm.fpl.client.FpPeriodResource";
    public static final Calendar calendar = Calendar.getInstance();
    public static final String SEPARATOR = ".";
    public static final String LONGSEPARATOR = "!";
    public static final int showStart = 100;
    public static final String YearCode = "Y";
    public static final int YearLevel = 1;
    public static final int showYear = 1;
    public static final String HalfYearCode = "HY";
    public static final int HalfYearLevel = 2;
    public static final int showHalfYear = 900;
    public static final String QuarterCode = "Q";
    public static final int QuarterLevel = 3;
    public static final int showQuarter = 400;
    public static final String MonthCode = "M";
    public static final int MonthLevel = 4;
    public static final int MonthShowLevel = 50;
    public static final String WeekCode = "W";
    public static final String YearWeekCode = "W";
    public static final int YearWeekLevel = 2;
    public static final int showYearWeek = 1900;
    public static final String DayCode = "D";
    public static final int DayLevel = 5;
    public static final String MonthWeekCode = "MW";
    public static final int MonthWeekLevel = 5;
    public static final int showMonthWeek = 90;

    public static String getHalfYearName(int i) {
        String s = "";
        if (i == 1) {
            s = EASResource.getString((String)STRRESOURCE, (String)"firstHalfYear");
        } else if (i == 2) {
            s = EASResource.getString((String)STRRESOURCE, (String)"lastHalfYear");
        }
        return s;
    }

    public static int getYear() {
        calendar.clear();
        calendar.setTime(new Date());
        return calendar.get(1);
    }

    public static int getQuarter() {
        return 4;
    }

    public static int getMonth() {
        return 12;
    }

    public static int getDaysOfYear(int Year) {
        if (FpPeriodHelper.isLeapYear(Year)) {
            return 366;
        }
        return 365;
    }

    public static Date getFirstDay(int Year) {
        calendar.clear();
        calendar.set(Year, 0, 1);
        return calendar.getTime();
    }

    public static Date getLastDay(int Year) {
        calendar.clear();
        calendar.setTime(FpPeriodHelper.getFirstDay(Year + 1));
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date getHalfYearFirstDay(int year, int halfYear) {
        calendar.clear();
        switch (halfYear) {
            case 1: {
                calendar.set(year, 0, 1);
                break;
            }
            case 2: {
                calendar.set(year, 6, 1);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getHalfYearLastDay(int year, int halfYear) {
        calendar.clear();
        switch (halfYear) {
            case 1: {
                calendar.set(year, 5, 30);
                break;
            }
            case 2: {
                calendar.set(year, 11, 31);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getQuarterFirstDay(int Year, int Quarter) {
        calendar.clear();
        switch (Quarter) {
            case 1: {
                calendar.set(Year, 0, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 9, 1);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getQuarterLastDay(int Year, int Quarter) {
        calendar.clear();
        switch (Quarter) {
            case 1: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 9, 1);
                break;
            }
            case 4: {
                calendar.set(Year + 1, 0, 1);
                break;
            }
        }
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date getMonthFirstDay(int Year, int Month) {
        calendar.clear();
        switch (Month) {
            case 1: {
                calendar.set(Year, 0, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 1, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 2, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 5: {
                calendar.set(Year, 4, 1);
                break;
            }
            case 6: {
                calendar.set(Year, 5, 1);
                break;
            }
            case 7: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 8: {
                calendar.set(Year, 7, 1);
                break;
            }
            case 9: {
                calendar.set(Year, 8, 1);
                break;
            }
            case 10: {
                calendar.set(Year, 9, 1);
                break;
            }
            case 11: {
                calendar.set(Year, 10, 1);
                break;
            }
            case 12: {
                calendar.set(Year, 11, 1);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getMonthLastDay(int Year, int Month) {
        calendar.clear();
        switch (Month) {
            case 1: {
                calendar.set(Year, 1, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 2, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 4, 1);
                break;
            }
            case 5: {
                calendar.set(Year, 5, 1);
                break;
            }
            case 6: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 7: {
                calendar.set(Year, 7, 1);
                break;
            }
            case 8: {
                calendar.set(Year, 8, 1);
                break;
            }
            case 9: {
                calendar.set(Year, 9, 1);
                break;
            }
            case 10: {
                calendar.set(Year, 10, 1);
                break;
            }
            case 11: {
                calendar.set(Year, 11, 1);
                break;
            }
            case 12: {
                calendar.set(Year + 1, 0, 1);
                break;
            }
        }
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static int getDayOfMonth(int Year, int Month) {
        int days = 0;
        if (Month == 1 || Month == 3 || Month == 5 || Month == 7 || Month == 8 || Month == 10 || Month == 12) {
            days = 31;
        } else if (Month == 4 || Month == 6 || Month == 9 || Month == 11) {
            days = 30;
        } else if (Month == 2) {
            days = FpPeriodHelper.isLeapYear(Year) ? 29 : 28;
        }
        return days;
    }

    public static Date getDay(int Year, int Month, int Day) {
        calendar.clear();
        calendar.set(Year, Month - 1, Day);
        return calendar.getTime();
    }

    public static int getDayOfWeek(int Year, int Month, int Day) {
        calendar.clear();
        calendar.set(Year, Month - 1, Day);
        return calendar.get(7);
    }

    public static int getWeek(int Year, boolean isYear) {
        int Week = 53;
        Week = isYear ? FpPeriodHelper.getYearWeek(Year) : FpPeriodHelper.getMonthWeek(Year);
        return Week;
    }

    private static int getYearWeek(int Year) {
        int Week = 53;
        calendar.clear();
        Week = FpPeriodHelper.isLeapYear(Year) ? (FpPeriodHelper.getDayOfWeek(Year, 1, 1) == 7 ? 54 : 53) : 53;
        return Week;
    }

    private static int getMonthWeek(int Year) {
        int week = 0;
        for (int i = 1; i <= 12; ++i) {
            calendar.clear();
            calendar.setTime(FpPeriodHelper.getMonthLastDay(Year, i));
            week += calendar.get(4);
        }
        return week;
    }

    public static boolean isLeapYear(int Year) {
        return Year % 400 == 0 || Year % 4 == 0 && Year % 100 != 0;
    }

    public static Date getWeekFirstDay(int Year, int Week) {
        if (Week == 1) {
            return FpPeriodHelper.getFirstDay(Year);
        }
        calendar.clear();
        int days = FpPeriodHelper.getDayOfWeek(Year, 1, 1);
        calendar.set(Year, 0, 1);
        calendar.add(3, Week - 1);
        calendar.add(6, 1 - days);
        return calendar.getTime();
    }

    public static Date getWeekLastDay(int Year, int Week) {
        if (Week >= 53) {
            return FpPeriodHelper.getLastDay(Year);
        }
        calendar.clear();
        int days = FpPeriodHelper.getDayOfWeek(Year, 1, 1);
        calendar.set(Year, 0, 1);
        calendar.add(3, Week);
        calendar.add(6, -1);
        calendar.add(6, 1 - days);
        return calendar.getTime();
    }

    public static Date getMonthWeekFirstDay(int Year, int Month, int Week) {
        calendar.clear();
        calendar.setTime(FpPeriodHelper.getMonthFirstDay(Year, Month));
        int n = FpPeriodHelper.getDayOfMonth(Year, Month);
        for (int i = 1; i <= n; ++i) {
            if (calendar.get(4) == Week) {
                return calendar.getTime();
            }
            calendar.add(6, 1);
        }
        return calendar.getTime();
    }

    public static Date getMonthWeekLastDay(int Year, int Month, int Week) {
        calendar.clear();
        calendar.setTime(FpPeriodHelper.getMonthLastDay(Year, Month));
        int n = 1;
        for (int i = FpPeriodHelper.getDayOfMonth(Year, Month); i >= n; --i) {
            if (calendar.get(4) == Week) {
                return calendar.getTime();
            }
            calendar.add(6, -1);
        }
        return calendar.getTime();
    }
}

