/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpTemplateCollection;
import com.kingdee.eas.fm.fpl.FpTemplateException;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.IFpTemplate;
import com.kingdee.eas.fm.fpl.TemRefBgPeriodsInfo;
import com.kingdee.eas.fm.fpl.TemRefCurrenciesInfo;
import com.kingdee.eas.fm.fpl.TemRefFPAssistItemCombinesInfo;
import com.kingdee.eas.fm.fpl.TemRefFPItemsInfo;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FpTemplateHelper {
    public static final String OPER_COPY = "COPY";

    public static void saveRefProp(Context ctx, String templatePk, KDTable table) throws BOSException, EASBizException {
        HashMap<String, String> refItemMap = new HashMap<String, String>();
        Map refAssistItemMap = new HashMap();
        HashMap<String, String> refPeriodMap = new HashMap<String, String>();
        HashMap<String, String> refCurrencyMap = new HashMap<String, String>();
        Map itemMap = FpItemFormulaHelper.getItemMap(ctx);
        Map periodMap = FpItemFormulaHelper.getPeriodMap(ctx);
        Map currencyMap = FpItemFormulaHelper.getCurrencyMap(ctx);
        ICell cell = null;
        String range = null;
        String formula = null;
        String[] params = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                params = FpHelper.getItemParams(cell);
                formula = FpHelper.getItemFormula(cell);
                if (params == null || params.length != 5 || !formula.startsWith("=FpItem")) {
                    range = TableToolkit.xy2range((int)j, (int)i);
                    throw new FpTemplateException(FpTemplateException.ITEMFORMULA_ERROR, new Object[]{range, formula});
                }
                if (FMHelper.isEmpty((String)params[0])) {
                    throw new FpFormException(FpFormException.SUBMITNOITEM, new String[]{formula});
                }
                if (!refItemMap.containsValue(params[0])) {
                    String fpItemId = (String)itemMap.get(params[0]);
                    if (!FMHelper.isEmpty((String)fpItemId)) {
                        refItemMap.put(fpItemId, params[0]);
                    } else {
                        throw new FpFormException(FpFormException.SUBMITERRORITEM, new String[]{formula, params[0]});
                    }
                }
                if (!FMHelper.isEmpty((String)params[2]) && !refPeriodMap.containsValue(params[2])) {
                    String fpPeriodId = (String)periodMap.get(params[2]);
                    if (!FMHelper.isEmpty((String)fpPeriodId)) {
                        refPeriodMap.put(fpPeriodId, params[2]);
                    } else {
                        throw new FpFormException(FpFormException.SUBMITERRORPERIOD, new String[]{formula, params[2]});
                    }
                }
                if (FMHelper.isEmpty((String)params[4]) || refCurrencyMap.containsValue(params[4])) continue;
                String currencyId = (String)currencyMap.get(params[4]);
                if (!FMHelper.isEmpty((String)currencyId)) {
                    refCurrencyMap.put(currencyId, params[4]);
                    continue;
                }
                throw new FpFormException(FpFormException.SUBMITERRORCURRENCY, new String[]{formula, params[4]});
            }
        }
        refAssistItemMap = FpTemplateHelper.getAssistItemCombineMap(ctx, table);
        FpTemplateHelper.saveRefItem(ctx, templatePk, refItemMap);
        FpTemplateHelper.saveRefAssistItem(ctx, templatePk, refAssistItemMap);
        FpTemplateHelper.saveRefPeriod(ctx, templatePk, refPeriodMap);
        FpTemplateHelper.saveRefCurrency(ctx, templatePk, refCurrencyMap);
    }

    public static Map getAssistItemCombineMap(Context ctx, KDTable table) throws BOSException, EASBizException {
        ICell cell = null;
        String[] params = null;
        Map asstItemCombMap = FpItemFormulaHelper.getAsstItemCombMap(ctx);
        HashMap<String, String> hasExistMap = new HashMap<String, String>();
        HashMap<String, String> noExistMap = new HashMap<String, String>();
        String formula = null;
        String asstItemComb = null;
        String id = null;
        int rowCount = table.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            int colCount = table.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                formula = FpHelper.getItemFormula(cell);
                params = FpHelper.getItemParams(cell);
                if (params == null || params.length != 5 || FMHelper.isEmpty((String)(asstItemComb = params[1]))) continue;
                if (!FpItemFormulaHelper.validateAsstItemComb(ctx, asstItemComb)) {
                    throw new FpFormException(FpFormException.SUBMITERRORASSTITEM, new Object[]{formula, asstItemComb});
                }
                if (asstItemCombMap.containsKey(asstItemComb)) {
                    id = (String)asstItemCombMap.get(asstItemComb);
                    hasExistMap.put(id, asstItemComb);
                    continue;
                }
                if (noExistMap.containsKey(asstItemComb)) continue;
                noExistMap.put(asstItemComb, asstItemComb);
            }
        }
        Map newSaveMap = FpTemplateHelper.saveAsstItemCombine(ctx, noExistMap);
        hasExistMap.putAll(newSaveMap);
        return hasExistMap;
    }

    private static Map saveAsstItemCombine(Context ctx, Map asstItemCombMap) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (asstItemCombMap == null || asstItemCombMap.size() <= 0) {
            return map;
        }
        String asstItemComb2 = null;
        String[] asstItems = null;
        String[] refFields = null;
        Map asstItemMap = FpItemFormulaHelper.getAsstItemMap(ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = null;
        String asstItemId = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Collection valueColl = asstItemCombMap.values();
            for (String asstItemComb2 : valueColl) {
                int j;
                asstItems = FpItemFormulaParser.getAssistItems(asstItemComb2);
                refFields = FpTemplateHelper.getRefField(ctx, asstItems, asstItemMap);
                int itemLen = asstItems.length;
                sql = new StringBuffer();
                sql.append(" INSERT INTO T_FPL_FpAssistItemCombi (FID, ");
                for (j = 0; j < refFields.length; ++j) {
                    sql.append(refFields[j] + " , ");
                }
                sql.append(" FKey, FIsLeaf) ");
                sql.append(" VALUES ( ? , ");
                for (j = 0; j < itemLen; ++j) {
                    sql.append(" ? , ");
                }
                sql.append(" ?, ? ) ");
                pstmt = conn.prepareStatement(sql.toString());
                String fId = Uuid.create().toString() + "ABCDEFGH";
                int index = 0;
                pstmt.setString(++index, fId);
                for (int j2 = 0; j2 < itemLen; ++j2) {
                    asstItemId = ((FpAssistItemInfo)asstItemMap.get(asstItems[j2])).getId().toString();
                    pstmt.setString(++index, asstItemId);
                }
                pstmt.setString(++index, asstItemComb2);
                pstmt.setInt(++index, FpTemplateHelper.isLeafAssistItemCombine(ctx, asstItems, asstItemMap));
                pstmt.executeUpdate();
                map.put(fId, asstItemComb2);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
        return map;
    }

    private static int isLeafAssistItemCombine(Context ctx, String[] asstItems, Map asstItemMap) throws BOSException {
        if (asstItems == null || asstItems.length <= 0) {
            throw new NullPointerException("AssistItemCombine should be not null!");
        }
        if (asstItems == null) {
            return 0;
        }
        FpAssistItemInfo info = null;
        int length = asstItems.length;
        for (int i = 0; i < length; ++i) {
            info = (FpAssistItemInfo)asstItemMap.get(asstItems[i]);
            if (info.isIsLeaf()) continue;
            return 0;
        }
        return 1;
    }

    private static String[] getRefField(Context ctx, String[] asstItems, Map asstItemMap) throws BOSException, FpTemplateException {
        if (asstItems == null) {
            return null;
        }
        int length = asstItems.length;
        String[] refField = new String[length];
        for (int i = 0; i < length; ++i) {
            if (asstItemMap.get(asstItems[i]) == null) {
                throw new FpTemplateException(FpTemplateException.ASSTITEMISERROR, new Object[]{asstItems[i]});
            }
            refField[i] = ((FpAssistItemInfo)asstItemMap.get(asstItems[i])).getRefField();
            if (!FMHelper.isEmpty((String)refField[i])) continue;
            throw new FpTemplateException(FpTemplateException.ASSTITEMNOREFFIELD, new Object[]{asstItems[i]});
        }
        return refField;
    }

    private static void saveRefItem(Context ctx, String templatePk, Map refItemMap) throws BOSException {
        if (templatePk == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BOSObjectType bosType = new TemRefFPItemsInfo().getBOSType();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = FpTemplateHelper.buildDeleteRefPropSql("T_FPL_TemRefFPItems", templatePk);
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            sql = FpTemplateHelper.buildSaveRefPropSql("T_FPL_TemRefFPItems", "FFpItemID");
            pstmt = conn.prepareStatement(sql);
            FpTemplateHelper.saveRefProp(ctx, pstmt, bosType, templatePk, refItemMap);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private static void saveRefAssistItem(Context ctx, String templatePk, Map refAssistItemMap) throws BOSException {
        if (templatePk == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BOSObjectType bosType = new TemRefFPAssistItemCombinesInfo().getBOSType();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = FpTemplateHelper.buildDeleteRefPropSql("T_FPL_TemRefFPAsstItemComb", templatePk);
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            sql = FpTemplateHelper.buildSaveRefPropSql("T_FPL_TemRefFPAsstItemComb", "FAssistItemCombiID");
            pstmt = conn.prepareStatement(sql);
            FpTemplateHelper.saveRefProp(ctx, pstmt, bosType, templatePk, refAssistItemMap);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private static void saveRefPeriod(Context ctx, String templatePk, Map refPeriodMap) throws BOSException {
        if (templatePk == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BOSObjectType bosType = new TemRefBgPeriodsInfo().getBOSType();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = FpTemplateHelper.buildDeleteRefPropSql("T_FPL_TemRefBgPeriods", templatePk);
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            sql = FpTemplateHelper.buildSaveRefPropSql("T_FPL_TemRefBgPeriods", "FBgPeriodID");
            pstmt = conn.prepareStatement(sql);
            FpTemplateHelper.saveRefProp(ctx, pstmt, bosType, templatePk, refPeriodMap);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private static void saveRefCurrency(Context ctx, String templatePk, Map refCurrencyMap) throws BOSException {
        if (templatePk == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BOSObjectType bosType = new TemRefCurrenciesInfo().getBOSType();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = FpTemplateHelper.buildDeleteRefPropSql("T_FPL_TemRefCurrencies", templatePk);
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            sql = FpTemplateHelper.buildSaveRefPropSql("T_FPL_TemRefCurrencies", "FCurrencyID");
            pstmt = conn.prepareStatement(sql);
            FpTemplateHelper.saveRefProp(ctx, pstmt, bosType, templatePk, refCurrencyMap);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private static String buildDeleteRefPropSql(String table, String tempaltePk) {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM ").append(table).append(" WHERE FHeadID = '").append(tempaltePk).append("'");
        return sql.toString();
    }

    private static String buildSaveRefPropSql(String table, String refProp) {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(table).append(" ( FID, FHeadID, ").append(refProp).append(", FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime )").append(" VALUES (?, ?, ?, ?, ?, ?, ?)");
        return sql.toString();
    }

    private static void saveRefProp(Context ctx, PreparedStatement pstmt, BOSObjectType bosType, String templatePk, Map refPropMap) throws SQLException {
        if (bosType == null || refPropMap == null || refPropMap.size() == 0) {
            return;
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        BOSUuid uuid = null;
        String key = null;
        int i = 0;
        Set keySet = refPropMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            uuid = BOSUuid.create((BOSObjectType)bosType);
            key = (String)iter.next();
            i = 0;
            pstmt.setString(++i, uuid.toString());
            pstmt.setString(++i, templatePk);
            pstmt.setString(++i, key);
            pstmt.setString(++i, userInfo.getId().toString());
            pstmt.setTimestamp(++i, currTime);
            pstmt.setString(++i, userInfo.getId().toString());
            pstmt.setTimestamp(++i, currTime);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
    }

    public static FpTemplateCollection getCollection(Context ctx, String orgId, String fpTempId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)fpTempId, CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IFpTemplate iFpTemplate = FpTemplateFactory.getLocalInstance(ctx);
        FpTemplateCollection coll = iFpTemplate.getFpTemplateCollection(evi);
        return coll;
    }
}

