/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPPastDataFactory;
import com.kingdee.eas.fm.fpl.FPPastDataInfo;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.IFPPastData;
import com.kingdee.eas.fm.fpl.app.AbstractFPPastRecordControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class FPPastRecordControllerBean
extends AbstractFPPastRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FPPastRecordControllerBean");

    protected void _savePastRecord(Context ctx, String formId) throws BOSException, EASBizException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, formId);
        String adjustRootID = info.getAdjustRootID();
        if (FMHelper.isEmpty((String)adjustRootID)) {
            return;
        }
        BOSUuid pastRecordId = BOSUuid.create((BOSObjectType)new FPPastDataInfo().getBOSType());
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT T_FPL_FpPastRecord (FID, FCreatorID, FCreateTime, FLastUpdateUserID, ").append("FLastUpdateTime, FVersionNo, FDiffDataSource, FFpFormID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            UserInfo currUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            Timestamp currTime = new Timestamp(System.currentTimeMillis());
            int i = 0;
            pstmt.setString(++i, pastRecordId.toString());
            pstmt.setString(++i, currUser.getId().toString());
            pstmt.setTimestamp(++i, currTime);
            pstmt.setString(++i, currUser.getId().toString());
            pstmt.setTimestamp(++i, currTime);
            pstmt.setString(++i, info.getVersionNo());
            pstmt.setString(++i, "MANUAL");
            pstmt.setString(++i, adjustRootID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        IFPPastData iFpPastData = FPPastDataFactory.getLocalInstance(ctx);
        iFpPastData.savePastData(adjustRootID, pastRecordId.toString());
    }
}

