/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPCtrlParamCollection;
import com.kingdee.eas.fm.fpl.FPCtrlParamInfo;
import com.kingdee.eas.fm.fpl.FPLCtrlHandlerFactory;
import com.kingdee.eas.fm.fpl.FpCommonException;
import com.kingdee.eas.fm.fpl.FpCtrlDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpCtrlException;
import com.kingdee.eas.fm.fpl.FpCtrlHelper;
import com.kingdee.eas.fm.fpl.FpCtrlRecordCollection;
import com.kingdee.eas.fm.fpl.FpCtrlRecordFactory;
import com.kingdee.eas.fm.fpl.FpCtrlRecordInfo;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFPLCtrlHandler;
import com.kingdee.eas.fm.fpl.IFpCtrlRecord;
import com.kingdee.eas.fm.fpl.IFpFormFacade;
import com.kingdee.eas.fm.fpl.app.AbstractFpCtrlFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FpCtrlFacadeControllerBean
extends AbstractFpCtrlFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpCtrlFacadeControllerBean");
    FpCtrlHelper helper = new FpCtrlHelper();

    protected String _getWarnMsg(Context ctx, IObjectCollection params) throws BOSException, EASBizException {
        FPCtrlParamCollection paramColl = (FPCtrlParamCollection)params;
        if (paramColl == null || paramColl.isEmpty()) {
            return null;
        }
        this.checkBalance(ctx, paramColl);
        String msg = this.getWarnMsg2(ctx, paramColl);
        if (!FMHelper.isEmpty((String)msg)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"0_FpCtrlFacadeControllerBean", (Locale)ctx.getLocale()) + msg;
        }
        return msg;
    }

    private String getWarnMsg2(Context ctx, FPCtrlParamCollection paramColl) throws BOSException, FpCtrlException {
        if (paramColl == null || paramColl.isEmpty()) {
            return null;
        }
        boolean isWithoutFpForm = false;
        StringBuffer error = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        FpItemFormulaParser parser = null;
        FPCtrlParamInfo info = null;
        Map fpItemInfoMap = FpItemFormulaHelper.getItemInfoMap(ctx);
        FpItemInfo itemInfo = null;
        String fpItem = null;
        int size = paramColl.size();
        for (int i = 0; i < size; ++i) {
            info = paramColl.get(i);
            if (info.isIsOk()) continue;
            parser = new FpItemFormulaParser(ctx, info.getItemFormula());
            parser.parse();
            fpItem = parser.getItem();
            itemInfo = (FpItemInfo)fpItemInfoMap.get(fpItem);
            if (info.getBalance() == null) {
                isWithoutFpForm = true;
                error.append("\n");
                error.append(parser.getDetailFormula());
                continue;
            }
            sb.append("\n");
            sb.append(parser.getDetailFormula());
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"1_FpCtrlFacadeControllerBean", (Locale)ctx.getLocale()));
            sb.append(info.getReqAmount());
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"2_FpCtrlFacadeControllerBean", (Locale)ctx.getLocale()));
            sb.append(info.getBalance().add(info.getReqAmount()));
        }
        if (isWithoutFpForm) {
            throw new FpCtrlException(FpCtrlException.FPITEMWITHOUTFPFORM, new Object[]{error.toString()});
        }
        return sb.toString();
    }

    private void checkBalance(Context ctx, FPCtrlParamCollection paramColl) throws BOSException, EASBizException {
        Map ctrlRecordMap = this.getCtrlRecordMap(ctx, paramColl);
        FpCtrlRecordInfo recordInfo = null;
        FPCtrlParamInfo paramInfo = null;
        String itemFormula = null;
        BigDecimal balance = null;
        int size = paramColl.size();
        for (int i = 0; i < size; ++i) {
            paramInfo = paramColl.get(i);
            paramInfo.setIsOk(true);
            if (!paramInfo.isIsNeedCtrl()) continue;
            itemFormula = paramInfo.getItemFormula();
            balance = this.helper.getBalance(ctx, paramInfo);
            if (balance == null) {
                paramInfo.setIsOk(true);
                continue;
            }
            recordInfo = (FpCtrlRecordInfo)ctrlRecordMap.get(itemFormula);
            if (recordInfo != null) {
                balance = balance.add(recordInfo.getAmount());
            }
            balance = balance.add(paramInfo.getReqAmount().negate());
            paramInfo.setBalance(balance);
            if (paramInfo.getBalance().compareTo(Constants.ZERO) >= 0) {
                paramInfo.setIsOk(true);
                continue;
            }
            paramInfo.setIsOk(false);
        }
    }

    private Map getCtrlRecordMap(Context ctx, FPCtrlParamCollection paramColl) throws BOSException, EASBizException {
        HashMap<String, FpCtrlRecordInfo> map = new HashMap<String, FpCtrlRecordInfo>();
        if (paramColl == null || paramColl.size() <= 0) {
            return map;
        }
        String billIds = this.getSrcBillIds(paramColl);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FFormula, b.FID, b.FBillID, b.FAmount, b.FBalance, FFpDataID FROM T_FPL_FpData a \n").append(" \tJOIN T_FPL_FpCtrlRecord b ON a.FID = b.FFpDataID \n").append("\tWHERE b.FBillID IN " + billIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            FpCtrlRecordInfo info = null;
            while (rs.next()) {
                info = new FpCtrlRecordInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setBillId(rs.getString("FBillID"));
                info.setAmount(rs.getBigDecimal("FAmount"));
                info.setBalance(rs.getBigDecimal("FBalance"));
                info.setFpDataId(rs.getString("FFpDataID"));
                map.put(rs.getString("FFormula"), info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("FpCtrlFacadeControllerBean getFpData error:" + e));
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String getSrcBillIds(FPCtrlParamCollection paramColl) {
        String formulas = "";
        FPCtrlParamInfo info = null;
        int size = paramColl.size();
        for (int i = 0; i < size; ++i) {
            info = paramColl.get(i);
            formulas = FMHelper.isEmpty((String)formulas) ? "('" + info.getBillId() + "'" : formulas + ", '" + info.getBillId() + "'";
        }
        if (!FMHelper.isEmpty((String)formulas)) {
            formulas = formulas + ")";
        }
        return formulas;
    }

    public boolean _specialApprove(Context ctx, String boId, String handleName) throws BOSException, EASBizException {
        this._monitorCancel(ctx, boId);
        FPCtrlParamCollection paramColl = FPLCtrlHandlerFactory.createHandler(handleName).getParameters(ctx, boId);
        if (paramColl == null || paramColl.isEmpty()) {
            return true;
        }
        this.requestBalance(ctx, paramColl);
        IFpCtrlRecord iFpCtrRecord = FpCtrlRecordFactory.getLocalInstance(ctx);
        iFpCtrRecord.record(paramColl);
        return true;
    }

    protected boolean _monitorRequest(Context ctx, String boId, String handleName) throws BOSException, EASBizException {
        this._monitorCancel(ctx, boId);
        IFPLCtrlHandler handler = FPLCtrlHandlerFactory.createHandler(handleName);
        FPCtrlParamCollection paramColl = handler.getParameters(ctx, boId);
        if (paramColl == null || paramColl.isEmpty()) {
            return true;
        }
        this.checkBalance(ctx, paramColl);
        String msg = this.getWarnMsg2(ctx, paramColl);
        if (!FMHelper.isEmpty((String)msg)) {
            throw new FpCommonException(FpCommonException.MONITORNOTPASS, new Object[]{msg});
        }
        this.requestBalance(ctx, paramColl);
        IFpCtrlRecord iFpCtrRecord = FpCtrlRecordFactory.getLocalInstance(ctx);
        iFpCtrRecord.record(paramColl);
        return true;
    }

    private void syncFpActualData(Context ctx, Map map) throws BOSException, EASBizException {
        Set fpFormIdSet = this.getFpFormIds(ctx, map.keySet());
        IFpFormFacade facade = FpFormFacadeFactory.getLocalInstance(ctx);
        facade.syncFpActualData(fpFormIdSet);
    }

    protected void _monitorCancel(Context ctx, String billId) throws BOSException, EASBizException {
        this._innerMomitorCancel(ctx, billId);
    }

    private void requestBalance(Context ctx, FPCtrlParamCollection paramColl) throws BOSException, EASBizException {
        this.prepareFpDataId(ctx, paramColl);
        this.changeBalance(ctx, paramColl, false);
        Map map = this.getFpDataMap(ctx, paramColl);
        this.syncFpActualData(ctx, map);
    }

    private void prepareFpDataId(Context ctx, FPCtrlParamCollection paramColl) throws BOSException, EASBizException {
        Map map = this.helper.getFpDataInfoMap(ctx, paramColl);
        FPCtrlParamInfo info = null;
        FpDataInfo dataInfo = null;
        for (int i = 0; i < paramColl.size(); ++i) {
            info = paramColl.get(i);
            dataInfo = (FpDataInfo)map.get(info.getItemFormula());
            if (dataInfo == null) continue;
            info.setFpDataId(dataInfo.getId());
        }
    }

    private void changeBalance(Context ctx, FPCtrlParamCollection coll, boolean isNegative) throws BOSException, FpCtrlException {
        String sql = " UPDATE T_FPL_FpData SET FBizActual = FBizActual + ?, FFpBalance = FFpBalance - ?  WHERE FID = ?";
        FPCtrlParamInfo info = null;
        BigDecimal amount = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getFpDataId() == null) continue;
            amount = isNegative ? info.getReqAmount().negate() : info.getReqAmount();
            Object[] params = new Object[]{amount, amount, info.getFpDataId()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    private Map getFpDataMap(Context ctx, FPCtrlParamCollection coll) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (coll == null || coll.isEmpty()) {
            return map;
        }
        FPCtrlParamInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getFpDataId(), info.getReqAmount());
        }
        return map;
    }

    private Map getFpDataMap(Context ctx, FpCtrlRecordCollection coll) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (coll == null || coll.isEmpty()) {
            return map;
        }
        FpCtrlRecordInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getFpDataId(), info.getAmount());
        }
        return map;
    }

    private Set getFpFormIds(Context ctx, Set fpDataIdSet) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        if (fpDataIdSet == null || fpDataIdSet.isEmpty()) {
            return idSet;
        }
        String sql = "SELECT DISTINCT FFpFormId FpFormID FROM T_FPL_FpData WHERE FID IN " + FpHelper.tranColl2String(fpDataIdSet);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return idSet;
    }

    protected void _innerMomitorCancel(Context ctx, String boId) throws BOSException, EASBizException {
        FpCtrlRecordCollection coll = this.getFpCtrlRecordColl(ctx, boId);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        this.changeBalance(ctx, coll, true);
        String deleteSql = "DELETE FROM T_FPL_FpCtrlRecord WHERE FBillId = ?";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{boId});
        Map map = this.getFpDataMap(ctx, coll);
        this.syncFpActualData(ctx, map);
    }

    private FpCtrlRecordCollection getFpCtrlRecordColl(Context ctx, String boId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)boId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IFpCtrlRecord iFpCtrlRecord = FpCtrlRecordFactory.getLocalInstance(ctx);
        FpCtrlRecordCollection coll = iFpCtrlRecord.getFpCtrlRecordCollection(evi);
        return coll;
    }

    private void changeBalance(Context ctx, FpCtrlRecordCollection coll, boolean isNegative) throws BOSException {
        if (coll == null || coll.size() <= 0) {
            return;
        }
        String sql = "UPDATE T_FPL_FpData SET FBizActual = FBizActual + ?, FFpBalance = FFpBalance - ? WHERE FID = ?";
        FpCtrlRecordInfo info = null;
        BigDecimal amount = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            amount = isNegative ? info.getAmount().negate() : info.getAmount();
            Object[] params = new Object[]{amount, amount, info.getFpDataId()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    protected BigDecimal _getCtrlData(Context ctx, String boId, String handlerName, FpCtrlDataTypeEnum dataType) throws BOSException, EASBizException {
        FPCtrlParamCollection paramColl = FPLCtrlHandlerFactory.createHandler(handlerName).getParameters(ctx, boId);
        if (paramColl == null || paramColl.isEmpty()) {
            return Constants.ZERO;
        }
        if (dataType == FpCtrlDataTypeEnum.Req_LocalAmt) {
            return this.getSum(ctx, paramColl, "reqAmount");
        }
        if (dataType == FpCtrlDataTypeEnum.Bal_LocalAmt) {
            this.requestBalance(ctx, paramColl);
            return this.getSum(ctx, paramColl, "balance");
        }
        return Constants.ZERO;
    }

    private BigDecimal getSum(Context ctx, FPCtrlParamCollection paramColl, String field) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = null;
        ExchangeTableInfo exTableInfo = null;
        CurrencyInfo baseCurr = null;
        IExchangeRate iExRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo rateInfo = null;
        Map currInfoMap = FpItemFormulaHelper.getCurrencyInfoMap(ctx);
        CurrencyInfo currInfo = null;
        FPCtrlParamInfo paramInfo = null;
        BigDecimal sum = Constants.ZERO;
        BigDecimal value = null;
        int mode = 4;
        int size = paramColl.size();
        for (int i = 0; i < size; ++i) {
            paramInfo = paramColl.get(i);
            currInfo = (CurrencyInfo)currInfoMap.get(paramInfo.getCurrencyNumber());
            companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(paramInfo.getOrgUnitId()));
            exTableInfo = companyInfo.getBaseExchangeTable();
            baseCurr = companyInfo.getBaseCurrency();
            rateInfo = iExRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exTableInfo.getId()), (IObjectPK)new ObjectUuidPK(currInfo.getId()), (IObjectPK)new ObjectUuidPK(baseCurr.getId()), paramInfo.getBizDate());
            value = paramInfo.getBigDecimal(field);
            sum = sum.add(value.multiply(rateInfo.getConvertRate())).setScale(rateInfo.getPrecision(), mode);
        }
        return sum;
    }

    protected boolean _isPassedFpCtrl(Context ctx, String id) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)id)) {
            return false;
        }
        String sql = "SELECT FID FROM T_FPL_FpCtrlRecord WHERE FBillId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{id});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return false;
    }
}

