/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.CheckFormItemFormulaDup;
import com.kingdee.eas.fm.fpl.FpConstants;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormCollection;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.app.AbstractFpFormControllerBean;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FpFormControllerBean
extends AbstractFpFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpFormControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfoIsValid(ctx, (FpFormInfo)model);
        FpFormInfo info = (FpFormInfo)model;
        boolean isActual = FpDataTypeEnum.A.equals((Object)info.getDataType());
        info.setItemFormulaExt(isActual);
        super._addnew(ctx, pk, model);
        FpFormHelper.drawOutFpData(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfoIsValid(ctx, (FpFormInfo)model);
        FpFormInfo info = (FpFormInfo)model;
        boolean isActual = FpDataTypeEnum.A.equals((Object)info.getDataType());
        info.setItemFormulaExt(isActual);
        IObjectPK pk = super._addnew(ctx, model);
        FpFormHelper.drawOutFpData(ctx, pk, model);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model, boolean isVerifyPower) throws BOSException, EASBizException {
        FpFormInfo info = (FpFormInfo)model;
        boolean isActual = info.getDataType().equals((Object)FpDataTypeEnum.A);
        info.setItemFormulaExt(isActual);
        super._update(ctx, pk, model, isVerifyPower);
        FpFormHelper.drawOutFpData(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FpFormInfo info = (FpFormInfo)model;
        boolean isActual = FpDataTypeEnum.A.equals((Object)info.getDataType());
        info.setItemFormulaExt(isActual);
        super._update(ctx, pk, model);
        FpFormHelper.drawOutFpData(ctx, pk, model);
    }

    private void checkInfoIsValid(Context ctx, FpFormInfo info) throws BOSException, EASBizException {
        this.checkIsBlank(info, "FpForm");
        this.checkIsBlank(info.getFpTemplate(), "FpTempate referenced by FpForm");
        this.checkIsBlank(info.getFpCycle(), "FpForm's FpCycle");
        this.checkIsBlank(info.getBgPeriod(), "FpForm's Period");
        BgPeriodEnum periodType = info.getBgPeriod().getPeriodType();
        if (periodType == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("periodType"));
            ObjectUuidPK pk = new ObjectUuidPK(info.getBgPeriod().getId());
            IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance((Context)ctx);
            BgPeriodInfo periodInfo = iBgPeriod.getBgPeriodInfo((IObjectPK)pk, sic);
            periodType = periodInfo.getPeriodType();
            info.setBgPeriod(periodInfo);
        }
        if (!periodType.equals((Object)info.getFpCycle())) {
            throw new FpFormException(FpFormException.PERIODNOTMACTHFPCYCLE);
        }
        this.checkFormDump(ctx, info);
    }

    private void checkIsBlank(Object obj, String msg) throws EASBizException {
        if (obj == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{msg});
        }
    }

    public void checktempCodeDump(Context ctx, ReportBaseInfo reportBaseInfo) throws BOSException, RptAndTempException, EASBizException {
        super.checktempCodeDump(ctx, reportBaseInfo);
        FpFormInfo info = (FpFormInfo)reportBaseInfo;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String id = info.getId().toString();
            String number = info.getNumber();
            String ouId = info.getOrgUnit().getId().toString();
            String adjustRootId = info.getAdjustRootID();
            StringBuffer sql = new StringBuffer(60);
            sql.append(" SELECT FID FROM T_FPL_FpForm WHERE FNumber = ? AND FOrgUnitId = ? ");
            if (!FMHelper.isEmpty((String)id)) {
                sql.append(" AND FID != ? ");
            }
            if (!FMHelper.isEmpty((String)adjustRootId)) {
                sql.append(" AND FID != ? ");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, number);
            pstmt.setString(2, ouId);
            if (!FMHelper.isEmpty((String)id)) {
                pstmt.setString(3, id);
            }
            if (!FMHelper.isEmpty((String)adjustRootId)) {
                pstmt.setString(4, adjustRootId);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                throw new FpFormException(FpFormException.NUMBERDUMP);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private void checkFormDump(Context ctx, FpFormInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{"FpForm"});
        }
        if (info.getState().equals((Object)FpFormStateEnum.ADJUSTING)) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String templateId = info.getFpTemplate().getId().toString();
            String periodId = info.getBgPeriod().getId().toString();
            String currendyId = info.getCurrency().getId().toString();
            String ouId = info.getOrgUnit().getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FNumber FROM T_FPL_FpForm WHERE FFpTemplateID = ? ").append(" AND FBgPeriodID = ? AND FCurrencyID = ? AND FOrgUnitId = ? ");
            if (info.getId() != null) {
                sql.append(" AND FID <> ?");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, templateId);
            pstmt.setString(2, periodId);
            pstmt.setString(3, currendyId);
            pstmt.setString(4, ouId);
            if (info.getId() != null) {
                pstmt.setString(5, info.getId().toString());
            }
            if ((rs = pstmt.executeQuery()).next()) {
                String number = rs.getString("FNumber");
                String period = info.getBgPeriod().getName();
                String currency = info.getCurrency().getName();
                throw new FpFormException(FpFormException.FORMDUMP, new String[]{period, currency, number});
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    protected String _checkFormulaDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpFormInfo info = (FpFormInfo)model;
        String msg = "";
        CheckFormItemFormulaDup checkForm = new CheckFormItemFormulaDup(info.getDataType());
        msg = checkForm.checkItemFormulaDup((IObjectValue)info);
        if (msg != null && msg.trim().length() > 0) {
            return msg;
        }
        FpFormCollection coll = this.getCollection(ctx, info);
        if (coll == null || coll.size() <= 0) {
            return null;
        }
        return checkForm.checkItemFormulaDup((IObjectValue)info, (IObjectCollection)coll);
    }

    private FpFormCollection getCollection(Context ctx, FpFormInfo info) throws BOSException {
        String ouId = info.getOrgUnit().getId().toString();
        String id = info.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getAdjustRootID(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("adjustRootId", (Object)info.getAdjustRootID(), CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FpFormCollection coll = this.getFpFormCollection(ctx, evi);
        return coll;
    }

    protected void _saveSimpleInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpFormInfo info = (FpFormInfo)model;
        this.checktempCodeDump(ctx, info);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            StringBuffer sql = new StringBuffer(60);
            sql.append(" UPDATE T_FPL_FpForm SET FName = ?, FNumber = ?, FDescription = ? WHERE FID = ? ");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int i = 0;
            pstmt.setString(++i, info.getName());
            pstmt.setString(++i, info.getNumber());
            pstmt.setString(++i, info.getDescription());
            pstmt.setString(++i, info.getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected String _adjust(Context ctx, String formId) throws BOSException, EASBizException {
        PostilCollection postilColl;
        this.checkIsCanAdjust(ctx, formId);
        FpFormInfo formInfo = FpFormHelper.getFpFormInfo(ctx, formId);
        String adjustRootId = formId;
        if (!FMHelper.isEmpty((String)formInfo.getAdjustRootID())) {
            adjustRootId = formInfo.getAdjustRootID();
        }
        this.syncAdjustValue(ctx, adjustRootId);
        boolean isFirstAdjust = this.isFirstAdjust(ctx, formId);
        int seq = this.getNextSeq(isFirstAdjust, formInfo);
        String name = this.getNextName(isFirstAdjust, seq, formInfo.getName());
        String number = this.getNextNumber(isFirstAdjust, seq, formInfo.getNumber());
        FpFormInfo adjFormInfo = (FpFormInfo)formInfo.clone();
        adjFormInfo.setId(BOSUuid.create((BOSObjectType)adjFormInfo.getBOSType()));
        adjFormInfo.setName(name);
        adjFormInfo.setNumber(number);
        adjFormInfo.setVersionNo(this.genVersionNO(ctx, formInfo.getVersionNo()));
        adjFormInfo.setAdjustRootID(adjustRootId);
        adjFormInfo.setState(FpFormStateEnum.ADJUSTING);
        RptSheetParamCollection paramColl = adjFormInfo.getSheetParam();
        RptSheetParamInfo paramInfo = null;
        if (paramColl != null) {
            int size = paramColl.size();
            for (int i = 0; i < size; ++i) {
                PostilCollection postilColl2;
                paramInfo = paramColl.get(i);
                paramInfo.setId(null);
                paramInfo.setReport(null);
                if (paramInfo.getPostils() == null || (postilColl2 = paramInfo.getPostils()) == null) continue;
                int size1 = postilColl2.size();
                for (int j = 0; j < size1; ++j) {
                    postilColl2.get(j).setId(null);
                    postilColl2.get(j).setReport(null);
                }
            }
        }
        if ((postilColl = adjFormInfo.getPostils()) != null) {
            int size = postilColl.size();
            for (int i = 0; i < size; ++i) {
                postilColl.get(i).setId(null);
                postilColl.get(i).setReport(null);
            }
        }
        IObjectPK pk = this._addnew(ctx, (IObjectValue)adjFormInfo);
        return pk.toString();
    }

    private void syncAdjustValue(Context ctx, String id) throws BOSException {
        String sql = "UPDATE T_FPL_FpData SET FAdjustValue = FFpValue WHERE FFpFormId = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    private String genVersionNO(Context ctx, String versionNo) {
        BigDecimal ver = new BigDecimal(versionNo);
        return String.valueOf(ver.add(FpConstants.NextVer));
    }

    private int getNextSeq(boolean isFirstAdjust, FpFormInfo info) throws BOSException {
        if (isFirstAdjust) {
            return 1;
        }
        String number = info.getNumber();
        if (FMHelper.isEmpty((String)number)) {
            return 0;
        }
        int index = number.lastIndexOf("_");
        if (index == -1) {
            return 1;
        }
        String currValue = number.substring(index + 1, number.length());
        int seq = 0;
        try {
            seq = Integer.parseInt(currValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return ++seq;
    }

    private String getNextName(boolean isFirstAdjust, int seq, String name) throws BOSException {
        String resClass = "com.kingdee.eas.fm.fpl.FPLResource";
        String resName = "adjustName";
        String seqName = MessageFormat.format(this.getResString(resClass, resName), String.valueOf(seq));
        if (isFirstAdjust) {
            return name + "_" + seqName;
        }
        int index = name.lastIndexOf("_");
        if (index == -1) {
            return name + "_" + seqName;
        }
        return name.substring(0, index + 1) + seqName;
    }

    private boolean isFirstAdjust(Context ctx, String formId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjustRootId", (Object)formId));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)formId, CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FpFormCollection coll = this.getFpFormCollection(ctx, evi);
        return coll == null || coll.isEmpty();
    }

    private String getResString(String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)FpFormControllerBean.getLocale());
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }

    private String getNextNumber(boolean isFirstAdjust, int seq, String number) throws BOSException {
        if (isFirstAdjust) {
            return number + "_" + seq;
        }
        int index = number.lastIndexOf("_");
        if (index == -1) {
            return number + "_" + seq;
        }
        return number.substring(0, index + 1) + String.valueOf(seq);
    }

    private void checkIsCanAdjust(Context ctx, String formId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer(60);
            sql.append(" SELECT FNumber FROM T_FPL_FpForm WHERE FAdjustRootID = ? ").append(" AND FID != ? AND (FState = ? OR FState = ?) ");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, formId);
            pstmt.setString(2, formId);
            pstmt.setString(3, "adjusting");
            pstmt.setString(4, "adjustSubmited");
            rs = pstmt.executeQuery();
            if (rs.next()) {
                throw new FpFormException(FpFormException.ADJUSTDUP, new String[]{rs.getString("FNumber")});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }
}

