/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPItemFormulaFormat;
import com.kingdee.eas.fm.fpl.FPPastRecordFactory;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyCollection;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyFactory;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormCollection;
import com.kingdee.eas.fm.fpl.FpFormException;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.IFPPastRecord;
import com.kingdee.eas.fm.fpl.IFpCtrlStrategy;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.fm.fpl.IFpTemplate;
import com.kingdee.eas.fm.fpl.app.AbstractFpFormFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FpFormFacadeControllerBean
extends AbstractFpFormFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)FpFormFacadeControllerBean.class.getName());
    private static final int ROUND = 4;
    private static final BigDecimal BASE_DIVISOR = new BigDecimal("100");

    protected boolean _submit(Context ctx, String id) throws BOSException, EASBizException {
        boolean re = true;
        if (id == null) {
            return false;
        }
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        this.checkIsCanSubmit(ctx, info);
        FpFormStateEnum state = null;
        if (info.getState().equals((Object)FpFormStateEnum.EDITING)) {
            state = FpFormStateEnum.SUBMITED;
        } else if (info.getState().equals((Object)FpFormStateEnum.ADJUSTING)) {
            state = FpFormStateEnum.ADJUSTSUBMITED;
        } else {
            return false;
        }
        this.setFormState(ctx, id, state);
        this.submit4WF(ctx, info);
        return re;
    }

    private void checkIsCanSubmit(Context ctx, FpFormInfo info) throws EASBizException, BOSException {
        if (!(info.getState().equals((Object)FpFormStateEnum.EDITING) || info.getState().equals((Object)FpFormStateEnum.ADJUSTING) || info.getState().equals((Object)FpFormStateEnum.SUBMITED))) {
            throw new FpFormException(FpFormException.CANNOTSUBMIT);
        }
    }

    protected void _submitBtach(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            this._submit(ctx, (String)idList.get(i));
        }
    }

    protected boolean _submit4WF(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpFormInfo fpFormInfo = (FpFormInfo)model;
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"submit4WF", (BOSObjectType)model.getBOSType(), (IObjectPK)new ObjectUuidPK(fpFormInfo.getId()), (String)(fpFormInfo.getNumber() + " - " + fpFormInfo.getName()), (String)"fpl_form_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return true;
    }

    protected boolean _audit(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new NullPointerException("Id is null!");
        }
        this.checkIsCanAudit(ctx, id);
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        if (FMHelper.isEmpty((String)info.getAdjustRootID()) || info.getId().toString().equals(info.getAdjustRootID())) {
            return this.setFormState(ctx, id, FpFormStateEnum.APPROVED);
        }
        return this.auditAdjustForm(ctx, id);
    }

    private void checkIsCanAudit(Context ctx, String id) throws EASBizException, BOSException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        if (!info.getState().equals((Object)FpFormStateEnum.SUBMITED) && !info.getState().equals((Object)FpFormStateEnum.ADJUSTSUBMITED)) {
            throw new FpFormException(FpFormException.CANNOTAUDIT);
        }
    }

    private boolean auditAdjustForm(Context ctx, String id) throws BOSException, EASBizException {
        IFPPastRecord iFpPastRecord = FPPastRecordFactory.getLocalInstance(ctx);
        iFpPastRecord.savePastRecord(id);
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        String adjustRootID = info.getAdjustRootID();
        FpFormInfo adjustRootInfo = FpFormHelper.getFpFormInfo(ctx, adjustRootID);
        byte[] data = info.getData();
        String version = info.getVersionNo();
        String name = info.getName();
        String number = info.getNumber();
        info.setName(adjustRootInfo.getName());
        info.setNumber(adjustRootInfo.getNumber());
        info.setData(adjustRootInfo.getData());
        FpFormHelper.setFpData(ctx, info, FpDataTypeEnum.P);
        info.setVersionNo(adjustRootInfo.getVersionNo());
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        iFpForm.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        adjustRootInfo.setName(name);
        adjustRootInfo.setNumber(number);
        adjustRootInfo.setData(data);
        adjustRootInfo.setVersionNo(version);
        iFpForm.update((IObjectPK)new ObjectUuidPK(adjustRootInfo.getId()), (CoreBaseInfo)adjustRootInfo);
        this.syncFpValue(ctx, adjustRootID);
        return this.setFormState(ctx, id, FpFormStateEnum.HISTORY);
    }

    private void syncFpValue(Context ctx, String id) throws BOSException {
        String sql = "UPDATE T_FPL_FpData SET FFpValue = FAdjustValue WHERE FFpFormId = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    protected void _auditNoPass(Context ctx, String id) throws BOSException, EASBizException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        FpFormStateEnum state = null;
        if (info.getState().equals((Object)FpFormStateEnum.SUBMITED)) {
            state = FpFormStateEnum.EDITING;
        } else if (info.getState().equals((Object)FpFormStateEnum.ADJUSTSUBMITED)) {
            state = FpFormStateEnum.ADJUSTING;
        }
        this.setFormState(ctx, id, state);
    }

    protected void _antiAudit(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new NullPointerException("Id is null!");
        }
        this.checkIsCanAntiAudit(ctx, id);
        this.setFormState(ctx, id, FpFormStateEnum.EDITING);
    }

    private void checkIsCanAntiAudit(Context ctx, String id) throws EASBizException, BOSException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        if (!info.getState().equals((Object)FpFormStateEnum.APPROVED)) {
            throw new FpFormException(FpFormException.CANNOTANTIAUDIT);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjustRootId", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        FpFormCollection coll = iFpForm.getFpFormCollection(evi);
        if (coll != null && !coll.isEmpty()) {
            throw new FpFormException(FpFormException.CANNOTANTIAUDITBYADJUST);
        }
    }

    protected void _execute(Context ctx, String id) throws BOSException, EASBizException {
        this.checkIsCanExecute(ctx, id);
        this.setFormState(ctx, id, FpFormStateEnum.EXECUTING);
    }

    private void checkIsCanExecute(Context ctx, String id) throws EASBizException, BOSException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        if (!info.getState().equals((Object)FpFormStateEnum.APPROVED)) {
            throw new FpFormException(FpFormException.CANNOTEXECUTE);
        }
        this.checkHasEnabledCtrlStrategy(ctx, info.getOrgUnit().getId().toString());
    }

    private void checkHasEnabledCtrlStrategy(Context ctx, String ouId) throws BOSException, FpFormException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgId", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)Boolean.TRUE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IFpCtrlStrategy iFpCtrl = FpCtrlStrategyFactory.getLocalInstance(ctx);
        FpCtrlStrategyCollection coll = iFpCtrl.getFpCtrlStrategyCollection(evi);
        if (coll == null || coll.isEmpty()) {
            throw new FpFormException(FpFormException.CANNOTEXECUTEBYNOSTRATEGY);
        }
    }

    private void checkPeriodOverlap(Context ctx, FpFormInfo info) throws BOSException, FpFormException {
        String ouId = info.getOrgUnit().getId().toString();
        String state = "executing";
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)state));
        evi.setFilter(filter);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        FpFormCollection coll = iFpForm.getFpFormCollection(evi);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        BgPeriodInfo periodInfo = info.getBgPeriod();
        BgPeriodInfo periodInfo2 = null;
        FpFormInfo info2 = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info2 = coll.get(i);
            periodInfo2 = coll.get(i).getBgPeriod();
            if (periodInfo.getBeginDate().compareTo(periodInfo2.getEndDate()) > 0 || periodInfo.getEndDate().compareTo(periodInfo2.getBeginDate()) < 0) continue;
            throw new FpFormException(FpFormException.PERIODOVERLAP, new Object[]{info.getName(), info.getBgPeriod().getName(), info2.getName(), info2.getBgPeriod().getName()});
        }
    }

    protected void _antiExecute(Context ctx, String id) throws BOSException, EASBizException {
        this.checkIsCanAntiExecute(ctx, id);
        this.setFormState(ctx, id, FpFormStateEnum.APPROVED);
    }

    private void checkIsCanAntiExecute(Context ctx, String id) throws EASBizException, BOSException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        if (!info.getState().equals((Object)FpFormStateEnum.EXECUTING)) {
            throw new FpFormException(FpFormException.CANNOTANTIEXECUTE);
        }
    }

    protected boolean _blankOut(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new NullPointerException("Id is null!");
        }
        this.checkIsCanBlankOut(ctx, id);
        return this.setFormState(ctx, id, FpFormStateEnum.HISTORY);
    }

    private void checkIsCanBlankOut(Context ctx, String id) throws EASBizException, BOSException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        if (!info.getState().equals((Object)FpFormStateEnum.APPROVED)) {
            throw new FpFormException(FpFormException.CANNOTBLANKOUT);
        }
    }

    private boolean setFormState(Context ctx, String id, FpFormStateEnum state) throws BOSException {
        boolean flag = false;
        if (ctx == null || id == null || state == null) {
            return flag;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE T_FPL_FpForm SET FState = ? WHERE FID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int i = 0;
            pstmt.setString(++i, state.getValue());
            pstmt.setString(++i, id);
            pstmt.executeUpdate();
            flag = true;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return flag;
    }

    protected boolean _delete(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new NullPointerException("Id is null!");
        }
        this.checkIsCanDelete(ctx, id);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            SQLUtils.execute((Connection)conn, (String)("DELETE FROM T_FPL_FpData WHERE FFpFormId = '" + id + "'"));
            SQLUtils.execute((Connection)conn, (String)("DELETE FROM T_FPL_FpForm WHERE FId = '" + id + "'"));
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new FpFormException(FpFormException.DELETEFORMERROR);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return true;
    }

    private void checkIsCanDelete(Context ctx, String id) throws BOSException, EASBizException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, id);
        FpFormStateEnum state = info.getState();
        if (!(state.equals((Object)FpFormStateEnum.EDITING) || state.equals((Object)FpFormStateEnum.SUBMITED) || state.equals((Object)FpFormStateEnum.ADJUSTING) || state.equals((Object)FpFormStateEnum.ADJUSTSUBMITED))) {
            throw new FpFormException(FpFormException.CANNOTDELETE);
        }
        if (FpFormHelper.hasCtrlRecord(ctx, id)) {
            throw new FpFormException(FpFormException.CANNOTDELETEHASCTRLRECORD);
        }
    }

    protected IObjectValue _getFormOrgCollectValue(Context ctx, IObjectPK pk, List orgList, String collectType) throws BOSException, EASBizException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, pk.toString());
        if (info.getZipData() == null) {
            return info;
        }
        KDF kdf = FpFormHelper.getKDF(info);
        Collection collection = kdf.getAllTable();
        KDF newKDF = new KDF();
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                KDTable tempTable = (KDTable)kdf.getTableByIndex(i);
                kdf.removeTableByID(tempTable.getID());
                FpFormHelper.collectOrgFormDetail(ctx, tempTable, orgList, collectType);
                newKDF.addTable((IDObject)tempTable);
            }
        }
        kdf = newKDF;
        try {
            info.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        ObjectUuidPK adjustRootPk = new ObjectUuidPK(info.getAdjustRootID());
        this.saveFpFormCollectOu(ctx, (IObjectPK)adjustRootPk, orgList);
        if (collectType.equals("fpOrgAdjustCollect")) {
            IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
            info.setDataType(FpDataTypeEnum.ADJ);
            iFpForm.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        return info;
    }

    private void saveFpFormCollectOu(Context ctx, IObjectPK fpFormPk, List orgList) throws BOSException {
        if (fpFormPk == null || orgList == null || orgList.isEmpty()) {
            return;
        }
        String deleteSql = "DELETE FROM T_FPL_FpFormCollectOrgUnit WHERE FFpFormID = ? ";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{fpFormPk.toString()});
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_FPL_FpFormCollectOrgUnit (FID, FFpFormID, FOrgUnitID) VALUES (?, ?, ?) ";
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            int size = orgList.size();
            for (int i = 0; i < size; ++i) {
                index = 1;
                pstmt.setString(index++, Uuid.create().toString() + "QWERTYUI");
                pstmt.setString(index++, fpFormPk.toString());
                pstmt.setString(index++, ((FullOrgUnitInfo)orgList.get(i)).getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IObjectValue _getFormPeriodCollectValue(Context ctx, IObjectPK pk, List periodList) throws BOSException, EASBizException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, pk.toString());
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"getFormPeriodCollectValue", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)(info.getNumber() + " - " + info.getName()), (String)"fpl_form_collectByPeriod");
        if (info.getZipData() == null) {
            return info;
        }
        String orgId = info.getOrgUnit().getId().toString();
        BgPeriodInfo period = info.getBgPeriod();
        KDF kdf = FpFormHelper.getKDF(info);
        Collection collection = kdf.getAllTable();
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                KDTable tempTable = (KDTable)kdf.getTableByIndex(i);
                FpFormHelper.collectPeriodFormDetail(ctx, tempTable, orgId, period, periodList);
            }
        }
        try {
            info.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return info;
    }

    protected boolean _disassembleByOrg(Context ctx, String formId, Map orgPropMap) throws BOSException, EASBizException {
        Map srcMap = this._getFpDataMap(ctx, formId);
        HashMap<String, Map> tempMap = new HashMap<String, Map>();
        String orgId2 = null;
        for (String orgId2 : orgPropMap.keySet()) {
            tempMap.put(orgId2, this.getFpDataMap(ctx, orgId2, null));
        }
        HashMap<String, BigDecimal> destMap = new HashMap<String, BigDecimal>();
        BigDecimal prop = null;
        BigDecimal srcValue = null;
        BigDecimal propValue = null;
        FpDataInfo dataInfo = null;
        for (Map.Entry entry : orgPropMap.entrySet()) {
            orgId2 = (String)entry.getKey();
            prop = (BigDecimal)entry.getValue();
            Map formulaMap = (Map)tempMap.get(orgId2);
            for (Map.Entry entry1 : formulaMap.entrySet()) {
                String formula = (String)entry1.getKey();
                if (!srcMap.containsKey(formula)) continue;
                srcValue = ((FpDataInfo)srcMap.get(formula)).getFpValue();
                int scale = FMHelper.getPrecOfCurrency((Context)ctx, (String)((FpDataInfo)srcMap.get(formula)).getCurrencyId());
                propValue = this.getPropValue(srcValue, prop, scale);
                dataInfo = (FpDataInfo)formulaMap.get(formula);
                destMap.put(dataInfo.getId(), propValue);
            }
        }
        this.updateFpData(ctx, destMap);
        return true;
    }

    private void updateFpData(Context ctx, Map fpDataMap) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = " UPDATE T_FPL_FpData SET FFpValue = ? WHERE FID = ? ";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            for (Map.Entry entry : fpDataMap.entrySet()) {
                String id = (String)entry.getKey();
                BigDecimal value = (BigDecimal)entry.getValue();
                pstmt.setBigDecimal(1, value);
                pstmt.setString(2, id);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private BigDecimal getPropValue(BigDecimal srcValue, BigDecimal prop, int scale) {
        if (scale == 0) {
            scale = srcValue.scale();
        }
        return srcValue.multiply(prop).divide(BASE_DIVISOR, scale, 4);
    }

    private Map getFpDataMap(Context ctx, String orgId, String periodId) throws BOSException {
        HashMap<String, FpDataInfo> fpDataMap = new HashMap<String, FpDataInfo>();
        if (FMHelper.isEmpty((String)orgId)) {
            throw new BOSException("params is null!");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            String state = "editing";
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT a.* FROM T_FPL_FpData a \n").append("\tJOIN T_FPL_FpForm b ON a.FFpFormId = b.FID \n").append(" WHERE b.FOrgUnitId = ? AND b.FState = ? ");
            if (!FMHelper.isEmpty((String)periodId)) {
                sql.append(" AND a.FFpPeriodId = ?");
            }
            sql.append(" ORDER BY a.FFormula");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgId);
            pstmt.setString(2, state);
            if (!FMHelper.isEmpty((String)periodId)) {
                pstmt.setString(3, periodId);
            }
            rs = pstmt.executeQuery();
            FpDataInfo info = null;
            while (rs.next()) {
                info = new FpDataInfo();
                info.setId(rs.getString("FID"));
                info.setFpFormId(rs.getString("FFpFormId"));
                info.setFpValue(rs.getBigDecimal("FFpValue"));
                info.setAdjustValue(rs.getBigDecimal("FAdjustValue"));
                info.setBizActual(rs.getBigDecimal("FBizActual"));
                info.setFpFormula(rs.getString("FFormula"));
                info.setFpItemId(rs.getString("FFpItemId"));
                info.setFpAssistItemId(rs.getString("FFpAssistItemCombId"));
                info.setFpPeriodId(rs.getString("FFpPeriodId"));
                info.setCurrencyId(rs.getString("FCurrencyId"));
                fpDataMap.put(rs.getString("FFormula"), info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return fpDataMap;
    }

    protected boolean _disassembleByPeriod(Context ctx, String formId, Map periodPropMap) throws BOSException, EASBizException {
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, formId);
        Map srcMap = this._getFpDataMap(ctx, formId);
        String srcPeriodNum = info.getBgPeriod().getNumber();
        String srcOrgId = info.getOrgUnit().getId().toString();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"disassembleByPeriod", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)(info.getNumber() + " - " + info.getName() + " - " + srcPeriodNum), (String)"fpl_form_disassembleByPeriod");
        HashMap<String, Map> tempMap = new HashMap<String, Map>();
        String periodId2 = null;
        for (String periodId2 : periodPropMap.keySet()) {
            tempMap.put(periodId2, this.getFpDataMap(ctx, srcOrgId, periodId2));
        }
        FPItemFormulaFormat fmt = FPItemFormulaFormat.getInstance();
        FpItemFormulaInfo formulaInfo = null;
        HashMap<String, BigDecimal> destMap = new HashMap<String, BigDecimal>();
        for (Map.Entry entry : periodPropMap.entrySet()) {
            periodId2 = (String)entry.getKey();
            BigDecimal prop = (BigDecimal)entry.getValue();
            Map formulaMap = (Map)tempMap.get(periodId2);
            for (Map.Entry entry1 : formulaMap.entrySet()) {
                String formula = (String)entry1.getKey();
                try {
                    formulaInfo = (FpItemFormulaInfo)fmt.parseObject(formula);
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                formulaInfo.setPeriodNum(srcPeriodNum);
                String srcFormula = fmt.format(formulaInfo);
                if (!srcMap.containsKey(srcFormula)) continue;
                BigDecimal srcValue = ((FpDataInfo)srcMap.get(srcFormula)).getFpValue();
                int scale = FMHelper.getPrecOfCurrency((Context)ctx, (String)((FpDataInfo)srcMap.get(srcFormula)).getCurrencyId());
                BigDecimal propValue = this.getPropValue(srcValue, prop, scale);
                FpDataInfo dataInfo = (FpDataInfo)formulaMap.get(formula);
                destMap.put(dataInfo.getId(), propValue);
            }
        }
        this.updateFpData(ctx, destMap);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        return true;
    }

    protected List _getCollectOuIds(Context ctx, String fpFormId) throws BOSException, EASBizException {
        ArrayList<String> ouIdList = new ArrayList<String>();
        if (FMHelper.isEmpty((String)fpFormId)) {
            return ouIdList;
        }
        try {
            String sql = "SELECT FOrgUnitID FROM T_FPL_FpFormCollectOrgUnit WHERE FFpFormID = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fpFormId});
            while (rs.next()) {
                ouIdList.add(rs.getString("FOrgUnitID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("_getCollectOuIds generate error:" + e));
            throw new BOSException((Throwable)e);
        }
        return ouIdList;
    }

    protected Map _getFpDataMap(Context ctx, String formId) throws BOSException, EASBizException {
        HashMap<String, FpDataInfo> fpDataMap = new HashMap<String, FpDataInfo>();
        if (formId == null) {
            return fpDataMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM T_FPL_FpData WHERE FFpFormId = ? ORDER BY FFormula ");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, formId);
            rs = pstmt.executeQuery();
            FpDataInfo info = null;
            while (rs.next()) {
                info = new FpDataInfo();
                info.setId(rs.getString("FID"));
                info.setFpFormId(rs.getString("FFpFormId"));
                info.setFpValue(rs.getBigDecimal("FFpValue"));
                info.setBizActual(rs.getBigDecimal("FBizActual"));
                info.setAdjustValue(rs.getBigDecimal("FAdjustValue"));
                info.setFpFormula(rs.getString("FFormula"));
                info.setFpItemId(rs.getString("FFpItemId"));
                info.setFpAssistItemId(rs.getString("FFpAssistItemCombId"));
                info.setFpPeriodId(rs.getString("FFpPeriodId"));
                info.setCurrencyId(rs.getString("FCurrencyId"));
                fpDataMap.put(rs.getString("FFormula"), info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return fpDataMap;
    }

    protected void _syncFpActualData(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        FpFormCollection coll = this.getFpFormColl(ctx, idSet);
        this.syncFpActualData(ctx, coll);
        logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"4_FpFormFacadeControllerBean", (Locale)ctx.getLocale()));
    }

    private FpFormCollection getFpFormColl(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        FpFormCollection coll = iFpForm.getFpFormCollection(evi);
        return coll;
    }

    private void syncFpActualData(Context ctx, FpFormCollection coll) throws EASBizException, BOSException {
        FpFormInfo info = null;
        Map beforeSyncMap = null;
        Map afterSyncMap = null;
        byte[] data = null;
        ArrayList result = null;
        HashMap changedValueMap = new HashMap();
        IReport iReport = ReportFactory.getLocalInstance((Context)ctx);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            beforeSyncMap = FpFormHelper.beforeSyncFpActual(ctx, info);
            data = info.getData();
            result = iReport.backCalcEx((IObjectValue)info, data, null);
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"5_FpFormFacadeControllerBean", (Locale)ctx.getLocale()));
            afterSyncMap = FpFormHelper.syncKDF(info, result);
            changedValueMap.putAll(this.getChangedValueMap(beforeSyncMap, afterSyncMap, ctx));
        }
        this.syncFpActualData(ctx, changedValueMap);
    }

    private Map getChangedValueMap(Map beforeSyncMap, Map afterSyncMap, Context ctx) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (beforeSyncMap == null || beforeSyncMap.isEmpty() || afterSyncMap == null || afterSyncMap.isEmpty()) {
            return map;
        }
        if (beforeSyncMap.size() != afterSyncMap.size()) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"6_FpFormFacadeControllerBean", (Locale)ctx.getLocale()));
            throw new NullPointerException("ssssssssssssssssss");
        }
        Set keySet = beforeSyncMap.keySet();
        String key2 = null;
        FpDataInfo info = null;
        String fpDataId = null;
        BigDecimal afterValue = null;
        for (String key2 : keySet) {
            info = (FpDataInfo)beforeSyncMap.get(key2);
            afterValue = (BigDecimal)afterSyncMap.get(key2);
            if (info.getBizActual().compareTo(afterValue) == 0) continue;
            fpDataId = info.getId();
            map.put(fpDataId, afterValue.add(info.getBizActual().negate()));
        }
        return map;
    }

    private void syncFpActualData(Context ctx, Map map) throws FpFormException, BOSException {
        if (map == null || map.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE T_FPL_FpData SET FBizActual = FBizActual + ?, FFpBalance = FFpBalance - ? WHERE FID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int i = 0;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                i = 0;
                Map.Entry entry = iter.next();
                pstmt.setBigDecimal(++i, (BigDecimal)entry.getValue());
                pstmt.setBigDecimal(++i, (BigDecimal)entry.getValue());
                pstmt.setString(++i, (String)entry.getKey());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected List _getFpFormStyle(Context ctx, String ouId, String templateId, String currencyId, String beginPeriodId, String endPeriodId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("fpTemplate.id", (Object)templateId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)beginPeriodId, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)endPeriodId, CompareType.LESS_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo("bgPeriod.longNumber");
        sorterItem.setSortType(SortType.DESCEND);
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(sorterItem);
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        FpFormCollection coll = iFpForm.getFpFormCollection(evi);
        if (coll == null || coll.isEmpty()) {
            IFpTemplate iFpTemplate = FpTemplateFactory.getLocalInstance(ctx);
            FpTemplateInfo templateInfo = iFpTemplate.getFpTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
            KDF kdf = FpFormHelper.getKDF(templateInfo);
            return this.getFpFormStyle(ctx, kdf);
        }
        FpFormInfo info = coll.get(0);
        KDF kdf = FpFormHelper.getKDF(info);
        return this.getFpFormStyle(ctx, kdf);
    }

    private List getFpFormStyle(Context ctx, KDF kdf) throws BOSException {
        ArrayList list = new ArrayList();
        if (kdf == null) {
            return list;
        }
        Collection coll = kdf.getAllTable();
        KDTable table = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            table = (KDTable)kdf.getTableByIndex(i);
            list.addAll(this.getFpFormStyle(ctx, table));
        }
        return list;
    }

    private List getFpFormStyle(Context ctx, KDTable table) throws BOSException {
        Map itemInfoMap = FpItemFormulaHelper.getItemInfoMap(ctx);
        ArrayList rowList = new ArrayList();
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell cell = null;
        boolean hasItem = false;
        FpItemInfo info = null;
        FpItemFormulaParser parser = null;
        String formula = null;
        String itemNum = null;
        for (int i = 0; i < rowCount; ++i) {
            ArrayList<FpItemInfo> cellList = new ArrayList<FpItemInfo>();
            hasItem = false;
            for (int j = 0; j < colCount; ++j) {
                cell = table.getCell(i, j);
                if (!FpFormHelper.hasItemFormula(cell)) continue;
                formula = FpFormHelper.getFormula(cell);
                parser = new FpItemFormulaParser(formula);
                parser.parse();
                if (!parser.isAsstItemCombEmpty() || cellList.contains(info = (FpItemInfo)itemInfoMap.get(itemNum = parser.getItem()))) continue;
                cellList.add(info);
                hasItem = true;
            }
            if (!hasItem) continue;
            rowList.add(cellList);
        }
        return rowList;
    }
}

