/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.gnt.GnoteInfo;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordCollection;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordFactory;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordCollection;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordFactory;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordInfo;
import com.kingdee.eas.fm.gnt.IGnoteProvideRecord;
import com.kingdee.eas.fm.gnt.app.AbstractGnoteFacadeControllerBean;
import com.kingdee.eas.fm.gnt.app.ProvideDisposer;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.fm.gnt.common.NoteNumberHelper;
import com.kingdee.eas.fm.nt.ChequeAppRecFactory;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.IChequeAppRec;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.SelSymbolEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class GnoteFacadeControllerBean
extends AbstractGnoteFacadeControllerBean {
    public static String resourcePath = "com.kingdee.eas.fm.gnt.GntResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.gnt.app.GnoteFacadeControllerBean");

    public CoreBaseCollection getBankByNoteType(NTTypeGroupEnum enums, Context ctx) throws BOSException {
        EntityViewInfo noteTypeView = new EntityViewInfo();
        FilterInfo noteTypeFilter = new FilterInfo();
        noteTypeFilter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(enums.getValue())));
        noteTypeView.setFilter(noteTypeFilter);
        CoreBaseCollection nttypeColl = null;
        try {
            nttypeColl = NTTypeFactory.getLocalInstance((Context)ctx).getCollection(noteTypeView);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashSet<String> nttypeID = new HashSet<String>();
        if (nttypeColl.size() == 0) {
            return null;
        }
        for (int i = 0; i < nttypeColl.size(); ++i) {
            nttypeID.add(nttypeColl.get(i).getId().toString());
        }
        EntityViewInfo purchaseView = new EntityViewInfo();
        FilterInfo purchaseFilter = new FilterInfo();
        purchaseView.setFilter(purchaseFilter);
        purchaseFilter.getFilterItems().add(new FilterItemInfo("ntType.id", nttypeID, CompareType.INCLUDE));
        purchaseView.getSelector().add("bank.*");
        GnotePurchaseRecordCollection purchaseColl = GnotePurchaseRecordFactory.getLocalInstance(ctx).getGnotePurchaseRecordCollection(purchaseView);
        HashSet<String> bankIdSet = new HashSet<String>();
        Iterator iterator = purchaseColl.iterator();
        while (iterator.hasNext()) {
            GnotePurchaseRecordInfo purchaseInfo = (GnotePurchaseRecordInfo)iterator.next();
            bankIdSet.add(purchaseInfo.getBank().getId().toString());
        }
        CoreBaseCollection coll = GnoteFacadeControllerBean.getBaseInfoFromIdSet(ctx, bankIdSet);
        return coll;
    }

    public static CoreBaseCollection getBaseInfoFromIdSet(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        ICoreBase bizCtrl = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(idSet.toArray()[0].toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        CoreBaseCollection collection = bizCtrl.getCollection(evi);
        return collection;
    }

    @Override
    protected IObjectCollection _getBankColl(Context ctx, int noteGroupEnum) throws BOSException, EASBizException {
        NTTypeGroupEnum enums = NTTypeGroupEnum.getEnum((int)noteGroupEnum);
        EntityViewInfo noteTypeView = new EntityViewInfo();
        FilterInfo noteTypeFilter = new FilterInfo();
        noteTypeFilter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(enums.getValue())));
        noteTypeView.setFilter(noteTypeFilter);
        CoreBaseCollection nttypeColl = null;
        try {
            nttypeColl = NTTypeFactory.getLocalInstance((Context)ctx).getCollection(noteTypeView);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashSet<String> nttypeID = new HashSet<String>();
        if (nttypeColl.size() == 0) {
            return null;
        }
        for (int i = 0; i < nttypeColl.size(); ++i) {
            nttypeID.add(nttypeColl.get(i).getId().toString());
        }
        EntityViewInfo purchaseView = new EntityViewInfo();
        FilterInfo purchaseFilter = new FilterInfo();
        purchaseView.setFilter(purchaseFilter);
        purchaseFilter.getFilterItems().add(new FilterItemInfo("ntType.id", nttypeID, CompareType.INCLUDE));
        purchaseView.getSelector().add("bank.*");
        GnotePurchaseRecordCollection purchaseColl = GnotePurchaseRecordFactory.getLocalInstance(ctx).getGnotePurchaseRecordCollection(purchaseView);
        HashSet<String> bankIdSet = new HashSet<String>();
        Iterator iterator = purchaseColl.iterator();
        while (iterator.hasNext()) {
            GnotePurchaseRecordInfo purchaseInfo = (GnotePurchaseRecordInfo)iterator.next();
            if (purchaseInfo.getBank() == null) continue;
            bankIdSet.add(purchaseInfo.getBank().getId().toString());
        }
        CoreBaseCollection coll = GnoteFacadeControllerBean.getBaseInfoFromIdSet(ctx, bankIdSet);
        return coll;
    }

    @Override
    protected IObjectValue _getProvideByNoteNumber(Context ctx, String number) throws BOSException, EASBizException {
        HashSet set;
        GnotePurchaseRecordCollection coll = GnotePurchaseRecordFactory.getLocalInstance(ctx).getGnotePurchaseRecordCollection();
        Iterator iter1 = coll.iterator();
        GnotePurchaseRecordInfo purchase = null;
        while (iter1.hasNext() && !(set = (purchase = (GnotePurchaseRecordInfo)iter1.next()).getNumberHashSet()).contains(number)) {
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("ntType.*");
        view.getSelector().add("*");
        view.getSelector().add("parent.bank.id");
        view.getSelector().add("receiptor.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)purchase.getId().toString()));
        GnoteProvideRecordCollection coll2 = GnoteProvideRecordFactory.getLocalInstance(ctx).getGnoteProvideRecordCollection(view);
        Iterator iter2 = coll2.iterator();
        GnoteProvideRecordInfo provide = null;
        while (iter2.hasNext()) {
            provide = (GnoteProvideRecordInfo)iter2.next();
            List numberList = NoteNumberHelper.getProvidedNotesNum(provide.getReceiptedNum());
            HashSet set2 = NoteNumberHelper.getCodingNumber(purchase.getNumRule(), numberList);
            if (!set2.contains(number)) continue;
            return provide;
        }
        return null;
    }

    @Override
    protected void _disposeProvide(Context ctx, IObjectValue provide, IObjectValue cheque, String oprtState) throws BOSException, EASBizException {
        HashSet set;
        GnoteProvideRecordInfo info = (GnoteProvideRecordInfo)provide;
        if (info == null) {
            return;
        }
        ChequeInfo chequeInfo = (ChequeInfo)cheque;
        if (OprtState.ADDNEW.equals(oprtState)) {
            info.setUsedAmount(info.getUsedAmount() + 1);
            info.setRemainAmount(info.getReceiptAmount() - info.getUsedAmount());
            set = info.getUsedNumbersHashSet();
            set.add(chequeInfo.getNumber());
            info.SetUsedNumbersHashSet(set);
        } else if (OprtState.EDIT.equals(oprtState)) {
            ChequeInfo originalCheque = ChequeFactory.getLocalInstance((Context)ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(chequeInfo.getId().toString()));
            HashSet set2 = info.getUsedNumbersHashSet();
            set2.remove(chequeInfo.getNumber());
            set2.add(originalCheque.getNumber());
            info.SetUsedNumbersHashSet(set2);
        } else if ("DELETE".equals(oprtState)) {
            set = info.getUsedNumbersHashSet();
            set.remove(chequeInfo.getNumber());
            info.SetUsedNumbersHashSet(set);
            info.setUsedAmount(info.getUsedAmount() - 1);
            info.setRemainAmount(info.getReceiptAmount() - info.getUsedAmount());
        }
        IGnoteProvideRecord IProvide = GnoteProvideRecordFactory.getLocalInstance(ctx);
        IProvide.disposeProvide((IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }

    @Override
    protected IRowSet _getGnoteUsed(Context ctx, HashMap filterParam) throws BOSException {
        Date startDate = (Date)filterParam.get("startDate");
        Date endDate = (Date)filterParam.get("endDate");
        Set companyIdSet = (Set)filterParam.get("companySet");
        Set notetypeIdSet = (Set)filterParam.get("noteTypeSet");
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sfilter = new StringBuffer();
        sfilter.append(" where  a.fissueDate>{" + startDate + "} and a.fissueDate<{" + endDate + "}  ");
        StringBuffer sfilterCompany = new StringBuffer();
        StringBuffer sfilterNoteType = new StringBuffer();
        Iterator iter = null;
        if (companyIdSet != null) {
            iter = companyIdSet.iterator();
            while (iter.hasNext()) {
                sfilterCompany.append("'" + iter.next().toString() + "',");
            }
            sfilter.append(" and a.fcompanyid in (" + sfilterCompany.substring(0, sfilterCompany.length() - 1) + ")");
        }
        if (notetypeIdSet != null) {
            iter = notetypeIdSet.iterator();
            while (iter.hasNext()) {
                sfilterNoteType.append("'" + iter.next().toString() + "',");
            }
            sfilter.append(" and a.fnttypeid in (" + sfilterNoteType.substring(0, sfilterNoteType.length() - 1) + ")");
        }
        sfilter.append(" and a.FNoteState in (2, 4,3)");
        String sql1 = "select b.fname_" + loc + " as companyname,a.fnumber,a.fissueDate,c.fname_" + loc + " as nttype,d.fname_" + loc + " as signer,a.FNoteState as state from t_nt_cheque a left join t_org_company b  on a.fcompanyid=b.fid left join t_nt_nttype c on a.fnttypeid=c.fid left join T_BD_Person d on a.FSignerID=d.fid";
        sql1 = sql1 + sfilter;
        String sql2 = "select b.fname_" + loc + " as companyname,a.fnumber,a.fissueDate,c.fname_" + loc + " as nttype,d.fname_" + loc + " as signer,a.FNoteState as state from t_gnt_gnote  a left join t_org_company b on a.fcompanyid=b.fid left join t_nt_nttype c on a.fnttypeid=c.fid left join T_BD_Person d on a.FSignerID=d.fid";
        sql2 = sql2 + sfilter;
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql(sql1 + " union " + sql2);
        return this.getRowSet(ctx, sqlBuilder);
    }

    private IRowSet getRowSet(Context ctx, SQLUtil sqlBuilder) throws BOSException {
        JdbcRowSet rowSet = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = sqlBuilder.createState(conn);
            rs = stmt.executeQuery();
            rowSet = new JdbcRowSet();
            rowSet.populate(rs);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rowSet;
    }

    @Override
    protected HashSet _getValidProvideIDByBank(Context ctx, String bankID) throws BOSException, EASBizException {
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankID, CompareType.EQUALS));
        view.setFilter(filter);
        GnotePurchaseRecordCollection purchaseColl = GnotePurchaseRecordFactory.getLocalInstance(ctx).getGnotePurchaseRecordCollection(view);
        Iterator iter = purchaseColl.iterator();
        while (iter.hasNext()) {
            GnotePurchaseRecordInfo purchase = (GnotePurchaseRecordInfo)iter.next();
            set.add(purchase.getId());
        }
        return set;
    }

    @Override
    protected void _updateCheque(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ChequeInfo cheque = (ChequeInfo)model;
        ICheque icheque = ChequeFactory.getLocalInstance((Context)ctx);
        ProvideDisposer disposer = new ProvideDisposer(ctx, (CoreBaseInfo)cheque);
        ChequeInfo oldCheque = icheque.getChequeInfo(pk);
        IGnoteProvideRecord iProvide = GnoteProvideRecordFactory.getLocalInstance(ctx);
        int updateState = 0;
        IChequeAppRec iRec = ChequeAppRecFactory.getLocalInstance((Context)ctx);
        switch (updateState) {
            case 0: {
                disposer.usedAmtOfProvideAddOne();
                cheque.setState(ChequeStatusEnum.APPLIED);
                ChequeAppRecInfo appRec = new ChequeAppRecInfo();
                appRec.setCeiling(this.getCeiling(cheque.getSealSymbol()));
                iRec.addnew((CoreBaseInfo)appRec);
                cheque.setApplyRec(appRec);
                icheque.updateCheque(pk, (IObjectValue)cheque);
                break;
            }
            case 1: {
                cheque.getApplyRec().setCeiling(this.getCeiling(cheque.getSealSymbol()));
                iRec.update((IObjectPK)new ObjectUuidPK(cheque.getApplyRec().getId().toString()), (CoreBaseInfo)cheque.getApplyRec());
                icheque.updateCheque(pk, (IObjectValue)cheque);
                break;
            }
            case 2: {
                oldCheque.setState(ChequeStatusEnum.NEW);
                oldCheque.setApplyRec(null);
                disposer.setNote((CoreBaseInfo)oldCheque);
                disposer.usedAmtOfProvideReduceOne();
                icheque.updateCheque(pk, (IObjectValue)oldCheque);
                GnoteInfo gnote = (GnoteInfo)NoteHelper.getNotUsedNote((ICoreBillBase)icheque, cheque.getNumber());
                cheque.setId(gnote.getId());
                cheque.setState(ChequeStatusEnum.APPLIED);
                ChequeAppRecInfo appRec2 = new ChequeAppRecInfo();
                appRec2.setCeiling(this.getCeiling(cheque.getSealSymbol()));
                iRec.addnew((CoreBaseInfo)appRec2);
                cheque.setApplyRec(appRec2);
                cheque.setAbandonDate(null);
                disposer.setNote((CoreBaseInfo)gnote);
                disposer.usedAmtOfProvideAddOne();
                icheque.updateCheque((IObjectPK)new ObjectUuidPK(cheque.getId().toString()), (IObjectValue)cheque);
            }
        }
    }

    @Override
    protected void _deleteCheque(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChequeInfo cheque = ChequeFactory.getLocalInstance((Context)ctx).getChequeInfo(pk);
        ProvideDisposer disposer = new ProvideDisposer(ctx, (CoreBaseInfo)cheque);
        disposer.usedAmtOfProvideReduceOne();
    }

    @Override
    protected String _getNextValidNumber(Context ctx, String Number2) throws BOSException {
        return null;
    }

    private BigDecimal getCeiling(SelSymbolEnum sel) {
        if (0 == sel.getValue()) {
            return new BigDecimal("999.9999");
        }
        if (1 == sel.getValue()) {
            return new BigDecimal("9999.9999");
        }
        if (2 == sel.getValue()) {
            return new BigDecimal("99999.9999");
        }
        return null;
    }
}

