/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.ExternalAccountBalanceFactory;
import com.kingdee.eas.fm.liquid.ExternalAccountBalanceInfo;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ExternalAccountBalanceDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)ExternalAccountBalanceDataImport.class.getName());
    private HashMap<String, AccountBankInfo> bankMap = new HashMap();
    private HashMap<String, AccountViewInfo> viewMap = new HashMap();
    private HashMap map;

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal amount;
        String resMessage;
        String resMessage2;
        ExternalAccountBalanceInfo info = new ExternalAccountBalanceInfo();
        Object data = null;
        CompanyOrgUnitInfo curCompany = null;
        CurrencyInfo curCurrency = null;
        boolean isByCurrency = false;
        String accountName = "";
        data = this.getData(hsData, "companyNumber");
        if (data == null || data.equals("")) {
            String resMessage3 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage3);
        }
        if (data != null && data.toString().trim().length() > 0) {
            CompanyOrgUnitInfo company = LiquidBaseHelper.getCompanyByNumber(ctx, data.toString());
            if (company == null) {
                String resMessage4 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage4, data.toString()));
            }
            String companyId = company.getId().toString();
            if (this.map == null) {
                try {
                    this.map = LiquidBaseHelper.getAuthorizedOrgViewIDs(ctx, true, (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId()), OrgViewType.COMPANY, null, null, null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!this.map.containsKey(companyId)) {
                String resMessage5 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNoPermission", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage5, data.toString(), ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
            }
            curCompany = company;
            info.setCompany(company);
        }
        if ((data = this.getData(hsData, "date")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"bizTimeNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToDate((Object)data).after(DateUtil.getDayEnd())) {
                resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"dateAfterToday", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage2);
            }
            info.setDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "currencyNumber")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currencyNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0) {
            CurrencyInfo currency = LiquidBaseHelper.getCurrencyByNumber(ctx, data.toString());
            if (currency == null) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currenyNotExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage, data.toString()));
            }
            curCurrency = currency;
        }
        if ((data = this.getData(hsData, "accountNumber")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"accountNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        accountName = data.toString();
        if (data != null && data.toString().trim().length() > 0 && curCompany != null && curCompany.getNumber() != null) {
            AccountBankInfo bankInfos = null;
            AccountViewInfo viewInfos = null;
            String keyValue = data.toString().trim() + curCompany.getNumber();
            if (this.bankMap.containsKey(keyValue)) {
                bankInfos = this.bankMap.get(keyValue);
            } else {
                bankInfos = LiquidBaseHelper.getBankFromNumber(ctx, data.toString(), curCompany.getNumber());
                if (bankInfos != null) {
                    this.bankMap.put(keyValue, bankInfos);
                }
            }
            if (bankInfos != null) {
                info.setAccountBank(bankInfos);
                if (curCurrency != null) {
                    if (!bankInfos.isIsByCurrency()) {
                        info.setCurrency(curCurrency);
                    } else if (bankInfos.getCurrency() != null && curCurrency.getId().toString().equals(bankInfos.getCurrency().getId().toString()) && bankInfos.isIsByCurrency()) {
                        info.setCurrency(curCurrency);
                    } else {
                        String resMessage6 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currencyNotFit", (Locale)ctx.getLocale());
                        throw new TaskExternalException(MessageFormat.format(resMessage6, data.toString(), curCurrency.getNumber()));
                    }
                }
            }
            if (bankInfos == null) {
                if (this.viewMap.containsKey(keyValue)) {
                    viewInfos = this.viewMap.get(keyValue);
                } else {
                    viewInfos = LiquidBaseHelper.getViewFromNumber(ctx, data.toString(), curCompany.getNumber());
                    if (viewInfos != null) {
                        this.viewMap.put(keyValue, viewInfos);
                    }
                }
                if (viewInfos != null) {
                    info.setAccountView(viewInfos);
                    AccountCurrencyCollection curCol = viewInfos.getAccountCurrency();
                    CurrencyInfo currency = null;
                    for (int i = 0; i < curCol.size(); ++i) {
                        CurrencyInfo viewCur = curCol.get(i).getCurrency();
                        if (viewCur == null || curCurrency == null || !viewCur.getId().toString().equals(curCurrency.getId().toString())) continue;
                        currency = viewCur;
                    }
                    if (currency != null) {
                        info.setCurrency(currency);
                    } else {
                        String resMessage7 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"viewCurrencyNotFit", (Locale)ctx.getLocale());
                        throw new TaskExternalException(MessageFormat.format(resMessage7, data.toString(), curCurrency.getNumber()));
                    }
                }
            }
            if (bankInfos == null && viewInfos == null) {
                String resMessage8 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"accountNumberNotExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage8, data.toString(), curCompany.getNumber()));
            }
        }
        if ((data = this.getData(hsData, "amount")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setAmount(amount);
        }
        if ((data = this.getData(hsData, "amountLoc")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountLocNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountLocEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setAmountLoc(amount);
        }
        if (info.getAmount().compareTo(BigDecimal.ZERO) == 0 && info.getAmountLoc().compareTo(BigDecimal.ZERO) != 0 || info.getAmount().compareTo(BigDecimal.ZERO) != 0 && info.getAmountLoc().compareTo(BigDecimal.ZERO) == 0 || info.getAmount().compareTo(BigDecimal.ZERO) > 0 && info.getAmountLoc().compareTo(BigDecimal.ZERO) < 0 || info.getAmount().compareTo(BigDecimal.ZERO) < 0 && info.getAmountLoc().compareTo(BigDecimal.ZERO) > 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountMustSame", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        return info;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ExternalAccountBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

