/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fm.liquid.ExternalTransDetailFactory;
import com.kingdee.eas.fm.liquid.ExternalTransDetailInfo;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ExternalTransDetailDataImport
extends BlockDataTransmission {
    private static Logger logger = Logger.getLogger((String)ExternalTransDetailDataImport.class.getName());
    private HashMap<String, AccountBankInfo> bankMap = new HashMap();
    private HashMap<String, AccountViewInfo> viewMap = new HashMap();
    private HashMap<String, FeeTypeInfo> feeMap = new HashMap();
    private HashMap map;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ExternalTransDetailFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.ORMAPPING;
    }

    protected void verifyCoreBaseInfo(Context ctx, CoreBaseInfo info) throws TaskExternalException {
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        CoreBaseCollection ExternalTransDetailCollection2 = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            SimpleRecord rec = (SimpleRecord)coll.get(i);
            ExternalTransDetailInfo ExternalTransDetailInfo2 = this.transmit(rec, ctx);
            ExternalTransDetailCollection2.add((CoreBaseInfo)ExternalTransDetailInfo2);
        }
        return ExternalTransDetailCollection2;
    }

    private ExternalTransDetailInfo transmit(SimpleRecord hsData, Context ctx) throws TaskExternalException {
        BigDecimal amount;
        String resMessage;
        String resMessage2;
        String resMessage3;
        ExternalTransDetailInfo info = new ExternalTransDetailInfo();
        Object data = null;
        CompanyOrgUnitInfo curCompany = null;
        CurrencyInfo curCurrency = null;
        data = this.getData(hsData, "companyNumber");
        if (data == null || data.equals("")) {
            String resMessage4 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage4);
        }
        if (data != null && data.toString().trim().length() > 0) {
            CompanyOrgUnitInfo company = LiquidBaseHelper.getCompanyByNumber(ctx, data.toString());
            if (company == null) {
                String resMessage5 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage5, data.toString()));
            }
            String companyId = company.getId().toString();
            if (this.map == null) {
                try {
                    this.map = LiquidBaseHelper.getAuthorizedOrgViewIDs(ctx, true, (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId()), OrgViewType.COMPANY, null, null, null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!this.map.containsKey(companyId)) {
                resMessage3 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNoPermission", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage3, data.toString(), ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
            }
            curCompany = company;
            info.setCompany(company);
        }
        if ((data = this.getData(hsData, "bizTime")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"bizTimeNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0) {
            if (LiquidBaseHelper.objToTimestamp(data).after(DateUtil.getDayEnd())) {
                resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"dateAfterToday", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage2);
            }
            info.setBizTime(TypeConversionUtils.objToTimestamp((Object)data));
        }
        if ((data = this.getData(hsData, "feeType")) != null && data.toString().trim().length() > 0) {
            String keyValue = data.toString();
            FeeTypeInfo feeType = null;
            if (this.feeMap.containsKey(keyValue)) {
                feeType = this.feeMap.get(keyValue);
            } else {
                feeType = LiquidBaseHelper.getFeeTypeByNumber(ctx, data.toString());
                if (feeType != null) {
                    this.feeMap.put(keyValue, feeType);
                } else {
                    resMessage3 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"feeTypeNotExit", (Locale)ctx.getLocale());
                    throw new TaskExternalException(MessageFormat.format(resMessage3, data.toString()));
                }
            }
            info.setFeeType(feeType);
        }
        if ((data = this.getData(hsData, "currencyNumber")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currencyNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0) {
            CurrencyInfo currency = LiquidBaseHelper.getCurrencyByNumber(ctx, data.toString());
            if (currency == null) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currenyNotExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage, data.toString()));
            }
            curCurrency = currency;
        }
        if ((data = this.getData(hsData, "accountNumber")) == null || data.equals("")) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"accountNull", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (data != null && data.toString().trim().length() > 0 && curCompany != null && curCompany.getNumber() != null) {
            Object baseInfo = null;
            AccountBankInfo bankInfos = null;
            AccountViewInfo viewInfos = null;
            String keyValue = data.toString().trim() + curCompany.getNumber();
            if (this.bankMap.containsKey(keyValue)) {
                bankInfos = this.bankMap.get(keyValue);
            } else {
                bankInfos = LiquidBaseHelper.getBankFromNumber(ctx, data.toString(), curCompany.getNumber());
                if (bankInfos != null) {
                    this.bankMap.put(keyValue, bankInfos);
                }
            }
            if (bankInfos != null) {
                info.setAccountBank(bankInfos);
                if (curCurrency != null) {
                    if (!bankInfos.isIsByCurrency()) {
                        info.setCurrency(curCurrency);
                    } else if (bankInfos.getCurrency() != null && curCurrency.getId().toString().equals(bankInfos.getCurrency().getId().toString()) && bankInfos.isIsByCurrency()) {
                        info.setCurrency(curCurrency);
                    } else {
                        String resMessage6 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"currencyNotFit", (Locale)ctx.getLocale());
                        throw new TaskExternalException(MessageFormat.format(resMessage6, data.toString(), curCurrency.getNumber()));
                    }
                }
            }
            if (this.viewMap.containsKey(keyValue)) {
                viewInfos = this.viewMap.get(keyValue);
            } else {
                viewInfos = LiquidBaseHelper.getViewFromNumber(ctx, data.toString(), curCompany.getNumber());
                if (viewInfos != null) {
                    this.viewMap.put(keyValue, viewInfos);
                }
            }
            if (viewInfos != null) {
                info.setAccountView(viewInfos);
                AccountCurrencyCollection curCol = viewInfos.getAccountCurrency();
                CurrencyInfo currency = null;
                if (curCurrency != null) {
                    for (int i = 0; i < curCol.size(); ++i) {
                        CurrencyInfo viewCur = curCol.get(i).getCurrency();
                        if (viewCur == null || !viewCur.getId().toString().equals(curCurrency.getId().toString())) continue;
                        currency = viewCur;
                    }
                    if (currency != null) {
                        info.setCurrency(currency);
                    } else {
                        String resMessage7 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"viewCurrencyNotFit", (Locale)ctx.getLocale());
                        throw new TaskExternalException(MessageFormat.format(resMessage7, data.toString(), curCurrency.getNumber()));
                    }
                }
            }
            if (bankInfos == null && viewInfos == null) {
                String resMessage8 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"accountNumberNotExit", (Locale)ctx.getLocale());
                throw new TaskExternalException(MessageFormat.format(resMessage8, data.toString(), data.toString(), curCompany.getNumber()));
            }
        }
        if ((data = this.getData(hsData, "debitAmount")) == null || data.equals("")) {
            info.setDebitAmount(BigDecimal.ZERO);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setDebitAmount(amount);
        }
        if ((data = this.getData(hsData, "debitAmountLoc")) == null || data.equals("")) {
            info.setDebitAmountLoc(BigDecimal.ZERO);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setDebitAmountLoc(amount);
        }
        if (info.getDebitAmount().compareTo(BigDecimal.ZERO) == 0 && info.getDebitAmountLoc().compareTo(BigDecimal.ZERO) != 0 || info.getDebitAmount().compareTo(BigDecimal.ZERO) != 0 && info.getDebitAmountLoc().compareTo(BigDecimal.ZERO) == 0 || info.getDebitAmount().compareTo(BigDecimal.ZERO) > 0 && info.getDebitAmountLoc().compareTo(BigDecimal.ZERO) < 0 || info.getDebitAmount().compareTo(BigDecimal.ZERO) < 0 && info.getDebitAmountLoc().compareTo(BigDecimal.ZERO) > 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"debitMustSame", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        data = this.getData(hsData, "creditAmount");
        if (data == null || data.equals("")) {
            info.setCreditAmount(BigDecimal.ZERO);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setCreditAmount(amount);
        }
        if ((data = this.getData(hsData, "creditAmountLoc")) == null || data.equals("")) {
            info.setCreditAmountLoc(BigDecimal.ZERO);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setCreditAmountLoc(amount);
        }
        if (info.getCreditAmount().compareTo(BigDecimal.ZERO) == 0 && info.getCreditAmountLoc().compareTo(BigDecimal.ZERO) != 0 || info.getCreditAmount().compareTo(BigDecimal.ZERO) != 0 && info.getCreditAmountLoc().compareTo(BigDecimal.ZERO) == 0 || info.getCreditAmount().compareTo(BigDecimal.ZERO) > 0 && info.getCreditAmountLoc().compareTo(BigDecimal.ZERO) < 0 || info.getCreditAmount().compareTo(BigDecimal.ZERO) < 0 && info.getCreditAmountLoc().compareTo(BigDecimal.ZERO) > 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"creditMustSame", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        data = this.getData(hsData, "balance");
        if (data == null || data.equals("")) {
            info.setBalance(BigDecimal.ZERO);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountLocEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setBalance(amount);
        }
        if ((data = this.getData(hsData, "balanceLoc")) == null || data.equals("")) {
            info.setBalanceLoc(BigDecimal.ZERO);
        }
        if (data != null && data.toString().trim().length() > 0) {
            amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(new BigDecimal("-10000000000000")) <= 0 || amount.compareTo(new BigDecimal("10000000000000")) >= 0) {
                resMessage = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountLocEx", (Locale)ctx.getLocale());
                throw new TaskExternalException(resMessage);
            }
            info.setBalanceLoc(amount);
        }
        if (info.getBalance().compareTo(BigDecimal.ZERO) == 0 && info.getBalanceLoc().compareTo(BigDecimal.ZERO) != 0 || info.getBalance().compareTo(BigDecimal.ZERO) != 0 && info.getBalanceLoc().compareTo(BigDecimal.ZERO) == 0 || info.getBalance().compareTo(BigDecimal.ZERO) > 0 && info.getBalanceLoc().compareTo(BigDecimal.ZERO) < 0 || info.getBalance().compareTo(BigDecimal.ZERO) < 0 && info.getBalanceLoc().compareTo(BigDecimal.ZERO) > 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"balanceMustSame", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (info.getCreditAmount().compareTo(BigDecimal.ZERO) != 0 && info.getDebitAmount().compareTo(BigDecimal.ZERO) != 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountMutual", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (info.getCreditAmountLoc().compareTo(BigDecimal.ZERO) != 0 && info.getDebitAmountLoc().compareTo(BigDecimal.ZERO) != 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountLocMutual", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        if (info.getCreditAmount().compareTo(BigDecimal.ZERO) == 0 && info.getCreditAmountLoc().compareTo(BigDecimal.ZERO) == 0 && info.getDebitAmount().compareTo(BigDecimal.ZERO) == 0 && info.getDebitAmountLoc().compareTo(BigDecimal.ZERO) == 0) {
            resMessage2 = EASCommonResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"AllZero", (Locale)ctx.getLocale());
            throw new TaskExternalException(resMessage2);
        }
        data = this.getData(hsData, "remark");
        if (data != null && data.toString().trim().length() > 0) {
            String remark = data.toString();
            if (data.toString().length() > 200) {
                remark = data.toString().substring(0, 199);
            }
            info.setRemake(remark);
        }
        if ((data = this.getData(hsData, "oppUnit")) != null && data.toString().trim().length() > 0) {
            String oppUnit = data.toString();
            if (data.toString().length() > 200) {
                oppUnit = data.toString().substring(0, 199);
            }
            info.setOppUnit(oppUnit);
        }
        return info;
    }

    private Object getData(SimpleRecord hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = hsData.get((String)fieldName).data;
        }
        return data;
    }
}

