/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.AccountParam;
import com.kingdee.eas.fm.liquid.CalendarHelperFm;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class LiquidHelper {
    public static final String regex = "0xx1xx";
    public static final String LIQUID_RESOURCE = "com.kingdee.eas.fm.liquid.LiquidResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.LiquidHelper");

    public static Set<String> getSetFromString(String srcString, String regex) {
        HashSet<String> idSet = new HashSet<String>();
        if (EmptyUtil.isEmpty((String)srcString)) {
            return null;
        }
        String[] idArray = srcString.split(regex);
        int length = idArray.length;
        for (int i = 0; i < length; ++i) {
            idSet.add(idArray[i]);
        }
        return idSet;
    }

    public static String getLiquidResource(Context ctx, String sourceName) {
        if (ctx == null) {
            return EASResource.getString((String)LIQUID_RESOURCE, (String)sourceName);
        }
        return ResourceBase.getString((String)LIQUID_RESOURCE, (String)sourceName, (Locale)ctx.getLocale());
    }

    public static Set<String> ids2Set(String idString) {
        return LiquidHelper.getSetFromString(idString, regex);
    }

    public static BgPeriodCollection getBeginAndEndDates(Context ctx, Date beginDate, Date endDate, int bgPeriodType) throws EASBizException {
        BgPeriodCollection bgPeriodCol = new BgPeriodCollection();
        try {
            bgPeriodCol = BgPeriodHelper.getPeriodColInfo((Context)ctx, (Date)beginDate, (Date)endDate, (int)bgPeriodType);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return bgPeriodCol;
    }

    public static ArrayList getAcctParamListByRs(IRowSet irs, String type) throws EASBizException {
        ArrayList<AccountParam> acctParamList = new ArrayList<AccountParam>();
        try {
            while (irs.next()) {
                String acctid = irs.getString("FAccountBankId");
                String currencyId = irs.getString("FCurrencyId");
                String companyId = irs.getString("FCompanyId");
                String isBankInterface = irs.getString("FISSETBANKINTERFACE").equals("1") ? "1" : "0";
                AccountParam acctParam = new AccountParam();
                if (acctid == null) continue;
                acctParam.setAcctid(acctid);
                acctParam.setDateType(type);
                acctParam.setCurrencyId(currencyId);
                acctParam.setCompanyId(companyId);
                acctParam.setIsBankInterface(isBankInterface);
                acctParamList.add(acctParam);
            }
            irs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return acctParamList;
    }

    public static Date getFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private static String getBgPeriodNumber(Context ctx, Date date, int type) throws EASBizException {
        String number = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fnumber from ").append("t_bg_BgPeriod");
        sql.append(" WHERE FPERIODTYPE = ").append(type).append("\n");
        sql.append(" and FENDDATE >={ts'").append(sdf.format(date.getTime())).append("'}\n");
        sql.append("  AND FBEGINDATE <= {ts'").append(sdf.format(date.getTime())).append("'}\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                number = rs.getString("fnumber");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return number;
    }

    public static Date getLastBgPeriodDate(Context ctx, Date date, int type) throws EASBizException {
        String curPeriodNumber = LiquidHelper.getBgPeriodNumber(ctx, date, type);
        String lastPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber((String)curPeriodNumber, (int)-1);
        return LiquidHelper.getEndDay(lastPeriodNumber);
    }

    public static Date getEndDay(String periodNumber) {
        if (periodNumber == null) {
            return null;
        }
        int periodType = BgNPeriodHelper.parserBgPeriodType((String)periodNumber);
        if (periodType != 9 && periodType != 2) {
            return BgPeriodHelper.getEndDay((String)periodNumber);
        }
        return LiquidHelper.getEndDayFm(periodNumber);
    }

    public static Date getLastBgPeriodDateForYear(Context ctx, Date date, int type) throws EASBizException {
        String curPeriodNumber = LiquidHelper.getBgPeriodNumber(ctx, date, type);
        String lastYearPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumberForYear((String)curPeriodNumber, (int)-1);
        return LiquidHelper.getEndDay(lastYearPeriodNumber);
    }

    public static Date getEndDayFm(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return null;
        }
        int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber);
        String[] param = bgPeriodNumber.split("\\.");
        int year = -1;
        int halfYear = -1;
        int month = -1;
        int tenDays = -1;
        CalendarHelper calendar = new CalendarHelper();
        CalendarHelperFm calendarFm = new CalendarHelperFm();
        try {
            switch (periodType) {
                case 2: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    halfYear = Integer.parseInt(param[1].substring(0, 2));
                    if (halfYear == 1) {
                        return calendar.getLastDayOfMonth(year, 6);
                    }
                    return calendar.getLastDayOfMonth(year, 12);
                }
                case 9: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    tenDays = Integer.parseInt(param[2].substring(0, 2));
                    return calendarFm.getLastDayOfMonthTenDays(year, month, tenDays);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            return null;
        }
        return null;
    }

    public static BgPeriodInfo getBgPeriodInfoByDateAndCycle(Context ctx, Date date, int queryCycle) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("beginDate");
        selector.add("endDate");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(queryCycle)));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("beginDate"));
        view.setSorter(sorter);
        BgPeriodCollection colls = null;
        colls = ctx == null ? BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view) : BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
            return colls.get(0);
        }
        return null;
    }

    public static void printDiffTime(String name, Date beginTime, Date endTime) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now2String = df.format(endTime);
        System.out.println(now2String);
        long difTime = endTime.getTime() - beginTime.getTime();
        System.out.println(name + " Spend Secends: " + difTime / 1000L);
    }

    public static void printTime(String name, Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now2String = df.format(date);
        logger.debug((Object)(name + " EndTime: " + now2String));
    }
}

