/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class DealFinancingDataRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.DealFinancingDataRunnable");
    private final String sql = " INSERT INTO T_LI_FinancingBalance (FCompanyID,FBankID,FFinanceFinancingID,FRedeemDate,FBeginDate,FCurrencyID,FExchangeRate,FBalance,FFinanceAmount) VALUES ( ?,?,?,?,?,?,?,?,?) ";
    private Context ctx;
    private Date dealDate = DateTimeUtils.truncateDate((Date)new Date());

    public DealFinancingDataRunnable(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void run() {
        this.dealData();
    }

    private void dealData() {
        try {
            this.dealFinancingAccountData();
            this.dealFinancingRedeemData();
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u5904\u7406>>\u5904\u7406\u6295\u8d44\u4f59\u989d\u8868\u53d6\u6570\u62a5\u9519");
            logger.error((Object)e);
        }
    }

    private void dealFinancingAccountData() throws BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select FCompanyID, FBankID, FFinanceFinancingID, FBeginDate, FCurrencyID, FExchangeRate, FBalance, FFinanceAmount ");
        sb.append(" from T_IVT_FinancingAccount where FState = 3 and FBalance > 0 and FBeginDate < ? ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        while (rs.next()) {
            DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_FinancingBalance (FCompanyID,FBankID,FFinanceFinancingID,FRedeemDate,FBeginDate,FCurrencyID,FExchangeRate,FBalance,FFinanceAmount) VALUES ( ?,?,?,?,?,?,?,?,?) ", (Object[])new Object[]{rs.getString("FCompanyID"), rs.getString("FBankID"), rs.getString("FFinanceFinancingID"), null, rs.getDate("FBeginDate"), rs.getString("FCurrencyID"), rs.getBigDecimal("FExchangeRate"), rs.getBigDecimal("FBalance"), rs.getBigDecimal("FFinanceAmount")});
        }
    }

    private void dealFinancingRedeemData() throws BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select  max(a.FCompanyID) company, max(a.FBankID) bank, max(a.FFinanceFinancingID) finance, max(b.FRedeemDate) redeemDate, ");
        sb.append(" max(a.FBeginDate) beginDate, max(a.FCurrencyID) currency, max(a.FExchangeRate) rate, sum(b.FRedeemAmount) balance, ");
        sb.append(" case when max(a.FBalance)=0 then max(a.FFinanceAmount) else 0 end amount ");
        sb.append(" FROM T_IVT_FinancingAccount a left join T_IVT_FinancingRedeem b on a.FId=b.FSOURCEBILLID ");
        sb.append(" where b.FRedeemDate >= ? and  a.FBeginDate < ? ");
        sb.append(" group by a.FId ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        while (rs.next()) {
            DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_FinancingBalance (FCompanyID,FBankID,FFinanceFinancingID,FRedeemDate,FBeginDate,FCurrencyID,FExchangeRate,FBalance,FFinanceAmount) VALUES ( ?,?,?,?,?,?,?,?,?) ", (Object[])new Object[]{rs.getString("company"), rs.getString("bank"), rs.getString("finance"), rs.getDate("redeemDate"), rs.getDate("beginDate"), rs.getString("currency"), rs.getBigDecimal("rate"), rs.getBigDecimal("balance"), rs.getBigDecimal("amount")});
        }
    }
}

