/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class DealInnerAcctDataRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.DealInnerAcctDataRunnable");
    private static final String SQL = " INSERT INTO T_LI_InnerAcctBalance ( FBizDate,FOrgID,FCompanyID,FBankID,FInnerAcctID,FCurrencyID,FBalance) VALUES ( ?,?,?,?,?,?,?) ";
    private static final String SUB_QUERY = "com.kingdee.eas.fm.fs.SubsidiaryLedgerQuery";
    private Context ctx;
    private BankInfo clearingHouse;
    private InnerAccountInfo innerAcctInfo;
    private CurrencyCollection currencyCol;
    private Date dealDate;

    public DealInnerAcctDataRunnable(Context ctx, InnerAccountInfo innerAcctInfo, CurrencyCollection currencyCol, Date dealDate) {
        this.ctx = ctx;
        this.clearingHouse = innerAcctInfo.getClearingHouse();
        this.innerAcctInfo = innerAcctInfo;
        this.currencyCol = currencyCol;
        this.dealDate = dealDate;
    }

    @Override
    public void run() {
        this.dealInnerAcctBalance();
    }

    private void dealInnerAcctBalance() {
        try {
            for (int i = 0; i < this.currencyCol.size(); ++i) {
                CurrencyInfo currency = this.currencyCol.get(i);
                BigDecimal adjustBalance = this.getAdjustBalance(currency.getId().toString());
                Date dateFrom = this.adjustDate();
                BigDecimal balance = InAcctFactory.getLocalInstance((Context)this.ctx).inAcct(this.innerAcctInfo.getCompany().getNumber(), this.innerAcctInfo.getNumber(), currency.getNumber(), dateFrom, null, InAcctDataTypeEnum.C);
                balance = balance.add(adjustBalance);
                DbUtil.execute((Context)this.ctx, (String)SQL, (Object[])new Object[]{new Timestamp(this.dealDate.getTime()), this.innerAcctInfo.getApplyUnit().getId().toString(), this.innerAcctInfo.getCompany().getId().toString(), this.clearingHouse.getId().toString(), this.innerAcctInfo.getId().toString(), currency.getId().toString(), balance});
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u51c6\u5907,\u5185\u90e8\u94f6\u884c\u8d26\u6237\uff1a>>" + this.innerAcctInfo.getName() + ">>\u5904\u7406\u4f59\u989d\u5f02\u5e38"));
            logger.error((Object)e);
        }
    }

    private BigDecimal getAdjustBalance(String currencyId) throws BOSException, SQLException {
        Date settDate = this.clearingHouse.getSettleDate();
        if (settDate == null || this.dealDate.before(settDate) || this.dealDate.equals(settDate)) {
            return Constants.ZERO;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)this.innerAcctInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)settDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)this.dealDate, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        MetaDataPK mainQueryPK = new MetaDataPK(SUB_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("\tSELECT ");
        sb.append(" SUM(DEBITAMOUNT)-SUM(CREDITAMOUNT) AS BALANCE");
        sb.append(" from (");
        sb.append(sql);
        sb.append(" ) a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        BigDecimal adjustBalance = null;
        if (rs.next()) {
            adjustBalance = rs.getBigDecimal("BALANCE");
        }
        if (adjustBalance == null) {
            adjustBalance = Constants.ZERO;
        }
        return adjustBalance;
    }

    private Date adjustDate() {
        Date openDate = this.clearingHouse.getOpenDate();
        Date settDate = this.clearingHouse.getSettleDate();
        if (settDate == null) {
            return null;
        }
        if (this.dealDate.before(openDate)) {
            return openDate;
        }
        if (this.dealDate.after(settDate)) {
            return settDate;
        }
        return DateTimeUtils.truncateDate((Date)this.dealDate);
    }
}

