/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class DealLoanDataRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.DealLoanDateRunnable");
    private final String sql = " INSERT INTO T_LI_LoanBalance (FCompanyID,FInstitutionID,FTypeID,FBizDate,FIssueDate,FCurrencyID,FLocalRate,FBalance,FAmount) VALUES ( ?,?,?,?,?,?,?,?,?) ";
    private Context ctx;
    private Date dealDate = DateTimeUtils.truncateDate((Date)new Date());

    public DealLoanDataRunnable(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void run() {
        this.dealData();
    }

    private void dealData() {
        try {
            this.dealLoanData();
            this.dealRepayData();
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u5904\u7406>>\u5904\u7406\u501f\u6b3e\u4f59\u989d\u8868\u53d6\u6570\u62a5\u9519");
            logger.error((Object)e);
        }
    }

    private void dealLoanData() throws BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select FCompanyID, isnull(FInstitutionID,FGROUPID) institution, FTypeID, FIssueDate, FCurrencyID, FLocalCurExRate, FBalance, FAmount ");
        sb.append(" from T_FIN_Loan where FBalance > 0 and FIssueDate < ? ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        while (rs.next()) {
            DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_LoanBalance (FCompanyID,FInstitutionID,FTypeID,FBizDate,FIssueDate,FCurrencyID,FLocalRate,FBalance,FAmount) VALUES ( ?,?,?,?,?,?,?,?,?) ", (Object[])new Object[]{rs.getString("FCompanyID"), rs.getString("institution"), rs.getString("FTypeID"), null, rs.getDate("FIssueDate"), rs.getString("FCurrencyID"), rs.getBigDecimal("FLocalCurExRate"), rs.getBigDecimal("FBalance"), rs.getBigDecimal("FAmount")});
        }
    }

    private void dealRepayData() throws BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select a.FCompanyID company, isnull(a.FInstitutionID,a.FGROUPID) institution, a.FTypeID type, b.FBizDate bizDate, ");
        sb.append(" a.FIssueDate issueDate, a.FCURRENCYID currency, a.FLocalCurExRate rate, b.FAmount balance, ");
        sb.append(" case when a.FBalance=0 then a.FAmount else 0 end amount ");
        sb.append(" FROM T_FIN_Loan a left join T_FIN_REPAYMENT b on a.FId=b.FLoanId ");
        sb.append(" where b.FBizDate >= ? and  a.FIssueDate < ? ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        while (rs.next()) {
            DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_LoanBalance (FCompanyID,FInstitutionID,FTypeID,FBizDate,FIssueDate,FCurrencyID,FLocalRate,FBalance,FAmount) VALUES ( ?,?,?,?,?,?,?,?,?) ", (Object[])new Object[]{rs.getString("company"), rs.getString("institution"), rs.getString("type"), rs.getDate("bizDate"), rs.getDate("issueDate"), rs.getString("currency"), rs.getBigDecimal("rate"), rs.getBigDecimal("balance"), rs.getBigDecimal("amount")});
        }
    }
}

