/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class DealNtDataRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.DealNtDataRunnable");
    private final String sql = " INSERT INTO T_LI_NtBalance (FCompanyID,FBillID,FNtTypeID,FPayBillAmt,FRecBillAmt) VALUES ( ?,?,?,?,?) ";
    private Context ctx;
    private Date dealDate = DateTimeUtils.truncateDate((Date)new Date());

    public DealNtDataRunnable(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void run() {
        this.dealData();
    }

    private void dealData() {
        try {
            this.dealPayableData();
            this.dealReceivableData();
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u5904\u7406>>\u5904\u7406\u7968\u636e\u4f59\u989d\u8868\u53d6\u6570\u62a5\u9519");
            logger.error((Object)e);
        }
    }

    private void dealPayableData() throws BOSException, SQLException {
        StringBuffer sb1 = new StringBuffer();
        sb1.append(" select FCompanyID as company, FID as billId, FNtTypeID as ntType, FAmount as amount ");
        sb1.append(" from T_NT_PayableBill ");
        sb1.append(" where FMakeType in (0,1) and FBillState in (0,5,2,3,6,7) and FIssueDate < ?  ");
        IRowSet rs1 = DbUtil.executeQuery((Context)this.ctx, (String)sb1.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertPayableBillData(rs1);
        StringBuffer sb2 = new StringBuffer();
        sb2.append(" select p.FCompanyID as company, p.FID as billId, p.FNtTypeID as ntType, p.FAmount as amount ");
        sb2.append(" from T_NT_PayableBill  p ");
        sb2.append(" inner join T_FIN_REPAYMENT r  on r.FSourceBillId = p.FId ");
        sb2.append(" where p.FMakeType in (0,1) and p.FBillState =1 and p.FIssueDate < ? and r.FbizDate >= ? ");
        IRowSet rs2 = DbUtil.executeQuery((Context)this.ctx, (String)sb2.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertPayableBillData(rs2);
        StringBuffer sb3 = new StringBuffer();
        sb3.append(" select p.FCompanyID as company, p.FID as billId, p.FNtTypeID as ntType, p.FAmount as amount ");
        sb3.append(" from T_NT_PayableBill  p ");
        sb3.append(" inner join T_NT_ReturnBill r  on r.FPayableBillID = p.FId ");
        sb3.append(" where p.FMakeType in (0,1) and p.FBillState =9 and p.FIssueDate < ? and r.FReturnDate >= ? ");
        IRowSet rs3 = DbUtil.executeQuery((Context)this.ctx, (String)sb3.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertPayableBillData(rs3);
    }

    private void insertPayableBillData(IRowSet rs) throws BOSException, SQLException {
        while (rs.next()) {
            DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_NtBalance (FCompanyID,FBillID,FNtTypeID,FPayBillAmt,FRecBillAmt) VALUES ( ?,?,?,?,?) ", (Object[])new Object[]{rs.getString("company"), rs.getString("billId"), rs.getString("ntType"), rs.getBigDecimal("amount"), BigDecimal.ZERO});
        }
    }

    private void dealReceivableData() throws BOSException, SQLException {
        StringBuffer sb1 = new StringBuffer();
        sb1.append(" select FCompanyID as company, FID as billId, FNtTypeID as ntType, FBillAmt as amount ");
        sb1.append(" from T_NT_ReceivableBill ");
        sb1.append(" where FBillState in (1,8,11,12) and FTakeDate < ?  ");
        IRowSet rs1 = DbUtil.executeQuery((Context)this.ctx, (String)sb1.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertReceivableBillData(rs1);
        StringBuffer sb2 = new StringBuffer();
        sb2.append(" select FCompanyID as company, FID as billId, FNtTypeID as ntType, FBillAmt as amount ");
        sb2.append(" from T_NT_ReceivableBill ");
        sb2.append(" where FBillState =4 and FTakeDate < ? and FTransferDate >= ? ");
        IRowSet rs2 = DbUtil.executeQuery((Context)this.ctx, (String)sb2.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertReceivableBillData(rs2);
        StringBuffer sb3 = new StringBuffer();
        sb3.append(" select r.FCompanyID as company, r.FID as billId, r.FNtTypeID as ntType, r.FBillAmt as amount ");
        sb3.append(" from T_NT_ReceivableBill r ");
        sb3.append(" inner join T_NT_EndorsementBill e on r.FEndorseBillID = e.FID  ");
        sb3.append(" where r.FBillState in (2,7) and r.FTakeDate < ? and e.FEndorseDate >= ? ");
        IRowSet rs3 = DbUtil.executeQuery((Context)this.ctx, (String)sb3.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertReceivableBillData(rs3);
        StringBuffer sb4 = new StringBuffer();
        sb4.append(" select r.FCompanyID as company, r.FID as billId, r.FNtTypeID as ntType, r.FBillAmt as amount ");
        sb4.append(" from T_NT_ReceivableBill r ");
        sb4.append(" inner join T_NT_DiscountBill d on r.FDiscountBillID = d.FID  ");
        sb4.append(" where r.FBillState =3 and r.FTakeDate < ? and d.FDiscountDate >= ? ");
        IRowSet rs4 = DbUtil.executeQuery((Context)this.ctx, (String)sb4.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertReceivableBillData(rs4);
        StringBuffer sb5 = new StringBuffer();
        sb5.append(" select r.FCompanyID as company, r.FID as billId, r.FNtTypeID as ntType, r.FBillAmt as amount ");
        sb5.append(" from T_NT_ReceivableBill r ");
        sb5.append(" inner join T_NT_ReturnBill t on t.FReceivableBillID = r.FID  ");
        sb5.append(" where r.FBillState =9 and r.FTakeDate < ? and t.FReturnDate >= ? ");
        IRowSet rs5 = DbUtil.executeQuery((Context)this.ctx, (String)sb5.toString(), (Object[])new Object[]{new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime()), new Timestamp(DateUtil.getAfterDay((Date)this.dealDate).getTime())});
        this.insertReceivableBillData(rs5);
    }

    private void insertReceivableBillData(IRowSet rs) throws BOSException, SQLException {
        while (rs.next()) {
            DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_NtBalance (FCompanyID,FBillID,FNtTypeID,FPayBillAmt,FRecBillAmt) VALUES ( ?,?,?,?,?) ", (Object[])new Object[]{rs.getString("company"), rs.getString("billId"), rs.getString("ntType"), BigDecimal.ZERO, rs.getBigDecimal("amount")});
        }
    }
}

