/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.ExternalAccountBalanceCollection;
import com.kingdee.eas.fm.liquid.ExternalAccountBalanceFactory;
import com.kingdee.eas.fm.liquid.ExternalAccountBalanceInfo;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.app.AbstractExternalAccountBalanceControllerBean;
import org.apache.log4j.Logger;

public class ExternalAccountBalanceControllerBean
extends AbstractExternalAccountBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.ExternalAccountBalanceControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExternalAccountBalanceInfo info = (ExternalAccountBalanceInfo)model;
        this.verifyIsExit(ctx, info);
        IObjectPK pk = null;
        pk = super._addnew(ctx, model);
        return pk;
    }

    private void verifyIsExit(Context ctx, ExternalAccountBalanceInfo info) throws LiquidException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)info.getDate()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        if (info.getAccountBank() != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)info.getAccountBank().getId().toString()));
        }
        if (info.getAccountView() != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)info.getAccountView().getId().toString()));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        view.setSelector(sic);
        ExternalAccountBalanceCollection coll = ExternalAccountBalanceFactory.getLocalInstance(ctx).getExternalAccountBalanceCollection(view);
        if (coll != null && coll.size() > 0) {
            ExternalAccountBalanceInfo exitInfo = coll.get(0);
            String accountName = "";
            if (exitInfo.getAccountBank() != null) {
                accountName = exitInfo.getAccountBank().getName();
            } else if (exitInfo.getAccountView() != null) {
                accountName = exitInfo.getAccountView().getName();
            }
            throw new LiquidException(LiquidException.EXTERNALEXIT, new Object[]{exitInfo.getCompany().getName(), accountName, exitInfo.getCurrency().getName(), exitInfo.getDate().toString()});
        }
    }
}

