/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.liquid.AccountParam;
import com.kingdee.eas.fm.liquid.LiquidFacadeFactory;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.AbstractLiquidJobFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.InitParam;
import com.kingdee.eas.fm.liquid.app.LiquidAppConstants;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper;
import com.kingdee.eas.fm.liquid.app.backcal.util.DateUtil;
import com.kingdee.eas.fm.liquid.app.flow.LiquidFlowDataSetHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class LiquidJobFacadeControllerBean
extends AbstractLiquidJobFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.LiquidJobFacadeControllerBean");

    @Override
    protected void _executeBalanceBatch(Context ctx) throws BOSException, EASBizException {
        this.excuteBalanceByCompany(ctx, "");
        LiquidFlowDataSetHelper.initFlowDetailTable(ctx, null);
    }

    @Override
    protected void _excuteBalanceByCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin _excuteBalanceByCompany", beginTime);
        java.util.Date monthEndDate = DateHelper.getEndDayOfCurMonth();
        java.util.Date weekEndDate = DateHelper.getNextDay((java.util.Date)new java.util.Date(), (int)7);
        java.util.Date date = monthEndDate.after(weekEndDate) ? monthEndDate : weekEndDate;
        beginTime = new java.util.Date();
        LiquidHelper.printTime("begin generateAcctBalance", beginTime);
        this.generateAcctBalance(ctx, date);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end generateAcctBalance", beginTime);
        this.generateCompanyBalance(ctx, date);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end generateCompanyBalance", beginTime);
        this.generateLimitedBalance(ctx, new java.util.Date());
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end generateLimitedBalance", beginTime);
        this.generateCompanyLimitedBalance(ctx, new java.util.Date());
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end generateCompanyLimitedBalance", beginTime);
        this.createOneLvelBankTable(ctx);
        String deleteCurrencySql = "delete from T_Liquid_BalanceCurrency";
        DbUtil.execute((Context)ctx, (String)deleteCurrencySql);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end deleteCurrencySql", beginTime);
        String currencySql = "insert into T_Liquid_BalanceCurrency select distinct(fcurrencyid) from t_cas_journal union select distinct(fcurrencyid) from t_cas_journalbalance ";
        DbUtil.execute((Context)ctx, (String)currencySql);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end insert CurrencySql", beginTime);
        StringBuffer logSql = new StringBuffer();
        Timestamp d = new Timestamp(new java.util.Date().getTime());
        logSql.append("insert into T_Liquid_Process (fupdateDate) values (?)");
        DbUtil.execute((Context)ctx, (String)logSql.toString(), (Object[])new Object[]{d});
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end T_Liquid_Process", beginTime);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end  excuteBalanceByCompany", beginTime);
    }

    private void createOneLvelBankTable(Context ctx) throws BOSException {
        try {
            HashMap<String, String> oneLevelBankMap = new HashMap<String, String>();
            StringBuffer oneLevelBankSql = new StringBuffer();
            oneLevelBankSql.append("select fid, fnumber from t_bd_bank where fparentid is null ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oneLevelBankSql.toString());
            while (rs.next()) {
                String id = rs.getString("fid");
                String number = rs.getString("fnumber");
                oneLevelBankMap.put(number, id);
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            StringBuffer bankSql = new StringBuffer();
            bankSql.append("select fid,flongnumber from t_bd_bank ");
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)bankSql.toString());
            while (rs2.next()) {
                String id = rs2.getString("fid");
                String bankLongNumber = rs2.getString("flongnumber");
                String[] longNumbers = bankLongNumber.split("!");
                String oneLevelNumber = longNumbers[0];
                String oneLevelBankId = (String)oneLevelBankMap.get(oneLevelNumber);
                paramsList.add(new Object[]{id, oneLevelBankId});
            }
            String deleteBankSql = "delete from T_Liquid_Bank";
            DbUtil.execute((Context)ctx, (String)deleteBankSql);
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into T_Liquid_Bank (FBankid,FOneLevelBankId )").append(" \n");
            insertSql.append("values (?,?) ").append(" \n");
            DbUtil.executeBatch((Context)ctx, (String)insertSql.toString(), paramsList);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void generateAcctBalance(Context ctx, java.util.Date date) throws BOSException, EASBizException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("isFromProcess", "true");
        IRowSet irs = LiquidFacadeFactory.getLocalInstance(ctx).getAccountsInfomation(paramMap);
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getAccountsInfomation", beginTime);
        ArrayList acctParamList = LiquidHelper.getAcctParamListByRs(irs, "1");
        String acctidInSql = "";
        beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getInitBalanceMap", beginTime);
        Map initBalanceMap = LiquidFacadeHelper.getInitBalanceMap(ctx, date, acctidInSql);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getInitBalanceMap", beginTime);
        Map detailMap = LiquidFacadeHelper.getDetailMap(ctx, date, acctidInSql);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getDetailMap", beginTime);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_Liquid_Balance (FCompanyID,FAccountBankID,FCurrencyID,ftype,fcashOrBank").append(" \n");
        insertSql.append(",FBizDate,FBalance,FDebitAmount,FCreditAmount ) values (?,?,?,?,?,?,?,?,?) ").append(" \n");
        ArrayList paramsList = new ArrayList();
        ArrayList<Object[]> bankParamsListForDelete = new ArrayList<Object[]>();
        ArrayList<Object[]> bankParamsListForInsert = new ArrayList<Object[]>();
        String del = "delete from T_Liquid_Balance where FCompanyID=? and FAccountBankID=? and FCurrencyID=? and FBizDate=?";
        String insert = "insert into T_Liquid_Balance (FCompanyID,FAccountBankID,FCurrencyID,ftype,fcashOrBank ,FBizDate,FBalance,FDebitAmount,FCreditAmount ) values (?,?,?,?,?,?,?,?,?) ";
        for (int i = 0; i < acctParamList.size(); ++i) {
            Map oneDetailMap;
            String key;
            AccountParam initBalanceAcctParam;
            AccountParam acctParam = (AccountParam)acctParamList.get(i);
            List oneParamsList = this.getParamList(acctParam, initBalanceAcctParam = (AccountParam)initBalanceMap.get(key = acctParam.getAcctid() + acctParam.getDateType() + acctParam.getCurrencyId()), oneDetailMap = (Map)detailMap.get(key), date);
            if (oneParamsList != null) {
                String deleteSql = "delete from   T_Liquid_Balance where faccountbankid=? and fcurrencyid=?";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{acctParam.getAcctid(), acctParam.getCurrencyId()});
                DbUtil.executeBatch((Context)ctx, (String)insertSql.toString(), (List)oneParamsList);
            }
            if (!acctParam.getIsBankInterface().equals("1")) continue;
            java.util.Date today = new java.util.Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(today);
            calendar.add(5, -1);
            java.util.Date yesterday = calendar.getTime();
            calendar.add(5, 2);
            java.util.Date tomorrow = calendar.getTime();
            StringBuffer besql = new StringBuffer();
            besql.append("select FACCOUNTBANKID,FCURRENCYID,FCOMPANYID,FBIZDATE,FVALIBALANCE  from T_BE_AccountBankBalance where (FBIZDATE=? or FBIZDATE=?) and FACCOUNTBANKID=?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)besql.toString(), (Object[])new Object[]{new Date(today.getTime()), new Date(yesterday.getTime()), acctParam.getAcctid()});
            try {
                while (rs.next()) {
                    String faccountbankid = rs.getString("FACCOUNTBANKID");
                    String fcurrencyid = rs.getString("FCURRENCYID");
                    String fcompanyid = rs.getString("FCOMPANYID");
                    Date fbizdate = rs.getDate("FBIZDATE");
                    String val = rs.getString("FVALIBALANCE");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String dateNowStr = sdf.format(fbizdate);
                    bankParamsListForDelete.add(new Object[]{fcompanyid, faccountbankid, fcurrencyid, new Timestamp(sdf.parse(dateNowStr).getTime())});
                    bankParamsListForInsert.add(new Object[]{fcompanyid, faccountbankid, fcurrencyid, 2, 1, new Timestamp(sdf.parse(dateNowStr).getTime()), val, 0, 0});
                    if (!DateUtils.isSameDay((java.util.Date)fbizdate, (java.util.Date)today)) continue;
                    bankParamsListForDelete.add(new Object[]{fcompanyid, faccountbankid, fcurrencyid, new Timestamp(tomorrow.getTime())});
                    bankParamsListForInsert.add(new Object[]{fcompanyid, faccountbankid, fcurrencyid, 2, 1, new Timestamp(tomorrow.getTime()), val, 0, 0});
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        if (bankParamsListForDelete.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)del, bankParamsListForDelete);
        }
        if (bankParamsListForInsert.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)insert, bankParamsListForInsert);
        }
    }

    private void generateLimitedBalance(Context ctx, java.util.Date date) throws BOSException, EASBizException {
        String deleteSql = "delete from  T_Liquid_LimitedBalance ";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("end deleteSql T_Liquid_LimitedBalance", beginTime);
        ArrayList dateList = DateUtil.getDateList(date);
        for (int i = 0; i < dateList.size(); ++i) {
            java.util.Date oneDate = (java.util.Date)dateList.get(i);
            StringBuffer insertSql = new StringBuffer();
            StringBuffer limitedSql = this.getLimitedSql(oneDate);
            insertSql.append("insert into T_Liquid_LimitedBalance ").append(" \n");
            insertSql.append("(FCompanyID,FAccountBankID,FCurrencyID,ftype,FBizDate,FLimitedBalance )  ").append(" \n");
            insertSql.append(" select fcompanyid,FAccountBankID,fcurrencyid,ftype, ");
            insertSql.append(" {ts'").append(LiquidAppConstants.sdf.format(oneDate.getTime())).append("'} ");
            insertSql.append(" ,famount limitedBalance ").append(" \n");
            insertSql.append("from(").append(" \n");
            insertSql.append(limitedSql).append(" \n");
            insertSql.append(") a ").append(" \n");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
    }

    private void generateCompanyLimitedBalance(Context ctx, java.util.Date date) throws BOSException, EASBizException {
        String deleteSql = "delete from  T_Liquid_CompanyLimitedBalance ";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("end deleteSql T_Liquid_CompanyLimitedBalance", beginTime);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_Liquid_CompanyLimitedBalance ").append(" \n");
        insertSql.append("(FCompanyID,FCurrencyID,ftype,FBizDate,FLimitedBalance )  ").append(" \n");
        insertSql.append(" select fcompanyid,fcurrencyid,ftype,fbizdate ");
        insertSql.append(" ,sum(flimitedbalance) limitedBalance ").append(" \n");
        insertSql.append("from t_liquid_limitedbalance ").append(" \n");
        insertSql.append("group by fcompanyid,fcurrencyid,ftype,fbizdate ").append(" \n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private StringBuffer getLimitedSql(java.util.Date date) {
        StringBuffer dateRestrictedSql = new StringBuffer();
        dateRestrictedSql.append("select FACCBANKCOMPANYID fcompanyid,FAccountBankID,FCurrencyId, '").append("1").append("' ftype").append(" ,FAmount from ").append(LiquidFacadeControllerBean.restrictedTable).append("  a ").append("\n");
        dateRestrictedSql.append(" where  FRESTRICTEDTYPE =1 ").append("\n");
        dateRestrictedSql.append(" and FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        dateRestrictedSql.append("and (not exists (select 1 from  ").append(LiquidFacadeControllerBean.restrictedTable).append(" b where A.FACCOUNTBANKID=B.FACCOUNTBANKID  and  A.FCurrencyId=B.FCurrencyId ").append("\n");
        dateRestrictedSql.append("         AND  b.FStartDate>a.FStartDate  AND b.FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        dateRestrictedSql.append("     ))").append("\n");
        dateRestrictedSql.append(" and ( fendDate>={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        dateRestrictedSql.append("      or fendDate is null ) \n");
        StringBuffer noDateRestrictedSql = new StringBuffer();
        StringBuffer balanceSql = new StringBuffer();
        balanceSql.append("select  a.FAccountBankID,a.fcurrencyid,a.ftype,a.fbalance  from ").append(LiquidFacadeControllerBean.balanceTableNew).append(" as a ").append("\n");
        balanceSql.append("where  FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}\n");
        noDateRestrictedSql.append("select restrictedAccount.FACCBANKCOMPANYID fcpmpanyid, restrictedAccount.FAccountBankID ,restrictedAccount.FCurrencyId ,isnull(d.Ftype,1) Ftype,case when d.FBALANCE>0 then d.FBALANCE else 0 end FBALANCE from ").append(LiquidFacadeControllerBean.restrictedTable).append("  restrictedAccount ").append("\n");
        noDateRestrictedSql.append("left join ").append("\n");
        noDateRestrictedSql.append(" ( ").append("\n");
        noDateRestrictedSql.append(balanceSql);
        noDateRestrictedSql.append(") d on d.FACCOUNTBANKID=restrictedAccount.FAccountBankID and d.fcurrencyid=restrictedAccount.fcurrencyid ").append("\n");
        noDateRestrictedSql.append(" where  FRESTRICTEDTYPE =0 ").append("\n");
        noDateRestrictedSql.append(" and ").append("\n");
        noDateRestrictedSql.append(" (( FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}").append("  and fendDate>={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'})\n");
        noDateRestrictedSql.append("       or ( FStartDate<={ts'").append(LiquidAppConstants.sdf.format(date.getTime())).append("'}").append("       and fendDate is null )\n");
        noDateRestrictedSql.append(" )").append("\n");
        StringBuffer restrictedSql = new StringBuffer();
        restrictedSql.append(dateRestrictedSql);
        restrictedSql.append(" union ").append("\n");
        restrictedSql.append(noDateRestrictedSql);
        return restrictedSql;
    }

    private void generateCompanyBalance(Context ctx, java.util.Date date) throws BOSException, EASBizException {
        String deleteSql = "delete from   T_Liquid_CompanyBalance";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("end delete  T_Liquid_CompanyBalance", beginTime);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_Liquid_CompanyBalance ").append(" \n");
        insertSql.append("(FCompanyID,FCurrencyID,ftype,FBizDate,FBalance,FDebitAmount,FCreditAmount )  ").append(" \n");
        insertSql.append(" select  Fcompanyid, fcurrencyid,ftype,fbizdate, sum(fbalance) fbalance,sum(fdebitamount) fdebitamount,sum(fcreditamount) fcreditamount ").append(" \n");
        insertSql.append(" from  ").append(LiquidFacadeControllerBean.balanceTableNew).append(" \n");
        insertSql.append(" group by  Fcompanyid,fcurrencyid,ftype , fbizdate ").append(" \n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end insert  T_Liquid_CompanyBalance", beginTime);
    }

    private List getParamList(AccountParam acctParam, AccountParam initBalanceAcctParam, Map oneDetailMap, java.util.Date date) {
        ArrayList<Object[]> oneParamsList = new ArrayList<Object[]>();
        String companyId = acctParam.getCompanyId();
        String acctId = acctParam.getAcctid();
        String currencyId = acctParam.getCurrencyId();
        String dataType = acctParam.getDateType();
        String cashOrBank = "1";
        InitParam initParam = this.getInitParam(initBalanceAcctParam, oneDetailMap);
        java.util.Date beginDate = initParam.getBeginDate();
        if (beginDate == null) {
            return null;
        }
        BigDecimal balance = initParam.getInitBalance();
        BigDecimal debitAmount = initParam.getInitDebitAmount();
        BigDecimal creditAmount = initParam.getInitCreditAmount();
        oneParamsList.add(new Object[]{companyId, acctId, currencyId, dataType, cashOrBank, new Date(beginDate.getTime()), balance, debitAmount, creditAmount});
        ArrayList betweenDays = LiquidFacadeHelper.getBetweenDay(beginDate, date);
        for (int i = 0; i < betweenDays.size(); ++i) {
            java.util.Date oneDay = (java.util.Date)betweenDays.get(i);
            Date sqlOneDay = new Date(oneDay.getTime());
            if (oneDetailMap != null) {
                AccountParam oneDetailAcctParam = (AccountParam)oneDetailMap.get(sqlOneDay.toString());
                if (oneDetailAcctParam != null) {
                    debitAmount = oneDetailAcctParam.getInAmount();
                    creditAmount = oneDetailAcctParam.getOutAmount();
                    balance = balance.add(debitAmount.subtract(creditAmount));
                } else {
                    debitAmount = BigDecimal.ZERO;
                    creditAmount = BigDecimal.ZERO;
                }
            } else {
                debitAmount = BigDecimal.ZERO;
                creditAmount = BigDecimal.ZERO;
            }
            oneParamsList.add(new Object[]{companyId, acctId, currencyId, dataType, cashOrBank, sqlOneDay, balance, debitAmount, creditAmount});
        }
        return oneParamsList;
    }

    private InitParam getInitParam(AccountParam initBalanceAcctParam, Map oneDetailMap) {
        Iterator it;
        InitParam initParam = new InitParam();
        java.util.Date initBalanceBeginDate = null;
        java.util.Date detailBeginDate = null;
        AccountParam earyliestDetailAcctParam = null;
        if (initBalanceAcctParam != null) {
            initBalanceBeginDate = initBalanceAcctParam.getBizDate();
        }
        if (oneDetailMap != null && (it = oneDetailMap.entrySet().iterator()).hasNext()) {
            Map.Entry entry = it.next();
            earyliestDetailAcctParam = (AccountParam)entry.getValue();
            detailBeginDate = earyliestDetailAcctParam.getBizDate();
        }
        if (initBalanceBeginDate != null) {
            if (detailBeginDate != null) {
                if (initBalanceBeginDate.compareTo(detailBeginDate) <= 0) {
                    initParam.setBeginDate(initBalanceBeginDate);
                    initParam.setFromBalanceTable(true);
                    initParam.setInitBalance(initBalanceAcctParam.getBalance());
                    initParam.setInitDebitAmount(BigDecimal.ZERO);
                    initParam.setInitCreditAmount(BigDecimal.ZERO);
                } else {
                    initParam.setBeginDate(detailBeginDate);
                    initParam.setFromBalanceTable(false);
                    if (earyliestDetailAcctParam != null) {
                        initParam.setInitBalance(earyliestDetailAcctParam.getInAmount().subtract(earyliestDetailAcctParam.getOutAmount()));
                        initParam.setInitDebitAmount(earyliestDetailAcctParam.getInAmount());
                        initParam.setInitCreditAmount(earyliestDetailAcctParam.getOutAmount());
                    }
                }
            } else {
                initParam.setBeginDate(initBalanceBeginDate);
                initParam.setFromBalanceTable(true);
                initParam.setInitBalance(initBalanceAcctParam.getBalance());
                initParam.setInitDebitAmount(BigDecimal.ZERO);
                initParam.setInitCreditAmount(BigDecimal.ZERO);
            }
        }
        if (initBalanceBeginDate == null) {
            if (detailBeginDate != null) {
                initParam.setBeginDate(detailBeginDate);
                initParam.setFromBalanceTable(false);
                if (earyliestDetailAcctParam != null) {
                    initParam.setInitBalance(earyliestDetailAcctParam.getInAmount().subtract(earyliestDetailAcctParam.getOutAmount()));
                    initParam.setInitDebitAmount(earyliestDetailAcctParam.getInAmount());
                    initParam.setInitCreditAmount(earyliestDetailAcctParam.getOutAmount());
                }
            } else {
                initParam.setBeginDate(null);
            }
        }
        return initParam;
    }

    private java.util.Date getDetailBeginDate(Map oneDetailMap) {
        java.util.Date beginDate;
        block0: {
            beginDate = null;
            Iterator it = oneDetailMap.entrySet().iterator();
            if (!it.hasNext()) break block0;
            Map.Entry entry = it.next();
            AccountParam oneDetailAcctParam = (AccountParam)entry.getValue();
            beginDate = oneDetailAcctParam.getBizDate();
        }
        return beginDate;
    }

    private void excuteBalanceByAcctId(Context ctx, String companyId, String acctId, String currencyId) throws BOSException, EASBizException {
        StringBuffer theEarliestJouranlBalanceSql = new StringBuffer();
        theEarliestJouranlBalanceSql.append("");
        try {
            logger.debug((Object)("balanceSql:" + theEarliestJouranlBalanceSql));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)theEarliestJouranlBalanceSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                AccountParam acctParam = new AccountParam();
                acctParam.setAcctid(rs.getString("FACCOUNTBANKID"));
                acctParam.setDateType(rs.getString("FTYPE"));
                acctParam.setCurrencyId(rs.getString("FCURRENCYID"));
                acctParam.setBalance(rs.getBigDecimal("FBALANCE"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

