/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.backcal.NodeData;
import com.kingdee.eas.fm.liquid.app.backcal.NodeDataTable;
import com.kingdee.eas.fm.liquid.app.backcal.OrgNode;
import com.kingdee.eas.fm.liquid.app.backcal.OrgTree;
import com.kingdee.eas.fm.liquid.app.backcal.util.DateUtil;
import com.kingdee.eas.fm.mobile.util.PermissionCompanyTreeUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MobileFacadeHelper {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.MobileFacadeHelper");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static void createBalanceTableForUser(Context ctx, java.util.Date date) throws LiquidException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        OrgTree tree = MobileFacadeHelper.bulidVirtualCompanyBalanceTree(ctx, date);
        MobileFacadeHelper.catchVirtualCompanyBalanceTree(ctx, user, tree);
        OrgTree limitTree = MobileFacadeHelper.bulidVirtualCompanyLimitTree(ctx, date);
        MobileFacadeHelper.catchVirtualCompanyLimitTree(ctx, user, limitTree);
    }

    public static OrgTree bulidVirtualCompanyBalanceTree(Context ctx, java.util.Date date) throws LiquidException {
        try {
            OrgTree tree = MobileFacadeHelper.getPermissionCompanyTree(ctx);
            ArrayList dateList = DateUtil.getDateList(date);
            String inSql = DateUtil.buildIn(dateList);
            java.util.Date beginTime = new java.util.Date();
            LiquidHelper.printTime("bulidVirtualCompanyBalanceTree 2", beginTime);
            StringBuffer dataSql = new StringBuffer();
            dataSql.append(" select fcompanyid, fcurrencyid,  ftype, fbizdate, sum(fbalance) fbalance, sum(fdebitamount) fdebitamount,sum(fcreditamount) fcreditamount from ").append(LiquidFacadeControllerBean.balanceTableNew);
            if (inSql.length() > 0) {
                dataSql.append(" where fbizdate in ").append(inSql);
            }
            dataSql.append(" group by fcompanyid, fcurrencyid,  ftype, fbizdate");
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)dataSql.toString());
            while (rs2.next()) {
                String id = rs2.getString("fcompanyid");
                String currencyid = rs2.getString("fcurrencyid");
                String type = rs2.getString("ftype");
                Date bizDate = rs2.getDate("fbizdate");
                BigDecimal balance = rs2.getBigDecimal("fbalance");
                BigDecimal debitamount = rs2.getBigDecimal("fdebitamount");
                BigDecimal creditamount = rs2.getBigDecimal("fcreditamount");
                tree.addData(id, currencyid, bizDate, balance, debitamount, creditamount, type);
            }
            beginTime = new java.util.Date();
            LiquidHelper.printTime("bulidVirtualCompanyBalanceTree 3", beginTime);
            tree.buildData();
            beginTime = new java.util.Date();
            LiquidHelper.printTime("bulidVirtualCompanyBalanceTree 4", beginTime);
            return tree;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
    }

    private static OrgTree getPermissionCompanyTree(Context ctx) throws EASBizException, BOSException {
        OrgTree tree = new OrgTree();
        CompanyOrgUnitCollection companyColl = PermissionCompanyTreeUtil.getCompanyTreeWithPermission(ctx);
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("bulidVirtualCompanyBalanceTree 1", beginTime);
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo companyInfo = companyColl.get(i);
            String id = companyInfo.getId().toString();
            String parentID = companyInfo.getLevel() == 0 ? null : companyInfo.getParent().getId().toString();
            tree.add(id, parentID);
        }
        tree.buildTree();
        return tree;
    }

    public static void catchVirtualCompanyBalanceTree(Context ctx, UserInfo user, OrgTree tree) throws LiquidException {
        try {
            java.util.Date beginTime = new java.util.Date();
            LiquidHelper.printTime("catchVirtualCompanyBalanceTree 1", beginTime);
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append(" delete from T_Liquid_CompanyUserBalance where FUserID = ? ");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{user.getId().toString()});
            StringBuffer insertBalanceSql = new StringBuffer();
            insertBalanceSql.append("insert into T_Liquid_CompanyUserBalance");
            insertBalanceSql.append(" (FUserID,FCompanyID,FCurrencyID,ftype").append(" \n");
            insertBalanceSql.append(",FBizDate,FBalance,FDebitAmount,FCreditAmount ) values (?,?,?,?,?,?,?,?) ").append(" \n");
            ArrayList paramsList = new ArrayList();
            Map<String, OrgNode> allNode = tree.getAllNode();
            for (OrgNode aNode : allNode.values()) {
                List oneParamsList;
                if (aNode.childrenSize() == 0 || (oneParamsList = MobileFacadeHelper.getParamListByNodeDataMap(user, aNode)) == null) continue;
                paramsList.addAll(oneParamsList);
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)insertBalanceSql.toString(), paramsList);
            }
            beginTime = new java.util.Date();
            LiquidHelper.printTime("catchVirtualCompanyBalanceTree 3", beginTime);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
    }

    private static List getParamListByNodeDataMap(UserInfo user, OrgNode aNode) {
        NodeDataTable aNodeDataMap = aNode.getNodeDataMap();
        ArrayList<Object[]> oneParamsList = new ArrayList<Object[]>();
        for (NodeData aNodeData : aNodeDataMap.getData().values()) {
            String companyId = aNode.getID();
            String currencyid = aNodeData.getCurrencyid();
            String type = aNodeData.getType();
            java.util.Date bizDate = aNodeData.getBizdate();
            BigDecimal balance = aNodeData.getBalance();
            BigDecimal debitAmount = aNodeData.getDebitamount();
            BigDecimal creditAmount = aNodeData.getCreditamount();
            oneParamsList.add(new Object[]{user.getId().toString(), companyId, currencyid, type, bizDate, balance, debitAmount, creditAmount});
        }
        return oneParamsList;
    }

    public static OrgTree bulidVirtualCompanyLimitTree(Context ctx, java.util.Date date) throws LiquidException {
        try {
            OrgTree tree = MobileFacadeHelper.getPermissionCompanyTree(ctx);
            java.util.Date beginTime = new java.util.Date();
            LiquidHelper.printTime("begin  executeOneYearData", beginTime);
            StringBuffer dataSql = new StringBuffer();
            dataSql.append(" select fcompanyid, fcurrencyid,  ftype, fbizdate,  flimitedbalance from ").append(LiquidFacadeControllerBean.limitBalanceTable);
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)dataSql.toString());
            while (rs2.next()) {
                String id = rs2.getString("fcompanyid");
                String currencyid = rs2.getString("fcurrencyid");
                String type = rs2.getString("ftype");
                Date bizDate = rs2.getDate("fbizdate");
                BigDecimal balance = rs2.getBigDecimal("flimitedbalance");
                tree.addData(id, currencyid, bizDate, balance, BigDecimal.ZERO, BigDecimal.ZERO, type);
            }
            tree.buildData();
            return tree;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
    }

    public static void catchVirtualCompanyLimitTree(Context ctx, UserInfo user, OrgTree tree) throws LiquidException {
        try {
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append(" delete from T_Liquid_ComLimitUserBalance where FUserID = ? ");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{user.getId().toString()});
            StringBuffer insertCompanySql = new StringBuffer();
            insertCompanySql.append("insert into T_Liquid_ComLimitUserBalance (FUserID,FCompanyID,FCurrencyID,ftype").append(" \n");
            insertCompanySql.append(",FBizDate,FLimitedBalance) values (?,?,?,?,?,?) ").append(" \n");
            ArrayList paramsList = new ArrayList();
            Map<String, OrgNode> allNode = tree.getAllNode();
            for (OrgNode aNode : allNode.values()) {
                List oneParamsList;
                if (aNode.childrenSize() == 0 || (oneParamsList = MobileFacadeHelper.getParamListByNodeDataMapForLimit(user, aNode)) == null || oneParamsList.size() <= 0) continue;
                paramsList.addAll(oneParamsList);
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)insertCompanySql.toString(), paramsList);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
    }

    private static List getParamListByNodeDataMapForLimit(UserInfo user, OrgNode aNode) {
        NodeDataTable aNodeDataMap = aNode.getNodeDataMap();
        ArrayList<Object[]> oneParamsList = new ArrayList<Object[]>();
        for (NodeData aNodeData : aNodeDataMap.getData().values()) {
            String companyId = aNode.getID();
            String currencyid = aNodeData.getCurrencyid();
            String type = aNodeData.getType();
            java.util.Date bizDate = aNodeData.getBizdate();
            BigDecimal balance = aNodeData.getBalance();
            oneParamsList.add(new Object[]{user.getId().toString(), companyId, currencyid, type, bizDate, balance});
        }
        return oneParamsList;
    }
}

