/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.backcal;

import com.kingdee.eas.fm.liquid.app.backcal.NodeData;
import com.kingdee.eas.fm.liquid.app.backcal.OrgNode;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OrgTree
extends OrgNode {
    private Map<String, OrgNode> allNode = new HashMap<String, OrgNode>();
    private Map<String, String> relateMapping = new HashMap<String, String>();
    private OrgNode root;

    public Map<String, OrgNode> getAllNode() {
        return this.allNode;
    }

    public OrgTree() {
        super(null);
    }

    public void add(String id, String parentID) {
        this.relateMapping.put(id, parentID);
        this.createNode(id);
    }

    private OrgNode find(String parentID) {
        return this.allNode.get(parentID);
    }

    public OrgNode getRoot() {
        return this.root;
    }

    private OrgNode createNode(String id) {
        OrgNode orgNode = new OrgNode(id);
        this.allNode.put(id, orgNode);
        return orgNode;
    }

    public void buildTree() {
        for (String id : this.relateMapping.keySet()) {
            String parentID = this.relateMapping.get(id);
            if (parentID == null) {
                this.root = this.find(id);
                continue;
            }
            OrgNode parentNode = this.find(parentID);
            OrgNode selfNode = this.find(id);
            parentNode.addChild(selfNode);
        }
    }

    @Override
    public String toString() {
        return "root=" + this.root + "]";
    }

    public void addData(String orgid, String currencyid, Date bizdate, BigDecimal balance, BigDecimal debitamount, BigDecimal creditamount, String type) {
        OrgNode node = this.allNode.get(orgid);
        if (node != null) {
            NodeData nodeDate = new NodeData(orgid, currencyid, bizdate, balance != null ? balance : BigDecimal.ZERO, debitamount, creditamount, type);
            node.addData(nodeDate);
        }
    }

    @Override
    public void buildData() {
        this.root.buildData();
    }
}

