/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.app.dataset.AbstractLiquidDataSet;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.FlowPeriodTypeHandler;
import com.kingdee.eas.fm.liquid.app.flow.LiquidFlowDataSetHelper;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFlowDataSetTemplet
extends AbstractLiquidDataSet {
    protected FlowPeriodTypeHandler periodTypeHandler = new FlowPeriodTypeHandler();

    private void getFlowItemFilter(Context ctx, Map<String, Object> filterParamMap, StringBuilder filterBuilder) throws BOSException, EASBizException {
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        if (!EmptyUtil.isEmpty((String)flowItemParentId)) {
            FundFlowItemInfo flowItemInfo = LiquidCompanyHelper.getFlowItemInfo(ctx, flowItemParentId);
            if (!flowItemInfo.isIsLeaf()) {
                filterBuilder.append(" AND FLOWITEM.FLongNumber LIKE '").append(flowItemInfo.getLongNumber()).append("!%'");
            } else {
                filterBuilder.append(" AND FLOWITEM.FId = '").append(flowItemParentId).append("'");
            }
        }
    }

    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        StringBuilder filterBuilder = new StringBuilder();
        Set currencyIdSet = (Set)filterParamMap.get("currencyIdSet");
        if (!EmptyUtil.isEmpty((Collection)currencyIdSet)) {
            if (currencyIdSet.size() == 1) {
                filterBuilder.append(" AND JOURNAL.FCurrencyId = '").append((String)currencyIdSet.iterator().next()).append("'");
            } else {
                filterBuilder.append(" AND JOURNAL.FCurrencyId IN ").append(FMHelper.setTran2String((Set)currencyIdSet));
            }
        }
        this.getFlowItemFilter(ctx, filterParamMap, filterBuilder);
        return filterBuilder.toString();
    }

    protected final void getDateFilterSql(StringBuilder filterBuilder, String beginDateString, String endDateString) {
        filterBuilder.append(" AND JOURNAL.FCreateDate >= ").append(LiquidDataSetHelper.dateFormat(beginDateString));
        filterBuilder.append(" AND JOURNAL.FCreateDate <= ").append(LiquidDataSetHelper.dateFormat(endDateString));
    }

    protected String getFlowDetailTable(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String filterSql = this.getFilterSql(ctx, filterParamMap);
        String companyTable = this.getCompanyTable(ctx, filterParamMap);
        return LiquidFlowDataSetHelper.getFlowDetailTable(ctx, filterParamMap, filterSql, companyTable);
    }

    protected abstract String getFlowPeriodData(Context var1, Map<String, Object> var2, String var3) throws BOSException, EASBizException;

    protected abstract String getFlowSumData(Context var1, Map<String, Object> var2, String var3) throws BOSException, EASBizException;

    protected abstract String getFlowSumDataByPeriodType(Context var1, Map<String, Object> var2, String var3) throws BOSException, EASBizException;

    protected abstract String getQueryFlowSql(Context var1, Map<String, Object> var2, String var3, String var4) throws BOSException, EASBizException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRowSet getQueryDataSet(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String flowDetailTable = this.getFlowDetailTable(ctx, filterParamMap);
        String flowPeriodTable = this.getFlowPeriodData(ctx, filterParamMap, flowDetailTable);
        flowPeriodTable = this.getFlowSumData(ctx, filterParamMap, flowPeriodTable);
        String flowSumDataTable = this.getFlowSumDataByPeriodType(ctx, filterParamMap, flowPeriodTable);
        String exchangeRateTable = LiquidDataSetHelper.getExchangeRateTable(ctx, filterParamMap, flowSumDataTable);
        String sql = this.getQueryFlowSql(ctx, filterParamMap, flowSumDataTable, exchangeRateTable);
        try {
            IRowSet iRowSet = LiquidDataSetHelper.executeQuery(ctx, sql);
            return iRowSet;
        }
        finally {
            if (LiquidFlowDataSetHelper.getParamLiquid001Value(ctx) != 1000) {
                LiquidDataSetHelper.releaseTemporaryTableName(ctx, flowDetailTable);
                LiquidDataSetHelper.releaseTemporaryTableName(ctx, flowPeriodTable);
                LiquidDataSetHelper.releaseTemporaryTableName(ctx, flowSumDataTable);
                LiquidDataSetHelper.releaseTemporaryTableName(ctx, exchangeRateTable);
                LiquidDataSetHelper.releaseTemporaryTableName(ctx, this.getCompanyTable(ctx, filterParamMap));
            }
        }
    }
}

