/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FlowPeriodTypeHandler {
    private static final String FIELD_VARCHAR_44 = "VARCHAR(44)";
    public static final int PERIOD_THIS_PERIOD = 1;
    public static final int PERIOD_THIS_YEAR = 2;
    public static final int PERIOD_LAST_YEARE_PERIOD = 3;
    public static final int PERIOD_LAST_YEARE = 4;
    public static final int PERIOD_LAST_PERIOD = 5;
    private Map<String, String> customMapFields;
    private boolean isPerioded;
    private boolean isNetWorth;
    private static final String SQL_TABLE_FLOW_PERIOD = "CREATE TABLE {0} (FItemId VARCHAR(44),FCompanyId VARCHAR(44),FCurrencyId VARCHAR(44),FPeriodType NUMERIC(2),{1}FIncomeAmount NUMERIC(19,4),FOutcomeAmount NUMERIC(19,4))";
    private static final String SQL_INSERT_FLOW_PERIOD = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FPeriodType{1},FIncomeAmount,FOutcomeAmount)\n";
    private static final String SQL_DATA_FLOW_PERIOD = "SELECT FItemId,FCompanyId,FCurrencyId,{3} FPeriodType{4},SUM(FIncomeAmount) FIncomeAmount, SUM(FOutcomeAmount) FOutcomeAmount \nFROM {0} \nWHERE FCreateDate >= {1} AND FCreateDate <= {2} \nGROUP BY FItemId,FCompanyId,FCurrencyId{4}";
    private static final String SQL_DATA_FLOW_PERIODS = "SELECT FItemId,FCompanyId,FCurrencyId,{3} FPeriodType,''{4}'' FPeriodId{5},SUM(FIncomeAmount) FIncomeAmount, SUM(FOutcomeAmount) FOutcomeAmount \nFROM {0} \nWHERE FCreateDate >= {1} AND FCreateDate <= {2} \nGROUP BY FItemId,FCompanyId,FCurrencyId{5}";
    private static final String SQL_FLOW_ITEM_LONG_NUMBER = "SELECT DETAIL.*,FLOWITEM.FLongNumber FItemLongNumber FROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID";
    private static final String SQL_FLOW_ITEM_PARENT_SUM = "SELECT FLOWITEM.FID FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{4},\nSUM(DETAIL.FIncomeAmount) FIncomeAmount,SUM(DETAIL.FOutcomeAmount) FOutcomeAmount \nFROM {1} FLOWITEM \nINNER JOIN (\nSELECT DETAIL.*,FLOWITEM.FLongNumber FItemLongNumber FROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID\n) DETAIL ON CHARINDEX(FLOWITEM.FLongNumber,DETAIL.FItemLongNumber) >= 1 \nWHERE FLOWITEM.FLevel <= {2} AND FLOWITEM.FLevel >= {3} AND FLOWITEM.FIsLeaf = 0 \nGROUP BY FLOWITEM.FID,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{4}";
    private static final String SQL_FLOW_ITEM_PARENT = "SELECT FLOWITEM.FID FItemId,NULL FCompanyId,NULL FCurrencyId,1 FPeriodType{4},\n0.00 FIncomeAmount,0.00 FOutcomeAmount \nFROM {1} FLOWITEM \nINNER JOIN (\nSELECT DETAIL.*,FLOWITEM.FLongNumber FItemLongNumber FROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID\n) DETAIL ON CHARINDEX(FLOWITEM.FLongNumber,DETAIL.FItemLongNumber) >= 1 \nWHERE FLOWITEM.FLevel <= {2} AND FLOWITEM.FLevel >= {3} AND FLOWITEM.FIsLeaf = 0 \nGROUP BY FLOWITEM.FID{4}";
    private static final String SQL_FLOW_COMPANY_LONG_NUMBER = "SELECT DETAIL.*,COMPANY.FLongNumber FCompanyLongNumber FROM {0} DETAIL \nINNER JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID";
    private static final String SQL_FLOW_COMPANY_PARENT_SUM = "SELECT DETAIL.FItemId,COMPANY.FID FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{3},\nSUM(DETAIL.FIncomeAmount) FIncomeAmount,SUM(DETAIL.FOutcomeAmount) FOutcomeAmount \nFROM {1} COMPANY \nINNER JOIN (\nSELECT DETAIL.*,COMPANY.FLongNumber FCompanyLongNumber FROM {0} DETAIL \nINNER JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID\n) DETAIL ON CHARINDEX(COMPANY.FLongNumber,DETAIL.FCompanyLongNumber) >= 1 \nWHERE COMPANY.FIsLeaf = 0 AND CHARINDEX(''{2}'',COMPANY.FLongNumber) >= 1 \nGROUP BY DETAIL.FItemId,COMPANY.FID,DETAIL.FCurrencyId,DETAIL.FPeriodType{3}";
    private static final String SQL_FLOW_COMPANY_PARENT_NETWORTH = "SELECT DETAIL.FItemId,COMPANY.FID FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{3},\nSUM(DETAIL.FIncomeAmount-DETAIL.FOutcomeAmount) FIncomeAmount,0.00 FOutcomeAmount \nFROM {1} COMPANY \nINNER JOIN (\nSELECT DETAIL.*,COMPANY.FLongNumber FCompanyLongNumber FROM {0} DETAIL \nINNER JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID\n) DETAIL ON CHARINDEX(COMPANY.FLongNumber,DETAIL.FCompanyLongNumber) >= 1 \nWHERE COMPANY.FIsLeaf = 0 AND CHARINDEX(''{2}'',COMPANY.FLongNumber) >= 1 \nGROUP BY DETAIL.FItemId,COMPANY.FID,DETAIL.FCurrencyId,DETAIL.FPeriodType{3}";
    private static final String SQL_INSERT_FLOW_ITEM_NET_WORTH = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FPeriodType,FISNETWORTH{1},FIncomeAmount,FOutcomeAmount)\n";
    private static final String SQL_FLOW_ITEM_LONGNUMBER = "SELECT DETAIL.*,FLOWITEM.FLongNumber FItemLongNumber \nFROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID AND FLOWITEM.FIsLeaf = 1 \n";
    private static final String SQL_FLOW_ITEM_NET_WORTH = "SELECT FLOWITEM.FID FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType,1 FISNETWORTH{2},\nSUM(FIncomeAmount) FIncomeAmount,SUM(FOutcomeAmount) FOutcomeAmount \nFROM {1} FLOWITEM \nINNER JOIN (\nSELECT DETAIL.*,FLOWITEM.FLongNumber FItemLongNumber \nFROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID AND FLOWITEM.FIsLeaf = 1 \n\n ) DETAIL ON CHARINDEX(FLOWITEM.FLongNumber,DETAIL.FItemLongNumber) >= 1 \nWHERE FLOWITEM.FLevel = 1 AND FLOWITEM.FIsLeaf = 0 AND FLOWITEM.FDirection = 0 \nGROUP BY FLOWITEM.FID,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{2}";
    private static final String SQL_FLOW_ITEM_IO_NETWORTH_DATA = "SELECT ''{3}'' FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{2},\nSUM(FIncomeAmount) FIncomeAmount,SUM(FOutcomeAmount) FOutcomeAmount \nFROM (\nSELECT DETAIL.*,FLOWITEM.FLongNumber FItemLongNumber \nFROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID AND FLOWITEM.FIsLeaf = 1 \n) DETAIL \nWHERE EXISTS(SELECT FLOWITEM.FID FROM {1} FLOWITEM WHERE CHARINDEX(FLOWITEM.FLongNumber,DETAIL.FItemLongNumber) >= 1 AND FLOWITEM.FLevel = 1 AND FLOWITEM.FDirection = 0) \nGROUP BY DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{2}";
    private static final String SQL_FLOW_ITEM_NETWORTH_DATA = "SELECT ''{3}'' FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{2},\nSUM(FIncomeAmount) FIncomeAmount,SUM(FOutcomeAmount) FOutcomeAmount \nFROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID AND FLOWITEM.FIsLeaf = 1 \nGROUP BY DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FPeriodType{2}";
    private static final String SQL_STOCK_BALANCE_MAXMIN_DATE = "SELECT MAX(FBizDate),MIN(FBizDate) FROM {0}";
    private static final String SQL_DATA_STOCK_BALANCE = "SELECT ''{2}'' FItemId,BALANCE.FCompanyId,BALANCE.FCurrencyId,{4} FPeriodType{5},\nSUM(FBALANCE) FIncomeAmount, 0.00 FOutcomeAmount \nFROM {0} BALANCE \nINNER JOIN {1} COMPANY ON BALANCE.FCompanyId = COMPANY.FID \nWHERE BALANCE.FType = 1 AND BALANCE.FCashOrBank = 1 AND FBizDate = {3} {6}\nGROUP BY BALANCE.FCompanyId,BALANCE.FCurrencyId";

    public void setCustomMapFields(Map<String, String> customMapFields) {
        this.customMapFields = customMapFields;
    }

    public void setPerioded(boolean isPerioded) {
        this.isPerioded = isPerioded;
    }

    public void setNetWorth(boolean isNetWorth) {
        this.isNetWorth = isNetWorth;
    }

    private Map<String, String> getExtendMapFields() {
        HashMap<String, String> extendMapFields = new HashMap<String, String>();
        if (this.isPerioded || this.isNetWorth) {
            if (this.isPerioded) {
                extendMapFields.put("FPeriodId", FIELD_VARCHAR_44);
            }
            if (this.isNetWorth) {
                extendMapFields.put("FIsNetWorth", "NUMERIC(2) DEFAULT 0");
            }
        }
        return extendMapFields;
    }

    private String getCustomFields(Map<String, String> customMapFields) {
        StringBuilder fieldBuilder = new StringBuilder();
        if (customMapFields != null) {
            Iterator<String> iterator = customMapFields.keySet().iterator();
            while (iterator.hasNext()) {
                fieldBuilder.append(",").append(iterator.next());
            }
        }
        return fieldBuilder.toString();
    }

    public String createFlowPeriodTable(Context ctx) throws BOSException {
        String flowPeriodTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "FLOW_PERIOD_DATA");
        StringBuilder fieldBuilder = new StringBuilder();
        Map<String, String> extendMapFields = this.getExtendMapFields();
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        for (String fieldName : extendMapFields.keySet()) {
            fieldBuilder.append(fieldName.toUpperCase()).append("  ").append(extendMapFields.get(fieldName)).append(",");
        }
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOW_PERIOD, flowPeriodTable, fieldBuilder.toString()));
        return flowPeriodTable;
    }

    private void insertPeriodData(Context ctx, String flowDetailTable, String flowPeriodTable, String beginDateString, String endDateString, int periodType) throws BOSException {
        String customFields = this.getCustomFields(this.customMapFields);
        String insertSql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields);
        String sql = MessageFormat.format(SQL_DATA_FLOW_PERIOD, flowDetailTable, LiquidDataSetHelper.dateFormat(beginDateString), LiquidDataSetHelper.dateFormat(endDateString), String.valueOf(periodType), customFields);
        LiquidDataSetHelper.execute(ctx, insertSql + sql);
    }

    public void insertThisPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable, String flowPeriodTable) throws BOSException, EASBizException {
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        this.insertPeriodData(ctx, flowDetailTable, flowPeriodTable, beginDateString, endDateString, 1);
    }

    public Date getLastYearDate(Date date) {
        Calendar calBeginDate = Calendar.getInstance();
        calBeginDate.setTime(date);
        calBeginDate.add(1, -1);
        return calBeginDate.getTime();
    }

    private BgPeriodInfo createPeriodInfo(Date beginDate, Date endDate) {
        BgPeriodInfo periodInfo = new BgPeriodInfo();
        periodInfo.setId(BOSUuid.create((BOSObjectType)periodInfo.getBOSType()));
        periodInfo.setBeginDate(beginDate);
        periodInfo.setEndDate(endDate);
        return periodInfo;
    }

    public BgPeriodInfo getLastPeriodInfo(Context ctx, Date beginDate, Date endDate, String queryCycleString) throws EASBizException, BOSException {
        int queryCycle;
        Date lastPeriodBeginDate;
        BgPeriodInfo periodInfo = null;
        if (!EmptyUtil.isEmpty((String)queryCycleString) && queryCycleString.equals("-1") && (lastPeriodBeginDate = LiquidHelper.getLastBgPeriodDate(ctx, beginDate, queryCycle = Integer.parseInt(queryCycleString))) != null) {
            periodInfo = LiquidHelper.getBgPeriodInfoByDateAndCycle(ctx, lastPeriodBeginDate, queryCycle);
        }
        if (periodInfo == null) {
            periodInfo = this.createPeriodInfo(this.getLastYearDate(beginDate), this.getLastYearDate(endDate));
        }
        return periodInfo;
    }

    public void insertLastPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable, String flowPeriodTable) throws BOSException, EASBizException {
        Date beginDate = DateUtil.stringToDate((String)((String)filterParamMap.get("beginDate")));
        Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
        String queryCycleString = (String)filterParamMap.get("queryCycle");
        BgPeriodInfo periodInfo = this.getLastPeriodInfo(ctx, beginDate, endDate, queryCycleString);
        String beginDateString = DateUtil.DateToString((Date)periodInfo.getBeginDate());
        String endDateString = DateUtil.DateToString((Date)periodInfo.getEndDate());
        this.insertPeriodData(ctx, flowDetailTable, flowPeriodTable, beginDateString, endDateString, 5);
    }

    public void insertThisYearData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable, String flowPeriodTable) throws BOSException, EASBizException {
        String endDateString = (String)filterParamMap.get("endDate");
        String beginDateString = DateUtil.DateToString((Date)DateUtil.getFirstYearDate((Date)DateUtil.stringToDate((String)endDateString)));
        this.insertPeriodData(ctx, flowDetailTable, flowPeriodTable, beginDateString, endDateString, 2);
    }

    public BgPeriodInfo getLastPeriodInfoForYear(Context ctx, Date beginDate, Date endDate, String queryCycleString) throws EASBizException, BOSException {
        int queryCycle;
        Date lastPeriodBeginDate;
        BgPeriodInfo periodInfo = null;
        if (!EmptyUtil.isEmpty((String)queryCycleString) && queryCycleString.equals("-1") && (lastPeriodBeginDate = LiquidHelper.getLastBgPeriodDateForYear(ctx, beginDate, queryCycle = Integer.parseInt(queryCycleString))) != null) {
            periodInfo = LiquidHelper.getBgPeriodInfoByDateAndCycle(ctx, lastPeriodBeginDate, queryCycle);
        }
        if (periodInfo == null) {
            periodInfo = this.createPeriodInfo(this.getLastYearDate(beginDate), this.getLastYearDate(endDate));
        }
        return periodInfo;
    }

    public void insertLastYearPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable, String flowPeriodTable) throws BOSException, EASBizException {
        Date beginDate = DateUtil.stringToDate((String)((String)filterParamMap.get("beginDate")));
        Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
        String queryCycleString = (String)filterParamMap.get("queryCycle");
        BgPeriodInfo periodInfo = this.getLastPeriodInfoForYear(ctx, beginDate, endDate, queryCycleString);
        String beginDateString = DateUtil.DateToString((Date)periodInfo.getBeginDate());
        String endDateString = DateUtil.DateToString((Date)periodInfo.getEndDate());
        this.insertPeriodData(ctx, flowDetailTable, flowPeriodTable, beginDateString, endDateString, 3);
    }

    public void insertLastYearData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable, String flowPeriodTable) throws BOSException, EASBizException {
        Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getLastYearDate(endDate));
        int lastYear = calendar.get(1);
        String beginDateString = DateUtil.DateToString((Date)DateUtil.getFirstYearDate((int)lastYear));
        String endDateString = DateUtil.DateToString((Date)DateUtil.getLastYearDate((int)lastYear));
        this.insertPeriodData(ctx, flowDetailTable, flowPeriodTable, beginDateString, endDateString, 4);
    }

    public BgPeriodCollection getPeriods(Context ctx, Map<String, Object> filterParamMap) throws EASBizException {
        Date beginDate = DateUtil.stringToDate((String)((String)filterParamMap.get("beginDate")));
        Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
        String queryCycleString = (String)filterParamMap.get("queryCycle");
        BgPeriodCollection periods = null;
        if (!EmptyUtil.isEmpty((String)queryCycleString) && !queryCycleString.equals("-1")) {
            int queryCycle = Integer.parseInt(queryCycleString);
            periods = LiquidHelper.getBeginAndEndDates(ctx, beginDate, endDate, queryCycle);
        } else {
            BgPeriodInfo periodInfo = this.createPeriodInfo(beginDate, endDate);
            periods = new BgPeriodCollection();
            periods.add(periodInfo);
        }
        return periods;
    }

    public void insertDataByPeriods(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable, String flowPeriodTable) throws BOSException, EASBizException {
        BgPeriodCollection periods = this.getPeriods(ctx, filterParamMap);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)periods)) {
            return;
        }
        String customFields = this.getCustomFields(this.customMapFields);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, ",FPeriodId" + customFields));
        int size = periods.size();
        for (int i = 0; i < size; ++i) {
            BgPeriodInfo periodInfo = periods.get(i);
            String sql = MessageFormat.format(SQL_DATA_FLOW_PERIODS, flowDetailTable, LiquidDataSetHelper.dateFormat(periodInfo.getBeginDate()), LiquidDataSetHelper.dateFormat(periodInfo.getEndDate()), String.valueOf(1), periodInfo.getId().toString(), customFields);
            if (i > 0) {
                sqlBuilder.append("\n UNION ALL \n");
            }
            sqlBuilder.append(sql);
        }
        LiquidDataSetHelper.execute(ctx, sqlBuilder.toString());
    }

    public void summarizeDataByFlowItem(Context ctx, String flowPeriodTable, Map<String, Object> filterParamMap, int maxFlowItemLevel) throws BOSException, EASBizException {
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        int minFlowItemLevel = 1;
        if (!EmptyUtil.isEmpty((String)flowItemParentId)) {
            FundFlowItemInfo flowItemInfo = LiquidCompanyHelper.getFlowItemInfo(ctx, flowItemParentId);
            if (flowItemInfo.isIsLeaf()) {
                return;
            }
            minFlowItemLevel = flowItemInfo.getLevel();
        }
        Map<String, String> extendMapFields = this.getExtendMapFields();
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_ITEM_PARENT_SUM, flowPeriodTable, "T_CAS_FUNDFLOWITEM", new Integer(maxFlowItemLevel), String.valueOf(minFlowItemLevel), customFields);
        sql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
    }

    public void insertParentFlowItem(Context ctx, String flowPeriodTable, Map<String, Object> filterParamMap, int maxFlowItemLevel) throws BOSException, EASBizException {
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        int minFlowItemLevel = 1;
        if (!EmptyUtil.isEmpty((String)flowItemParentId)) {
            FundFlowItemInfo flowItemInfo = LiquidCompanyHelper.getFlowItemInfo(ctx, flowItemParentId);
            if (flowItemInfo.isIsLeaf()) {
                return;
            }
            minFlowItemLevel = flowItemInfo.getLevel();
        }
        Map<String, String> extendMapFields = this.getExtendMapFields();
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_ITEM_PARENT, flowPeriodTable, "T_CAS_FUNDFLOWITEM", new Integer(maxFlowItemLevel), String.valueOf(minFlowItemLevel), customFields);
        sql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
    }

    public void summarizeDataByCompany(Context ctx, String flowPeriodTable, String companyTable, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String companyId = (String)filterParamMap.get("parentCompanyId");
        CoreBaseInfo orgInfo = LiquidCompanyHelper.getOrgInfo(ctx, companyId);
        if (LiquidCompanyHelper.isOrgLeaf(ctx, orgInfo)) {
            return;
        }
        Map<String, String> extendMapFields = this.getExtendMapFields();
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_COMPANY_PARENT_SUM, flowPeriodTable, companyTable, LiquidCompanyHelper.getOrgLongNumber(ctx, orgInfo), customFields);
        sql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
    }

    public void summarizeNetWorthByCompany(Context ctx, String flowPeriodTable, String companyTable, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String companyId = (String)filterParamMap.get("parentCompanyId");
        CoreBaseInfo orgInfo = LiquidCompanyHelper.getOrgInfo(ctx, companyId);
        if (LiquidCompanyHelper.isOrgLeaf(ctx, orgInfo)) {
            return;
        }
        Map<String, String> extendMapFields = this.getExtendMapFields();
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_COMPANY_PARENT_NETWORTH, flowPeriodTable, companyTable, LiquidCompanyHelper.getOrgLongNumber(ctx, orgInfo), customFields);
        sql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
    }

    public String insertNetWorthData(Context ctx, String flowPeriodTable) throws BOSException, EASBizException {
        HashMap<String, String> extendMapFields = new HashMap<String, String>();
        if (this.isPerioded) {
            extendMapFields.put("FPeriodId", FIELD_VARCHAR_44);
        }
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_ITEM_NET_WORTH, flowPeriodTable, "T_CAS_FUNDFLOWITEM", customFields);
        sql = MessageFormat.format(SQL_INSERT_FLOW_ITEM_NET_WORTH, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
        return flowPeriodTable;
    }

    public String insertFlowIONetWorth(Context ctx, String flowPeriodTable, String flowItemId) throws BOSException, EASBizException {
        HashMap<String, String> extendMapFields = new HashMap<String, String>();
        if (this.isPerioded) {
            extendMapFields.put("FPeriodId", FIELD_VARCHAR_44);
        }
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_ITEM_IO_NETWORTH_DATA, flowPeriodTable, "T_CAS_FUNDFLOWITEM", customFields, flowItemId);
        sql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
        return flowPeriodTable;
    }

    public String insertFlowNetWorth(Context ctx, String flowPeriodTable, String flowItemId) throws BOSException, EASBizException {
        HashMap<String, String> extendMapFields = new HashMap<String, String>();
        if (this.isPerioded) {
            extendMapFields.put("FPeriodId", FIELD_VARCHAR_44);
        }
        if (this.customMapFields != null) {
            extendMapFields.putAll(this.customMapFields);
        }
        String customFields = this.getCustomFields(extendMapFields);
        String sql = MessageFormat.format(SQL_FLOW_ITEM_NETWORTH_DATA, flowPeriodTable, "T_CAS_FUNDFLOWITEM", customFields, flowItemId);
        sql = MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, customFields) + sql;
        LiquidDataSetHelper.execute(ctx, sql);
        return flowPeriodTable;
    }

    public Date[] getMaxAndMinBalanceDate(Context ctx) throws BOSException {
        Date maxBizDate = null;
        Date minBizDate = null;
        String sql = MessageFormat.format(SQL_STOCK_BALANCE_MAXMIN_DATE, "T_LIQUID_BALANCE");
        IRowSet rowSet = LiquidDataSetHelper.executeQuery(ctx, sql);
        try {
            if (rowSet.first()) {
                maxBizDate = rowSet.getDate(1);
                minBizDate = rowSet.getDate(2);
            }
            if (minBizDate == null) {
                minBizDate = DateUtil.stringToDate((String)"1800-01-01");
            }
            if (maxBizDate == null) {
                maxBizDate = DateUtil.stringToDate((String)"4000-12-31");
            }
            return new Date[]{minBizDate, maxBizDate};
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Date getBalanceBizDate(Date bizDate, Date maxBizDate, Date minBizDate) {
        if (bizDate.before(minBizDate)) {
            bizDate = minBizDate;
        } else if (bizDate.after(maxBizDate)) {
            bizDate = maxBizDate;
        }
        return bizDate;
    }

    public void insertStockBeginingBalance(Context ctx, String flowPeriodTable, Map<String, Object> filterParamMap, String companyTable, BgPeriodInfo periodInfo, Date[] minAndMaxDates) throws BOSException, EASBizException {
        String isDiffYearString;
        boolean isPeriod = periodInfo.getId() != null;
        String sql = isPeriod ? MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, ",FPeriodId") : MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, "");
        StringBuilder sqlBuilder = new StringBuilder(sql);
        Date beginDate = periodInfo.getBeginDate();
        Date endDate = periodInfo.getEndDate();
        String queryCycleString = (String)filterParamMap.get("queryCycle");
        Date minBizDate = minAndMaxDates[0];
        Date maxBizDate = minAndMaxDates[1];
        String periodField = isPeriod ? ",'" + periodInfo.getId().toString() + "' FPeriodId" : "";
        StringBuilder filterBuilder = new StringBuilder();
        Set currencyIdSet = (Set)filterParamMap.get("currencyIdSet");
        if (!EmptyUtil.isEmpty((Collection)currencyIdSet)) {
            filterBuilder.append(" AND BALANCE.FCurrencyId IN ").append(FMHelper.setTran2String((Set)currencyIdSet));
        }
        Date bizDate = DateUtil.getBeforeDay((Date)beginDate);
        bizDate = this.getBalanceBizDate(bizDate, maxBizDate, minBizDate);
        sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM004", LiquidDataSetHelper.dateFormat(bizDate), new Integer(1), periodField, filterBuilder.toString());
        sqlBuilder.append(sql);
        if (!isPeriod && !"true".equalsIgnoreCase(isDiffYearString = (String)filterParamMap.get("isDiffYear"))) {
            bizDate = DateUtil.getBeforeDay((Date)DateUtil.getFirstYearDate((Date)endDate));
            bizDate = this.getBalanceBizDate(bizDate, maxBizDate, minBizDate);
            sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM004", LiquidDataSetHelper.dateFormat(bizDate), new Integer(2), periodField, filterBuilder.toString());
            sqlBuilder.append("\n UNION ALL \n").append(sql);
            bizDate = DateUtil.getBeforeDay((Date)this.getLastPeriodInfoForYear(ctx, beginDate, endDate, queryCycleString).getBeginDate());
            bizDate = this.getBalanceBizDate(bizDate, maxBizDate, minBizDate);
            sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM004", LiquidDataSetHelper.dateFormat(bizDate), new Integer(3), periodField, filterBuilder.toString());
            sqlBuilder.append("\n UNION ALL \n").append(sql);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.add(1, -2);
            bizDate = DateUtil.getLastYearDate((int)calendar.get(1));
            bizDate = this.getBalanceBizDate(bizDate, maxBizDate, minBizDate);
            sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM004", LiquidDataSetHelper.dateFormat(bizDate), new Integer(4), periodField, filterBuilder.toString());
            sqlBuilder.append("\n UNION ALL \n").append(sql);
        }
        LiquidDataSetHelper.execute(ctx, sqlBuilder.toString());
    }

    public void insertStockEndingBalance(Context ctx, String flowPeriodTable, Map<String, Object> filterParamMap, String companyTable, BgPeriodInfo periodInfo, Date[] minAndMaxDates) throws BOSException, EASBizException {
        String isDiffYearString;
        boolean isPeriod = periodInfo.getId() != null;
        String sql = isPeriod ? MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, ",FPeriodId") : MessageFormat.format(SQL_INSERT_FLOW_PERIOD, flowPeriodTable, "");
        StringBuilder sqlBuilder = new StringBuilder(sql);
        Date beginDate = periodInfo.getBeginDate();
        Date endDate = periodInfo.getEndDate();
        String queryCycleString = (String)filterParamMap.get("queryCycle");
        Date minBizDate = minAndMaxDates[0];
        Date maxBizDate = minAndMaxDates[1];
        String periodField = isPeriod ? ",'" + periodInfo.getId().toString() + "' FPeriodId" : "";
        StringBuilder filterBuilder = new StringBuilder();
        Set currencyIdSet = (Set)filterParamMap.get("currencyIdSet");
        if (!EmptyUtil.isEmpty((Collection)currencyIdSet)) {
            filterBuilder.append(" AND BALANCE.FCurrencyId IN ").append(FMHelper.setTran2String((Set)currencyIdSet));
        }
        Date bizDate = this.getBalanceBizDate(endDate, maxBizDate, minBizDate);
        sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM005", LiquidDataSetHelper.dateFormat(bizDate), new Integer(1), periodField, filterBuilder.toString());
        sqlBuilder.append(sql);
        if (!isPeriod && !"true".equalsIgnoreCase(isDiffYearString = (String)filterParamMap.get("isDiffYear"))) {
            bizDate = this.getBalanceBizDate(endDate, maxBizDate, minBizDate);
            sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM005", LiquidDataSetHelper.dateFormat(bizDate), new Integer(2), periodField, filterBuilder.toString());
            sqlBuilder.append("\n UNION ALL \n").append(sql);
            bizDate = this.getLastPeriodInfoForYear(ctx, beginDate, endDate, queryCycleString).getEndDate();
            bizDate = this.getBalanceBizDate(bizDate, maxBizDate, minBizDate);
            sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM005", LiquidDataSetHelper.dateFormat(bizDate), new Integer(3), periodField, filterBuilder.toString());
            sqlBuilder.append("\n UNION ALL \n").append(sql);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.add(1, -1);
            bizDate = DateUtil.getLastYearDate((int)calendar.get(1));
            bizDate = this.getBalanceBizDate(bizDate, maxBizDate, minBizDate);
            sql = MessageFormat.format(SQL_DATA_STOCK_BALANCE, "T_LIQUID_BALANCE", companyTable, "FLOWITEM005", LiquidDataSetHelper.dateFormat(bizDate), new Integer(4), periodField, filterBuilder.toString());
            sqlBuilder.append("\n UNION ALL \n").append(sql);
        }
        LiquidDataSetHelper.execute(ctx, sqlBuilder.toString());
    }
}

