/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow.mobile;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.AbstractFlowDataSetTemplet;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FlowJournalByFlowItemDataSet
extends AbstractFlowDataSetTemplet {
    private static final int DEFAULT_TOP_COUNT = 10;
    private static final String SQL_DATA_FLOW_JOUNAL = "SELECT COMPANY.FName_{4} FCompanyName\n, CURRENCY.FName_{4} FCurrencyName, ''{3}'' FLocalCurrencyName \n, JOURNAL.FCreateDate FBizDate, JOURNAL.FOppUnit FOppUnit, JOURNAL.FOppBank, JOURNAL.FOppAcctNumber, JOURNAL.FDescription \n, ACCOUNTBANK.FBankAccountNumber FBankAccountNumber, ACCOUNTBANK.FName_{4} FAccountBankName, BANK.FName_{4} FOpenBankName \n, JOURNAL.FIsDebit, (DETAIL.FIncomeAmount + DETAIL.FOutcomeAmount) FBalance\n, (DETAIL.FIncomeAmount + DETAIL.FOutcomeAmount) * EXRATE.FExchangeRate FLocalBalance\nFROM T_CAS_JOURNAL JOURNAL \nINNER JOIN {0} DETAIL ON DETAIL.FBillId = JOURNAL.FID \nINNER JOIN {1} COMPANY ON JOURNAL.FCompanyId = COMPANY.FID \nINNER JOIN T_BD_CURRENCY CURRENCY ON JOURNAL.FCurrencyId = CURRENCY.FID \nLEFT JOIN {2} EXRATE ON JOURNAL.FCurrencyId = EXRATE.FCurrencyId \nLEFT JOIN T_BD_ACCOUNTBANKS ACCOUNTBANK ON JOURNAL.FAccountBankId = ACCOUNTBANK.FID \nLEFT JOIN T_BD_BANK BANK ON ACCOUNTBANK.FBANK = BANK.FID \nORDER BY DETAIL.FIncomeAmount DESC";

    @Override
    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        filterParamMap.put("extraFields", "FBillId");
        String filter = super.getFilterSql(ctx, filterParamMap);
        StringBuilder filterBuilder = new StringBuilder(filter);
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        this.getDateFilterSql(filterBuilder, beginDateString, endDateString);
        Set flowItemIdSet = (Set)filterParamMap.get("flowItemIdSet");
        if (!EmptyUtil.isEmpty((Collection)flowItemIdSet)) {
            filterBuilder.append(" AND FLOWITEM.FID IN ").append(FMHelper.setTran2String((Set)flowItemIdSet));
        }
        return filterBuilder.toString();
    }

    @Override
    protected String getFlowPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable) throws BOSException, EASBizException {
        return flowDetailTable;
    }

    @Override
    protected String getFlowSumData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumDataByPeriodType(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        return flowPeriodTable;
    }

    @Override
    protected String getQueryFlowSql(Context ctx, Map<String, Object> filterParamMap, String flowSumDataTable, String exchangeRateTable) throws BOSException, EASBizException {
        String localCurrencyName = "";
        CurrencyInfo currencyInfo = LiquidCompanyHelper.getLocalCompanyInfo(ctx, filterParamMap).getBaseCurrency();
        if (currencyInfo != null) {
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()));
            localCurrencyName = currencyInfo.getName();
        }
        return MessageFormat.format(SQL_DATA_FLOW_JOUNAL, flowSumDataTable, this.getCompanyTable(ctx, filterParamMap), exchangeRateTable, localCurrencyName, LiquidDataSetHelper.getCurrentLanguage(ctx));
    }

    @Override
    public IRowSet getQueryDataSet(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        IRowSet rowSet = super.getQueryDataSet(ctx, filterParamMap);
        String topCount = (String)filterParamMap.get("topCount");
        if (EmptyUtil.isEmpty((String)topCount)) {
            topCount = String.valueOf(10);
        }
        return this.getTopRowSet(ctx, rowSet, Integer.parseInt(topCount));
    }

    private IRowSet getTopRowSet(Context ctx, IRowSet iRowSet, int n) throws BOSException {
        try {
            if (iRowSet.size() <= n) {
                return iRowSet;
            }
            DynamicRowSet rowSets = DynamicRowSet.create((IRowSet)iRowSet);
            rowSets.insertRows(iRowSet);
            DynamicRowSet rowSet = rowSets.subRowSet(0, n + 1);
            int count = 1;
            BigDecimal balance = BigDecimal.ZERO;
            BigDecimal localBalance = BigDecimal.ZERO;
            rowSets.beforeFirst();
            while (rowSets.next()) {
                if (count++ <= n) continue;
                balance = balance.add(rowSets.getBigDecimal("FBalance"));
                localBalance = localBalance.add(rowSets.getBigDecimal("FLocalBalance"));
            }
            rowSet.last();
            rowSet.updateString("FCompanyName", LiquidHelper.getLiquidResource(ctx, "OtherAmountSum"));
            rowSet.updateString("FCurrencyName", null);
            rowSet.updateDate("FBizDate", null);
            rowSet.updateString("FOppUnit", null);
            rowSet.updateString("FOppBank", null);
            rowSet.updateString("FOppAcctNumber", null);
            rowSet.updateString("FDescription", null);
            rowSet.updateString("FBankAccountNumber", null);
            rowSet.updateString("FAccountBankName", null);
            rowSet.updateString("FOpenBankName", null);
            rowSet.updateInt("FIsDebit", 0);
            rowSet.updateBigDecimal("FBalance", balance);
            rowSet.updateBigDecimal("FLocalBalance", localBalance);
            rowSet.beforeFirst();
            return rowSet;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

