/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.AbstractFlowDataSetTemplet;
import com.kingdee.eas.fm.liquid.app.flow.LiquidFlowDataSetHelper;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class FlowAnalysisDataSet
extends AbstractFlowDataSetTemplet {
    private String flowItemTable;
    private int maxFlowItemLevel = 2;
    private boolean isDiffYear;
    private static final String SQL_TABLE_FLOW_PERIOD_SUM = "CREATE TABLE {0} (FItemId VARCHAR(44),FCompanyId VARCHAR(44),FCurrencyId VARCHAR(44),FIsNetWorth NUMERIC(2),FItemType NUMERIC(2),FThisEndingBalance NUMERIC(19,4),FThisYearEndBalance NUMERIC(19,4),FLastYearPeriodBalance NUMERIC(19,4),FLastYearEndBalance NUMERIC(19,4))";
    private static final String SQL_INSERT_FLOW_PERIOD_SUM = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FIsNetWorth,FItemType,\nFThisEndingBalance,FThisYearEndBalance,FLastYearPeriodBalance,FLastYearEndBalance)\n";
    private static final String SQL_DATA_FLOW_CURRENT_YEAR = ", 0.00 FThisYearEndBalance,0.00 FLastYearPeriodBalance ,0.00 FLastYearEndBalance \n";
    private static final String SQL_DATA_FLOW_CURRENT_YEAR_SUM = ",SUM(CASE DETAIL.FPeriodType WHEN 2 THEN (DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FIsNetWorth=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount) ELSE 0 END) FThisYearEndBalance \n,SUM(CASE DETAIL.FPeriodType WHEN 3 THEN (DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FIsNetWorth=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount) ELSE 0 END) FLastYearPeriodBalance \n,SUM(CASE DETAIL.FPeriodType WHEN 4 THEN (DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FIsNetWorth=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount) ELSE 0 END) FLastYearEndBalance \n";
    private static final String SQL_DATA_FLOW_PERIOD_SUM = "SELECT DETAIL.FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FIsNetWorth, FLOWITEM.FItemType \n,SUM(CASE DETAIL.FPeriodType WHEN 1 THEN (DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FIsNetWorth=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount)  ELSE 0 END) FThisEndingBalance \n{4}FROM {1} DETAIL \nINNER JOIN {2} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID \nWHERE FLOWITEM.FLevel <= {3} \nGROUP BY DETAIL.FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FIsNetWorth, FLOWITEM.FItemType";
    private static final String SQL_INSERT_CUSTOM_FLOWITEM = "INSERT INTO {0}(FItemId) \nSELECT FID FROM {1} \nWHERE NOT EXISTS(SELECT DETAIL.FItemId FROM {0} DETAIL WHERE DETAIL.FItemId = {1}.FID) AND FItemType > 0";
    private static final String SQL_FLOW_DATA = "SELECT CASE DETAIL.FIsNetWorth WHEN 0 THEN DETAIL.FItemId ELSE CONCAT(DETAIL.FItemId,''A'') END FFlowItemId\n, CASE DETAIL.FIsNetWorth WHEN 0 THEN FLOWITEM.FName_{4} ELSE CONCAT(FLOWITEM.FName_{4},''_{5}'') END FFlowItemName\n, CASE DETAIL.FIsNetWorth WHEN 0 THEN FLOWITEM.FNumber ELSE CONCAT(FLOWITEM.FNumber,''ZZ'') END FFlowItemNumber\n, CASE DETAIL.FIsNetWorth WHEN 0 THEN FLOWITEM.FParentId ELSE DETAIL.FItemId END FFlowItemParentId\n, FLOWITEM.FIsLeaf FFlowItemIsLeaf\n, FLOWITEM.FLevel FFlowItemLevel\n, FLOWITEM.FDirection FFlowItemDirection\n, FLOWITEM.FProperty FFlowItemProperty\n, FLOWITEM.FItemType FFlowItemType\n, DETAIL.FIsNetWorth FIsNetWorth\n, COMPANY.FID FCompanyId\n, COMPANY.FName_{4} FCompanyName\n, COMPANY.FLongNumber FCompanyLongNumber\n, COMPANY.FParentId FCompanyParentId\n, COMPANY.FIsLeaf FCompanyIsLeaf\n, CURRENCY.FID FCurrencyId\n, CURRENCY.FName_{4} FCurrencyName\n, CURRENCY.FNumber FCurrencyNumber\n, DETAIL.FThisEndingBalance FThisEndingBalance\n, DETAIL.FThisEndingBalance * EXRATE.FExchangeRate FLocalThisEndingBalance\n, DETAIL.FThisYearEndBalance FThisYearEndBalance\n, DETAIL.FThisYearEndBalance * EXRATE.FExchangeRate FLocalThisYearEndBalance\n, DETAIL.FLastYearPeriodBalance FLastYearPeriodBalance\n, DETAIL.FLastYearPeriodBalance * EXRATE.FExchangeRate FLocalLastYearPeriodBalance\n, DETAIL.FLastYearEndBalance FLastYearEndBalance\n, DETAIL.FLastYearEndBalance * EXRATE.FExchangeRate FLocalLastYearEndBalance\n, CASE WHEN DETAIL.FLastYearEndBalance = 0 THEN 0 ELSE (DETAIL.FThisYearEndBalance-DETAIL.FLastYearEndBalance)/ABS(DETAIL.FLastYearEndBalance) END FCurrentYearRatio\n, CASE WHEN DETAIL.FLastYearPeriodBalance = 0 THEN 0 ELSE (DETAIL.FThisEndingBalance-DETAIL.FLastYearPeriodBalance)/ABS(DETAIL.FLastYearPeriodBalance) END FYearOnYearRatio\nFROM {0} DETAIL \nINNER JOIN {2} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID \nLEFT JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID \nLEFT JOIN T_BD_CURRENCY CURRENCY ON DETAIL.FCurrencyId = CURRENCY.FID \nLEFT JOIN {3} EXRATE ON DETAIL.FCurrencyId = EXRATE.FCurrencyId ";

    private String getFlowItemTable(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((String)this.flowItemTable)) {
            return this.flowItemTable;
        }
        this.flowItemTable = LiquidFlowDataSetHelper.createFlowItemTable(ctx, filterParamMap);
        return this.flowItemTable;
    }

    @Override
    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String filter = super.getFilterSql(ctx, filterParamMap);
        StringBuilder filterBuilder = new StringBuilder(filter);
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        String isDiffYearString = (String)filterParamMap.get("isDiffYear");
        this.isDiffYear = "true".equalsIgnoreCase(isDiffYearString);
        if (!this.isDiffYear) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtil.stringToDate((String)beginDateString));
            calendar.add(1, -1);
            beginDateString = DateUtil.DateToString((Date)DateUtil.getFirstYearDate((Date)calendar.getTime()));
        }
        this.getDateFilterSql(filterBuilder, beginDateString, endDateString);
        return filterBuilder.toString();
    }

    @Override
    protected String getFlowPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable) throws BOSException, EASBizException {
        this.periodTypeHandler.setNetWorth(true);
        String flowPeriodTable = this.periodTypeHandler.createFlowPeriodTable(ctx);
        this.periodTypeHandler.insertThisPeriodData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        if (!this.isDiffYear) {
            this.periodTypeHandler.insertThisYearData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
            this.periodTypeHandler.insertLastYearPeriodData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
            this.periodTypeHandler.insertLastYearData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        }
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        if (!EmptyUtil.isEmpty((String)flowItemParentId)) {
            this.maxFlowItemLevel = LiquidCompanyHelper.getFlowItemInfo(ctx, flowItemParentId).getLevel() + 2;
        }
        this.periodTypeHandler.summarizeDataByFlowItem(ctx, flowPeriodTable, filterParamMap, this.maxFlowItemLevel);
        if (EmptyUtil.isEmpty((String)flowItemParentId)) {
            this.periodTypeHandler.insertNetWorthData(ctx, flowPeriodTable);
            this.periodTypeHandler.insertFlowNetWorth(ctx, flowPeriodTable, "FLOWITEM003");
            String companyTable = this.getCompanyTable(ctx, filterParamMap);
            Date beginDate = DateUtil.stringToDate((String)((String)filterParamMap.get("beginDate")));
            Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
            BgPeriodInfo periodInfo = new BgPeriodInfo();
            periodInfo.setBeginDate(beginDate);
            periodInfo.setEndDate(endDate);
            Date[] minAndMaxDates = this.periodTypeHandler.getMaxAndMinBalanceDate(ctx);
            this.periodTypeHandler.insertStockBeginingBalance(ctx, flowPeriodTable, filterParamMap, companyTable, periodInfo, minAndMaxDates);
            this.periodTypeHandler.insertStockEndingBalance(ctx, flowPeriodTable, filterParamMap, companyTable, periodInfo, minAndMaxDates);
        }
        this.periodTypeHandler.summarizeDataByCompany(ctx, flowPeriodTable, this.getCompanyTable(ctx, filterParamMap), filterParamMap);
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumDataByPeriodType(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowDataTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "SQL_TABLE_FLOW_PERIOD");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOW_PERIOD_SUM, flowDataTable));
        String flowItemTable = this.getFlowItemTable(ctx, filterParamMap);
        String otherPeriodData = !this.isDiffYear ? SQL_DATA_FLOW_CURRENT_YEAR_SUM : SQL_DATA_FLOW_CURRENT_YEAR;
        String sql = MessageFormat.format("INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FIsNetWorth,FItemType,\nFThisEndingBalance,FThisYearEndBalance,FLastYearPeriodBalance,FLastYearEndBalance)\nSELECT DETAIL.FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FIsNetWorth, FLOWITEM.FItemType \n,SUM(CASE DETAIL.FPeriodType WHEN 1 THEN (DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FIsNetWorth=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount)  ELSE 0 END) FThisEndingBalance \n{4}FROM {1} DETAIL \nINNER JOIN {2} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID \nWHERE FLOWITEM.FLevel <= {3} \nGROUP BY DETAIL.FItemId,DETAIL.FCompanyId,DETAIL.FCurrencyId,DETAIL.FIsNetWorth, FLOWITEM.FItemType", flowDataTable, flowPeriodTable, flowItemTable, new Integer(this.maxFlowItemLevel), otherPeriodData);
        LiquidDataSetHelper.execute(ctx, sql);
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        if (EmptyUtil.isEmpty((String)flowItemParentId)) {
            sql = MessageFormat.format(SQL_INSERT_CUSTOM_FLOWITEM, flowDataTable, flowItemTable);
            LiquidDataSetHelper.execute(ctx, sql);
        }
        return flowDataTable;
    }

    @Override
    protected String getQueryFlowSql(Context ctx, Map<String, Object> filterParamMap, String flowSumDataTable, String exchangeRateTable) throws BOSException, EASBizException {
        String netWorth = LiquidHelper.getLiquidResource(ctx, "NetWorth");
        String flowItemTable = this.getFlowItemTable(ctx, filterParamMap);
        return MessageFormat.format(SQL_FLOW_DATA, flowSumDataTable, this.getCompanyTable(ctx, filterParamMap), flowItemTable, exchangeRateTable, LiquidDataSetHelper.getCurrentLanguage(ctx), netWorth);
    }
}

