/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.AbstractFlowDataSetTemplet;
import com.kingdee.eas.fm.liquid.app.flow.LiquidFlowDataSetHelper;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;

public class FlowAnalysisPeriodDataSet
extends AbstractFlowDataSetTemplet {
    private String flowItemTable;
    private int maxFlowItemLevel = 2;
    private static final String SQL_INSERT_CUSTOM_FLOWITEM = "INSERT INTO {0}(FItemId) \nSELECT FID FROM {1} \nWHERE NOT EXISTS(SELECT DETAIL.FItemId FROM {0} DETAIL WHERE DETAIL.FItemId = {1}.FID) AND FItemType > 0";
    private static final String SQL_FLOW_DATA = "SELECT CASE DETAIL.FIsNetWorth WHEN 0 THEN DETAIL.FItemId ELSE CONCAT(DETAIL.FItemId,''A'') END FFlowItemId\n, CASE DETAIL.FIsNetWorth WHEN 0 THEN FLOWITEM.FName_{4} ELSE CONCAT(FLOWITEM.FName_{4},''_{5}'') END FFlowItemName\n, CASE DETAIL.FIsNetWorth WHEN 0 THEN FLOWITEM.FNumber ELSE CONCAT(FLOWITEM.FNumber,''ZZ'') END FFlowItemNumber\n, FLOWITEM.FIsLeaf FFlowItemIsLeaf\n, FLOWITEM.FLevel FFlowItemLevel\n, FLOWITEM.FDirection FFlowItemDirection\n, FLOWITEM.FItemType FFlowItemType\n, DETAIL.FIsNetWorth FIsNetWorth\n, COMPANY.FID FCompanyId\n, COMPANY.FName_{4} FCompanyName\n, COMPANY.FLongNumber FCompanyLongNumber\n, COMPANY.FParentId FCompanyParentId\n, COMPANY.FIsLeaf FCompanyIsLeaf\n, CURRENCY.FID FCurrencyId\n, CURRENCY.FName_{4} FCurrencyName\n, CURRENCY.FNumber FCurrencyNumber\n, ISNULL(BGPERIOD.FName_{4}, ''{6}'') FQueryCycleName\n, ISNULL(BGPERIOD.FBeginDate, {7}) FQueryCycleBeginDate\n, ISNULL(BGPERIOD.FEndDate, {8})  FQueryCycleEndDate\n, DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FISNETWORTH=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount FThisEndingBalance\n,(DETAIL.FIncomeAmount + (CASE WHEN FLOWITEM.FItemType=0 AND DETAIL.FISNETWORTH=0 THEN 1 ELSE -1 END) * DETAIL.FOutcomeAmount) * EXRATE.FEXCHANGERATE FLocalThisEndingBalance\nFROM {0} DETAIL \nLEFT JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID \nLEFT JOIN T_BD_CURRENCY CURRENCY ON DETAIL.FCurrencyId = CURRENCY.FID \nINNER JOIN {2} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID AND FLOWITEM.FLevel <= {9}\nLEFT JOIN T_BG_BGPERIOD BGPERIOD ON DETAIL.FPeriodId = BGPERIOD.FID \nLEFT JOIN {3} EXRATE ON DETAIL.FCurrencyId = EXRATE.FCurrencyId";

    private String getFlowItemTable(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((String)this.flowItemTable)) {
            return this.flowItemTable;
        }
        this.flowItemTable = LiquidFlowDataSetHelper.createFlowItemTable(ctx, filterParamMap);
        return this.flowItemTable;
    }

    @Override
    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String filter = super.getFilterSql(ctx, filterParamMap);
        StringBuilder filterBuilder = new StringBuilder(filter);
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        this.getDateFilterSql(filterBuilder, beginDateString, endDateString);
        return filterBuilder.toString();
    }

    @Override
    protected String getFlowPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable) throws BOSException, EASBizException {
        this.periodTypeHandler.setPerioded(true);
        this.periodTypeHandler.setNetWorth(true);
        String flowPeriodTable = this.periodTypeHandler.createFlowPeriodTable(ctx);
        this.periodTypeHandler.insertDataByPeriods(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumDataByPeriodType(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        if (EmptyUtil.isEmpty((String)flowItemParentId)) {
            String flowItemTable = this.getFlowItemTable(ctx, filterParamMap);
            String sql = MessageFormat.format(SQL_INSERT_CUSTOM_FLOWITEM, flowPeriodTable, flowItemTable);
            LiquidDataSetHelper.execute(ctx, sql);
        }
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowItemParentId = (String)filterParamMap.get("flowParentItemId");
        if (!EmptyUtil.isEmpty((String)flowItemParentId)) {
            this.maxFlowItemLevel = LiquidCompanyHelper.getFlowItemInfo(ctx, flowItemParentId).getLevel() + 2;
        }
        this.periodTypeHandler.summarizeDataByFlowItem(ctx, flowPeriodTable, filterParamMap, this.maxFlowItemLevel);
        if (EmptyUtil.isEmpty((String)flowItemParentId)) {
            this.periodTypeHandler.insertNetWorthData(ctx, flowPeriodTable);
            this.periodTypeHandler.insertFlowIONetWorth(ctx, flowPeriodTable, "FLOWITEM001");
            this.periodTypeHandler.insertFlowNetWorth(ctx, flowPeriodTable, "FLOWITEM003");
            String companyTable = this.getCompanyTable(ctx, filterParamMap);
            Date[] minAndMaxDates = this.periodTypeHandler.getMaxAndMinBalanceDate(ctx);
            BgPeriodCollection periods = this.periodTypeHandler.getPeriods(ctx, filterParamMap);
            int size = periods.size();
            for (int i = 0; i < size; ++i) {
                BgPeriodInfo periodInfo = periods.get(i);
                this.periodTypeHandler.insertStockBeginingBalance(ctx, flowPeriodTable, filterParamMap, companyTable, periodInfo, minAndMaxDates);
                this.periodTypeHandler.insertStockEndingBalance(ctx, flowPeriodTable, filterParamMap, companyTable, periodInfo, minAndMaxDates);
            }
        }
        this.periodTypeHandler.summarizeDataByCompany(ctx, flowPeriodTable, this.getCompanyTable(ctx, filterParamMap), filterParamMap);
        return flowPeriodTable;
    }

    @Override
    protected String getQueryFlowSql(Context ctx, Map<String, Object> filterParamMap, String flowSumDataTable, String exchangeRateTable) throws BOSException, EASBizException {
        String netWorth = LiquidHelper.getLiquidResource(ctx, "NetWorth");
        String titleCustom = LiquidHelper.getLiquidResource(ctx, "SelfCustomPeriod");
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        String flowItemTable = this.getFlowItemTable(ctx, filterParamMap);
        return MessageFormat.format(SQL_FLOW_DATA, flowSumDataTable, this.getCompanyTable(ctx, filterParamMap), flowItemTable, exchangeRateTable, LiquidDataSetHelper.getCurrentLanguage(ctx), netWorth, titleCustom, LiquidDataSetHelper.dateFormat(beginDateString), LiquidDataSetHelper.dateFormat(endDateString), new Integer(this.maxFlowItemLevel));
    }
}

