/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.LiquidAccPerDayDataVo;
import com.kingdee.eas.fm.mobile.util.LiquidDetailVo;
import com.kingdee.eas.fm.mobile.util.LiquidOrgPerDayDataVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalDetailHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.CapitalDetailHelper");

    public Map getLiquidInitData(Context ctx) throws BOSException, EASBizException {
        Map<String, String> result = new HashMap<String, Object>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "CAPITAL_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", (String)((Object)Integer.valueOf(1)));
            result.put("errorMsg", "\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u7684\u8d44\u91d1\u5b58\u91cf\u53ca\u6d41\u6c34\u67e5\u8be2\u6743\u9650");
        } else {
            List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
            CompanyOrgUnitInfo company = null;
            if (companyList.size() == 1) {
                company = companyList.get(0);
            }
            if (companyList.size() > 1) {
                company = CapitalHelper.getDefaultCompany(ctx, companyList);
            }
            if (company != null) {
                String companyId = company.getId().toString();
                String currencyId = company.getBaseCurrency().getId().toString();
                java.util.Date endDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
                java.util.Date startDate = DateUtil.getBeforeDay((java.util.Date)endDate);
                result = this.getDataGroupByDateWithOrg(ctx, companyId, currencyId, startDate, endDate, 1);
                result.put("currencyId", currencyId);
            }
            result.put("idSet", (String)((Object)idSet));
        }
        return result;
    }

    public Map getDataGroupByDateWithOrg(Context ctx, String queryId, String currencyId, java.util.Date startDate, java.util.Date endDate, int unit) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<LiquidOrgPerDayDataVo> detail = new ArrayList<LiquidOrgPerDayDataVo>();
        CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(queryId));
        String orgId = orgInfo.getId().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(" select sum(t0.fbalance) balance,sum(t0.finAmount) inAmount,sum(t0.foutAmount) outAmount,t0.FBizDate bizDate ");
        sb.append(" from T_ORG_COMPANY main ");
        sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
        sb.append(" where ( main.flongnumber like ? or main.fid =? ) ");
        sb.append(" and t0.FCurrencyID=? and t0.FBizDate>=? and t0.FBizDate<=? and main.fISFREEZE=0 and main.fIsSealUp=0 ");
        sb.append(" group by t0.FBizDate order by t0.FBizDate desc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{orgInfo.getLongNumber() + "!%", orgId, currencyId, new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal balance = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                BigDecimal inAmount = rs.getBigDecimal("inAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("inAmount");
                BigDecimal outAmount = rs.getBigDecimal("outAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("outAmount");
                Date bizDate = rs.getDate("bizDate");
                LiquidOrgPerDayDataVo vo = new LiquidOrgPerDayDataVo();
                vo.setUnit(unit);
                vo.setCompanyId(queryId);
                vo.setCurrencyId(currencyId);
                vo.setBizDate(bizDate);
                vo.setAmount(balance);
                vo.setInAmount(inAmount);
                vo.setOutAmount(outAmount);
                detail.add(vo);
            }
            result.put("detail", detail);
            result.put("detailType", "org");
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    public Map getAcctBankSumDataWithDate(Context ctx, String queryId, String currencyId, java.util.Date dealDate, int unit) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<LiquidAccPerDayDataVo> detail = new ArrayList<LiquidAccPerDayDataVo>();
        try {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(queryId));
            String longnumber = companyInfo.getLongNumber();
            String accFilter = " ( company.longnumber like '" + longnumber + "!%' or company.id = '" + queryId + "' ) and isclosed=0 ";
            result.put("accFilter", accFilter);
            StringBuilder sb = new StringBuilder();
            sb.append(" select t0.fbalance balance,t0.finAmount inAmount,t0.foutAmount outAmount,t0.FBizDate bizDate, ");
            sb.append(" t1.fid accid,t1.fname_l2 name,t1.FBANKACCOUNTNUMBER number, main.FNAME_L2 companyName ");
            sb.append(" from T_ORG_COMPANY main ");
            sb.append(" left join T_LI_CapitalData t0 on main.fid=t0.forgid ");
            sb.append(" left join T_BD_ACCOUNTBANKS t1 on t0.faccid=t1.fid ");
            sb.append(" where ( main.flongnumber like ? or main.fid = ? ) ");
            sb.append(" and t0.FCurrencyID=? and t0.FBizDate=? and main.fISFREEZE=0 and main.fIsSealUp=0 and t0.fcashorbank=2 ");
            sb.append(" order by t0.finAmount+t0.foutAmount desc ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{longnumber + "!%", queryId, currencyId, new Timestamp(dealDate.getTime())});
            while (rs.next()) {
                String accId = rs.getString("accid");
                String accName = rs.getString("name");
                String accNumber = rs.getString("number");
                BigDecimal inAmount = rs.getBigDecimal("inAmount");
                BigDecimal outAmount = rs.getBigDecimal("outAmount");
                String companyName = rs.getString("companyName");
                LiquidAccPerDayDataVo vo = new LiquidAccPerDayDataVo();
                vo.setUnit(unit);
                vo.setAccId(accId);
                vo.setAccName(accName);
                vo.setAccNumber(accNumber);
                vo.setBizDate(dealDate);
                vo.setCurrencyId(currencyId);
                vo.setInAmount(inAmount);
                vo.setOutAmount(outAmount);
                if (!companyInfo.isIsLeaf()) {
                    vo.setCompanyName(companyName);
                }
                detail.add(vo);
            }
            result.put("detail", detail);
            result.put("detailType", "acctBank");
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    public Map queryAcctBankLiquidDataByAccId(Context ctx, String queryId, String currencyId, java.util.Date startDate, java.util.Date endDate, int unit) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<LiquidAccPerDayDataVo> detail = new ArrayList<LiquidAccPerDayDataVo>();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" select t0.fbalance balance,t0.finAmount inAmount,t0.foutAmount outAmount,t0.FBizDate bizDate, ");
            sb.append(" t1.fid accid,t1.fname_l2 name,t1.FBANKACCOUNTNUMBER number, main.FNAME_L2 companyName");
            sb.append(" from T_BD_ACCOUNTBANKS t1  ");
            sb.append(" left join T_LI_CapitalData t0 on  t0.faccid=t1.fid ");
            sb.append(" left join T_ORG_COMPANY main on  t1.FCompanyID=main.fid ");
            sb.append(" where t1.fid=? ");
            sb.append(" and t0.FCurrencyID=? and t0.FBizDate>=?  and t0.FBizDate<=? and t0.fcashorbank=2 ");
            sb.append(" order by t0.FBizDate desc, t0.finAmount+t0.foutAmount desc");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{queryId, currencyId, new Timestamp(startDate.getTime()), new Timestamp(endDate.getTime())});
            while (rs.next()) {
                String accId = rs.getString("accid");
                String accName = rs.getString("name");
                String accNumber = rs.getString("number");
                BigDecimal inAmount = rs.getBigDecimal("inAmount");
                BigDecimal outAmount = rs.getBigDecimal("outAmount");
                Date dealDate = rs.getDate("bizDate");
                String companyName = rs.getString("companyName");
                LiquidAccPerDayDataVo vo = new LiquidAccPerDayDataVo();
                vo.setUnit(unit);
                vo.setAccId(accId);
                vo.setAccName(accName);
                vo.setAccNumber(accNumber);
                vo.setBizDate(dealDate);
                vo.setCurrencyId(currencyId);
                vo.setInAmount(inAmount);
                vo.setOutAmount(outAmount);
                vo.setCompanyName(companyName);
                detail.add(vo);
            }
            result.put("detail", detail);
            result.put("detailType", "acctBank");
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    public Map getAcctBankLiquidData(Context ctx, String queryId, String currencyId, java.util.Date startDate, java.util.Date endDate, int unit, String desc, String payAmt, String recAmt) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<LiquidDetailVo> detail = new ArrayList<LiquidDetailVo>();
        try {
            AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(queryId));
            if (acctBankInfo.isIsSetBankInterface()) {
                TransDetailCollection col = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(this.getTransDetailFilter(queryId, currencyId, startDate, endDate, desc, payAmt, recAmt));
                for (int i = 0; i < col.size(); ++i) {
                    TransDetailInfo info = col.get(i);
                    LiquidDetailVo vo = new LiquidDetailVo();
                    vo.setUnit(unit);
                    if (info.isIsDebit()) {
                        vo.setPayOrRec("pay");
                        vo.setAmount(info.getDebitAmount());
                    } else {
                        vo.setPayOrRec("rec");
                        vo.setAmount(info.getCreditAmount());
                    }
                    vo.setOppUnit(info.getOppUnit());
                    vo.setDesc(info.getDescription());
                    vo.setBizDate(info.getBizTime());
                    detail.add(vo);
                }
            } else {
                JournalCollection col = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(this.getJournalFilter(queryId, currencyId, startDate, endDate, desc, payAmt, recAmt));
                for (int i = 0; i < col.size(); ++i) {
                    JournalInfo info = col.get(i);
                    LiquidDetailVo vo = new LiquidDetailVo();
                    vo.setUnit(unit);
                    if (info.isIsDebit()) {
                        vo.setPayOrRec("rec");
                        vo.setAmount(info.getDebitAmount());
                    } else {
                        vo.setPayOrRec("pay");
                        vo.setAmount(info.getCreditAmount());
                    }
                    vo.setOppUnit(info.getOppUnit());
                    vo.setDesc(info.getDescription());
                    vo.setBizDate(info.getBizDate());
                    detail.add(vo);
                }
            }
            result.put("detail", detail);
            result.put("detailType", "liquidDetail");
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    private EntityViewInfo getTransDetailFilter(String acctBankId, String currencyId, java.util.Date startDate, java.util.Date endDate, String desc, String payAmt, String recAmt) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("bankAccount", (Object)acctBankId));
        items.add(new FilterItemInfo("currency", (Object)currencyId));
        if (startDate.compareTo(endDate) == 0) {
            items.add(new FilterItemInfo("bizDate", (Object)startDate, CompareType.EQUALS));
        } else {
            items.add(new FilterItemInfo("bizDate", (Object)startDate, CompareType.GREATER_EQUALS));
            items.add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        }
        if (!EmptyUtil.isEmpty((String)desc)) {
            items.add(new FilterItemInfo("description", (Object)("%" + desc + "%"), CompareType.LIKE));
        }
        if (!EmptyUtil.isEmpty((String)payAmt)) {
            items.add(new FilterItemInfo("debitAmount", (Object)payAmt));
        }
        if (!EmptyUtil.isEmpty((String)recAmt)) {
            items.add(new FilterItemInfo("creditAmount", (Object)recAmt));
        }
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("bizDate");
        sortInfo.setSortType(SortType.DESCEND);
        sort.add(sortInfo);
        view.setSorter(sort);
        return view;
    }

    private EntityViewInfo getJournalFilter(String acctBankId, String currencyId, java.util.Date startDate, java.util.Date endDate, String desc, String payAmt, String recAmt) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("accountBank", (Object)acctBankId));
        items.add(new FilterItemInfo("currency", (Object)currencyId));
        if (startDate.compareTo(endDate) == 0) {
            items.add(new FilterItemInfo("bizDate", (Object)startDate, CompareType.EQUALS));
        } else {
            items.add(new FilterItemInfo("bizDate", (Object)startDate, CompareType.GREATER_EQUALS));
            items.add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        }
        if (!EmptyUtil.isEmpty((String)desc)) {
            items.add(new FilterItemInfo("description", (Object)("%" + desc + "%"), CompareType.LIKE));
        }
        if (!EmptyUtil.isEmpty((String)payAmt)) {
            items.add(new FilterItemInfo("creditAmount", (Object)payAmt));
        }
        if (!EmptyUtil.isEmpty((String)recAmt)) {
            items.add(new FilterItemInfo("debitAmount", (Object)recAmt));
        }
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("bizDate");
        sortInfo.setSortType(SortType.DESCEND);
        sort.add(sortInfo);
        view.setSorter(sort);
        return view;
    }
}

