/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.CapitalDistributionVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalDistributionHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.CapitalDistributionHelper");

    public Map getInitData(Context ctx) throws BOSException, EASBizException {
        Map<String, Object> result = new HashMap<String, Object>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "CAPITAL_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", 1);
            result.put("errorMsg", "\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u7684\u8d44\u91d1\u5b58\u91cf\u53ca\u6d41\u6c34\u67e5\u8be2\u6743\u9650");
        } else {
            List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
            CompanyOrgUnitInfo company = null;
            if (companyList.size() == 1) {
                company = companyList.get(0);
            }
            if (companyList.size() > 1) {
                company = CapitalHelper.getDefaultCompany(ctx, companyList);
            }
            if (company != null) {
                String companyId = company.getId().toString();
                String currencyId = company.getBaseCurrency().getId().toString();
                result = this.getDataByFilter(ctx, companyId, currencyId);
            }
            result.put("idSet", idSet);
        }
        return result;
    }

    public Map getDataByFilter(Context ctx, String companyId, String currencyId) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        result.put("currencyId", currencyId);
        result.put("currency", (String)currency);
        result.put("company", (String)company);
        result.put("unit", "\u4e07\u5143");
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String todayS = df.format(new Date());
        try {
            today = df.parse(todayS);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.dealBankData(ctx, result, company, currency, today);
        this.dealCompanyData(ctx, result, company, currency, today);
        this.dealCurrencyData(ctx, result, company, today);
        return result;
    }

    public Map getCompanySubData(Context ctx, String companyId, String currencyId) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String todayS = df.format(new Date());
        try {
            today = df.parse(todayS);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.dealCompanyData(ctx, result, company, currency, today);
        return result;
    }

    protected void dealBankData(Context ctx, Map result, CompanyOrgUnitInfo company, CurrencyInfo currency, Date date) throws BOSException, EASBizException {
        int i;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBank", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("level", (Object)1));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        BankCollection bankCol = BankFactory.getLocalInstance((Context)ctx).getBankCollection(entityViewInfo);
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        ArrayList<String> legend = new ArrayList<String>();
        BigDecimal sumAmt = BigDecimal.ZERO;
        boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
        String acctBankIds = null;
        if (zjdc001) {
            acctBankIds = CapitalHelper.getInGroupAcctBankIds(ctx, company.getLongNumber());
        }
        for (i = 0; i < bankCol.size(); ++i) {
            BankInfo bankInfo = bankCol.get(i);
            String longNumber = bankInfo.getLongNumber();
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT sum(t2.fbalance) balance FROM T_BD_Bank main ");
            sb.append(" left join T_BD_ACCOUNTBANKS  t1 on main.fid=t1.fbank ");
            sb.append(" left join t_li_capitaldata t2 on t2.faccid=t1.fid ");
            sb.append(" left join T_ORG_COMPANY t3 on t3.fid=t1.FCOMPANYID ");
            sb.append(" where ( main.FLONGNUMBER LIKE ? or main.fid = ? ) and main.FISLEAF =1 ");
            sb.append(" and ( t3.flongnumber like ? or t3.fid = ? ) ");
            sb.append(" and t2.fcurrencyid=? and t2.fbizdate=? ");
            sb.append(" and t3.fISFREEZE=0 and t3.fIsSealUp=0 ");
            if (acctBankIds != null) {
                sb.append(" and t2.FACCID not in (" + acctBankIds + ")");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{longNumber + "!%", bankInfo.getId().toString(), company.getLongNumber() + "!%", company.getId().toString(), currency.getId().toString(), new Timestamp(date.getTime())});
            try {
                while (rs.next()) {
                    BigDecimal sum = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    sumAmt = sumAmt.add(sum);
                    CapitalDistributionVo vo = new CapitalDistributionVo();
                    vo.setType("bank");
                    vo.setCompanyId(company.getId().toString());
                    vo.setCurrencyId(currency.getId().toString());
                    vo.setSign(currency.getSign());
                    vo.setName(bankInfo.getName());
                    vo.setObjId(bankInfo.getId().toString());
                    vo.setValue(sum);
                    detail.add(vo);
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        Collections.sort(detail, (Comparator)new Comparator<CapitalDistributionVo>(){

            @Override
            public int compare(CapitalDistributionVo o1, CapitalDistributionVo o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        result.put("BankSum", new DecimalFormat("###,##0.00").format(sumAmt.divide(new BigDecimal("10000"))));
        if (detail.size() <= 10) {
            for (i = 0; i < detail.size(); ++i) {
                CapitalDistributionVo vo = (CapitalDistributionVo)detail.get(i);
                legend.add(vo.getName());
            }
            result.put("legendDataForBank", legend);
            result.put("detailDataForBank", detail);
        } else {
            BigDecimal elseAmt = sumAmt;
            ArrayList<CapitalDistributionVo> realDetail = new ArrayList<CapitalDistributionVo>();
            for (int i2 = 0; i2 < 10; ++i2) {
                CapitalDistributionVo vo = (CapitalDistributionVo)detail.get(i2);
                legend.add(vo.getName());
                realDetail.add(vo);
                elseAmt = elseAmt.subtract(vo.getValue());
            }
            CapitalDistributionVo vo = new CapitalDistributionVo();
            vo.setType("bank");
            vo.setCompanyId(company.getId().toString());
            vo.setCurrencyId(currency.getId().toString());
            vo.setSign(currency.getSign());
            vo.setName("\u5176\u4ed6");
            vo.setObjId("");
            vo.setValue(elseAmt);
            realDetail.add(vo);
            legend.add("\u5176\u4ed6");
            result.put("legendDataForBank", legend);
            result.put("detailDataForBank", realDetail);
        }
    }

    protected void dealCompanyData(Context ctx, Map result, CompanyOrgUnitInfo company, CurrencyInfo currency, Date date) throws BOSException, EASBizException {
        BigDecimal sumAmt = BigDecimal.ZERO;
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        ArrayList<String> legend = new ArrayList<String>();
        if (company.isIsLeaf()) {
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT sum(t0.fbalance) balance FROM T_ORG_COMPANY main ");
            sb.append(" left join T_LI_CapitalData t0 on  main.fid=t0.forgid ");
            sb.append(" where  main.fid = ? and t0.FCurrencyID=? and t0.FBizDate= ?  ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getId().toString(), currency.getId().toString(), new Timestamp(date.getTime())});
            try {
                while (rs.next()) {
                    BigDecimal sum = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                    sumAmt = sumAmt.add(sum);
                    CapitalDistributionVo vo = new CapitalDistributionVo();
                    vo.setType("company");
                    vo.setCompanyId(company.getId().toString());
                    vo.setCurrencyId(currency.getId().toString());
                    vo.setSign(currency.getSign());
                    vo.setName(company.getName());
                    vo.setObjId(company.getId().toString());
                    vo.setValue(sum);
                    detail.add(vo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)false));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
            filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)company.getId().toString()));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityViewInfo);
            boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
            String acctBankIds = null;
            if (zjdc001) {
                acctBankIds = CapitalHelper.getInGroupAcctBankIds(ctx, company.getLongNumber());
            }
            for (int i = 0; i < companyCol.size(); ++i) {
                CompanyOrgUnitInfo companyInfo = companyCol.get(i);
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT sum(t0.fbalance) balance FROM T_ORG_COMPANY main ");
                sb.append(" left join T_LI_CapitalData t0 on  main.fid=t0.forgid ");
                sb.append(" where ( main.flongnumber like ? or main.fid = ? ) and t0.FCurrencyID=? and t0.FBizDate= ?  ");
                sb.append(" and main.fISFREEZE=0 and main.fIsSealUp=0 ");
                if (acctBankIds != null) {
                    sb.append(" and t0.FACCID not in (" + acctBankIds + ")");
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyInfo.getLongNumber() + "!%", companyInfo.getId().toString(), currency.getId().toString(), new Timestamp(date.getTime())});
                try {
                    while (rs.next()) {
                        BigDecimal sum = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                        sumAmt = sumAmt.add(sum);
                        CapitalDistributionVo vo = new CapitalDistributionVo();
                        vo.setType("company");
                        vo.setCompanyId(company.getId().toString());
                        vo.setCurrencyId(currency.getId().toString());
                        vo.setSign(currency.getSign());
                        vo.setName(companyInfo.getName());
                        vo.setObjId(companyInfo.getId().toString());
                        vo.setValue(sum);
                        detail.add(vo);
                    }
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        Collections.sort(detail, (Comparator)new Comparator<CapitalDistributionVo>(){

            @Override
            public int compare(CapitalDistributionVo o1, CapitalDistributionVo o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        result.put("CompanySumTitle", company.getName());
        result.put("CompanySum", new DecimalFormat("###,##0.00").format(sumAmt.divide(new BigDecimal("10000"))));
        if (detail.size() <= 10) {
            for (int i = 0; i < detail.size(); ++i) {
                CapitalDistributionVo vo = (CapitalDistributionVo)detail.get(i);
                legend.add(vo.getName());
            }
            result.put("legendDataForCompany", legend);
            result.put("detailDataForCompany", detail);
        } else {
            BigDecimal elseAmt = sumAmt;
            ArrayList<CapitalDistributionVo> realDetail = new ArrayList<CapitalDistributionVo>();
            for (int i = 0; i < 10; ++i) {
                CapitalDistributionVo vo = (CapitalDistributionVo)detail.get(i);
                legend.add(vo.getName());
                realDetail.add(vo);
                elseAmt = elseAmt.subtract(vo.getValue());
            }
            CapitalDistributionVo vo = new CapitalDistributionVo();
            vo.setType("company");
            vo.setCompanyId(company.getId().toString());
            vo.setCurrencyId(currency.getId().toString());
            vo.setSign(currency.getSign());
            vo.setName("\u5176\u4ed6");
            vo.setObjId("");
            vo.setValue(elseAmt);
            realDetail.add(vo);
            legend.add("\u5176\u4ed6");
            result.put("legendDataForCompany", legend);
            result.put("detailDataForCompany", realDetail);
        }
    }

    protected void dealCurrencyData(Context ctx, Map result, CompanyOrgUnitInfo company, Date date) throws BOSException, EASBizException {
        CapitalDistributionVo vo;
        boolean zjdc001 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "Zjdc001"));
        String acctBankIds = null;
        if (zjdc001) {
            acctBankIds = CapitalHelper.getInGroupAcctBankIds(ctx, company.getLongNumber());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT sum(t0.fbalance) balance,main.fsign sign,main.fname_l2 name,main.FID fid ");
        sb.append(" FROM T_BD_Currency main  ");
        sb.append(" left join T_LI_CapitalData t0 on  main.fid=t0.FCurrencyID ");
        sb.append(" left join T_ORG_COMPANY t1 on t1.fid=t0.forgid ");
        sb.append(" where ( t1.flongnumber like ? or t1.fid = ? ) and t0.FBizDate= ?  ");
        sb.append(" and t1.fISFREEZE=0 and t1.fIsSealUp=0 ");
        if (acctBankIds != null) {
            sb.append(" and t0.FACCID not in (" + acctBankIds + ") ");
        }
        sb.append(" group by main.FID ,main.fname_l2,main.fsign ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getLongNumber() + "!%", company.getId().toString(), new Timestamp(date.getTime())});
        BigDecimal sumAmt = BigDecimal.ZERO;
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        ArrayList<String> legend = new ArrayList<String>();
        try {
            while (rs.next()) {
                BigDecimal sum = rs.getBigDecimal("balance") == null ? BigDecimal.ZERO : rs.getBigDecimal("balance");
                sumAmt = sumAmt.add(sum);
                vo = new CapitalDistributionVo();
                vo.setType("currency");
                vo.setCompanyId(company.getId().toString());
                vo.setCurrencyId(rs.getString("fid"));
                vo.setSign(rs.getString("sign"));
                vo.setName(rs.getString("name"));
                vo.setObjId(rs.getString("fid"));
                vo.setValue(sum);
                detail.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        Collections.sort(detail, (Comparator)new Comparator<CapitalDistributionVo>(){

            @Override
            public int compare(CapitalDistributionVo o1, CapitalDistributionVo o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        if (detail.size() <= 10) {
            for (int i = 0; i < detail.size(); ++i) {
                vo = (CapitalDistributionVo)detail.get(i);
                legend.add(vo.getName());
            }
            result.put("legendDataForCurrency", legend);
            result.put("detailDataForCurrency", detail);
        } else {
            ArrayList<CapitalDistributionVo> realDetail = new ArrayList<CapitalDistributionVo>();
            BigDecimal elseAmt = sumAmt;
            for (int i = 0; i < 10; ++i) {
                CapitalDistributionVo vo2 = (CapitalDistributionVo)detail.get(i);
                legend.add(vo2.getName());
                realDetail.add(vo2);
                elseAmt = elseAmt.subtract(vo2.getValue());
            }
            CapitalDistributionVo vo3 = new CapitalDistributionVo();
            vo3.setType("currency");
            vo3.setCompanyId(company.getId().toString());
            vo3.setCurrencyId("");
            vo3.setSign("");
            vo3.setName("\u5176\u4ed6");
            vo3.setObjId("");
            vo3.setValue(elseAmt);
            realDetail.add(vo3);
            legend.add("\u5176\u4ed6");
            result.put("legendDataForCurrency", legend);
            result.put("detailDataForCurrency", realDetail);
        }
    }
}

