/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.util.NoPermissionException;
import com.kingdee.eas.fm.mobile.util.TreeLongnumberHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PermissionCompanyTreeUtil {
    public static CompanyOrgUnitInfo getTopLevelCompanyWithPermission(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyOrgUnitCollection = PermissionCompanyTreeUtil.getCompanyTreeWithPermission(ctx);
        for (CompanyOrgUnitInfo companyOrgUnitInfo : companyOrgUnitCollection) {
            if (companyOrgUnitInfo.getLevel() != 0) continue;
            return companyOrgUnitInfo;
        }
        return null;
    }

    public static CompanyOrgUnitCollection getCompanyTreeWithPermissionForPc(Context ctx) throws EASBizException, BOSException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        CompanyOrgUnitCollection companyOrgUnitCollection = PermissionCompanyTreeUtil.getCompanyTreeWithPermission(ctx, userID, "FUND_INSIGHT_USE");
        return companyOrgUnitCollection;
    }

    public static CompanyOrgUnitCollection getCompanyTreeWithPermission(Context ctx) throws EASBizException, BOSException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        CompanyOrgUnitCollection companyOrgUnitCollection = PermissionCompanyTreeUtil.getCompanyTreeWithPermission(ctx, userID, "CAPITAL_INSIGHT_USE");
        return companyOrgUnitCollection;
    }

    static CompanyOrgUnitCollection getCompanyTreeWithPermission(Context ctx, String userID, String permItemName) throws EASBizException, BOSException {
        String treeID = "00000000-0000-0000-0000-0000000000024F2827FD";
        OrgPermissionService service = new OrgPermissionService(ctx);
        FullOrgUnitCollection fullOrgUnitCollection = service.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userID), (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD"), permItemName);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(PermissionCompanyTreeUtil.getCompanyOrgUnitFilter(fullOrgUnitCollection));
        if (companyOrgUnitCollection.size() == 0) {
            throw new NoPermissionException();
        }
        TreeLongnumberHelper helper = new TreeLongnumberHelper(PermissionCompanyTreeUtil.extractLongnumbers(companyOrgUnitCollection));
        String[] longnumberTree = helper.fillingLongnumberTree();
        CompanyOrgUnitCollection companyTree = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(PermissionCompanyTreeUtil.getCompanyTreeFilter(longnumberTree));
        PermissionCompanyTreeUtil.resetLevel(companyTree, helper.getTopLongnumber());
        return companyTree;
    }

    private static void resetLevel(CompanyOrgUnitCollection companyTree, String topLongnumber) {
        for (CompanyOrgUnitInfo companyOrgUnitInfo : companyTree) {
            if (companyOrgUnitInfo.getLongNumber().equals(topLongnumber)) {
                companyOrgUnitInfo.setLevel(0);
                continue;
            }
            companyOrgUnitInfo.setLevel(1);
        }
    }

    private static String[] extractLongnumbers(CompanyOrgUnitCollection companyOrgUnitCollection) {
        ArrayList<String> result = new ArrayList<String>();
        for (CompanyOrgUnitInfo companyOrgUnitInfo : companyOrgUnitCollection) {
            result.add(companyOrgUnitInfo.getLongNumber());
        }
        return result.toArray(new String[0]);
    }

    static EntityViewInfo getCompanyOrgUnitFilter(FullOrgUnitCollection fullOrgUnitCollection) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(PermissionCompanyTreeUtil.buildSelectors());
        entityViewInfo.setFilter(PermissionCompanyTreeUtil.buildFilter(fullOrgUnitCollection));
        return entityViewInfo;
    }

    private static EntityViewInfo getCompanyTreeFilter(String[] longnumberTree) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(PermissionCompanyTreeUtil.buildCompanyTreeSelectors());
        entityViewInfo.setFilter(PermissionCompanyTreeUtil.buildCompanyTreeFilter(longnumberTree));
        return entityViewInfo;
    }

    private static SelectorItemCollection buildSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("number");
        selectors.add("longNumber");
        return selectors;
    }

    private static FilterInfo buildFilter(FullOrgUnitCollection fullOrgUnitCollection) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = EmptyUtil.isEmpty((AbstractObjectCollection)fullOrgUnitCollection) ? new FilterItemInfo("id", (Object)"000000") : new FilterItemInfo("id", PermissionCompanyTreeUtil.getIDSet(fullOrgUnitCollection), CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        return filterInfo;
    }

    private static FilterInfo buildCompanyTreeFilter(String[] longnumberTree) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("longnumber", new HashSet<String>(Arrays.asList(longnumberTree)), CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        return filterInfo;
    }

    private static SelectorItemCollection buildCompanyTreeSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("parent.id");
        selectors.add("level");
        selectors.add("isLeaf");
        selectors.add("description");
        selectors.add("longNumber");
        return selectors;
    }

    private static Set<String> getIDSet(FullOrgUnitCollection fullOrgUnitCollection) {
        HashSet<String> idSet = new HashSet<String>();
        for (FullOrgUnitInfo fullOrgUnitInfo : fullOrgUnitCollection) {
            idSet.add(fullOrgUnitInfo.getId().toString());
        }
        return idSet;
    }
}

