/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class TreeLongnumberHelper {
    final String[] longnumbers;

    public TreeLongnumberHelper(String[] longnumbers) {
        this.longnumbers = longnumbers;
    }

    public int getShortestTierSize() {
        int shortestTierSize = this.longnumbers[0].split("!").length;
        for (String longnumber : this.longnumbers) {
            int size = longnumber.split("!").length;
            if (size >= shortestTierSize) continue;
            shortestTierSize = size;
        }
        return shortestTierSize;
    }

    public String getTopLongnumber() {
        String[] shortestTierLongnumber = this.getShortestTierLongnumber();
        return this.getTopLongnumber(shortestTierLongnumber);
    }

    private String getTopLongnumber(String[] subtractOneTierLongnumber) {
        if (this.equalsAllElement(subtractOneTierLongnumber)) {
            return subtractOneTierLongnumber[0];
        }
        return this.getTopLongnumber(this.subtractOneTier(subtractOneTierLongnumber));
    }

    private boolean equalsAllElement(String[] shortestTierLongnumber) {
        String baseLongnumber = shortestTierLongnumber[0];
        for (String longnumber : shortestTierLongnumber) {
            if (longnumber.equals(baseLongnumber)) continue;
            return false;
        }
        return true;
    }

    private String[] subtractOneTier(String[] shortestTierLongnumber) {
        ArrayList<String> result = new ArrayList<String>();
        for (String longnumber : shortestTierLongnumber) {
            result.add(this.subtractOneTierLongnumber(longnumber));
        }
        return result.toArray(new String[0]);
    }

    private String subtractOneTierLongnumber(String longnumber) {
        return longnumber.substring(0, longnumber.lastIndexOf("!"));
    }

    public String[] fillingLongnumberTree() {
        String topLongnumber = this.getTopLongnumber();
        TreeSet<String> result = new TreeSet<String>();
        for (String longnumber : this.longnumbers) {
            this.fillingLongnumberTree(result, longnumber, topLongnumber);
        }
        return result.toArray(new String[0]);
    }

    private void fillingLongnumberTree(Set<String> result, String longnumber, String topLongnumber) {
        result.add(longnumber);
        if (topLongnumber.equals(longnumber)) {
            return;
        }
        this.fillingLongnumberTree(result, this.subtractOneTierLongnumber(longnumber), topLongnumber);
    }

    public String[] getShortestTierLongnumber() {
        int shortestTierSize = this.getShortestTierSize();
        ArrayList<String> result = new ArrayList<String>();
        for (String longnumber : this.longnumbers) {
            result.add(this.fixedLongnumberToSize(longnumber, shortestTierSize));
        }
        return result.toArray(new String[0]);
    }

    public String fixedLongnumberToSize(String longnumber, int shortestTierSize) {
        int len = longnumber.split("!").length;
        if (len == shortestTierSize) {
            return longnumber;
        }
        return this.fixedLongnumberToSize(longnumber.substring(0, longnumber.lastIndexOf("!")), shortestTierSize);
    }
}

