/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.fm.ntp.TransferState;
import com.kingdee.eas.fm.ntp.TrusteeOutBillInfo;
import com.kingdee.eas.fm.ntp.TrusteeToPledgeBillInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Date;

public class NTPVerifyHelper {
    public static boolean verifyPermission(Context ctx, BOSUuid companyId, String permissionName) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)permissionName);
        return isPermission;
    }

    public static void verifyLock(Context ctx, IMutexServiceControl iMutex, String id) {
        if (!iMutex.requestObjIDForUpdate(id)) {
            String msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
            throw new RuntimeException(msg);
        }
    }

    public static void verifyIsCollect(boolean isCollect) throws NTPException {
        if (isCollect) {
            throw new NTPException(NTPException.BILL_IS_COLLECTED);
        }
    }

    public static void verifyIsIsPledgeToTrustee(boolean isPledgeToTrustee) throws NTPException {
        if (isPledgeToTrustee) {
            throw new NTPException(NTPException.ISPLEDGETOTRUSTEED);
        }
    }

    public static void verifyIsTrusteeOut(TrusteeOutBillInfo info) throws NTPException {
        if (info != null) {
            throw new NTPException(NTPException.ISTRUSTEEOUTED);
        }
    }

    public static void verifyOutPledgeOut(String infoId) throws NTPException {
        if (infoId != null) {
            throw new NTPException(NTPException.ISPLEDGEOUTED);
        }
    }

    public static void verifyIsPoolTrustee(int stateValue) throws NTPException {
        if (BillStateEnum.POOLTRUSTEE.getValue() != stateValue) {
            throw new NTPException(NTPException.POOLTRUSTEE_CAN_OUT);
        }
    }

    public static void verifyIsPoolTrustee(BillStateEnum billState) throws NTPException {
        if (BillStateEnum.POOLTRUSTEE != billState) {
            throw new NTPException(NTPException.ISNOT_POOLTRUSTEE);
        }
    }

    public static void verifyIsElec(BillMediumEnum billMedium) throws NTPException {
        if (BillMediumEnum.ELECTRONIC == billMedium) {
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"774_NTPVerifyHelper"));
        }
    }

    public static void verifyIsBeyondDate(Date expiredDate) throws NTPException {
        if (expiredDate.before(new Date())) {
            throw new NTPException(NTPException.ISBEYONDDATE);
        }
    }

    public static void verifyBillState(BillStateEnum billState) throws NTPException {
        boolean needAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
        if (needAudit && BillStateEnum.Audit != billState || !needAudit && BillStateEnum.SAVED != billState) {
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"775_NTPVerifyHelper"));
        }
    }

    public static void verifyIsTrustee(boolean isTrustee) throws NTPException {
        if (isTrustee) {
            throw new NTPException(NTPException.ISTRUSTEED);
        }
    }

    public static void verifyIsPledge(boolean isPledge, boolean isDisPledge) throws NTPException {
        if (isPledge && !isDisPledge) {
            throw new NTPException(NTPException.ISPLEDGED);
        }
    }

    public static void verifyIsPledgeToTrustee(boolean state) throws NTPException {
        if (state) {
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"776_NTPVerifyHelper"));
        }
    }

    public static void verifyIsTrusteeToPledge(TrusteeToPledgeBillInfo info) throws NTPException {
        if (null != info && TransferState.TRANSFERED != info.getBillState()) {
            throw new NTPException(NTPException.ISTRUSTEETOPLEDGED);
        }
    }
}

