/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.NoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.NoteReceivableOpUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.nt.app.util.ReceivableBillCommitToBEUtil;
import com.kingdee.eas.fm.ntp.BillPoolJournalFactory;
import com.kingdee.eas.fm.ntp.BillPoolJournalInfo;
import com.kingdee.eas.fm.ntp.BizProcessTypeEnum;
import com.kingdee.eas.fm.ntp.DirectionEnum;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.fm.ntp.NTPVerifyHelper;
import com.kingdee.eas.fm.ntp.PledgeBillCollection;
import com.kingdee.eas.fm.ntp.PledgeBillEntryCollection;
import com.kingdee.eas.fm.ntp.PledgeBillEntryInfo;
import com.kingdee.eas.fm.ntp.PledgeBillFactory;
import com.kingdee.eas.fm.ntp.PledgeBillInfo;
import com.kingdee.eas.fm.ntp.PledgeBillStatusEnum;
import com.kingdee.eas.fm.ntp.PledgeTypeEnum;
import com.kingdee.eas.fm.ntp.PoolTypeEnum;
import com.kingdee.eas.fm.ntp.app.AbstractPledgeBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class PledgeBillControllerBean
extends AbstractPledgeBillControllerBean {
    private static final long serialVersionUID = 5742762844431294556L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ntp.app.PledgeBillControllerBean");
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> srcList = new ArrayList<String>();
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"PledgeBillControllerBean.submit");
        IObjectPK pk = super._submit(ctx, model);
        PerfLogRecorder.endRecord((String)pfLogId);
        PledgeBillInfo info = (PledgeBillInfo)model;
        String pfLogId_afterSubmit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"PledgeBillControllerBean.afterSubmit");
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getEntrys().get(i).getReceivableBill();
            recInfo.setInPledgeID(pk.toString());
            recInfo.setIsPoolPledge(true);
            recInfo.setTrusteeOutBill(null);
            srcList.add(recInfo.getId().toString());
            coll.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(coll);
        FMHelper.saveBOTRelation((Context)ctx, srcList, (String)info.getId().toString());
        PerfLogRecorder.endRecord((String)pfLogId_afterSubmit);
        return pk;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = PledgeBillFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            PledgeBillInfo info = (PledgeBillInfo)colls.get(i);
            if (!info.getBillStatus().equals((Object)PledgeBillStatusEnum.SUBMIT)) {
                throw new NTPException(NTPException.SUBMIT_CAN_AUDIT);
            }
            info.setBillStatus(PledgeBillStatusEnum.AUDIT);
            info.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            info.setAuditDate(DateUtil.getDayBegin());
        }
        if (colls.size() > 0) {
            super.update(ctx, colls);
        }
    }

    @Override
    protected void _inPoolConfirm(Context ctx, String billId) throws BOSException, EASBizException {
        PledgeBillInfo info = this.getPledgeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_pledgeBillInPool_05confirm")) {
            throw new NTPException(NTPException.NO_POOLCONFIRM_PERMISSION);
        }
        if (!info.getBillStatus().equals((Object)PledgeBillStatusEnum.AUDIT)) {
            throw new NTPException(NTPException.AUDIT_CAN_INPOOL);
        }
        info.setBillStatus(PledgeBillStatusEnum.INPOOL);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setConfirmer(userInfo);
        info.setConfirmDate(DateUtil.getDayBegin());
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        BillPoolJournalInfo journalInfo = this.buildJournalInfo(ctx, info);
        BillPoolJournalFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)journalInfo);
        CoreBaseCollection receivableColl = this.getReceivableBillColls(ctx, info);
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
    }

    private void doInPoolConfirm(Context ctx, PledgeBillInfo info) throws EASBizException, BOSException {
        info.setBillStatus(PledgeBillStatusEnum.INPOOL);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setConfirmer(userInfo);
        info.setConfirmDate(DateUtil.getDayBegin());
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        BillPoolJournalInfo journalInfo = this.buildJournalInfo(ctx, info);
        BillPoolJournalFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)journalInfo);
        CoreBaseCollection receivableColl = this.getReceivableBillColls(ctx, info);
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
    }

    @Override
    protected void _outPoolConfirm(Context ctx, String billId) throws BOSException, EASBizException {
        PledgeBillInfo info = this.getPledgeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_billoutpool_05outPoolConfirm")) {
            throw new NTPException(NTPException.NO_OUTPOOLCONFIRM_PERMISSION);
        }
        if (!info.getBillStatus().equals((Object)PledgeBillStatusEnum.AUDIT)) {
            throw new NTPException(NTPException.AUDIT_CAN_OUTPOOL);
        }
        info.setBillStatus(PledgeBillStatusEnum.OUTPOOL);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setConfirmer(userInfo);
        info.setConfirmDate(DateUtil.getDayBegin());
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
        BillPoolJournalInfo journalInfo = this.buildJournalInfo(ctx, info);
        BillPoolJournalFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)journalInfo);
        CoreBaseCollection receivableColl = this.getReceivableBillColls(ctx, info);
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
    }

    private BillPoolJournalInfo buildJournalInfo(Context ctx, PledgeBillInfo info) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getPledgeDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.PLEDGE);
        if (info.getPledgeType() == PledgeTypeEnum.INPOOL) {
            journalInfo.setBizProcessType(BizProcessTypeEnum.PLEDGE_IN);
            journalInfo.setDirection(DirectionEnum.INFLOW);
            journalInfo.setInAmount(info.getAmount());
        } else {
            journalInfo.setBizProcessType(BizProcessTypeEnum.PLEDGE_OUT);
            journalInfo.setDirection(DirectionEnum.OUTFLOW);
            journalInfo.setOutAmount(info.getAmount());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPledgee())) {
            BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPledgee().getId().toString()));
            journalInfo.setCooperativeBank(bankInfo);
            journalInfo.setCooperativeBankName(bankInfo.getName());
        }
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        return journalInfo;
    }

    private CoreBaseCollection getReceivableBillColls(Context ctx, PledgeBillInfo info) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            idSet.add(info.getEntrys().get(i).getReceivableBill().getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        Date currentDate = DateUtil.getDayBegin();
        BankInfo bankInfo = new BankInfo();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPledgee())) {
            bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPledgee().getId().toString()));
        }
        CoreBaseCollection receivableColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getCollection(evi);
        if (info.getPledgeType() == PledgeTypeEnum.INPOOL) {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo receivableInfo = (ReceivableBillInfo)receivableColl.get(i);
                receivableInfo.setBillState(BillStateEnum.POOLPLEDGE);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
                    receivableInfo.setCooperativeBank(bankInfo);
                    receivableInfo.setCooperativeBankName(bankInfo.getName());
                }
                receivableInfo.setInPoolDate(currentDate);
            }
        } else {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo receivableInfo = (ReceivableBillInfo)receivableColl.get(i);
                receivableInfo.setCooperativeBank(null);
                receivableInfo.setCooperativeBankName(null);
                boolean isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
                if (isNeedAudit) {
                    receivableInfo.setBillState(BillStateEnum.Audit);
                } else {
                    receivableInfo.setBillState(BillStateEnum.SAVED);
                }
                receivableInfo.setInPledgeID(null);
                receivableInfo.setIsPoolPledge(false);
                receivableInfo.setOutPledgeID(null);
                receivableInfo.setOutPoolDate(currentDate);
            }
        }
        return receivableColl;
    }

    @Override
    protected void _unaudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = PledgeBillFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            PledgeBillInfo info = (PledgeBillInfo)colls.get(i);
            if (!info.getBillStatus().equals((Object)PledgeBillStatusEnum.AUDIT)) {
                throw new NTPException(NTPException.UNAUDIT_CAN_INPOOL);
            }
            info.setBillStatus(PledgeBillStatusEnum.SUBMIT);
            info.setAuditor(null);
            info.setAuditDate(null);
        }
        if (colls.size() > 0) {
            super.update(ctx, colls);
        }
    }

    @Override
    protected Map _cancelInPoolConfirm(Context ctx, String billId) throws BOSException, EASBizException {
        PledgeBillInfo info = this.getPledgeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        BatchExecuteResult result = new BatchExecuteResult();
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_pledgeBillInPool_06cancelconfirm")) {
            throw new NTPException(NTPException.NO_CANCELPOOLCONFIRM_PERMISSION);
        }
        if (!info.getBillStatus().equals((Object)PledgeBillStatusEnum.INPOOL)) {
            throw new NTPException(NTPException.INPOOL_CAN_CANCELINPOOL);
        }
        PledgeBillEntryCollection entryColl = info.getEntrys();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < entryColl.size(); ++i) {
            PledgeBillEntryInfo entryInfo = entryColl.get(i);
            ReceivableBillInfo recInfo = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(entryInfo.getReceivableBill().getId()));
            if (recInfo.getOutPledgeID() != null) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"720_PledgeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"721_PledgeBillControllerBean", (Locale)ctx.getLocale()));
            }
            if (recInfo.getBillState().getValue() != 11) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"720_PledgeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"722_PledgeBillControllerBean", (Locale)ctx.getLocale()));
            }
            if (recInfo.isIsCollect()) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"720_PledgeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"723_PledgeBillControllerBean", (Locale)ctx.getLocale()));
            }
            if (recInfo.isIsPledgeToTrustee()) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"720_PledgeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"724_PledgeBillControllerBean", (Locale)ctx.getLocale()));
            }
            if (!info.isIsCommitToBE() || recInfo.getBankReturnStatus() == null || recInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.COMMIT_FAIL) || recInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_FAIL)) continue;
            result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"720_PledgeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"725_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        }
        if (result.getDetailMsgList().size() > 0) {
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"726_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            info.setBillStatus(PledgeBillStatusEnum.AUDIT);
            info.setConfirmer(null);
            info.setConfirmDate(null);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
            BillPoolJournalFactory.getLocalInstance(ctx).delete("where billID='" + info.getId().toString() + "'");
            CoreBaseCollection receivableColl = this.getCancelReceivableBillColls(ctx, info);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"727_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    @Override
    protected void _cancelOutPoolConfirm(Context ctx, String billId) throws BOSException, EASBizException {
        PledgeBillInfo info = this.getPledgeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_billoutpool_06canceloutPoolConfirm")) {
            throw new NTPException(NTPException.NO_OUTPOOLCONFIRM_PERMISSION);
        }
        if (!info.getBillStatus().equals((Object)PledgeBillStatusEnum.OUTPOOL)) {
            throw new NTPException(NTPException.OUTPOOL_CAN_CANCELOUTPOOL);
        }
        info.setBillStatus(PledgeBillStatusEnum.AUDIT);
        info.setConfirmer(null);
        info.setConfirmDate(null);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
        BillPoolJournalFactory.getLocalInstance(ctx).delete("where billID='" + info.getId() + "'");
        CoreBaseCollection receivableColl = this.getCancelReceivableBillColls(ctx, info);
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
    }

    private CoreBaseCollection getCancelReceivableBillColls(Context ctx, PledgeBillInfo info) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            idSet.add(info.getEntrys().get(i).getReceivableBill().getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        CoreBaseCollection receivableColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getCollection(evi);
        if (info.getPledgeType() == PledgeTypeEnum.INPOOL) {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo receivableInfo = (ReceivableBillInfo)receivableColl.get(i);
                receivableInfo.setInPoolDate(null);
                boolean isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
                if (isNeedAudit) {
                    receivableInfo.setBillState(BillStateEnum.Audit);
                    continue;
                }
                receivableInfo.setBillState(BillStateEnum.SAVED);
            }
        } else {
            BankInfo bankInfo = new BankInfo();
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPledgee())) {
                bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPledgee().getId().toString()));
            }
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo receivableInfo = (ReceivableBillInfo)receivableColl.get(i);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
                    receivableInfo.setCooperativeBank(bankInfo);
                    receivableInfo.setCooperativeBankName(bankInfo.getName());
                }
                receivableInfo.setBillState(BillStateEnum.POOLPLEDGE);
                receivableInfo.setOutPoolDate(null);
                receivableInfo.setOutPledgeID(info.getId().toString());
                String pledgeId = "";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FID from t_ntp_pledgeBill where fid in (select fparentid from t_ntp_pledgeBillentry where FReceivableBillID = '" + receivableInfo.getId().toString() + "') and fpledgeType=1"));
                try {
                    while (rs.next()) {
                        pledgeId = rs.getString("FID");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                receivableInfo.setInPledgeID(pledgeId);
                receivableInfo.setIsPoolPledge(true);
            }
        }
        return receivableColl;
    }

    @Override
    protected Map _commitToBE(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceivableBillCollection coll;
        BatchExecuteResult result = new BatchExecuteResult();
        PledgeBillInfo info = this.getPledgeBillInfo(ctx, pk, this.getSelector());
        result = this.beforeCommit(ctx, info, result, coll = this.getReceivableColl(info));
        if (result.getDetailMsgList().size() > 0) {
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"728_PledgeBillControllerBean", (Locale)ctx.getLocale()));
            return result;
        }
        logger.debug((Object)"begin to commitToBE PledgeBillInfo");
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
        }
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info, coll);
        }
        result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"729_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        return result;
    }

    private void doCommitBE(Context ctx, NoteReceivableOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, PledgeBillInfo info, ReceivableBillCollection coll) throws EASBizException, BOSException {
        try {
            this.beforeProcess(ctx, info.isIsCommitToBE(), infoList);
            NoteReceivableBody body = this.parseRequestBody(ctx, totalAmount, infoList, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.NOTE_PLEDGE);
            NoteReceivableDetail[] detail = recOpUtil.noteRecOp(ctx, bizInfo, body);
            info.setIsCommitToBE(true);
            this.updatePartial(ctx, (CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBE"}));
            this.afterProcess(ctx, infoList, detail);
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                logger.error((Object)"---------\u629b\u51fa\u94f6\u4f01\u53c2\u6570\u89e3\u6790\u5f02\u5e38--------------------");
                logger.error((Object)err);
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void beforeProcess(Context ctx, boolean isCommitBE, List<ReceivableBillInfo> infoList) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo info = infoList.get(i);
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            if (isCommitBE && info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                info.setBankReturnStatus(null);
                info.setBankReturnMsg(null);
            }
            recBillCollection.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recBillCollection);
    }

    private BatchExecuteResult beforeCommit(Context ctx, PledgeBillInfo info, BatchExecuteResult result, ReceivableBillCollection coll) {
        if (info.getBillMedium() != BillMediumEnum.ELECTRONIC || info.getBillStatus() != PledgeBillStatusEnum.AUDIT) {
            result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"730_PledgeBillControllerBean", (Locale)ctx.getLocale()));
            return result;
        }
        boolean isBEProcessing = false;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() != null && !BankReturnStatusEnum.EB_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)entry.getBankReturnStatus())) continue;
            isBEProcessing = true;
            break;
        }
        if (info.isIsCommitToBE() && isBEProcessing) {
            result.getDetailMsgList().add(EASResource.getString((String)NTP_RES, (String)"012_BE_PROCESSING_WAITING"));
            return result;
        }
        boolean isBEFinished = true;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (BankReturnStatusEnum.BANK_FAIL.equals((Object)entry.getBankReturnStatus()) || BankReturnStatusEnum.BANK_SUCCESS.equals((Object)entry.getBankReturnStatus())) continue;
            isBEFinished = false;
            break;
        }
        if (info.isIsCommitToBE() && isBEFinished) {
            result.getDetailMsgList().add(EASResource.getString((String)NTP_RES, (String)"043_COMMITTOBE_FINISHED"));
            return result;
        }
        return result;
    }

    private NoteReceivableBody parseRequestBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, PledgeBillInfo info) throws EASBizException, BOSException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseDetail(Context ctx, List<ReceivableBillInfo> infoList, PledgeBillInfo info) throws EASBizException, BOSException {
        BankInfo bankInfo = info.getPledgee();
        NoteReceivableDetail[] details = null;
        if (infoList.size() > 0) {
            details = new NoteReceivableDetail[infoList.size()];
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo recInfo = infoList.get(i);
                NoteReceivableDetail detail = new NoteReceivableDetail();
                detail.setDetailSeqID(recInfo.getDetailSeqID());
                detail.setDetailBizNo(recInfo.getDetailSeqID());
                detail.setBillNo(recInfo.getDraftNumber());
                detail.setDraftType(recInfo.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
                detail.setTransferFlag("EM01");
                detail.setOppAccNo("0");
                detail.setOppAccName(bankInfo.getName());
                BEBankInfo beInfo = null;
                if (bankInfo.getAccountBank() != null) {
                    beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                }
                if (beInfo != null) {
                    detail.setOppCnapsCode(beInfo.getNumber());
                }
                detail.setOppAmount(info.getAmount().setScale(2).toString());
                detail.setBookingDate(DraftBEUtil.date2String((Date)recInfo.getIssuesDate(), (String)"yyyyMMddHHmmss"));
                detail.setDueDate(DraftBEUtil.date2String((Date)recInfo.getExpiredDate(), (String)"yyyyMMdd"));
                detail.setDesc(recInfo.getDescription());
                details[i] = detail;
            }
        }
        return details;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entrys.*");
        selector.add("entrys.receivableBill.*");
        selector.add("entrys.receivableBill.nttype.*");
        selector.add("entrys.receivableBill.holderAccount.id");
        selector.add("entrys.receivableBill.holderAccount.name");
        selector.add("entrys.receivableBill.holderAccount.bankAccountNumber");
        return selector;
    }

    @Override
    protected Map _synStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        int success = 0;
        PledgeBillCollection coll = this.getPledgeBillCollection(ctx, view);
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil();
        for (int i = 0; i < coll.size(); ++i) {
            PledgeBillInfo info = coll.get(i);
            ReceivableBillCollection recColl = this.getReceivableColl(info);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < coll.size(); ++j) {
                    ReceivableBillInfo entry = recColl.get(j);
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncStatus(ctx, recOpUtil, batchSeqMap);
                this._isAllBankSuccess(ctx, (IObjectValue)info);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idSet.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSyncStatus(Context ctx, NoteReceivableOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess(ctx, infoList, details);
        }
    }

    private NoteReceivableDetail[] queryRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    private ReceivableBillCollection getReceivableColl(PledgeBillInfo info) {
        ReceivableBillCollection coll = new ReceivableBillCollection();
        PledgeBillEntryCollection entryColl = info.getEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            coll.add(entryColl.get(i).getReceivableBill());
        }
        return coll;
    }

    private void afterProcess(Context ctx, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo recInfo = infoList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.NT180006);
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
    }

    @Override
    protected Map _releaseFailedBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PledgeBillInfo info = this.getPledgeBillInfo(ctx, pk, this.getSelector());
        ReceivableBillCollection coll = this.getFailedRecBill(info);
        if (info.isIsCommitToBE() && coll.size() > 0 && coll.size() < info.getEntrys().size()) {
            StringBuffer buffer = new StringBuffer("(");
            for (int i = 0; i < coll.size(); ++i) {
                buffer.append("'" + coll.get(i).getId() + "',");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(")");
            DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FIsPoolPledge=0,FInPledgeID=null,FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null where FID in " + buffer.toString()));
            DbUtil.execute((Context)ctx, (String)("delete from t_ntp_pledgeBillEntry where FReceivableBillID in " + buffer.toString()));
            int newCount = info.getEntrys().size() - coll.size();
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < coll.size(); ++i) {
                amount = i == 0 ? coll.get(i).getBillAmt() : amount.add(coll.get(i).getBillAmt());
            }
            amount = info.getAmount().subtract(amount);
            DbUtil.execute((Context)ctx, (String)("update t_ntp_pledgeBill set Fcount = " + newCount + ",FAmount = " + amount + " where FID= '" + info.getId() + "'"));
            this._isAllBankSuccess(ctx, (IObjectValue)info);
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"731_PledgeBillControllerBean", (Locale)ctx.getLocale()) + coll.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"608_EndorsementBillListUI", (Locale)ctx.getLocale()));
        } else {
            result.getDetailMsgList().add(EASResource.getString((String)NTP_RES, (String)"013_CONDITION_CAN_RELEASE"));
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"728_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private ReceivableBillCollection getFailedRecBill(PledgeBillInfo info) {
        ReceivableBillCollection coll = new ReceivableBillCollection();
        PledgeBillEntryCollection entryColl = info.getEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            ReceivableBillInfo recInfo = entryColl.get(i).getReceivableBill();
            if (!BankReturnStatusEnum.COMMIT_FAIL.equals((Object)recInfo.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_FAIL.equals((Object)recInfo.getBankReturnStatus())) continue;
            coll.add(recInfo);
        }
        return coll;
    }

    @Override
    protected Map _delete(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        PledgeBillCollection coll = this.getPledgeBillCollection(ctx, view);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        StringBuffer buffer = null;
        PledgeBillInfo info = null;
        int success = 0;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                buffer = new StringBuffer("(");
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_pledgeBillInPool_02delete")) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                if (1 != info.getBillStatus().getValue()) {
                    throw new NTPException(NTPException.SUBMIT_CAN_DELETE);
                }
                PledgeBillEntryCollection entryColl = info.getEntrys();
                for (int j = 0; j < entryColl.size(); ++j) {
                    buffer.append("'" + entryColl.get(j).getReceivableBill().getId() + "',");
                }
                buffer.deleteCharAt(buffer.length() - 1);
                buffer.append(")");
                DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FIsPoolPledge=0,FInPledgeID=null,FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null where FID in " + buffer.toString()));
                BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(info.getId().toString(), info.getBOSType().toString());
                PledgeBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"732_PledgeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"64_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (success == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected void _isAllBankSuccess(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PledgeBillInfo pledgeInfo = (PledgeBillInfo)info;
        boolean flag = true;
        PledgeBillEntryCollection entryColl = pledgeInfo.getEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            ReceivableBillInfo recInfo = entryColl.get(i).getReceivableBill();
            if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) continue;
            flag = false;
            break;
        }
        if (flag) {
            pledgeInfo.setBillStatus(PledgeBillStatusEnum.INPOOL);
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            pledgeInfo.setConfirmer(userInfo);
            pledgeInfo.setConfirmDate(DateUtil.getDayBegin());
            this.update(ctx, (IObjectPK)new ObjectUuidPK(pledgeInfo.getId()), (CoreBaseInfo)pledgeInfo);
            BillPoolJournalInfo journalInfo = this.buildJournalInfo(ctx, pledgeInfo);
            BillPoolJournalFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)journalInfo);
            CoreBaseCollection receivableColl = this.getReceivableBillColls(ctx, pledgeInfo);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
        }
    }
}

