/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.PaperNoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.PaperNoteRecOpUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.PaperNoteBizInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.nt.app.util.ReceivableBillCommitToBEUtil;
import com.kingdee.eas.fm.ntp.BillPoolJournalFactory;
import com.kingdee.eas.fm.ntp.BillPoolJournalInfo;
import com.kingdee.eas.fm.ntp.BillTransBizType;
import com.kingdee.eas.fm.ntp.BizProcessTypeEnum;
import com.kingdee.eas.fm.ntp.DirectionEnum;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.fm.ntp.NTPUtil;
import com.kingdee.eas.fm.ntp.NTPVerifyHelper;
import com.kingdee.eas.fm.ntp.PledgeBillStatusEnum;
import com.kingdee.eas.fm.ntp.PoolTypeEnum;
import com.kingdee.eas.fm.ntp.TrusteeOutBillCollection;
import com.kingdee.eas.fm.ntp.TrusteeOutBillFactory;
import com.kingdee.eas.fm.ntp.TrusteeOutBillInfo;
import com.kingdee.eas.fm.ntp.app.AbstractTrusteeOutBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class TrusteeOutBillControllerBean
extends AbstractTrusteeOutBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ntp.app.TrusteeOutBillControllerBean");
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String NTP_RESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    private IMutexServiceControl iMutex = null;
    private ReceivableBillCollection recCollForLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _submit(Context ctx, IObjectValue model, Set recIdSet) throws BOSException, EASBizException {
        TrusteeOutBillInfo info = (TrusteeOutBillInfo)model;
        ReceivableBillCollection coll = this.getRecCollection(ctx, recIdSet);
        info.setBillState(PledgeBillStatusEnum.SUBMIT);
        info.setBizDate(new Date());
        info.setCurrency(coll.get(0).getCurrency());
        info.setNtType(coll.get(0).getNtType());
        info.setCompany(coll.get(0).getHolder());
        ArrayList<String> srcIdList = new ArrayList<String>();
        BatchExecuteResult result = this.beforeSubmit(ctx, info, coll, srcIdList);
        if (srcIdList.size() < coll.size()) {
            return result;
        }
        try {
            this.iMutex.batchRequestObjIDForUpdate(srcIdList);
            info.setCount(coll.size());
            IObjectPK pk = super._submit(ctx, (IObjectValue)info);
            this.afterSubmit(ctx, info, coll, srcIdList, pk);
        }
        finally {
            this.iMutex.batchReleaseObjIDForUpdate(srcIdList);
        }
        return null;
    }

    @Override
    protected Map _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeOutBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection baseColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeOutBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeoutbill_03audit")) {
                    throw new NTPException(NTPException.NO_AUDIT_AUTHRIZED);
                }
                if (PledgeBillStatusEnum.SUBMIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEOUTBILL_CANNOT_AUDIT);
                }
                info.setBillState(PledgeBillStatusEnum.AUDIT);
                UserInfo auditUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                info.setAuditor(auditUser);
                info.setAuditDate(DATE_FORMAT.parse(DATE_FORMAT.format(new Date())));
                baseColl.add((CoreBaseInfo)info);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"099_TRUSTEEOUTBILL_AUDIT_FAIL", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (baseColl.size() > 0) {
            this.updateBatchData(ctx, baseColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEOUT_AUDIT);
        }
        if (baseColl.size() == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"ALL_AUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(baseColl.size()), String.valueOf(coll.size() - baseColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeOutBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection baseColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeOutBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeoutbill_04unaudit")) {
                    throw new NTPException(NTPException.NO_UNAUDIT_AUTHRIZED);
                }
                if (PledgeBillStatusEnum.AUDIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEOUTBILL_CANNOT_UNAUDIT);
                }
                if (info.isIsCommitToBE() && !NTPUtil.isAllBEFailed(ctx, info.getReceivableEntrys())) {
                    throw new NTPException(NTPException.BE_CANNOT_UNAUDIT);
                }
                info.setBillState(PledgeBillStatusEnum.SUBMIT);
                info.setAuditor(null);
                info.setAuditDate(null);
                baseColl.add((CoreBaseInfo)info);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"101_TRUSTEEOUTBILL_UNAUDIT_FAIL", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (baseColl.size() > 0) {
            this.updateBatchData(ctx, baseColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEOUT_UNAUDIT);
        }
        if (baseColl.size() == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"ALL_UNAUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(baseColl.size()), String.valueOf(coll.size() - baseColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _delete(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        StringBuffer truIdsBuffer = new StringBuffer("(");
        StringBuffer recIdsBuffer = new StringBuffer("(");
        int deletedIdsCount = 0;
        TrusteeOutBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        TrusteeOutBillInfo info = null;
        ReceivableBillCollection recColl = null;
        this.recCollForLog = new ReceivableBillCollection();
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeoutbill_02delete")) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                if (PledgeBillStatusEnum.SUBMIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEOUTBILL_CANNOT_DELETE);
                }
                ++deletedIdsCount;
                DbUtil.execute((Context)ctx, (String)("delete from T_bot_relation  where FDESTOBJECTID = '" + info.getId().toString() + "' and FDESTENTITYID ='" + info.getBOSType().toString() + "'"));
                truIdsBuffer.append("'" + info.getId().toString() + "',");
                recColl = info.getReceivableEntrys();
                this.recCollForLog.addCollection(recColl);
                for (int j = 0; j < recColl.size(); ++j) {
                    recIdsBuffer.append("'" + recColl.get(j).getId().toString() + "',");
                }
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"100_TRUSTEEOUTBILL_DELETE_FAIL", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (deletedIdsCount > 0) {
            truIdsBuffer.deleteCharAt(truIdsBuffer.length() - 1);
            truIdsBuffer.append(")");
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_TrusteeOutBill  where FID in " + truIdsBuffer.toString()));
            if (recIdsBuffer.length() > 1) {
                recIdsBuffer.deleteCharAt(recIdsBuffer.length() - 1);
                recIdsBuffer.append(")");
                DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FTrusteeOutBillID=null,FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null  where FID in " + recIdsBuffer.toString()));
            }
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEOUT_DELETE);
        }
        if (deletedIdsCount == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(deletedIdsCount), String.valueOf(coll.size() - deletedIdsCount)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _outPoolConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeOutBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection recCoreColl = new CoreBaseCollection();
        CoreBaseCollection trusteeOutBillCoreColl = new CoreBaseCollection();
        CoreBaseCollection journalColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeOutBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                ReceivableBillCollection entryColl = info.getReceivableEntrys();
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeoutbill_05confirm")) {
                    throw new NTPException(NTPException.NO_OUTPOOLCONFIRM_PERMISSION);
                }
                if (PledgeBillStatusEnum.AUDIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEOUTBILL_CANNOT_OUTPOOL);
                }
                this.setValue4TrusteeOutBill(ctx, info, trusteeOutBillCoreColl, true);
                this.updateBillPoolJournal(ctx, info, journalColl);
                this.setValue4ReceivableBill(ctx, info, recCoreColl, true);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"102_TRUSTEEOUTBILL_OUTPOOL_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (trusteeOutBillCoreColl.size() > 0) {
            this.updateBatchData(ctx, trusteeOutBillCoreColl);
            BillPoolJournalFactory.getLocalInstance(ctx).addnewBatchData(journalColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recCoreColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEOUT_CONFIRM);
        }
        if (trusteeOutBillCoreColl.size() == coll.size()) {
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"103_ALL_OUTPOOL_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"104_OUTPOOL_RESULT", (String[])new String[]{String.valueOf(trusteeOutBillCoreColl.size()), String.valueOf(coll.size() - trusteeOutBillCoreColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _cancelOutPoolConfirm(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeOutBillInfo info = this.getInfoById(ctx, id);
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeoutbill_06cancelconfirm")) {
            throw new NTPException(NTPException.NO_CANCELOUTPOOLCONFIRM_PERMISSION);
        }
        if (PledgeBillStatusEnum.OUTPOOL != info.getBillState()) {
            throw new NTPException(NTPException.TRUSTEEOUTBILL_CANNOT_CANCELOUTPOOL);
        }
        ReceivableBillCollection recColl = info.getReceivableEntrys();
        CoreBaseCollection recCoreColl = new CoreBaseCollection();
        ReceivableBillInfo recInfo = null;
        for (int i = 0; i < recColl.size(); ++i) {
            try {
                recInfo = recColl.get(i);
                NTPVerifyHelper.verifyIsElec(recInfo.getBillMedium());
                NTPVerifyHelper.verifyIsBeyondDate(recInfo.getExpiredDate());
                NTPVerifyHelper.verifyBillState(recInfo.getBillState());
                NTPVerifyHelper.verifyIsCollect(recInfo.isIsCollect());
                NTPVerifyHelper.verifyIsTrustee(recInfo.isIsTrustee());
                NTPVerifyHelper.verifyIsPledge(recInfo.isIsPledge(), recInfo.isIsDisPledge());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"105_TRUSTEEOUTBILL_CANCELOUTPOOL_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (result.getDetailMsgList().size() == 0) {
            this.setValue4TrusteeOutBill(ctx, info, null, false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_BillPoolJournal  where FBillID ='" + info.getId().toString() + "'"));
            this.setValue4ReceivableBill(ctx, info, recCoreColl, false);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recCoreColl);
            result.setSummaryMsg(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"106_CANCELOUTPOOL_SUCCESS"));
        } else {
            result.setSummaryMsg(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"107_CANCELOUTPOOL_FAIL"));
        }
        return result;
    }

    private ReceivableBillCollection getRecCollection(Context ctx, Set recIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("draftNumber");
        selector.add("billState");
        selector.add("isCollect");
        selector.add("trusteeToPledgeBill.id");
        selector.add("trusteeOutBill.id");
        selector.add("currency.id");
        selector.add("ntType.id");
        selector.add("holder.id");
        selector.add(new SelectorItemInfo("holder.name"));
        view.setSelector(selector);
        ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
        return coll;
    }

    private BatchExecuteResult beforeSubmit(Context ctx, TrusteeOutBillInfo info, ReceivableBillCollection coll, List<String> srcIdList) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        this.iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ReceivableBillInfo recInfo = null;
        String recId = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                recInfo = coll.get(i);
                recId = recInfo.getId().toString();
                NTPVerifyHelper.verifyLock(ctx, this.iMutex, recInfo.getId().toString());
                NTPVerifyHelper.verifyIsTrusteeOut(recInfo.getTrusteeOutBill());
                NTPVerifyHelper.verifyIsTrusteeToPledge(recInfo.getTrusteeToPledgeBill());
                NTPVerifyHelper.verifyIsPoolTrustee(recInfo.getBillState().getValue());
                NTPVerifyHelper.verifyIsCollect(recInfo.isIsCollect());
                srcIdList.add(recId);
                info.getReceivableEntrys().add(recInfo);
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"cannotOutPoolTrustee", (String[])new String[]{recInfo.getDraftNumber(), e.getMessage()}));
            }
        }
        if (result.getDetailMsgList().size() > 0) {
            result.setSummaryMsg(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"billCannotSubmit"));
        }
        return result;
    }

    private void afterSubmit(Context ctx, TrusteeOutBillInfo info, ReceivableBillCollection coll, List<String> srcIdList, IObjectPK pk) throws EASBizException, BOSException {
        ReceivableBillInfo recInfo = null;
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            recInfo.setTrusteeOutBill(info);
            baseColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(baseColl);
        FMHelper.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
        NTPUtil.addBillTransLogByColl(ctx, coll, BillTransBizType.TRUSTEEOUT_SUBMIT);
    }

    private void setValue4TrusteeOutBill(Context ctx, TrusteeOutBillInfo info, CoreBaseCollection trusteeOutBillCoreColl, boolean isOutPoolConfirm) throws EASBizException, BOSException {
        if (isOutPoolConfirm) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            info.setBillState(PledgeBillStatusEnum.OUTPOOL);
            info.setConfirmor(userInfo);
            info.setConfirmDate(DateUtil.getDayBegin());
            trusteeOutBillCoreColl.add((CoreBaseInfo)info);
        } else {
            info.setBillState(PledgeBillStatusEnum.AUDIT);
            info.setConfirmor(null);
            info.setConfirmDate(null);
        }
    }

    private void updateBillPoolJournal(Context ctx, TrusteeOutBillInfo info, CoreBaseCollection journalColl) throws EASBizException, BOSException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTrusteeDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_OUT);
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(info.getTotalAmout());
        journalInfo.setCooperativeBank(info.getTrustee());
        journalInfo.setCooperativeBankName(info.getTrustee().getName());
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        journalColl.add((CoreBaseInfo)journalInfo);
    }

    private void setValue4ReceivableBill(Context ctx, TrusteeOutBillInfo info, CoreBaseCollection recCoreColl, boolean isOutPoolConfirm) {
        ReceivableBillCollection coll = info.getReceivableEntrys();
        ReceivableBillInfo recInfo = null;
        if (isOutPoolConfirm) {
            boolean isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
            for (int i = 0; i < coll.size(); ++i) {
                recInfo = coll.get(i);
                if (isNeedAudit) {
                    recInfo.setBillState(BillStateEnum.Audit);
                } else {
                    recInfo.setBillState(BillStateEnum.SAVED);
                }
                recInfo.setOutPoolDate(DateUtil.getDayBegin());
                recInfo.setCooperativeBank(null);
                recInfo.setCooperativeBankName(null);
                recInfo.setIsPoolTrustee(false);
                recCoreColl.add((CoreBaseInfo)recInfo);
            }
        } else {
            for (int i = 0; i < coll.size(); ++i) {
                recInfo = coll.get(i);
                recInfo.setBillState(BillStateEnum.POOLTRUSTEE);
                recInfo.setOutPoolDate(null);
                recInfo.setCooperativeBank(info.getTrustee());
                recInfo.setCooperativeBankName(info.getTrustee().getName());
                recInfo.setIsPoolTrustee(true);
                recCoreColl.add((CoreBaseInfo)recInfo);
            }
        }
    }

    private TrusteeOutBillCollection getCollByIDSet(Context ctx, Set idSet) throws BOSException {
        SelectorItemCollection selector = this.getSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(selector);
        TrusteeOutBillCollection coll = TrusteeOutBillFactory.getLocalInstance(ctx).getTrusteeOutBillCollection(evi);
        return coll;
    }

    private TrusteeOutBillInfo getInfoById(Context ctx, String id) throws BOSException {
        SelectorItemCollection sellector = this.getSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sellector);
        return this.getTrusteeOutBillCollection(ctx, evi).get(0);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("billState");
        selector.add("auditor.id");
        selector.add("auditDate");
        selector.add("company.id");
        selector.add("trustee.id");
        selector.add("trusteeDate");
        selector.add("confirmDate");
        selector.add("totalAmout");
        selector.add("isCommitToBE");
        selector.add("count");
        selector.add("currency.id");
        selector.add("trustee.name");
        selector.add("receivableEntrys.*");
        selector.add("receivableEntrys.ntType.group");
        selector.add("receivableEntrys.holder.id");
        selector.add("receivableEntrys.payeeAccount.*");
        selector.add("receivableEntrys.holderAccount.*");
        selector.add("receivableEntrys.cooperativeBank.id");
        return selector;
    }

    @Override
    protected Map _synStatus(Context ctx, Set ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{ids.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivableEntrys.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.name"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.bankAccountNumber"));
        view.setSelector(sic);
        int success = 0;
        TrusteeOutBillCollection colls = this.getTrusteeOutBillCollection(ctx, view);
        PaperNoteRecOpUtil recOpUtil = new PaperNoteRecOpUtil(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            TrusteeOutBillInfo info = colls.get(i);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < info.getReceivableEntrys().size(); ++j) {
                    ReceivableBillInfo entry = info.getReceivableEntrys().get(j);
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncStatus(ctx, recOpUtil, batchSeqMap);
                this._isAllBankSuccess(ctx, (IObjectValue)info);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSyncStatus(Context ctx, PaperNoteRecOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess(ctx, infoList, details);
        }
    }

    private void afterProcess(Context ctx, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo recInfo = infoList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    // empty if block
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
    }

    private NoteReceivableDetail[] queryRec(Context ctx, PaperNoteRecOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryPaperNoteRec(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    @Override
    protected void _editStatus(Context ctx, List statusList) throws BOSException, EASBizException {
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            ReceivableBillInfo recInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (recInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
                throw new BEException(BEException.UPDATESTATEERROR1);
            }
            recInfo.setBankReturnStatus((BankReturnStatusEnum)map.get("bankReturnStatus"));
            updateList.add(recInfo);
        }
        logger.debug((Object)"begin to updateBeStatus TrusteeOutBillInfo");
        PaperNoteRecOpUtil util = new PaperNoteRecOpUtil(ctx);
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList));
        try {
            NoteStatusDetail[] details = util.updatePaperNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<ReceivableBillInfo> updateList) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            detail.setDetailSeqID(recInfo.getDetailSeqID());
            detail.setBatchSeqID(recInfo.getBatchSeqID());
            detail.setEbStatus(recInfo.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    private void afterProcess4Update(Context ctx, List<ReceivableBillInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    // empty if block
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
    }

    @Override
    protected void _isAllBankSuccess(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TrusteeOutBillInfo trusteeInfo = (TrusteeOutBillInfo)info;
        boolean flag = true;
        ReceivableBillCollection entryColl = trusteeInfo.getReceivableEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            ReceivableBillInfo recInfo = entryColl.get(i);
            if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) continue;
            flag = false;
            break;
        }
        if (flag) {
            trusteeInfo.setBillState(PledgeBillStatusEnum.OUTPOOL);
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            trusteeInfo.setConfirmor(userInfo);
            trusteeInfo.setConfirmDate(DateUtil.getDayBegin());
            this.update(ctx, (IObjectPK)new ObjectUuidPK(trusteeInfo.getId()), (CoreBaseInfo)trusteeInfo);
            BillPoolJournalInfo journalInfo = this.buildJournalInfo(ctx, trusteeInfo);
            BillPoolJournalFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)journalInfo);
            CoreBaseCollection receivableColl = this.getReceivableBillColls(ctx, trusteeInfo);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
        }
    }

    private BillPoolJournalInfo buildJournalInfo(Context ctx, TrusteeOutBillInfo info) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTrusteeDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_OUT);
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(info.getTotalAmout());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getTrustee())) {
            BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getTrustee().getId().toString()));
            journalInfo.setCooperativeBank(bankInfo);
            journalInfo.setCooperativeBankName(bankInfo.getName());
        }
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        return journalInfo;
    }

    private CoreBaseCollection getReceivableBillColls(Context ctx, TrusteeOutBillInfo info) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < info.getReceivableEntrys().size(); ++i) {
            idSet.add(info.getReceivableEntrys().get(i).getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        Date currentDate = DateUtil.getDayBegin();
        CoreBaseCollection receivableColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getCollection(evi);
        for (int i = 0; i < receivableColl.size(); ++i) {
            ReceivableBillInfo receivableInfo = (ReceivableBillInfo)receivableColl.get(i);
            receivableInfo.setCooperativeBank(null);
            receivableInfo.setCooperativeBankName(null);
            boolean isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
            if (isNeedAudit) {
                receivableInfo.setBillState(BillStateEnum.Audit);
            } else {
                receivableInfo.setBillState(BillStateEnum.SAVED);
            }
            receivableInfo.setTrusteeOutBill(null);
            receivableInfo.setIsTrustee(false);
            receivableInfo.setTrusteeInBill(null);
            receivableInfo.setOutPoolDate(currentDate);
            receivableInfo.setIsPoolPledge(false);
            receivableInfo.setIsPoolTrustee(false);
            receivableInfo.setBankReturnMsg(null);
            receivableInfo.setBankReturnStatus(null);
            receivableInfo.setElecBillStatus(null);
        }
        return receivableColl;
    }

    @Override
    protected Map _commitToBE(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceivableBillCollection coll;
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeOutBillInfo info = this.getTrusteeOutBillInfo(ctx, pk, this.getSelector());
        result = this.beforeCommit(info, result, coll = info.getReceivableEntrys());
        if (result.getSummaryMsg() != null) {
            return result;
        }
        logger.debug((Object)"begin to commitToBE TrusteeOutInfo");
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
        }
        PaperNoteRecOpUtil recOpUtil = new PaperNoteRecOpUtil(ctx);
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info, coll);
        }
        result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"729_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        return result;
    }

    private BatchExecuteResult beforeCommit(TrusteeOutBillInfo info, BatchExecuteResult result, ReceivableBillCollection coll) {
        if (info.getBillState() != PledgeBillStatusEnum.AUDIT) {
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"148_auditcancommitbe"));
            return result;
        }
        boolean isBEProcessing = false;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getHolderAccount() == null) {
                result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"147_hoderaccount_required", (Object[])new String[]{entry.getDraftNumber()}));
                return result;
            }
            if (entry.getBankReturnStatus() != null && !BankReturnStatusEnum.EB_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)entry.getBankReturnStatus())) continue;
            isBEProcessing = true;
            break;
        }
        if (info.isIsCommitToBE() && isBEProcessing) {
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"012_BE_PROCESSING_WAITING"));
            return result;
        }
        boolean isBEFinished = true;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (BankReturnStatusEnum.BANK_FAIL.equals((Object)entry.getBankReturnStatus()) || BankReturnStatusEnum.BANK_SUCCESS.equals((Object)entry.getBankReturnStatus())) continue;
            isBEFinished = false;
            break;
        }
        if (info.isIsCommitToBE() && isBEFinished) {
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"043_COMMITTOBE_FINISHED"));
            return result;
        }
        return result;
    }

    private void doCommitBE(Context ctx, PaperNoteRecOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, TrusteeOutBillInfo info, ReceivableBillCollection coll) throws EASBizException, BOSException {
        try {
            this.beforeProcess(ctx, info.isIsCommitToBE(), infoList);
            NoteReceivableBody body = this.parseRequestBody(ctx, totalAmount, infoList, info);
            PaperNoteBizInfo bizInfo = new PaperNoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(PaperNoteTypeEnum.OUT_TRUSTEEPOOL);
            NoteReceivableDetail[] detail = recOpUtil.paperNoteRecOp(ctx, bizInfo, body);
            info.setIsCommitToBE(true);
            this.updatePartial(ctx, (CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBE"}));
            this.afterProcess(ctx, infoList, detail);
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)coll);
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void beforeProcess(Context ctx, boolean isCommitBE, List<ReceivableBillInfo> infoList) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo info = infoList.get(i);
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            if (isCommitBE && info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                info.setBankReturnStatus(null);
                info.setBankReturnMsg(null);
            }
            recBillCollection.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recBillCollection);
    }

    private NoteReceivableBody parseRequestBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, TrusteeOutBillInfo info) throws EASBizException, BOSException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseDetail(Context ctx, List<ReceivableBillInfo> infoList, TrusteeOutBillInfo info) throws EASBizException, BOSException {
        BankInfo bankInfo = info.getTrustee();
        NoteReceivableDetail[] details = null;
        if (infoList.size() > 0) {
            details = new NoteReceivableDetail[infoList.size()];
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo recInfo = infoList.get(i);
                NoteReceivableDetail detail = new NoteReceivableDetail();
                detail.setDetailSeqID(recInfo.getDetailSeqID());
                detail.setDetailBizNo(recInfo.getDetailSeqID());
                detail.setBillNo(recInfo.getDraftNumber());
                detail.setDraftType(recInfo.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
                detail.setTransferFlag("EM01");
                detail.setOppAccNo("0");
                detail.setOppAccName(bankInfo.getName());
                BEBankInfo beInfo = null;
                if (bankInfo.getAccountBank() != null) {
                    beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                }
                if (beInfo != null) {
                    detail.setOppCnapsCode(beInfo.getNumber());
                }
                detail.setOppAmount(info.getTotalAmout().setScale(2).toString());
                detail.setBookingDate(DraftBEUtil.date2String((Date)recInfo.getIssuesDate(), (String)"yyyyMMdd"));
                detail.setDueDate(DraftBEUtil.date2String((Date)recInfo.getExpiredDate(), (String)"yyyyMMdd"));
                detail.setDesc(recInfo.getDescription());
                details[i] = detail;
            }
        }
        return details;
    }

    @Override
    protected Map _releaseFailedBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeOutBillInfo info = this.getTrusteeOutBillInfo(ctx, pk, this.getSelector());
        ReceivableBillCollection coll = this.getFailedRecBill(info);
        if (info.isIsCommitToBE() && coll.size() > 0 && coll.size() < info.getReceivableEntrys().size()) {
            StringBuffer buffer = new StringBuffer("(");
            for (int i = 0; i < coll.size(); ++i) {
                buffer.append("'" + coll.get(i).getId() + "',");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(")");
            DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FIsPoolTrustee=0,FTrusteeOutBillID=null,FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null where FID in " + buffer.toString()));
            int newCount = info.getReceivableEntrys().size() - coll.size();
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < coll.size(); ++i) {
                amount = i == 0 ? coll.get(i).getBillAmt() : amount.add(coll.get(i).getBillAmt());
            }
            amount = info.getTotalAmout().subtract(amount);
            DbUtil.execute((Context)ctx, (String)("update t_ntp_trusteeOutBill set Fcount = " + newCount + ",FTotalAmout = " + amount + " where FID= '" + info.getId() + "'"));
            this._isAllBankSuccess(ctx, (IObjectValue)info);
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"066_RELEASEFAILEDBILL_RESULT", (Object[])new String[]{String.valueOf(coll.size())}));
        } else {
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"131_cannot_Release_FailedBill"));
        }
        return result;
    }

    private ReceivableBillCollection getFailedRecBill(TrusteeOutBillInfo info) {
        ReceivableBillCollection coll = new ReceivableBillCollection();
        ReceivableBillCollection entryColl = info.getReceivableEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            ReceivableBillInfo recInfo = entryColl.get(i);
            if (!BankReturnStatusEnum.COMMIT_FAIL.equals((Object)recInfo.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_FAIL.equals((Object)recInfo.getBankReturnStatus())) continue;
            coll.add(recInfo);
        }
        return coll;
    }
}

