/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.pp.StandbyAmountCollection;
import com.kingdee.eas.fm.pp.StandbyAmountFactory;
import com.kingdee.eas.fm.pp.StandbyAmountInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class StandbyAmountDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)StandbyAmountDataImport.class.getName());
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private CompanyOrgUnitInfo currentCompany;

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return StandbyAmountFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String company;
        StandbyAmountInfo head = new StandbyAmountInfo();
        this.curKey = company = (String)this.getData(hsData, "company");
        logger.error((Object)("\u83b7\u53d6\u5230EXCEL\u5907\u7528\u91d1\u516c\u53f8\u7f16\u7801\u4e3a\uff1a" + company));
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        EntityViewInfo companyView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)company.trim()));
        companyView.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        companyView.setSelector(sic);
        CompanyOrgUnitCollection fiOrgColls = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(companyView);
        this.currentCompany = fiOrgColls.get(0);
        if (this.currentCompany == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"StandbyAmount_No_Company", (Locale)ctx.getLocale()));
        }
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()), "standbyAmount_04import");
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            head = (StandbyAmountInfo)this.parseHead(hsData, ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
            view.setFilter(fi);
            StandbyAmountCollection coll = null;
            try {
                coll = StandbyAmountFactory.getLocalInstance(ctx).getStandbyAmountCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll.size() > 0) {
                head.setId(coll.get(0).getId());
            }
        } else {
            if (EmptyUtil.isEmpty((String)company)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"046_StandbyAmount", (Locale)ctx.getLocale()));
            }
            if (!this.isExistHead(hsData, ctx)) {
                if (!this.infoMap.containsKey(this.curKey)) {
                    head = (StandbyAmountInfo)this.parseHead(hsData, ctx);
                    this.infoMap.put(this.curKey, head);
                } else {
                    head = (StandbyAmountInfo)this.infoMap.get(this.curKey);
                }
            }
        }
        return head;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx) throws BOSException {
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (this.currentCompany == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        evi.setFilter(filter);
        StandbyAmountCollection coll = StandbyAmountFactory.getLocalInstance(ctx).getStandbyAmountCollection(evi);
        if (coll != null && coll.size() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"047_StandbyAmount", (Locale)ctx.getLocale()));
        }
        return false;
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx) throws BOSException {
        StandbyAmountInfo info = new StandbyAmountInfo();
        BigDecimal zero = Constants.ZERO;
        Object data = null;
        info.setCompany(this.currentCompany);
        info.setCurrency(this.currentCompany.getBaseCurrency());
        data = this.getData(hsData, "amount");
        if (data != null && data.toString().trim().length() > 0) {
            BigDecimal amount = TypeConversionUtils.objToBigDecimal((Object)data);
            if (amount.compareTo(BigDecimal.ZERO) < 0) {
                info.setAmount(BigDecimal.ZERO);
            } else {
                info.setAmount(amount);
            }
        } else {
            info.setAmount(BigDecimal.ZERO);
        }
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
        }
    }
}

