/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.pp.FMAccountBankBalanceHelper;
import com.kingdee.eas.fm.pp.FundFlowBalanceCollection;
import com.kingdee.eas.fm.pp.FundFlowBalanceInfo;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryCollection;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryFactory;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryInfo;
import com.kingdee.eas.fm.pp.FundFlowSetAcctBankCollection;
import com.kingdee.eas.fm.pp.FundFlowSetAcctBankInfo;
import com.kingdee.eas.fm.pp.FundFlowSetInnerAcctCollection;
import com.kingdee.eas.fm.pp.FundFlowSetInnerAcctInfo;
import com.kingdee.eas.fm.pp.FundFlowSetNtTypeCollection;
import com.kingdee.eas.fm.pp.FundFlowSetNtTypeInfo;
import com.kingdee.eas.fm.pp.OrgScheduleCollection;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.app.AbstractAutoFundFlowBalanceFacade2ControllerBean;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoFundFlowBalanceFacade2ControllerBean
extends AbstractAutoFundFlowBalanceFacade2ControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.AutoFundFlowBalanceFacade2ControllerBean");
    private Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
    private Date beforeDate = DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)new Date()));
    private static final BigDecimal zero = BigDecimal.ZERO;
    private static final String currencyNumber = "BB01";
    private static final String paper_bank = "NVri2OoBSH6c30+2JTeQwNyc97k=";
    private static final String paper_business = "leFPhjgWSR6d90GGE/tdktyc97k=";
    private static final String elect_bank = "TvDo7KKQQ5+cimNZA91Rd9yc97k=";
    private static final String elect_business = "y73skr+HRl6EW7DN97x79Nyc97k=";
    private static final String bankType = "33333333-3333-3333-3333-3333333333331C9A9013";
    private static final String businessType = "44444444-4444-4444-4444-4444444444441C9A9013";
    Set companyIdSet = new HashSet();
    Map com_ParamMap = new HashMap();
    Map com_PeriodMap = new HashMap();
    Map comCur_ExcMap = new HashMap();
    Map comType_AmtMap = new HashMap();

    @Override
    public void _autoFundFlowBalance(Context ctx) throws BOSException, EASBizException {
        this.initScheduleCompany(ctx);
        if (this.companyIdSet.size() == 0) {
            return;
        }
        this.initCompanyParam(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("currency.id");
        selector.add("currency.number");
        selector.add("currency.precision");
        selector.add("company.id");
        selector.add("company.baseCurrency.id");
        selector.add("accountBanks.*");
        selector.add("accountBanks.accountBank.company.id");
        selector.add("accountBanks.accountBank.bank.inGroup");
        selector.add("accountBanks.accountBank.isSetBankInterface");
        selector.add("accountBanks.accountBank.innerAcct.*");
        selector.add("accountBanks.accountBank.innerAcct.company.id");
        selector.add("ntType.*");
        selector.add("innerAccount.*");
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        view.setFilter(filter);
        view.setSelector(selector);
        FundFlowItemSettingEntryCollection fundEntryColl = FundFlowItemSettingEntryFactory.getLocalInstance(ctx).getFundFlowItemSettingEntryCollection(view);
        if (fundEntryColl != null && fundEntryColl.size() > 0) {
            FundFlowBalanceCollection balanceColl = new FundFlowBalanceCollection();
            for (int i = 0; i < fundEntryColl.size(); ++i) {
                FundFlowSetInnerAcctCollection innerColl;
                FundFlowSetNtTypeCollection ntTypeColl;
                FundFlowItemSettingEntryInfo fundEntryInfo = fundEntryColl.get(i);
                FundFlowBalanceInfo fundBalanceInfo = new FundFlowBalanceInfo();
                fundBalanceInfo.setCompany(fundEntryInfo.getCompany());
                String companyId = fundEntryInfo.getCompany().getId().toString();
                fundBalanceInfo.setFundFlowItem(fundEntryInfo.getFundFlowItem());
                CurrencyInfo baseCurrency = fundEntryInfo.getCompany().getBaseCurrency();
                fundBalanceInfo.setCurrency(baseCurrency);
                fundBalanceInfo.setBalanceData(this.beforeDate);
                FundFlowSetAcctBankCollection acctBankColl = fundEntryInfo.getAccountBanks();
                if (acctBankColl != null && acctBankColl.size() > 0) {
                    for (int j = 0; j < acctBankColl.size(); ++j) {
                        BigDecimal balance;
                        CurrencyInfo currency;
                        FundFlowSetAcctBankInfo fundAcctBankInfo = acctBankColl.get(j);
                        AccountBankInfo acctBank = fundAcctBankInfo.getAccountBank();
                        boolean isBank = acctBank.isIsSetBankInterface();
                        boolean isInGroup = acctBank.getBank().isInGroup();
                        if (isBank && !isInGroup) {
                            currency = acctBank.getCurrency();
                            if (!acctBank.isIsByCurrency()) {
                                currency = baseCurrency;
                            }
                            if ((balance = FMAccountBankBalanceHelper.getBeAcctBankBalance(ctx, acctBank.getId().toString(), currency)).compareTo(zero) != 0 && acctBank.isIsByCurrency() && !baseCurrency.getId().toString().equals(currency.getId().toString())) {
                                balance = this.getLocAmount(ctx, companyId, currency.getId().toString(), baseCurrency, balance);
                            }
                            BigDecimal beAcctAmt = fundBalanceInfo.getBeAcctAmt() == null ? zero : fundBalanceInfo.getBeAcctAmt();
                            beAcctAmt = beAcctAmt.add(balance);
                            fundBalanceInfo.setBeAcctAmt(beAcctAmt);
                            continue;
                        }
                        if (!isBank && !isInGroup) {
                            currency = acctBank.getCurrency();
                            if (!acctBank.isIsByCurrency()) {
                                currency = baseCurrency;
                            }
                            if ((balance = FMAccountBankBalanceHelper.getNoBeAcctBankBalance(ctx, companyId, acctBank.getId().toString(), currency, this.currentDate, this.currentDate, CashDataTypeEnum.C)).compareTo(zero) != 0 && acctBank.isIsByCurrency() && !baseCurrency.getId().toString().equals(currency.getId().toString())) {
                                balance = this.getLocAmount(ctx, companyId, currency.getId().toString(), baseCurrency, balance);
                            }
                            BigDecimal noBeAcctAmt = fundBalanceInfo.getNoBeAcctAmt() == null ? zero : fundBalanceInfo.getNoBeAcctAmt();
                            noBeAcctAmt = noBeAcctAmt.add(balance);
                            fundBalanceInfo.setNoBeAcctAmt(noBeAcctAmt);
                            continue;
                        }
                        if (!isInGroup) continue;
                        InnerAccountInfo innerAccountInfo = acctBank.getInnerAcct();
                    }
                }
                if ((ntTypeColl = fundEntryInfo.getNtType()) != null && ntTypeColl.size() > 0) {
                    for (int j = 0; j < ntTypeColl.size(); ++j) {
                        FundFlowSetNtTypeInfo ntTypeInfo = ntTypeColl.get(j);
                        String ntTypeId = ntTypeInfo.getId().toString();
                        if (paper_bank.equals(ntTypeId)) {
                            BigDecimal paperBankAmount = this.getPaperTypeAmount(ctx, companyId, 1, bankType, "paper_bank");
                            fundBalanceInfo.setPaperBankAmt(paperBankAmount);
                            continue;
                        }
                        if (paper_business.equals(ntTypeId)) {
                            BigDecimal paperBusinessAmount = this.getPaperTypeAmount(ctx, companyId, 1, businessType, "paper_business");
                            fundBalanceInfo.setPaperBusinessAmt(paperBusinessAmount);
                            continue;
                        }
                        if (elect_bank.equals(ntTypeId)) {
                            BigDecimal electBankAmount = this.getPaperTypeAmount(ctx, companyId, 2, bankType, "elect_bank");
                            fundBalanceInfo.setElectronicBankAmt(electBankAmount);
                            continue;
                        }
                        if (!elect_business.equals(ntTypeId)) continue;
                        BigDecimal electBusinessAmount = this.getPaperTypeAmount(ctx, companyId, 2, businessType, "elect_business");
                        fundBalanceInfo.setElectronicBusinessAmt(electBusinessAmount);
                    }
                }
                if ((innerColl = fundEntryInfo.getInnerAccount()) == null || innerColl.size() <= 0) continue;
                for (int j = 0; j < innerColl.size(); ++j) {
                    FundFlowSetInnerAcctInfo fundFlowSetInnerAcctInfo = innerColl.get(j);
                }
            }
        }
    }

    private void initScheduleCompany(Context ctx) throws BOSException {
        EntityViewInfo orgView = new EntityViewInfo();
        SelectorItemCollection orgSelector = new SelectorItemCollection();
        orgSelector.add("*");
        orgSelector.add("userDefinedPeriod.startDate");
        orgSelector.add("userDefinedPeriod.endDate");
        FilterInfo orgFilter = new FilterInfo();
        orgFilter.getFilterItems().add(new FilterItemInfo("status", (Object)8, CompareType.NOTEQUALS));
        orgView.setSelector(orgSelector);
        orgView.setFilter(orgFilter);
        OrgScheduleCollection orgScheColl = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleCollection(orgView);
        if (orgScheColl != null && orgScheColl.size() > 0) {
            for (int i = 0; i < orgScheColl.size(); ++i) {
                OrgScheduleInfo orgScheduleInfo = orgScheColl.get(i);
                String companyId = orgScheduleInfo.getCompany().getId().toString();
                Date startDate = orgScheduleInfo.getUserDefinedPeriod().getStartDate();
                Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
                if ((!this.currentDate.after(startDate) || !this.currentDate.before(endDate)) && !this.currentDate.equals(startDate) && !this.currentDate.equals(endDate)) continue;
                this.com_PeriodMap.put(companyId, orgScheduleInfo.getUserDefinedPeriod());
                this.companyIdSet.add(companyId);
            }
        }
    }

    private void initCompanyParam(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("NT011");
        ArrayList paramlist = ParamControlFactory.getLocalInstance((Context)ctx).getParamListPatch(paramNumberList, new ArrayList(this.companyIdSet));
        for (ParamSimpleInfo paramSimple : paramlist) {
            String paramValue = paramSimple.getParamValue();
            String comPanyId = paramSimple.getOrgUnitPK().toString();
            this.com_ParamMap.put(comPanyId, Boolean.parseBoolean(paramValue));
        }
    }

    private BigDecimal getLocAmount(Context ctx, String companyId, String currencyId, CurrencyInfo baseCurrency, BigDecimal balance) throws EASBizException, BOSException {
        BigDecimal value;
        BigDecimal locAmount = BigDecimal.ZERO;
        Map exchangeRate = (Map)this.comCur_ExcMap.get(companyId + currencyId);
        if (exchangeRate == null) {
            exchangeRate = CASCommonWebFacadeFactory.getLocalInstance((Context)ctx).getExchangeRate(companyId, currencyId, this.beforeDate);
            this.comCur_ExcMap.put(companyId + currencyId, exchangeRate);
        }
        if ((value = (BigDecimal)exchangeRate.get("exchangeRate")).doubleValue() == 0.0) {
            value = new BigDecimal("1");
        }
        boolean isIndirectRate = (Integer)exchangeRate.get("isIndirectRate") == Integer.valueOf(1);
        int precision = baseCurrency.getPrecision();
        locAmount = isIndirectRate ? balance.divide(value, precision, 4) : balance.multiply(value);
        locAmount = locAmount.setScale(precision, 4);
        return balance;
    }

    private BigDecimal getPaperTypeAmount(Context ctx, String companyId, int billMedium, String NTtypeId, String type) throws BOSException {
        BigDecimal typeAmount = (BigDecimal)this.comType_AmtMap.get(companyId + type);
        if (typeAmount != null) {
            return typeAmount;
        }
        BigDecimal paperTypeAmount = BigDecimal.ZERO;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyNumber));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("billMedium", (Object)billMedium));
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)NTtypeId));
        filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)this.currentDate, CompareType.GREATER));
        if (((Boolean)this.com_ParamMap.get(companyId)).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)8));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)1));
        }
        view.setSelector(selector);
        view.setFilter(filter);
        ReceivableBillCollection receivableColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
        if (receivableColl != null && receivableColl.size() > 0) {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo info = receivableColl.get(i);
                BigDecimal naturalAmt = info.getNaturalAmt();
                paperTypeAmount = paperTypeAmount.add(naturalAmt);
            }
        }
        this.comType_AmtMap.put(companyId + type, paperTypeAmount);
        return paperTypeAmount;
    }
}

