/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.ReceivableBillEntryVO;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.pp.CapitalBalanceCollection;
import com.kingdee.eas.fm.pp.CapitalBalanceInfo;
import com.kingdee.eas.fm.pp.CapitalBalanceWebFacadeFactory;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PPPaySummarizingWayEnum;
import com.kingdee.eas.fm.pp.PPScheduleSettingCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.app.AbstractCapitalBalanceControllerBean;
import com.kingdee.eas.fm.pp.vo.BgControlRow;
import com.kingdee.eas.fm.pp.vo.CapitalBalanceRow;
import com.kingdee.eas.fm.pp.vo.PayPlanUpdateVerifyVO;
import com.kingdee.eas.fm.pp.vo.PaySchDetailCreatePayVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CapitalBalanceControllerBean
extends AbstractCapitalBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.CapitalBalanceControllerBean");

    @Override
    protected void _saveBalance(Context ctx, String orgScheduleId, List balance) throws BOSException, EASBizException {
        if (balance.size() <= 0) {
            return;
        }
        OrgScheduleInfo scheInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        if (scheInfo.getStatus().equals((Object)StatusEnum.SCHEDULE_AUDIT) || scheInfo.getStatus().equals((Object)StatusEnum.ADJUST_AUDIT) || scheInfo.getStatus().equals((Object)StatusEnum.COMPLETE)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_SAVE);
        }
        String deleteSql = "delete from T_PP_CapitalBalance where FOrgScheduleId=? ";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{orgScheduleId});
        CapitalBalanceCollection col = new CapitalBalanceCollection();
        for (int i = 0; i < balance.size(); ++i) {
            CapitalBalanceRow row = (CapitalBalanceRow)balance.get(i);
            FundFlowItemInfo fund = new FundFlowItemInfo();
            fund.setId(BOSUuid.read((String)row.getFundFlowItem()));
            OrgScheduleInfo parent = new OrgScheduleInfo();
            parent.setId(BOSUuid.read((String)orgScheduleId));
            CapitalBalanceInfo info = new CapitalBalanceInfo();
            info.setLevelSeq(row.getLevelSeq());
            info.setOrgScheduleId(parent);
            info.setFundFlowItem(fund);
            info.setBalanceType(row.getType());
            info.setCashAmount(row.getCashAmount());
            info.setCashAuditAmount(row.getCashAuditAmount());
            info.setCashCurAdjustAmt(row.getCashCurAdjustAmt());
            info.setCashCurAuditAmt(row.getCashCurAuditAmt());
            info.setCashAdjustSumAmt(row.getCashAdjustSumAmt());
            info.setCashSumAmt(row.getCashSumAmt());
            info.setCashAuditSumAmt(row.getCashAuditSumAmt());
            info.setBillAmount(row.getBillAmount());
            info.setBillAuditAmount(row.getBillAuditAmount());
            info.setBillCurAdjustAmt(row.getBillCurAdjustAmt());
            info.setBillCurAuditAmt(row.getBillCurAuditAmt());
            info.setBillAdjustSumAmt(row.getBillAdjustSumAmt());
            info.setBillSumAmt(row.getBillSumAmt());
            info.setBillAuditSumAmt(row.getBillAuditSumAmt());
            info.setCapitalAmt(row.getCapitalAmt());
            info.setCapitalAuditAmt(row.getCapitalAuditAmt());
            info.setCapitalAdjustAmt(row.getCapitalAdjustAmt());
            info.setCapitalAdjustAuditAmt(row.getCapitalAdjustAuditAmt());
            info.setCapitalSumAmt(row.getCapitalSumAmt());
            info.setCapitalAuditSumAmt(row.getCapitalAuditSumAmt());
            col.add(info);
        }
        this._addnewBatchData(ctx, (IObjectCollection)col);
    }

    @Override
    protected Map _submitBalance(Context ctx, String orgScheduleId, List balance) throws BOSException, EASBizException {
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        this.verifySubmitData(ctx, info, balance);
        this.verifyPaySchDetaiBill(ctx, info);
        this.saveBalance(ctx, orgScheduleId, balance);
        Map bgResult = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).buildBgControlData(orgScheduleId, null, false);
        if (bgResult.size() > 0) {
            List bgRowList = (List)bgResult.get("rowList");
            this.verifySubmitBgData(ctx, info, bgRowList);
        }
        if (bgResult.containsKey("allDepartment")) {
            List allDepartment = (List)bgResult.get("allDepartment");
            for (int i = 0; i < allDepartment.size(); ++i) {
                Map bgDepartmentResult = null;
                String departmentId = (String)allDepartment.get(i);
                bgDepartmentResult = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).buildBgControlDataByDepartment(orgScheduleId, null, false, departmentId);
                if (bgDepartmentResult == null || bgDepartmentResult.size() <= 0) continue;
                List bgDepartmentRowList = (List)bgDepartmentResult.get("rowList");
                this.verifySubmitBgDataByDepartment(ctx, info, bgDepartmentRowList, departmentId);
            }
        }
        String sql = "update T_PP_OrgSchedule set FStatus=? where fid=? ";
        if (info.getStatus().equals((Object)StatusEnum.SCHEDULEING)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{3, orgScheduleId});
        } else if (info.getStatus().equals((Object)StatusEnum.ADJUSTING)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{6, orgScheduleId});
        }
        OrgScheduleFactory.getLocalInstance(ctx).submitWF((IObjectPK)new ObjectUuidPK(orgScheduleId));
        return bgResult;
    }

    @Override
    protected void _auditBalance(Context ctx, String orgScheduleId, List balance) throws BOSException, EASBizException {
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        this.verifyAuditData(ctx, info, balance);
        this.verifyPaySchDetaiBill(ctx, info);
        this.saveBalance(ctx, orgScheduleId, balance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _audit(Context ctx, String orgScheduleId) throws BOSException, EASBizException {
        IMutexServiceControl iMutex;
        boolean getLock;
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        Map result = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).calculateCapitalBalanceData(orgScheduleId, new HashMap());
        List rowList = (List)result.get("rowList");
        this.auditBalance(ctx, orgScheduleId, rowList);
        Map bgResult = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).buildBgControlData(orgScheduleId, null, false);
        if (bgResult.size() > 0) {
            List bgRowList = (List)bgResult.get("rowList");
            this.verifySubmitBgData(ctx, info, bgRowList);
        }
        if (bgResult.containsKey("allDepartment")) {
            List allDepartment = (List)bgResult.get("allDepartment");
            for (int i = 0; i < allDepartment.size(); ++i) {
                Map bgDepartmentResult = null;
                String departmentId = (String)allDepartment.get(i);
                bgDepartmentResult = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).buildBgControlDataByDepartment(orgScheduleId, null, false, departmentId);
                if (bgDepartmentResult == null || bgDepartmentResult.size() <= 0) continue;
                List bgDepartmentRowList = (List)bgDepartmentResult.get("rowList");
                this.verifySubmitBgDataByDepartment(ctx, info, bgDepartmentRowList, departmentId);
            }
        }
        if (!(getLock = (iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx)).requestObjIDForUpdate("createPay" + orgScheduleId))) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"47_CapitalBalanceControllerBean", (Locale)ctx.getLocale()));
        }
        try {
            this.createPaymentBill(ctx, orgScheduleId, info.getCount(), info.getStatus());
        }
        finally {
            if (getLock) {
                iMutex.releaseObjIDForUpdate("createPay" + orgScheduleId);
            }
        }
        String sql = "update T_PP_OrgSchedule set FStatus=?,Fcount=? where fid=?";
        if (info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{4, info.getCount() + 1, orgScheduleId});
        } else if (info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{7, info.getCount() + 1, orgScheduleId});
        }
        return bgResult;
    }

    @Override
    protected void _back(Context ctx, String orgScheduleId) throws BOSException, EASBizException {
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        String sql = "update T_PP_OrgSchedule set FStatus=? where fid=?";
        if (info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{2, orgScheduleId});
        } else if (info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{5, orgScheduleId});
        } else {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_BACK);
        }
    }

    protected void verifySubmitData(Context ctx, OrgScheduleInfo info, List balance) throws BOSException, EASBizException {
        if (!info.getStatus().equals((Object)StatusEnum.SCHEDULEING) && !info.getStatus().equals((Object)StatusEnum.ADJUSTING)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_SUBMIT);
        }
        if (balance.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"48_CapitalBalanceControllerBean", (Locale)ctx.getLocale()));
        }
        List rowList = balance;
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS302", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!val && (info.getStatus().equals((Object)StatusEnum.SCHEDULEING) ? ((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getCashAmount().compareTo(BigDecimal.ZERO) < 0 || ((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getBillAmount().compareTo(BigDecimal.ZERO) < 0 : info.getStatus().equals((Object)StatusEnum.ADJUSTING) && (((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getCashSumAmt().compareTo(BigDecimal.ZERO) < 0 || ((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getBillSumAmt().compareTo(BigDecimal.ZERO) < 0))) {
            throw new PPException(PPException.CAPITALBALANCE_NO_BALANCE);
        }
    }

    protected void verifyAuditData(Context ctx, OrgScheduleInfo info, List balance) throws BOSException, EASBizException {
        if (balance.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"48_CapitalBalanceControllerBean", (Locale)ctx.getLocale()));
        }
        if (!info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT) && !info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_AUDIT);
        }
        List rowList = balance;
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS302", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!val && (info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT) ? ((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getCashAuditAmount().compareTo(BigDecimal.ZERO) < 0 || ((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getBillAuditAmount().compareTo(BigDecimal.ZERO) < 0 : info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT) && (((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getCashAuditSumAmt().compareTo(BigDecimal.ZERO) < 0 || ((CapitalBalanceRow)rowList.get(rowList.size() - 1)).getBillAuditSumAmt().compareTo(BigDecimal.ZERO) < 0))) {
            throw new PPException(PPException.CAPITALBALANCE_NO_BALANCE);
        }
    }

    protected void verifyPaySchDetaiBill(Context ctx, OrgScheduleInfo info) throws BOSException, EASBizException {
        String querySql = "select * from T_PP_PaySchDetailBill where ForgScheduleId=? and FpaySchDetailNumber=? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{info.getId().toString(), info.getCount()});
        if (rs.size() <= 0 && !StatusEnum.ADJUSTING.equals((Object)info.getStatus()) && !StatusEnum.ADJUST_SUBMIT.equals((Object)info.getStatus())) {
            throw new PPException(PPException.CAPITALBALANCE_SCHEDULEDATA_ISNULL);
        }
        try {
            while (rs.next()) {
                BigDecimal ntAmt = (BigDecimal)rs.getObject("FNtAuditedAmt");
                BigDecimal ntBalance = (BigDecimal)rs.getObject("FntBalance");
                String summaryFlag = (String)rs.getObject("FSummaryFlag");
                if (summaryFlag != null) {
                    BigDecimal ntSummaryAmt = (BigDecimal)rs.getObject("FNtSummaryAmt");
                    String sql = "SELECT sum(FntBalance) sum FROM T_PP_PaySchDetailBill where FSummaryFlag= ?";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{summaryFlag});
                    BigDecimal sum = (BigDecimal)rowSet.getObject("sum");
                    if (sum.compareTo(BigDecimal.ZERO) == 0 || ntSummaryAmt.subtract(sum).compareTo(BigDecimal.ZERO) == 0) continue;
                    throw new PPException(PPException.CAPTTALBALANCE_BILLAMT_UNEQUAL);
                }
                if (ntBalance.compareTo(BigDecimal.ZERO) == 0 || ntAmt.subtract(ntBalance).compareTo(BigDecimal.ZERO) == 0) continue;
                throw new PPException(PPException.CAPTTALBALANCE_BILLAMT_UNEQUAL);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    protected void createPaymentBill(Context ctx, String orgScheduleId, int count, StatusEnum status) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payPlan.*");
        sic.add("payPlan.company.basecurrency.id");
        sic.add("payPlan.company.BaseExchangeTable.id");
        sic.add("payPlan.department.id");
        sic.add("payPlan.department.name");
        sic.add("payPlan.payeeAccountBankO.id");
        sic.add("payPlan.payeeAccountBankO.name");
        sic.add("payPlan.SetFundProperty.id");
        sic.add("payPlan.SetFundProperty.fundflowitem");
        sic.add("PaymentBillType.id");
        sic.add("PaymentBillType.SourceSysType");
        sic.add("payerAccountBank.id");
        sic.add("payerAccountBank.account");
        sic.add("payerAccountBank.InnerAcct");
        sic.add("payerAccountBank.bank.inGroup");
        sic.add("nts.receivableBill.id");
        sic.add("nts.receivableBill.draftNumber");
        sic.add("nts.receivableBill.billAmt");
        FilterInfo filterPaySch = new FilterInfo();
        filterPaySch.getFilterItems().add(new FilterItemInfo("orgScheduleId", (Object)orgScheduleId, CompareType.EQUALS));
        filterPaySch.getFilterItems().add(new FilterItemInfo("paySchDetailNumber", (Object)count, CompareType.EQUALS));
        filterPaySch.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        EntityViewInfo eviPaySch = new EntityViewInfo();
        eviPaySch.setFilter(filterPaySch);
        eviPaySch.setSelector(sic);
        PaySchDetailBillCollection paySchCol = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(eviPaySch);
        if (paySchCol.size() == 0 && StatusEnum.ADJUST_SUBMIT.equals((Object)status)) {
            return;
        }
        if (paySchCol.size() <= 0) {
            throw new PPException(PPException.CAPITALBALANCE_SCHEDULEDATA_ISNULL);
        }
        HashMap<String, PaymentBillInfo> toCreatePay = new HashMap<String, PaymentBillInfo>();
        HashMap<String, PaySchDetailCreatePayVO> toUpdatePaySchDule = new HashMap<String, PaySchDetailCreatePayVO>();
        HashMap<String, PayPlanUpdateVerifyVO> toVerifyPayPlan = new HashMap<String, PayPlanUpdateVerifyVO>();
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        BigDecimal cashPayAmt = BigDecimal.ZERO;
        BigDecimal billPayAmt = BigDecimal.ZERO;
        rateMap.put("cashPayAmt", cashPayAmt);
        rateMap.put("billPayAmt", billPayAmt);
        String paymentTypeId = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
        PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
        paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeId));
        CountryInfo china = new CountryInfo();
        EntityViewInfo countryEvi = new EntityViewInfo();
        FilterInfo countryFilter = new FilterInfo();
        countryFilter.getFilterItems().add(new FilterItemInfo("name", (Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"117_FetchParamHelperForPaymentBillUI", (Locale)ctx.getLocale())));
        countryEvi.setFilter(countryFilter);
        CountryCollection countryCol = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(countryEvi);
        if (countryCol != null && countryCol.size() > 0) {
            china = countryCol.get(0);
        }
        for (int i = 0; i < paySchCol.size(); ++i) {
            PaySchDetailBillInfo paySchInfo = paySchCol.get(i);
            if (paySchInfo.getCashAuditedAmt().compareTo(BigDecimal.ZERO) == 1) {
                this.dealPaymentBillBySettlementType(ctx, paySchInfo, china, paymentTypeInfo, "cash", toCreatePay, toUpdatePaySchDule, toVerifyPayPlan, rateMap);
            }
            if (paySchInfo.getNtAuditedAmt().compareTo(BigDecimal.ZERO) != 1) continue;
            this.dealPaymentBillBySettlementType(ctx, paySchInfo, china, paymentTypeInfo, "nt", toCreatePay, toUpdatePaySchDule, toVerifyPayPlan, rateMap);
        }
        this.verifyAuditSumAmt(ctx, orgScheduleId, count, rateMap);
        String payPlanSql = " update T_PP_PayPlanBill set FCashToPayAmt=?,FPaperToPayAmt=?,FToPayAmount=? where fid=?";
        for (String key : toVerifyPayPlan.keySet()) {
            PayPlanUpdateVerifyVO vo = (PayPlanUpdateVerifyVO)toVerifyPayPlan.get(key);
            if (vo.getCashCreateAmt().compareTo(vo.getCashSchdlLockAmt().subtract(vo.getCashToPayAmt())) != 0 || vo.getNtCreateAmt().compareTo(vo.getNtSchdlLockAmt().subtract(vo.getNtToPayAmt())) != 0) {
                throw new PPException(PPException.PAYSCH_CREATEPAY_AMTVERIFY);
            }
            DbUtil.execute((Context)ctx, (String)payPlanSql, (Object[])new Object[]{vo.getCashSchdlLockAmt(), vo.getNtSchdlLockAmt(), vo.getCashSchdlLockAmt().add(vo.getNtSchdlLockAmt()), vo.getPayPlanID()});
        }
        ctx.put((Object)"fromSchedule", (Object)true);
        for (String key : toCreatePay.keySet()) {
            PaymentBillInfo PayInfo = (PaymentBillInfo)toCreatePay.get(key);
            IObjectPK pk = PaymentBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)PayInfo);
            this.saveBotp(ctx, PayInfo);
        }
        String paySchSql = " update T_PP_PaySchDetailBill set FCashPayBillID=?,FNtPayBillID=?,FStatus=? where fid=? ";
        for (String id : toUpdatePaySchDule.keySet()) {
            PaySchDetailCreatePayVO vo = (PaySchDetailCreatePayVO)toUpdatePaySchDule.get(id);
            DbUtil.execute((Context)ctx, (String)paySchSql, (Object[])new Object[]{vo.getCashPayBillID(), vo.getBillPayBillID(), 2, vo.getPaySchDetailBillID()});
        }
    }

    protected void saveBotp(Context ctx, PaymentBillInfo PayInfo) throws BOSException, EASBizException {
        HashSet<String> srcIdSet = new HashSet<String>();
        PaymentBillEntryCollection entrys = PayInfo.getEntries();
        for (int i = 0; i < entrys.size(); ++i) {
            PaymentBillEntryInfo entryInfo = entrys.get(i);
            if (entryInfo.getSrcPlanBillID() != null) {
                srcIdSet.add(entryInfo.getSrcPlanBillID());
            }
            if (entryInfo.getSrcPlanBillEntryID() == null) continue;
            srcIdSet.add(entryInfo.getSrcPlanBillEntryID());
        }
        if (!EmptyUtil.isEmpty(srcIdSet)) {
            List srcIdList = FMHelper.set2List(srcIdSet);
            BOTPUtil.saveBOTRelation((Context)ctx, (List)srcIdList, (String)PayInfo.getId().toString());
        }
    }

    protected void verifyAuditSumAmt(Context ctx, String orgScheduleId, int count, Map<String, BigDecimal> rateMap) throws BOSException, EASBizException {
        String balanceSql = count == 0 ? " select sum(FCashAuditAmount) cashPay,sum(FBillAuditAmount) billPay from T_PP_CapitalBalance where FOrgScheduleId=? and FBalanceType=? and flevelseq%10=0" : " select sum(FCashCurAuditAmt) cashPay,sum(FBillCurAuditAmt) billPay from T_PP_CapitalBalance where FOrgScheduleId=? and FBalanceType=? and flevelseq%10=0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)balanceSql, (Object[])new Object[]{orgScheduleId, 8});
        try {
            while (rs.next()) {
                BigDecimal billPayAmt;
                BigDecimal cashPay = rs.getBigDecimal("cashPay") == null ? BigDecimal.ZERO : rs.getBigDecimal("cashPay");
                BigDecimal billPay = rs.getBigDecimal("billPay") == null ? BigDecimal.ZERO : rs.getBigDecimal("billPay");
                BigDecimal cashPayAmt = rateMap.get("cashPayAmt") != null ? rateMap.get("cashPayAmt") : BigDecimal.ZERO;
                BigDecimal bigDecimal = billPayAmt = rateMap.get("billPayAmt") != null ? rateMap.get("billPayAmt") : BigDecimal.ZERO;
                if (count > 0) {
                    StringBuilder backSql = new StringBuilder();
                    backSql.append(" SELECT sum(FCashBackLocAmt) cashBackAmt ");
                    backSql.append(" FROM T_PP_PaySchDetailBill  ");
                    backSql.append(" where FOrgScheduleId=? and FBackCount =? ");
                    IRowSet backRS = DbUtil.executeQuery((Context)ctx, (String)backSql.toString(), (Object[])new Object[]{orgScheduleId, count});
                    while (backRS.next()) {
                        BigDecimal cashBackAmt = backRS.getBigDecimal("cashBackAmt") == null ? BigDecimal.ZERO : backRS.getBigDecimal("cashBackAmt");
                        cashPay = cashPay.add(cashBackAmt);
                    }
                    StringBuilder ntBackSql = new StringBuilder();
                    ntBackSql.append(" SELECT sum(FNtBackLocAmt) ntBackAmt ");
                    ntBackSql.append(" FROM T_PP_PaySchDetailBill  ");
                    ntBackSql.append(" where FOrgScheduleId=? and FNtBackCount =? ");
                    IRowSet ntbackRS = DbUtil.executeQuery((Context)ctx, (String)ntBackSql.toString(), (Object[])new Object[]{orgScheduleId, count});
                    while (ntbackRS.next()) {
                        BigDecimal ntBackAmt = ntbackRS.getBigDecimal("ntBackAmt") == null ? BigDecimal.ZERO : ntbackRS.getBigDecimal("ntBackAmt");
                        billPay = billPay.add(ntBackAmt);
                    }
                }
                if (cashPayAmt == null || cashPay == null || billPayAmt == null || billPay == null || cashPayAmt.compareTo(cashPay) == 0 && billPayAmt.compareTo(billPay) == 0) continue;
                throw new PPException(PPException.CAPITALBALANCE_VARIFYAMT);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void dealPaymentBillBySettlementType(Context ctx, PaySchDetailBillInfo paySchInfo, CountryInfo china, PaymentTypeInfo paymentTypeInfo, String cashOrNt, Map<String, PaymentBillInfo> toCreatePay, Map<String, PaySchDetailCreatePayVO> toUpdatePaySchDule, Map<String, PayPlanUpdateVerifyVO> toVerifyPayPlan, Map<String, BigDecimal> rateMap) throws BOSException, EASBizException {
        PaymentBillInfo payInfo;
        PaySchDetailCreatePayVO vo;
        BigDecimal locAmt;
        BigDecimal amt;
        SettlementTypeInfo settleTypeInfo;
        PayPlanUpdateVerifyVO verifyVO;
        PayPlanBillInfo payPlanInfo = paySchInfo.getPayPlan();
        if (toVerifyPayPlan.containsKey(payPlanInfo.getId().toString())) {
            verifyVO = toVerifyPayPlan.get(payPlanInfo.getId().toString());
        } else {
            verifyVO = new PayPlanUpdateVerifyVO();
            verifyVO.setPayPlanID(payPlanInfo.getId().toString());
            verifyVO.setCashSchdlLockAmt(payPlanInfo.getCashSchdlLockAmt());
            verifyVO.setCashToPayAmt(payPlanInfo.getCashToPayAmt());
            verifyVO.setNtSchdlLockAmt(payPlanInfo.getPaperSchdlLockAmt());
            verifyVO.setNtToPayAmt(payPlanInfo.getPaperToPayAmt());
            toVerifyPayPlan.put(payPlanInfo.getId().toString(), verifyVO);
        }
        String baseCurrencyID = payPlanInfo.getCompany().getBaseCurrency().getId().toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String payDate = sdf.format(paySchInfo.getDueDate());
        String paymentType = paySchInfo.getPaymentBillType().getId().toString();
        String payerAccountBankId = paySchInfo.getPayerAccountBank().getId().toString();
        String payeeNameId = payPlanInfo.getAsstActID();
        String payeeAccountBank = payPlanInfo.getPayeeAccountBank();
        String isCross = paySchInfo.isIsCrossOrg() ? "Y" : "N";
        String fundPropertyId = paySchInfo.getSetFundProperty().getId().toString();
        if (cashOrNt.equals("cash")) {
            settleTypeInfo = paySchInfo.getCashSettleType();
            amt = paySchInfo.getCashAuditedAmt();
            locAmt = paySchInfo.getCashAuditedLocAmt();
            BigDecimal cashPayAmt = rateMap.get("cashPayAmt");
            cashPayAmt = cashPayAmt.add(locAmt);
            rateMap.put("cashPayAmt", cashPayAmt);
        } else {
            settleTypeInfo = paySchInfo.getNtSettleType();
            amt = paySchInfo.getNtAuditedAmt();
            locAmt = paySchInfo.getNtAuditedLocAmt();
            BigDecimal billPayAmt = rateMap.get("billPayAmt");
            billPayAmt = billPayAmt.add(locAmt);
            rateMap.put("billPayAmt", billPayAmt);
        }
        String settleType = settleTypeInfo.getId().toString();
        String currencyId = paySchInfo.getCurrency().getId().toString();
        FilterInfo filterForCash = new FilterInfo();
        filterForCash.getFilterItems().add(new FilterItemInfo("paymentbill.settlementType", (Object)settleType, CompareType.EQUALS));
        filterForCash.getFilterItems().add(new FilterItemInfo("SrcPlanBillEntryID", (Object)paySchInfo.getId().toString(), CompareType.EQUALS));
        if (PaymentBillEntryFactory.getLocalInstance((Context)ctx).exists(filterForCash)) {
            throw new PPException(PPException.PAYSCH_CREATEPAY_USEDVERIFY);
        }
        String key = isCross + "|" + paymentType + "|" + payerAccountBankId + "|" + payeeNameId + "|" + payeeAccountBank + "|" + settleType + "|" + currencyId + "|" + payDate;
        FilterInfo settingFilter = new FilterInfo();
        settingFilter.getFilterItems().add(new FilterItemInfo("company", (Object)payPlanInfo.getCompany().getId().toString(), CompareType.EQUALS));
        SelectorItemCollection settingSic = new SelectorItemCollection();
        settingSic.add("*");
        settingSic.add("bizType.type");
        EntityViewInfo settingEvi = new EntityViewInfo();
        settingEvi.setFilter(settingFilter);
        settingEvi.setSelector(settingSic);
        PPScheduleSettingCollection setting = PPScheduleSettingFactory.getLocalInstance(ctx).getPPScheduleSettingCollection(settingEvi);
        if (paySchInfo.getSummaryFlag() != null) {
            key = paySchInfo.getSummaryFlag() + "|" + paymentType + "|" + payerAccountBankId + "|" + payeeNameId + "|" + payeeAccountBank + "|" + settleType + "|" + currencyId + "|" + payDate;
        } else if (setting.size() > 0) {
            PPPaySummarizingWayEnum paySummarizingWay = setting.get(0).getPaySummarizingWay();
            if (paySummarizingWay.equals((Object)PPPaySummarizingWayEnum.two)) {
                key = isCross + "|" + paymentType + "|" + payerAccountBankId + "|" + payeeNameId + "|" + payeeAccountBank + "|" + settleType + "|" + currencyId + "|" + payDate + "|" + fundPropertyId;
            } else if (paySummarizingWay.equals((Object)PPPaySummarizingWayEnum.three)) {
                key = paySchInfo.getId().toString() + cashOrNt;
            }
        }
        if (toUpdatePaySchDule.containsKey(paySchInfo.getId().toString())) {
            vo = toUpdatePaySchDule.get(paySchInfo.getId().toString());
        } else {
            vo = new PaySchDetailCreatePayVO();
            vo.setCashPayAmt(payPlanInfo.getCashToPayAmt());
            vo.setBillPayAmt(payPlanInfo.getPaperToPayAmt());
            vo.setPaySchDetailBillID(paySchInfo.getId().toString());
            vo.setPayPlanBillID(payPlanInfo.getId().toString());
            toUpdatePaySchDule.put(paySchInfo.getId().toString(), vo);
        }
        if (key != null && toCreatePay.containsKey(key)) {
            payInfo = toCreatePay.get(key);
            if (cashOrNt.equals("nt")) {
                StringBuilder settleNumber = new StringBuilder();
                if (!EmptyUtil.isEmpty((String)payInfo.getSettlementNumber())) {
                    settleNumber.append(payInfo.getSettlementNumber());
                }
                if (paySchInfo.getNts().size() > 0) {
                    List<ReceivableBillEntryVO> entryList = new ArrayList();
                    if (payInfo.get("receivableBillEntrys") != null) {
                        entryList = (List)payInfo.get("receivableBillEntrys");
                    }
                    for (int j = 0; j < paySchInfo.getNts().size(); ++j) {
                        if (j != 0 || !EmptyUtil.isEmpty((String)payInfo.getSettlementNumber())) {
                            settleNumber.append(";");
                        }
                        settleNumber.append(paySchInfo.getNts().get(j).getReceivableBill().getDraftNumber());
                        ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                        ReceivableBillInfo receivableBill = paySchInfo.getNts().get(j).getReceivableBill();
                        entryVO.setReceivableBillID(receivableBill.getId().toString());
                        entryVO.setBillType("\u4ed8\u6b3e\u5355");
                        entryVO.setReceivableBillNum(receivableBill.getDraftNumber());
                        entryVO.setEndorseAmt(receivableBill.getBillAmt());
                        entryVO.setSeq(j + 1);
                        if (receivableBill.getElecBillStatus() != null) {
                            entryVO.setElecBillStatus(receivableBill.getElecBillStatus().getValue());
                        }
                        entryList.add(entryVO);
                    }
                    payInfo.put("receivableBillEntrys", entryList);
                    payInfo.setSettlementNumber(settleNumber.toString());
                }
            }
        } else {
            payInfo = new PaymentBillInfo();
            BOSUuid uuid = BOSUuid.create((BOSObjectType)payInfo.getBOSType());
            payInfo.setId(uuid);
            payInfo.setIsSchCreated(true);
            payInfo.setCompany(payPlanInfo.getCompany());
            payInfo.setBillDate(new Date());
            payInfo.setBizDate(paySchInfo.getDueDate());
            payInfo.setPayBillType(payPlanInfo.getPaymentBillType());
            payInfo.setSettlementType(settleTypeInfo);
            payInfo.setCurrency(payPlanInfo.getCurrency());
            if (rateMap.containsKey(currencyId)) {
                BigDecimal rate = rateMap.get(currencyId);
                payInfo.setExchangeRate(rate);
            } else {
                ExchangeRateInfo exchangeRateInfo = com.kingdee.eas.fi.cas.utils.FMHelper.getExRateInfo((Context)ctx, (String)currencyId, (String)baseCurrencyID, (CompanyOrgUnitInfo)payInfo.getCompany(), (Date)new Date());
                BigDecimal rate = exchangeRateInfo.getConvertRate();
                rateMap.put(currencyId, rate);
                payInfo.setExchangeRate(rate);
            }
            payInfo.setPayerAccountBank(paySchInfo.getPayerAccountBank());
            payInfo.setPayerAccount(paySchInfo.getPayerAccountBank().getAccount());
            payInfo.setPayerBank(paySchInfo.getPayerBank());
            if (cashOrNt.equals("nt") && paySchInfo.getNts().size() > 0) {
                StringBuilder settleNumber = new StringBuilder();
                ArrayList<ReceivableBillEntryVO> entryList = new ArrayList<ReceivableBillEntryVO>();
                for (int j = 0; j < paySchInfo.getNts().size(); ++j) {
                    if (0 < j) {
                        settleNumber.append(";");
                    }
                    settleNumber.append(paySchInfo.getNts().get(j).getReceivableBill().getDraftNumber());
                    ReceivableBillEntryVO entryVO = new ReceivableBillEntryVO();
                    ReceivableBillInfo receivableBill = paySchInfo.getNts().get(j).getReceivableBill();
                    entryVO.setReceivableBillID(receivableBill.getId().toString());
                    entryVO.setBillType("\u4ed8\u6b3e\u5355");
                    entryVO.setReceivableBillNum(receivableBill.getDraftNumber());
                    entryVO.setEndorseAmt(receivableBill.getBillAmt());
                    entryVO.setSeq(j + 1);
                    if (receivableBill.getElecBillStatus() != null) {
                        entryVO.setElecBillStatus(receivableBill.getElecBillStatus().getValue());
                    }
                    entryList.add(entryVO);
                }
                payInfo.put("receivableBillEntrys", entryList);
                payInfo.setSettlementNumber(settleNumber.toString());
            }
            if (paySchInfo.getPayerAccountBank().getBank().isInGroup() && !EmptyUtil.isEmpty((CoreBaseInfo)paySchInfo.getPayerAccountBank().getInnerAcct()) && setting.size() > 0) {
                payInfo.setBizType(setting.get(0).getBizType());
            }
            payInfo.setAdminOrgUnit(payPlanInfo.getDepartment());
            payInfo.setDescription(paySchInfo.getUsage());
            payInfo.setUsage(paySchInfo.getUsage());
            payInfo.setPayeeType(payPlanInfo.getAsstActType());
            payInfo.setPayeeID(payPlanInfo.getAsstActID());
            payInfo.setPayeeName(payPlanInfo.getAsstActName());
            payInfo.setPayeeNumber(payPlanInfo.getAsstActNumber());
            payInfo.setPayeeAccountBankO(payPlanInfo.getPayeeAccountBankO());
            payInfo.setPayeeAccountBank(payPlanInfo.getPayeeAccountBank());
            payInfo.setPayeeBank(payPlanInfo.getPayeeBank());
            payInfo.setBankAcctName(payPlanInfo.getBankAcctName());
            if (!EmptyUtil.isEmpty((String)payPlanInfo.getPayeeBank())) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)payPlanInfo.getPayeeBank().trim(), CompareType.EQUALS));
                view.setFilter(filter);
                BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                if (coll.size() > 0) {
                    BEBankInfo bankInfo = coll.get(0);
                    payInfo.setRecCity(bankInfo.getBeCity());
                    payInfo.setRecProvince(bankInfo.getBeProvince());
                    payInfo.setBankNumber(bankInfo.getNumber());
                }
            }
            payInfo.setFRecCountry(china);
            payInfo.setExpectDealTime(paySchInfo.getDueDate());
            payInfo.setBillStatus(BillStatusEnum.SAVE);
            if (paySchInfo.getPaymentBillType().getSourceSysType().equals((Object)SourceTypeEnum.AP)) {
                payInfo.setPaymentType(paymentTypeInfo);
            }
            toCreatePay.put(key, payInfo);
        }
        if (paySchInfo.getPaymentBillType() != null) {
            payInfo.setSourceType(paySchInfo.getPaymentBillType().getSourceSysType());
        } else {
            payInfo.setSourceType(SourceTypeEnum.CASH);
        }
        PaymentBillEntryInfo entryInfo = new PaymentBillEntryInfo();
        entryInfo.setFundFlowItem(payPlanInfo.getSetFundProperty().getFundFlowItem());
        entryInfo.setCoreBillNumber(payPlanInfo.getCoreBillNumber());
        entryInfo.setCoreBillType(payPlanInfo.getCoreBillType());
        if (paySchInfo.getPaymentBillType().getSourceSysType().equals((Object)SourceTypeEnum.AP)) {
            if (cashOrNt.equals("nt")) {
                entryInfo.setAmount(amt);
                entryInfo.setLocalAmt(locAmt);
                if (!EmptyUtil.isEmpty((Object)paySchInfo.getNtSelectAmt()) && paySchInfo.getNtSelectAmt().compareTo(BigDecimal.ZERO) == 1 && paySchInfo.getSummaryFlag() == null) {
                    entryInfo.setActualAmt(paySchInfo.getNtSelectAmt());
                    entryInfo.setActualLocAmt(paySchInfo.getNtSelectAmt());
                } else {
                    entryInfo.setActualAmt(amt);
                    entryInfo.setActualLocAmt(locAmt);
                }
                entryInfo.setRebate(entryInfo.getAmount().subtract(entryInfo.getActualAmt()));
                entryInfo.setRebateLocAmt(entryInfo.getLocalAmt().subtract(entryInfo.getActualLocAmt()));
            } else {
                entryInfo.setAmount(amt);
                entryInfo.setLocalAmt(locAmt);
                entryInfo.setActualAmt(amt);
                entryInfo.setActualLocAmt(locAmt);
                entryInfo.setRebate(BigDecimal.ZERO);
                entryInfo.setRebateLocAmt(BigDecimal.ZERO);
            }
            entryInfo.setContractNum(paySchInfo.getContractNum());
        } else {
            entryInfo.setActualAmt(amt);
            entryInfo.setActualLocAmt(locAmt);
        }
        entryInfo.setSrcPlanBillID(payPlanInfo.getId().toString());
        entryInfo.setSrcPlanBillEntryID(paySchInfo.getId().toString());
        entryInfo.setSourceBillId(paySchInfo.getSourceBillId());
        entryInfo.setSourceBillEntryId(paySchInfo.getSrcBillHeadID());
        if (payPlanInfo.getOppAccount() != null) {
            entryInfo.setOppAccount(payPlanInfo.getOppAccount());
        }
        payInfo.getEntries().add(entryInfo);
        if (cashOrNt.equals("cash")) {
            vo.setCashPayAmt(vo.getCashPayAmt().add(entryInfo.getActualAmt()));
            vo.setCashPayBillID(payInfo.getId().toString());
            verifyVO.setCashCreateAmt(verifyVO.getCashCreateAmt().add(entryInfo.getActualAmt()));
        } else {
            vo.setBillPayAmt(vo.getBillPayAmt().add(entryInfo.getActualAmt()));
            vo.setBillPayBillID(payInfo.getId().toString());
            verifyVO.setNtCreateAmt(verifyVO.getNtCreateAmt().add(entryInfo.getActualAmt()));
        }
    }

    protected void verifySubmitBgData(Context ctx, OrgScheduleInfo info, List<BgControlRow> bgList) throws BOSException, EASBizException {
        for (int i = 0; i < bgList.size(); ++i) {
            BgControlRow row = bgList.get(i);
            if (!row.isControl() || row.getExecuteBalance().compareTo(BigDecimal.ZERO) != -1 && row.getCashExecuteBalance().compareTo(BigDecimal.ZERO) != -1 && row.getNtExecuteBalance().compareTo(BigDecimal.ZERO) != -1 && row.getCapitalExectureTotal().compareTo(BigDecimal.ZERO) != -1) continue;
            logger.error((Object)(row.getExecuteBalance() + "," + row.getCashExecuteBalance() + "," + row.getNtExecuteBalance() + "," + row.getCapitalExectureTotal()));
            throw new PPException(PPException.NO_BGCONTROL, new Object[]{row.getFundFlowItemNumber()});
        }
    }

    protected void verifySubmitBgDataByDepartment(Context ctx, OrgScheduleInfo info, List<BgControlRow> bgDepartmentRowList, String departmentId) throws BOSException, EASBizException {
        for (int i = 0; i < bgDepartmentRowList.size(); ++i) {
            BgControlRow row = bgDepartmentRowList.get(i);
            if (!row.isControl() || row.getExecuteBalance().compareTo(BigDecimal.ZERO) != -1 && row.getCashExecuteBalance().compareTo(BigDecimal.ZERO) != -1 && row.getNtExecuteBalance().compareTo(BigDecimal.ZERO) != -1 && row.getCapitalExectureTotal().compareTo(BigDecimal.ZERO) != -1) continue;
            logger.error((Object)("\u6821\u9a8c\u90e8\u95e8\u9884\u7b97,\u90e8\u95e8id\uff1a" + departmentId + ",\u90e8\u95e8\u540d\u79f0\uff1a" + departmentId));
            logger.error((Object)(row.getExecuteBalance() + "," + row.getCashExecuteBalance() + "," + row.getNtExecuteBalance() + "," + row.getCapitalExectureTotal()));
            AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(departmentId));
            throw new PPException(PPException.NO_DEPART_BGCONTROL, new Object[]{adminInfo.getName(), row.getFundFlowItemNumber()});
        }
    }
}

