/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.pp.app.AbstractNewFundPropertyWebFacadeControllerBean;
import com.kingdee.eas.fm.pp.vo.NewFundPropertyVO;
import com.kingdee.eas.fm.ps.EnableStatusEnum;
import com.kingdee.eas.fm.ps.FundPropertyCollection;
import com.kingdee.eas.fm.ps.FundPropertyFactory;
import com.kingdee.eas.fm.ps.FundPropertyInfo;
import com.kingdee.eas.fm.ps.IFundProperty;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NewFundPropertyWebFacadeControllerBean
extends AbstractNewFundPropertyWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.NewFundPropertyWebFacadeControllerBean");
    public static final String PS_RESOURCE = "com.kingdee.eas.fm.ps.PsResource";
    private static final String PERM_ITEM_SAVE = "pp_fundProperty_03update";
    private static final String PERM_ITEM_DELETE = "pp_fundProperty_04delete";
    private static final String PERM_ITEM_ENABLE = "pp_fundProperty_05enable";
    private static final String PERM_ITEM_DISABLE = "pp_fundProperty_06disable";

    @Override
    protected Map _saveFund(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        FundPropertyInfo fundPropertyInfo = (FundPropertyInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, FundPropertyInfo.class);
        IObjectPK rstID = null;
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)PERM_ITEM_SAVE);
            if (!isPermission) {
                throw new BOSException(PSUtils.getResource((Context)ctx, (String)"114_NO_FUND_SAVE_AUTH", (String[])new String[]{companyInfo.getName()}));
            }
            if (fundPropertyInfo.getParent() != null && fundPropertyInfo.getParent().getRevenueAndExpensesMark() != null && !fundPropertyInfo.getParent().getRevenueAndExpensesMark().equals((Object)fundPropertyInfo.getRevenueAndExpensesMark())) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"036_FundProperty", (Locale)ctx.getLocale()));
            }
            rstID = this.getBizInterface(ctx).submit((CoreBaseInfo)fundPropertyInfo);
            String sql = "update T_PP_SetFundProperty set FName=?,FNumber=? where FundPropertyID = ? ";
            DbUtil.executeUpdate((Context)ctx, (String)sql, (Object[])new Object[]{fundPropertyInfo.getName(), fundPropertyInfo.getNumber(), fundPropertyInfo.getId().toString()});
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug((Object)e);
            return result;
        }
        result.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
        result.put("OPStatus", "success");
        result.put("IdAfterSave", (String)rstID);
        return result;
    }

    @Override
    protected Map _deleteFund(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        NewFundPropertyVO fundVO = (NewFundPropertyVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, NewFundPropertyVO.class);
        HashSet<String> idSet = null;
        try {
            if (fundVO == null) {
                throw new BOSException(CASWebUtil.getResource((Context)ctx, (String)"InputDataExption"));
            }
            if (fundVO.getDeleteIDs() == null || fundVO.getDeleteIDs().length <= 0) {
                throw new BOSException(CASWebUtil.getResource((Context)ctx, (String)"PleSelectedDeleteRow"));
            }
            idSet = new HashSet<String>(Arrays.asList(fundVO.getDeleteIDs()));
            summary = summary + PSUtils.getResource((Context)ctx, (String)"008_BILL_SUM", (String[])new String[]{idSet.size() + ""});
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)PERM_ITEM_DELETE);
            if (!isPermission) {
                throw new BOSException(PSUtils.getResource((Context)ctx, (String)"113_NO_FUND_DELETE_AUTH", (String[])new String[]{companyInfo.getName()}));
            }
            FundPropertyCollection fundColls = this.getFundPropertyCollByIdSet(ctx, idSet);
            for (int i = 0; i < fundColls.size(); ++i) {
                FundPropertyInfo info = fundColls.get(i);
                try {
                    if (info.getDeletedStatus() != EnableStatusEnum.ENABLE) {
                        block12: {
                            try {
                                this.getBizInterface(ctx).isReferenced((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                            }
                            catch (ObjectReferedException e1) {
                                if (((BizReference)e1.getReferingObject()).getRefEntityName().equals(" ")) break block12;
                                Locale locale = ctx.getLocale();
                                result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"FundProperty_IsReferenced", (String[])new String[]{((BizReference)e1.getReferingObject()).getRefEntityAlias(locale)}));
                                continue;
                            }
                        }
                        this.getBizInterface(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                        ++success;
                        continue;
                    }
                    result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"007_BILL_NORMAL_NOT_DELETE", (String[])new String[]{info.getNumber()}));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"095_BILL_DELTE_FAIL", (String[])new String[]{info.getNumber()}));
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource((Context)ctx, (String)"094_FUND_DELETE_EX", null) + e1.getMessage());
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? PSUtils.getResource((Context)ctx, (String)"014_ALL_DELETE_SUCCESS", null) : summary + PSUtils.getResource((Context)ctx, (String)"013_DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _enableRecord(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + PSUtils.getResource((Context)ctx, (String)"008_BILL_SUM", (String[])new String[]{idSet.size() + ""});
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)PERM_ITEM_ENABLE);
            if (!isPermission) {
                throw new BOSException(PSUtils.getResource((Context)ctx, (String)"115_NO_FUND_ENABLE_AUTH", (String[])new String[]{companyInfo.getName()}));
            }
            FundPropertyCollection fundColls = this.getFundPropertyCollByIdSet(ctx, idSet);
            for (int i = 0; i < fundColls.size(); ++i) {
                FundPropertyInfo info = fundColls.get(i);
                try {
                    if (info.getDeletedStatus() == EnableStatusEnum.DISABLE) {
                        info.setDeletedStatus(EnableStatusEnum.ENABLE);
                        this.getBizInterface(ctx).update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getNumber(), (String)"pp_fundProperty_enable", (String)companyInfo.getId().toString());
                        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                        ++success;
                        continue;
                    }
                    result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"106_BILL_ENABLED", (String[])new String[]{info.getNumber()}));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"098_BILL_ENABLE_FAIL", (String[])new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource((Context)ctx, (String)"100_FUND_ENABLE_EX", (String[])new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? PSUtils.getResource((Context)ctx, (String)"102_ALL_ENABLE_SUCC", null) : summary + PSUtils.getResource((Context)ctx, (String)"104_ENABLE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _disableRecord(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        int realSize = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + PSUtils.getResource((Context)ctx, (String)"008_BILL_SUM", (String[])new String[]{idSet.size() + ""});
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)PERM_ITEM_DISABLE);
            if (!isPermission) {
                throw new BOSException(PSUtils.getResource((Context)ctx, (String)"116_NO_FUND_DISABLE_AUTH", (String[])new String[]{companyInfo.getName()}));
            }
            FundPropertyCollection fundColls = this.getFundPropertyCollByIdSet(ctx, idSet);
            realSize = fundColls.size();
            for (int i = 0; i < fundColls.size(); ++i) {
                FundPropertyInfo info = fundColls.get(i);
                try {
                    if (info.getDeletedStatus() == EnableStatusEnum.ENABLE) {
                        info.setDeletedStatus(EnableStatusEnum.DISABLE);
                        this.getBizInterface(ctx).update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getNumber(), (String)"pp_fundProperty_disable", (String)companyInfo.getId().toString());
                        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                        ++success;
                        continue;
                    }
                    result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"097_BILL_DISABLED", (String[])new String[]{info.getNumber()}));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource((Context)ctx, (String)"099_BILL_DISABEL_FAIL", (String[])new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource((Context)ctx, (String)"101_FUND_DISABLE_EX", (String[])new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == realSize ? PSUtils.getResource((Context)ctx, (String)"103_ALL_DISABLE_SUCC", null) : summary + PSUtils.getResource((Context)ctx, (String)"105_DISABLE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(realSize - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private FundPropertyInfo fundVoToInfo(Context ctx, NewFundPropertyVO fundVO) throws EASBizException, BOSException {
        FundPropertyInfo info = new FundPropertyInfo();
        if (fundVO == null) {
            return info;
        }
        if (fundVO.getId() != null) {
            try {
                info = this.getBizInterface(ctx).getFundPropertyInfo((IObjectPK)new ObjectUuidPK(fundVO.getId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (fundVO.getNumber() != null) {
            if (fundVO.getNumber().length() > 80) {
                info.setNumber(fundVO.getNumber().substring(0, 80));
            } else {
                info.setNumber(fundVO.getNumber());
            }
        }
        if (fundVO.getName_l1() != null) {
            if (fundVO.getName_l1().length() > 255) {
                info.setName(fundVO.getName_l1().substring(0, 255), LocaleUtils.getLocale((String)"l1"));
            } else {
                info.setName(fundVO.getName_l1(), LocaleUtils.getLocale((String)"l1"));
            }
        }
        if (fundVO.getName_l2() != null) {
            if (fundVO.getName_l2().length() > 255) {
                info.setName(fundVO.getName_l2().substring(0, 255), LocaleUtils.getLocale((String)"l2"));
            } else {
                info.setName(fundVO.getName_l2(), LocaleUtils.getLocale((String)"l2"));
            }
        }
        if (fundVO.getName_l3() != null) {
            if (fundVO.getName_l3().length() > 255) {
                info.setName(fundVO.getName_l3().substring(0, 255), LocaleUtils.getLocale((String)"l3"));
            } else {
                info.setName(fundVO.getName_l3(), LocaleUtils.getLocale((String)"l3"));
            }
        }
        if (fundVO.getDescription_l1() != null) {
            if (fundVO.getDescription_l1().length() > 255) {
                info.setDescription(fundVO.getDescription_l1().substring(0, 255), LocaleUtils.getLocale((String)"l1"));
            } else {
                info.setDescription(fundVO.getDescription_l1(), LocaleUtils.getLocale((String)"l1"));
            }
        }
        if (fundVO.getDescription_l2() != null) {
            info.setDescription(fundVO.getDescription_l2(), LocaleUtils.getLocale((String)"l2"));
            if (fundVO.getDescription_l2().length() > 255) {
                info.setDescription(fundVO.getDescription_l2().substring(0, 255), LocaleUtils.getLocale((String)"l2"));
            } else {
                info.setDescription(fundVO.getDescription_l2(), LocaleUtils.getLocale((String)"l2"));
            }
        }
        if (fundVO.getDescription_l3() != null) {
            if (fundVO.getDescription_l3().length() > 255) {
                info.setDescription(fundVO.getDescription_l3().substring(0, 255), LocaleUtils.getLocale((String)"l3"));
            } else {
                info.setDescription(fundVO.getDescription_l3(), LocaleUtils.getLocale((String)"l3"));
            }
        }
        if (info.getDeletedStatus() == null) {
            info.setDeletedStatus(EnableStatusEnum.ENABLE);
        }
        return info;
    }

    private FundPropertyCollection getFundPropertyCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        entityViewInfo.setFilter(filter);
        return this.getBizInterface(ctx).getFundPropertyCollection(entityViewInfo);
    }

    private boolean isReference(Context ctx, String fundId) throws BOSException {
        IRowSet rs;
        boolean hasRefer;
        block11: {
            hasRefer = false;
            String sql = " select top 1 * from T_PS_PaymentPlanBill where FFundPropertyID=?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fundId});
                if (rs != null) {
                    while (rs.next()) {
                        hasRefer = true;
                    }
                }
                if (!hasRefer) {
                    sql = "select top 1 * from T_PS_PayPlanSumary  where FFundPropertyID=?";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fundId});
                    if (rs != null) {
                        while (rs.next()) {
                            hasRefer = true;
                        }
                    }
                }
                if (hasRefer) break block11;
                sql = "select top 1 * from T_PP_SetFundProperty  where FFundPropertyID=?";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fundId});
                if (rs != null) {
                    while (rs.next()) {
                        hasRefer = true;
                    }
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hasRefer;
    }

    private IFundProperty getBizInterface(Context ctx) throws BOSException {
        return FundPropertyFactory.getLocalInstance((Context)ctx);
    }
}

