/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.pp.CapitalBalanceFactory;
import com.kingdee.eas.fm.pp.CapitalBalanceWebFacadeFactory;
import com.kingdee.eas.fm.pp.IOrgSchedule;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.UserDefinedPeriodFactory;
import com.kingdee.eas.fm.pp.UserDefinedPeriodInfo;
import com.kingdee.eas.fm.pp.app.AbstractOrgScheduleWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgScheduleWebFacadeControllerBean
extends AbstractOrgScheduleWebFacadeControllerBean {
    private static final long serialVersionUID = -8478029980198005344L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.OrgScheduleWebFacadeControllerBean");
    private Date currentDate = DateTimeUtils.truncateDate((Date)new Date());

    @Override
    public Map _schedule(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        StatusEnum status = info.getStatus();
        CompanyOrgUnitInfo company = info.getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)"OrgSchedule_02Schedule");
        if (!isPermission) {
            throw new PPException(PPException.ORGSCHEDULE_NO_SCHEDULE, new Object[]{company.getName()});
        }
        if (StatusEnum.NOT_SCHEDULE != status && StatusEnum.SCHEDULEING != status) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_CanSchedule")});
        }
        if (status != StatusEnum.SCHEDULEING) {
            info.setStatus(StatusEnum.SCHEDULEING);
            OrgScheduleFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        String startDate = info.getUserDefinedPeriod().getStartDate().toString();
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"schedule", (BOSObjectType)new OrgScheduleInfo().getBOSType(), null, (String)("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a" + startDate + "\u7684\u6392\u7a0b\u671f\u95f4"), (String)"pp_orgSchedule_schedule", (String)company.getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        result.setError(0);
        return result;
    }

    @Override
    public Map _adjust(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        StatusEnum status = info.getStatus();
        CompanyOrgUnitInfo company = info.getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)"OrgSchedule_04Adjust");
        if (!isPermission) {
            throw new PPException(PPException.ORGSCHEDULE_NO_ADJUST, new Object[]{company.getName()});
        }
        if (StatusEnum.SCHEDULE_AUDIT != status && StatusEnum.ADJUST_AUDIT != status && StatusEnum.ADJUSTING != status) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_CanAdjust")});
        }
        if (status != StatusEnum.ADJUSTING) {
            info.setStatus(StatusEnum.ADJUSTING);
            OrgScheduleFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        String startDate = info.getUserDefinedPeriod().getStartDate().toString();
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"adjust", (BOSObjectType)new OrgScheduleInfo().getBOSType(), null, (String)("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a" + startDate + "\u7684\u6392\u7a0b\u671f\u95f4"), (String)"pp_orgSchedule_adjust", (String)company.getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        result.setError(0);
        return result;
    }

    @Override
    public Map _scheduleAudit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        StatusEnum status = info.getStatus();
        CompanyOrgUnitInfo company = info.getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)"OrgSchedule_03ScheduleAudit");
        if (!isPermission) {
            throw new PPException(PPException.ORGSCHEDULE_NO_SCHEDULEAUDIT, new Object[]{company.getName()});
        }
        if (StatusEnum.SCHEDULE_SUBMIT != status) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_CanScheduleAudit")});
        }
        if (this.isInWorkFlow(ctx, info.getId().toString())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_InWorkFlow")});
        }
        String startDate = info.getUserDefinedPeriod().getStartDate().toString();
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"scheduleAudit", (BOSObjectType)new OrgScheduleInfo().getBOSType(), null, (String)("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a" + startDate + "\u7684\u6392\u7a0b\u671f\u95f4"), (String)"pp_orgSchedule_scheduleAudit", (String)company.getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        result.setError(0);
        return result;
    }

    @Override
    public Map _adjustAudit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        StatusEnum status = info.getStatus();
        CompanyOrgUnitInfo company = info.getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)"OrgSchedule_05AdjustAudit");
        if (!isPermission) {
            throw new PPException(PPException.ORGSCHEDULE_NO_ADJUSTAUDIT, new Object[]{company.getName()});
        }
        if (StatusEnum.ADJUST_SUBMIT != status) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_CanAdjustAudit")});
        }
        if (this.isInWorkFlow(ctx, info.getId().toString())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_InWorkFlow")});
        }
        String startDate = info.getUserDefinedPeriod().getStartDate().toString();
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"adjustAudit", (BOSObjectType)new OrgScheduleInfo().getBOSType(), null, (String)("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a" + startDate + "\u7684\u6392\u7a0b\u671f\u95f4"), (String)"pp_orgSchedule_adjustAudit", (String)company.getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        result.setError(0);
        return result;
    }

    @Override
    public Map _scheduleBack(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        StatusEnum status = info.getStatus();
        CompanyOrgUnitInfo company = info.getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)"OrgSchedule_07ScheduleBack");
        if (!isPermission) {
            throw new PPException(PPException.ORGSCHEDULE_NO_SCHEDULEBACK, new Object[]{company.getName()});
        }
        if (StatusEnum.COMPLETE != status) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_ScheduleBack")});
        }
        String startDate = info.getUserDefinedPeriod().getStartDate().toString();
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"scheduleBack", (BOSObjectType)new OrgScheduleInfo().getBOSType(), null, (String)("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a" + startDate + "\u7684\u6392\u7a0b\u671f\u95f4"), (String)"pp_orgSchedule_scheduleBack", (String)company.getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        result.setError(0);
        return result;
    }

    @Override
    public Map _beforeComplete(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        StatusEnum status = info.getStatus();
        CompanyOrgUnitInfo company = info.getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)"OrgSchedule_06Complete");
        if (!isPermission) {
            throw new PPException(PPException.ORGSCHEDULE_NO_COMPLETE, new Object[]{company.getName()});
        }
        if (StatusEnum.COMPLETE == status) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_NotComplete")});
        }
        if (this.isInWorkFlow(ctx, info.getId().toString())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_InWorkFlow")});
        }
        Date startDate = info.getUserDefinedPeriod().getStartDate();
        Date endDate = info.getUserDefinedPeriod().getEndDate();
        if (!endDate.before(this.currentDate)) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_NotBeforeCurrentDate")});
        }
        EntityViewInfo planView = new EntityViewInfo();
        FilterInfo planFilter = new FilterInfo();
        planView.setFilter(planFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        planView.setSelector(sic);
        planFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        planFilter.getFilterItems().add(new FilterItemInfo("payableDate", (Object)startDate, CompareType.GREATER_EQUALS));
        planFilter.getFilterItems().add(new FilterItemInfo("payableDate", (Object)DateUtil.getAfterDay((Date)endDate), CompareType.LESS));
        HashSet<Integer> statusSet = new HashSet<Integer>();
        statusSet.add(3);
        statusSet.add(4);
        statusSet.add(5);
        planFilter.getFilterItems().add(new FilterItemInfo("billStatus", statusSet, CompareType.INCLUDE));
        planFilter.getFilterItems().add(new FilterItemInfo("schdlBalanceAmt", (Object)BigDecimal.ZERO, CompareType.GREATER));
        PayPlanBillCollection colls = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(planView);
        if (colls != null && colls.size() > 0) {
            StringBuffer numbers = new StringBuffer();
            for (int i = 0; i < colls.size(); ++i) {
                PayPlanBillInfo payPlanInfo = colls.get(i);
                numbers.append(payPlanInfo.getNumber());
                numbers.append(",");
            }
            logger.error((Object)("\u5f53\u524d\u5468\u671f\u9700\u8981\u5904\u7406\u7684\u5f85\u6392\u7a0b\u7684\u4ed8\u6b3e\u8ba1\u5212\uff1a" + numbers.toString()));
            result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_ToPayPlan", (String[])new String[]{numbers.toString()}));
        }
        EntityViewInfo detailView = new EntityViewInfo();
        FilterInfo detailFilter = new FilterInfo();
        detailView.setFilter(detailFilter);
        detailView.setSelector(sic);
        detailFilter.getFilterItems().add(new FilterItemInfo("orgScheduleId", (Object)id));
        detailFilter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        PaySchDetailBillCollection paySchColl = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(detailView);
        if (paySchColl != null && paySchColl.size() > 0) {
            StringBuffer numbers = new StringBuffer();
            for (int i = 0; i < paySchColl.size(); ++i) {
                PaySchDetailBillInfo paySchInfo = paySchColl.get(i);
                numbers.append(paySchInfo.getNumber());
                numbers.append(",");
            }
            logger.error((Object)("\u5f53\u524d\u5468\u671f\u9700\u8981\u5904\u7406\u7684\u5df2\u6392\u7a0b\u660e\u7ec6\uff1a" + numbers.toString()));
            result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_ToPaySch", (String[])new String[]{numbers.toString()}));
        }
        if (result.getDetailMsgList().size() > 0) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_NotMeet"));
        } else {
            result.setError(0);
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_Confirm"));
        }
        return result;
    }

    @Override
    public Map _complete(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = true;
        try {
            b = iMutex.requestObjIDForUpdate(id);
            if (!b) {
                throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CANTCOMPLETE"));
            }
            IOrgSchedule orgSchedule = OrgScheduleFactory.getLocalInstance(ctx);
            OrgScheduleInfo info = orgSchedule.getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
            if (StatusEnum.COMPLETE == info.getStatus()) {
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgSchedule_NotComplete")});
            }
            if (info.getStatus() == StatusEnum.ADJUSTING) {
                Map map = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).calculateCapitalBalanceData(id, null);
                List rowList = (List)map.get("rowList");
                CapitalBalanceFactory.getLocalInstance(ctx).saveBalance(id, rowList);
            }
            info.setStatus(StatusEnum.COMPLETE);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("status"));
            orgSchedule.updatePartial(info, selector);
            UserDefinedPeriodInfo nextPeriod = UserDefinedPeriodFactory.getLocalInstance(ctx).getNextPeriodInfoById(info.getUserDefinedPeriod().getId().toString());
            if (nextPeriod == null) {
                throw new PPException(PPException.NO_PERIODINFO);
            }
            UserDefinedPeriodInfo nextNextPeriod = UserDefinedPeriodFactory.getLocalInstance(ctx).getNextPeriodInfoById(nextPeriod.getId().toString());
            if (nextNextPeriod == null) {
                throw new PPException(PPException.NO_NEXT_PERIODINFO);
            }
            OrgScheduleInfo newOrgScheduleInfo = new OrgScheduleInfo();
            newOrgScheduleInfo.setCompany(info.getCompany());
            newOrgScheduleInfo.setUserDefinedPeriod(nextNextPeriod);
            newOrgScheduleInfo.setStatus(StatusEnum.NOT_SCHEDULE);
            newOrgScheduleInfo.setCount(0);
            orgSchedule.addnew(newOrgScheduleInfo);
            String startDate = info.getUserDefinedPeriod().getStartDate().toString();
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"complete", (BOSObjectType)new OrgScheduleInfo().getBOSType(), null, (String)("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\uff1a" + startDate + "\u7684\u6392\u7a0b\u671f\u95f4"), (String)"pp_orgSchedule_complete", (String)info.getCompany().getId().toString(), null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        catch (EASBizException e) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_FAIL") + e.getMessage()});
        }
        catch (Exception e) {
            e.getStackTrace();
            logger.error((Object)("\u5355\u4f4d\u6392\u7a0b\u5b8c\u6210\u64cd\u4f5c\u5931\u8d25 \uff1a" + e));
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_FAIL")});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"OrgScheduleComplete_SUCCESS"));
        return result;
    }

    private boolean isInWorkFlow(Context ctx, String selectId) {
        try {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(selectId);
            return procInsts != null && procInsts.length != 0;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("company.id");
        sic.add("company.name");
        sic.add("userDefinedPeriod.startDate");
        sic.add("userDefinedPeriod.endDate");
        sic.add("*");
        return sic;
    }
}

